#ifndef BROWNNOISE8192_H_
#define BROWNNOISE8192_H_

#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
#include "mozzi_pgmspace.h"

/* Brown noise generated in Audacity
*/

#define BROWNNOISE8192_NUM_CELLS 8192
#define BROWNNOISE8192_SAMPLERATE 8192

CONSTTABLE_STORAGE(int8_t) BROWNNOISE8192_DATA []  =
        {
                54, 75, 42, 8, 11, 63, 34, -6, 36,
                79, 36, 72, 108, 99, 59, 106, 70, 102, 60, 100, 101, 97, 95, 127, 127, 127, 127,
                127, 127, 85, 124, 73, 56, 54, 12, -34, 25, -11, -2, 43, 41, 18, -29, 19, 76,
                40, 37, 79, 25, 72, 29, 8, 18, 45, 43, 31, 1, 8, -44, 4, 34, 25, 36, 46, 18, 18,
                43, 86, 27, 10, 49, 8, 3, 1, -37, -84, -43, -3, -36, -49, -88, -37, -48, -48,
                -34, -5, -57, -41, -17, 1, 7, 31, -1, 36, -12, 22, -17, -28, -1, -23, 2, -50,
                -19, 8, -41, 0, 13, 34, 21, 76, 117, 127, 123, 73, 93, 54, 25, -20, -25, -28,
                -62, -3, -17, -1, 21, -32, 11, 47, 9, 38, 33, 63, 33, 5, 27, 69, 26, 66, 35, 34,
                0, 36, 54, 99, 127, 79, 115, 127, 111, 124, 127, 127, 127, 127, 127, 127, 127,
                94, 32, 10, 10, 7, -6, 25, -17, 15, -38, -89, -74, -57, -76, -30, -33, -87, -98,
                -111, -128, -123, -110, -96, -59, -55, -91, -50, -32, -81, -44, 17, 73, 81, 51,
                89, 127, 108, 127, 90, 66, 13, -42, -49, 4, 33, -9, -45, -71, -98, -119, -105,
                -59, -62, -13, -33, -51, 9, 65, 58, 49, 85, 112, 107, 102, 58, 69, 36, 77, 95,
                36, 43, 70, 109, 127, 109, 127, 127, 126, 71, 119, 127, 127, 127, 116, 127, 91,
                52, 49, 6, 57, 109, 44, 92, 118, 59, 66, 115, 105, 107, 76, 110, 114, 77, 87,
                52, -8, -54, 1, 22, -8, -25, -4, -42, 11, 56, 82, 28, 35, 34, -18, -6, 33, 9,
                23, 40, 50, 17, -20, -65, -34, 10, 45, 91, 29, -12, -4, 27, -29, -24, -67, -35,
                -54, 3, -27, -6, 8, 14, 49, 80, 20, 31, 22, 12, -26, -13, 40, 11, -15, 44, -17,
                35, 60, 88, 64, 11, 65, 42, -7, -33, 8, 18, 23, -37, -4, -27, -24, -34, 17, -28,
                31, 22, 3, 0, 50, 0, -51, -23, -79, -41, -91, -111, -128, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -117, -109, -114, -125, -128, -128,
                -121, -97, -128, -128, -128, -113, -61, -95, -77, -18, -64, -64, -83, -77, -88,
                -31, -85, -115, -92, -128, -128, -88, -42, -6, 14, -18, -29, 9, 21, 77, 90, 84,
                81, 63, 47, 30, 65, 4, 25, 23, 40, -3, 24, 39, 71, 55, 94, 127, 87, 112, 102,
                127, 127, 87, 68, 48, 50, 8, -30, -51, -75, -89, -51, -23, 22, 28, 50, 56, 13,
                -42, -97, -128, -128, -102, -128, -115, -59, -26, -20, -33, 26, -32, 0, -58,
                -52, -33, -52, -34, -28, -25, -54, -100, -41, -12, 21, -13, -22, -37, -28, 13,
                39, 19, 8, 45, 92, 74, 102, 39, 78, 43, 71, 107, 108, 61, 101, 127, 127, 127,
                127, 121, 115, 121, 127, 97, 39, 19, -40, -37, 8, -7, -29, -40, -57, -74, -51,
                -24, -28, 13, 13, 33, 87, 54, 86, 55, 1, 7, 42, 78, 104, 123, 127, 95, 127, 93,
                72, 98, 127, 95, 78, 26, 11, -42, -59, -43, -83, -105, -128, -128, -88, -127,
                -128, -128, -128, -128, -128, -128, -128, -98, -95, -96, -74, -78, -128, -107,
                -128, -112, -85, -32, 11, 32, 14, -37, -40, -73, -51, -73, -16, -60, -46, -83,
                -59, -85, -73, -19, -3, 54, 107, 52, 70, 116, 127, 68, 75, 14, 36, 55, 102, 127,
                127, 127, 114, 118, 127, 127, 100, 127, 113, 127, 127, 127, 127, 71, 71, 72, 96,
                97, 95, 126, 120, 96, 75, 106, 42, 15, 54, 38, 67, 37, 20, 49, 96, 103, 126,
                127, 120, 110, 115, 93, 127, 127, 127, 127, 119, 66, 52, 18, -12, -37, -22, -19,
                7, -11, 19, 72, 61, 64, 27, -30, -17, 11, 16, -38, -54, -36, -50, -37, -1, -13,
                -3, 21, 12, 16, -23, -63, -92, -108, -78, -109, -106, -128, -91, -41, -65, -69,
                -85, -102, -96, -56, -31, -52, -47, -50, -53, -95, -124, -128, -128, -128, -125,
                -128, -110, -128, -128, -128, -128, -128, -128, -113, -128, -128, -101, -52,
                -63, -37, -7, 16, 44, 76, 84, 52, 98, 39, 19, 21, 34, 81, 88, 52, 7, 1, -11, 44,
                30, 22, -16, -37, -68, -37, 23, -1, -38, -82, -128, -96, -128, -124, -128, -128,
                -104, -88, -101, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -91, -39, -25, -31, 1, 50, 42, -1, -6, -16, 26, -2, 15, 17,
                30, 25, -7, 5, -16, 11, -15, -1, -56, -75, -78, -126, -128, -128, -81, -22, -41,
                -64, -98, -103, -88, -60, -10, 41, 0, -55, -85, -110, -87, -94, -53, -55, -63,
                -7, -49, -28, -8, -13, -35, 6, -16, -7, -58, -42, -15, 29, -9, 35, 61, 16, 16,
                29, -11, -56, -4, 52, -2, -59, -26, 28, 8, 20, -34, -36, 10, 28, 22, -12, -15,
                -14, 22, 55, 70, 64, 5, 39, 84, 61, 70, 121, 127, 127, 127, 127, 127, 127, 121,
                127, 91, 43, -16, -39, -5, 31, 78, 31, 6, 13, 41, 21, 6, -26, -75, -55, -55,
                -68, -92, -81, -126, -118, -128, -128, -109, -78, -79, -74, -64, -61, -3, -23,
                11, 66, 95, 127, 71, 14, -7, 43, 87, 100, 127, 74, 26, 71, 51, 74, 13, -15, -13,
                -34, -61, -25, 25, -11, -28, -28, -6, 16, 8, -51, -96, -126, -128, -128, -128,
                -128, -128, -128, -104, -40, -52, -52, -22, 13, -6, 6, -13, -21, 0, -24, 30, 42,
                28, 37, 19, 30, 80, 75, 102, 87, 109, 56, 80, 89, 113, 86, 55, 68, 101, 112,
                127, 127, 107, 61, 99, 77, 90, 74, 107, 98, 116, 124, 89, 48, -13, -69, -26,
                -34, -28, 3, -40, -16, 22, 40, 42, 10, 48, 1, -18, -61, -67, -74, -16, -19, 2,
                -6, 14, 15, -34, 25, 16, 4, 57, 68, 102, 63, 39, 41, 15, 23, -17, 12, -34, -40,
                -61, -101, -36, -88, -113, -118, -65, -91, -31, 29, -7, -24, -60, -82, -47, -48,
                -8, -4, 53, 99, 78, 55, 44, -6, -59, -106, -128, -110, -128, -125, -78, -46,
                -44, 0, -9, 29, -27, 24, 32, 24, -10, -47, -91, -50, -86, -115, -128, -100,
                -128, -128, -128, -128, -128, -128, -128, -101, -59, -65, -114, -76, -73, -69,
                -68, -16, 17, -36, -75, -37, -29, -34, -48, -91, -33, -75, -107, -128, -128,
                -128, -128, -120, -94, -89, -25, -66, -33, -2, 7, -38, -10, -61, -64, -38, -1,
                -41, -42, -5, -2, 47, 11, -45, -34, 13, -5, 15, -8, -47, -81, -103, -68, -99,
                -90, -102, -124, -128, -118, -95, -45, -3, -51, -91, -34, -32, -9, -65, -68,
                -78, -38, -21, -45, -57, -36, -75, -84, -57, -1, 2, -34, 24, -22, 29, 72, 80,
                16, -12, -65, -57, -96, -76, -100, -109, -123, -56, -14, -33, -27, -6, 51, 4,
                54, -2, 46, 19, -16, -36, -25, -3, -12, -12, 8, 3, -36, 14, 4, 37, 38, -8, 47,
                85, 127, 103, 127, 127, 127, 101, 53, 83, 49, 73, 115, 103, 63, 100, 79, 35, 30,
                39, 9, -49, -24, -73, -76, -78, -67, -4, -32, -11, -16, -44, -10, 32, -20, -15,
                -34, -56, -24, 28, 0, -22, -77, -126, -96, -128, -95, -91, -31, -33, -11, 1, 47,
                22, -29, 9, -14, 35, 64, 58, 50, 57, 14, -34, -66, -21, -14, -64, -50, -37, -79,
                -101, -72, -70, -111, -74, -45, -79, -105, -86, -58, -75, -17, -47, -64, -57,
                -16, -50, -58, -2, 48, 70, 51, 100, 114, 87, 38, 24, 15, -3, 11, 2, 30, 22, -18,
                13, 42, -5, -20, -41, -81, -17, 30, 29, -19, 2, 30, 0, -44, -71, -85, -118,
                -113, -55, -23, -65, -37, -86, -60, -96, -76, -41, -21, 32, 1, 30, -17, -16, 37,
                18, 27, 13, 16, -23, -13, -35, -86, -68, -23, -10, 36, 9, -21, -22, -31, -62,
                -73, -69, -63, -29, -29, -18, 16, -28, -16, 25, -22, -14, 7, -6, 2, -14, 0, -38,
                -31, -60, -102, -113, -115, -89, -90, -70, -55, -73, -21, 11, -33, -19, -62,
                -92, -71, -70, -68, -70, -20, 9, 62, 14, -34, -9, 11, 24, 55, 88, 127, 127, 127,
                127, 127, 127, 127, 127, 79, 37, 22, -7, -30, -82, -44, -81, -100, -101, -53,
                -4, 31, 53, 7, -40, 6, -7, 5, 25, 40, 63, 97, 98, 58, 83, 124, 127, 127, 127,
                127, 127, 100, 127, 93, 112, 95, 52, 20, 9, 36, 48, 41, 54, 54, 47, -6, 16, -30,
                -63, -90, -55, -20, -3, 10, 62, 12, 47, -6, 13, -27, -57, -110, -128, -104, -72,
                -105, -99, -48, -33, -2, 44, 27, -18, -64, -4, 28, 59, 62, 0, -53, -17, -46,
                -13, 17, 52, 57, 36, 83, 89, 91, 113, 127, 91, 82, 58, 79, 113, 76, 100, 82, 59,
                108, 57, 82, 91, 68, 95, 127, 73, 43, -14, -26, -74, -107, -115, -97, -65, -106,
                -109, -81, -89, -84, -128, -128, -115, -110, -52, -76, -64, -1, -35, -47, -15,
                -57, -94, -119, -77, -38, 16, 4, 7, 12, 31, 26, -33, -69, -69, -54, -59, -61,
                -54, -2, -40, -16, -40, -79, -128, -62, -112, -64, -73, -89, -128, -87, -64,
                -83, -110, -92, -102, -76, -83, -125, -82, -82, -21, 6, 5, 10, 51, 37, 39, 45,
                34, 17, 57, 96, 124, 127, 92, 123, 127, 127, 127, 127, 127, 127, 127, 123, 127,
                127, 80, 92, 62, 67, 67, 108, 68, 15, 16, 21, 73, 41, 33, 43, -2, -37, 6, -25,
                -69, -66, -60, -35, -63, -87, -48, -35, -8, -39, -73, -73, -124, -115, -128,
                -128, -128, -128, -82, -44, -7, -54, -79, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -87, -35, -79, -55, -86, -41, -64, -85, -78,
                -15, -57, -49, -60, -51, -40, -58, -79, -93, -106, -64, -52, -41, 2, 59, 101,
                57, 33, 14, -6, 40, 73, 26, 75, 118, 127, 124, 118, 127, 127, 127, 127, 127,
                127, 127, 109, 122, 59, 56, 56, 68, 118, 127, 93, 65, 34, 83, 107, 127, 127,
                127, 127, 127, 120, 125, 86, 83, 69, 102, 55, 107, 127, 86, 78, 48, 4, -42, -76,
                -91, -128, -128, -81, -128, -94, -72, -119, -128, -128, -128, -128, -128, -128,
                -128, -102, -47, -76, -47, -49, 6, -20, 35, 32, 26, -11, -46, -86, -107, -128,
                -128, -92, -123, -68, -111, -121, -67, -44, -39, -26, -82, -21, 27, -22, 38, 88,
                103, 127, 115, 50, 46, 84, 73, 15, 10, 41, 3, 17, -37, -4, -28, -29, -14, -45,
                -69, -116, -97, -61, -7, -44, -52, -4, -55, -66, -33, 14, -19, -52, 2, -30, -46,
                -23, -54, -76, -33, -82, -71, -122, -128, -128, -90, -128, -128, -128, -110,
                -128, -128, -125, -115, -126, -128, -128, -98, -70, -12, -45, -40, -24, 20, 70,
                10, 19, 27, -21, -76, -104, -127, -128, -111, -77, -29, -54, -75, -98, -125,
                -61, -104, -88, -66, -68, -90, -111, -46, -60, -2, -10, -55, -51, -82, -45, -10,
                -46, -57, -103, -126, -128, -128, -128, -119, -83, -96, -109, -128, -86, -47,
                -90, -128, -66, -38, -50, -33, -4, -26, 15, -3, 39, 26, 74, 119, 97, 89, 126,
                127, 127, 127, 127, 127, 127, 127, 127, 82, 56, 92, 65, 4, -36, -74, -101, -94,
                -84, -106, -107, -128, -89, -68, -117, -74, -125, -128, -128, -126, -128, -128,
                -89, -72, -103, -115, -68, -30, -84, -39, -53, -12, 6, 48, 56, 5, -7, 44, 92,
                79, 69, 100, 68, 82, 78, 40, 48, 12, 28, 61, 113, 118, 102, 98, 90, 37, -22,
                -36, -4, -40, -42, -13, -43, -38, -25, -28, 1, -28, 28, -33, 4, -1, -18, -73,
                -55, 6, 47, -11, -27, -42, -70, -86, -128, -128, -128, -102, -66, -96, -120,
                -62, -76, -107, -65, -45, -29, 28, 31, 2, 11, -2, -16, -54, -83, -42, -85, -96,
                -78, -35, -27, 33, 38, 56, 108, 127, 112, 120, 64, 3, -50, -67, -86, -53, -43,
                -88, -40, -25, 29, 3, -23, -34, 13, -18, -8, 21, 63, 25, 27, 39, 5, 2, 18, -11,
                -11, -1, 11, -12, -7, 18, -5, 28, 7, -42, -31, 30, -8, -8, 38, -20, -35, 21, 60,
                35, 13, -1, -24, 3, 37, 58, 18, 21, 53, 23, -9, -45, -84, -21, 0, 36, 30, 69,
                43, 51, 13, 35, 3, 58, 4, 49, 67, 57, 92, 87, 84, 53, 90, 67, 53, 106, 94, 30,
                75, 92, 127, 97, 50, -11, -48, -81, -50, -73, -48, -82, -88, -128, -77, -107,
                -122, -64, -87, -117, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -79, -30, 4, 57, 45, 78, 52, 72, 58, 14, 21, 37, 45, 19, 25,
                22, -29, -18, -67, -75, -90, -107, -101, -70, -88, -117, -97, -47, -43, -21,
                -67, -32, 6, 26, 36, -24, 35, -10, 37, 69, 5, -30, -35, 19, 53, 103, 127, 89,
                40, -15, -49, -51, -33, -68, -61, 2, 4, -16, -25, -81, -123, -128, -128, -128,
                -128, -128, -128, -128, -128, -121, -112, -58, -38, -84, -119, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -106, -128, -75, -28, -42, -82, -92, -101,
                -41, -88, -113, -64, -116, -128, -119, -128, -104, -42, -93, -128, -117, -128,
                -126, -110, -109, -70, -59, -1, 41, 69, 103, 127, 127, 127, 121, 74, 123, 127,
                101, 45, 18, 30, 77, 125, 127, 127, 102, 80, 69, 106, 45, 37, 15, 25, 64, 31,
                -22, -57, -105, -61, -89, -106, -81, -51, -60, -84, -37, -23, 8, 48, 20, -30,
                -38, -17, -53, -10, -27, -20, -28, -13, -62, -36, -27, 26, 78, 28, -29, -79,
                -114, -95, -98, -93, -105, -52, -76, -70, -57, -50, -41, -75, -84, -120, -56,
                -98, -108, -69, -68, -33, 7, -11, 28, 42, 55, 15, -25, -65, -97, -128, -75, -90,
                -89, -37, -17, -43, 4, -14, 12, -12, 40, 95, 73, 90, 121, 112, 68, 117, 57, 92,
                79, 86, 24, 71, 86, 109, 56, 108, 127, 92, 77, 47, 57, 25, -32, -24, -12, -28,
                -47, -28, 9, 16, 68, 116, 57, 9, 26, 68, 16, 58, 39, -7, -32, -56, -51, -42, 2,
                22, -3, -24, -48, -64, -54, -106, -117, -66, -52, -75, -43, -83, -70, -102, -81,
                -61, -111, -128, -101, -38, -88, -75, -123, -81, -74, -64, -1, 47, 47, 90, 81,
                72, 32, 72, 95, 114, 52, 38, -1, -15, -26, -74, -28, -15, 38, 34, 68, 88, 112,
                58, -1, -51, -96, -50, -92, -85, -128, -128, -128, -128, -128, -114, -128, -128,
                -128, -128, -128, -128, -128, -82, -100, -128, -128, -128, -70, -112, -64, -115,
                -82, -70, -44, -90, -51, -9, 48, 95, 68, 32, -21, -59, -38, -55, -85, -34, -6,
                36, -21, -8, 34, 59, 38, 40, 41, 22, 43, 17, 65, 17, -12, 26, 41, 53, -9, 18,
                43, -19, 7, -2, 29, -14, -31, -62, -41, -41, -89, -128, -128, -128, -97, -125,
                -113, -128, -128, -128, -97, -110, -80, -37, -82, -57, -41, -26, -20, 30, 26,
                34, 27, -17, 23, -7, 49, 7, -10, 25, 12, 58, 33, 61, 29, -6, -56, -36, -39, -5,
                29, 81, 48, 7, 46, 90, 78, 113, 90, 124, 127, 127, 127, 76, 87, 96, 88, 70, 49,
                101, 83, 53, 27, 52, 89, 127, 110, 114, 91, 97, 59, 6, 32, 61, 23, -15, 0, 35,
                -6, 16, 58, 63, 111, 127, 127, 127, 127, 127, 127, 127, 124, 125, 123, 127, 127,
                127, 122, 117, 71, 106, 127, 127, 92, 81, 127, 127, 127, 127, 87, 87, 39, 50, 4,
                -4, 4, 37, 52, 89, 41, 22, -35, -16, -64, -16, 32, -12, -4, 32, 53, 50, -5, 28,
                23, 79, 78, 110, 116, 121, 76, 57, 82, 114, 57, 104, 120, 127, 116, 85, 32, 32,
                65, 17, 59, 4, 46, 95, 88, 60, 90, 109, 95, 86, 110, 45, -3, 39, -11, 6, 7, 57,
                3, 34, 19, 62, 76, 48, 66, 63, 13, -29, -30, 28, 11, -41, -68, -53, -85, -117,
                -128, -128, -95, -120, -127, -105, -128, -95, -96, -68, -54, -71, -10, 6, 58,
                63, 27, 76, 111, 123, 98, 95, 127, 88, 46, 82, 127, 67, 120, 127, 106, 127, 124,
                82, 118, 103, 123, 102, 86, 114, 74, 38, -9, -23, -46, -48, -101, -106, -48,
                -19, -20, -71, -56, -2, 44, 25, 61, 23, -12, -5, 53, 89, 36, 24, -32, 26, 35,
                -12, -35, -19, -64, -93, -104, -122, -122, -128, -128, -113, -65, -22, -17, -8,
                29, 58, -4, 5, -46, 4, 51, 54, 109, 44, 83, 55, 105, 127, 127, 127, 127, 127,
                127, 104, 94, 110, 77, 100, 94, 127, 81, 127, 127, 127, 127, 127, 127, 82, 30,
                -11, 37, 61, 10, -7, -20, 13, 53, 14, 69, 84, 37, 42, 59, 67, 108, 62, 45, -9,
                -26, -54, -10, 7, 23, -32, -50, -53, -103, -82, -68, -67, -33, -16, -28, -48,
                -32, -23, -41, -69, -120, -108, -85, -50, -42, -5, 28, 60, 43, 89, 59, 20, 7,
                -37, -70, -103, -76, -94, -117, -88, -41, -49, -14, 23, 74, 34, 27, 80, 127,
                127, 108, 126, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 97, 121,
                102, 61, 72, 27, -31, 3, -55, -81, -51, -30, -3, 33, 18, -11, -43, -84, -57,
                -53, -40, -53, -14, -53, -87, -96, -63, -47, -56, -23, -32, -87, -58, -80, -93,
                -87, -71, -42, -65, -48, -66, -88, -56, -19, 16, 65, 113, 63, 18, 39, 80, 119,
                70, 48, 30, -11, -58, -92, -61, -77, -76, -100, -109, -128, -128, -107, -53,
                -34, 2, 33, 51, 39, 5, -41, -54, -24, 8, 40, -8, -63, -91, -61, -83, -128, -81,
                -25, 20, 25, 59, 74, 122, 60, 103, 120, 70, 88, 127, 110, 78, 21, -28, 1, 59,
                13, -37, -84, -59, -109, -50, -88, -107, -71, -93, -88, -25, 17, 25, 53, 69, 58,
                39, 43, 23, 51, 29, 2, 41, 34, -19, -47, -38, -91, -59, -65, -103, -128, -72,
                -85, -52, -70, -63, -108, -65, -116, -118, -125, -103, -88, -83, -128, -89, -51,
                -16, 42, -4, -48, -90, -95, -99, -128, -128, -86, -62, -76, -69, -62, -9, -34,
                23, 75, 27, 79, 22, 34, 13, -40, -63, -110, -64, -47, -95, -117, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -87,
                -128, -95, -98, -106, -61, -81, -83, -35, 14, -5, 41, 80, 58, 42, -5, -15, 39,
                60, 114, 127, 118, 70, 14, 22, -16, -26, -50, -96, -50, -30, 27, 32, 75, 47, -2,
                -18, 3, -5, 39, 8, -40, -23, -15, -44, 10, 46, 95, 83, 127, 99, 72, 112, 53, 86,
                26, 26, 12, -31, 23, 79, 34, 58, 20, -24, 18, 72, 27, 10, -35, -62, -43, 3, 48,
                90, 112, 62, 85, 84, 102, 127, 98, 40, 54, -5, -55, -50, -58, -13, -69, -68,
                -96, -106, -128, -128, -111, -88, -128, -128, -128, -128, -128, -111, -88, -105,
                -61, -44, -39, -65, -24, -22, 6, 0, -55, -84, -59, -1, 21, 8, 49, 66, 102, 70,
                51, -6, -60, -74, -98, -43, -9, -31, 10, 44, 71, 66, 3, -22, -24, -1, 38, 92,
                94, 93, 103, 77, 43, 83, 122, 91, 73, 106, 52, 57, 74, 88, 69, 101, 63, 115, 89,
                63, 9, -36, -30, -31, -78, -77, -98, -55, -30, -77, -117, -128, -128, -128,
                -128, -128, -106, -128, -64, -103, -128, -128, -128, -73, -98, -128, -128, -128,
                -128, -85, -58, -4, -33, 9, -19, -13, 46, 10, 24, -14, -56, -74, -28, -13, -39,
                -94, -94, -46, -13, 14, 68, 53, 53, 73, 22, 66, 104, 103, 100, 127, 89, 49, -12,
                43, 90, 111, 85, 115, 127, 89, 48, 20, -12, -25, -80, -75, -75, -89, -128, -128,
                -128, -128, -128, -128, -117, -128, -128, -128, -128, -117, -102, -114, -83,
                -44, -89, -78, -45, 13, 70, 117, 127, 127, 127, 127, 127, 127, 127, 124, 127,
                106, 126, 127, 127, 119, 127, 127, 127, 127, 76, 45, 75, 101, 127, 127, 127,
                127, 127, 127, 127, 127, 95, 76, 51, -9, -63, -93, -58, -57, -54, -40, -89,
                -100, -60, -91, -128, -128, -76, -96, -33, -62, -2, 27, 10, 10, -3, 55, 93, 127,
                69, 85, 37, -3, -43, -61, -9, -58, 3, 30, 25, -21, -68, -71, -39, -43, -4, 30,
                10, 12, 45, 98, 127, 127, 127, 77, 112, 127, 127, 127, 127, 127, 127, 127, 127,
                97, 115, 82, 29, 65, 5, -37, 20, 42, 32, 21, 33, 45, 61, 36, 59, 50, 100, 106,
                117, 123, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 113,
                118, 121, 127, 121, 80, 44, 75, 116, 127, 127, 127, 127, 119, 127, 91, 74, 62,
                51, 54, 84, 125, 127, 122, 71, 122, 69, 40, 87, 36, 61, 96, 127, 98, 47, 84, 85,
                122, 99, 71, 106, 108, 113, 114, 127, 115, 89, 120, 109, 127, 127, 104, 71, 108,
                80, 99, 114, 77, 14, 3, -31, -32, -75, -67, -112, -119, -90, -44, -15, -35, -81,
                -76, -17, -9, 26, 11, 49, 66, 43, 79, 16, 8, -36, -52, -29, -67, -113, -108,
                -46, -100, -44, -56, -2, -11, -62, -21, -10, -34, -29, 18, 33, 41, 90, 92, 87,
                104, 83, 28, -21, -10, 16, 62, 59, 18, 22, 1, -28, -40, -35, 25, 5, 52, 46, 41,
                20, 3, -30, -14, -57, -84, -25, 35, 37, 33, 56, -4, 2, -3, -42, -25, -76, -68,
                -50, -84, -64, -11, 34, -9, -39, -32, 6, 8, -14, 44, 6, -2, -46, -8, -40, -75,
                -69, -88, -88, -101, -128, -128, -83, -106, -128, -116, -111, -75, -97, -56, 5,
                -43, -79, -128, -99, -108, -105, -119, -122, -87, -89, -42, -67, -89, -119, -98,
                -128, -128, -128, -124, -115, -57, -77, -66, -78, -57, -82, -62, -42, -65, -55,
                -93, -95, -97, -96, -128, -87, -128, -128, -128, -108, -109, -46, -38, -65,
                -110, -93, -78, -124, -128, -128, -128, -128, -128, -92, -114, -128, -82, -112,
                -58, -19, -30, 10, -34, -10, -41, -2, -12, 47, 82, 24, 20, 37, -19, -49, -80,
                -101, -122, -119, -128, -128, -128, -128, -128, -128, -113, -113, -59, -29, -73,
                -42, -63, -106, -46, -68, -109, -128, -104, -48, -22, 22, -19, 29, 51, 91, 116,
                127, 123, 60, 28, 27, 58, 31, 72, 82, 76, 37, 46, 0, -41, 18, 62, 73, 34, 10,
                66, 87, 25, 33, 26, -23, -23, -31, -44, -73, -38, 7, 39, -6, -19, -50, 7, -27,
                -40, -94, -118, -74, -90, -97, -128, -80, -51, -91, -87, -42, -11, -7, 21, -15,
                29, -12, -47, -52, -98, -39, -85, -91, -91, -35, -79, -75, -113, -69, -50, -42,
                -35, -33, -51, -4, 43, 33, 46, 40, 39, 75, 71, 33, -11, 21, -22, -52, -10, -61,
                -107, -128, -113, -107, -128, -128, -124, -128, -122, -82, -81, -50, -33, -18,
                -48, 3, -21, -21, -57, -43, -47, -77, -128, -78, -91, -75, -78, -53, -38, -32,
                17, 46, 58, 6, -33, -12, 27, 13, 52, 40, 57, 49, 74, 48, 84, 90, 35, 72, 29, 53,
                64, 3, 53, 73, 59, 1, 30, 57, 28, 12, -47, -16, 26, -31, -19, -28, -56, 5, 25,
                66, 46, 51, -5, -47, -81, -75, -13, 45, -1, -25, -79, -33, -25, -50, -68, -26,
                17, -6, -59, -49, 0, 37, 82, 127, 74, 39, 53, 101, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 82, 25, 76, 66, 3, 45, 71, 123, 127, 88, 63, 81, 33, -12, 15, 55,
                12, 61, 55, 87, 127, 127, 127, 111, 127, 92, 93, 80, 96, 55, 44, 59, 71, 114,
                111, 127, 127, 127, 127, 127, 110, 127, 127, 97, 39, -12, -64, -76, -55, -26,
                -54, -45, -56, -2, 20, 38, 51, 7, -18, -63, -97, -49, -79, -96, -92, -128, -123,
                -107, -89, -105, -65, -105, -55, -2, -6, -17, -74, -76, -89, -52, 3, 33, 57, 75,
                78, 48, 102, 73, 30, 14, -32, -68, -70, -66, -97, -109, -68, -6, -6, -20, -23,
                -6, -50, -9, -13, -19, -37, -89, -36, -6, 24, 15, 35, 79, 124, 75, 94, 127, 98,
                58, 102, 112, 54, 35, 8, -43, 14, 64, 75, 105, 65, 95, 88, 98, 90, 124, 127,
                101, 111, 114, 81, 79, 49, 69, 63, 94, 80, 69, 47, 73, 27, 6, -21, -77, -95,
                -60, -91, -27, -73, -118, -61, -59, -13, 22, 29, -25, 30, 85, 114, 74, 13, -30,
                -16, 16, -27, -79, -25, 13, -26, -82, -127, -82, -63, -10, 21, -2, 38, 86, 21,
                61, 61, 111, 127, 102, 110, 53, 87, 43, 74, 66, 58, 9, 34, -3, -32, -21, -69,
                -51, -20, 11, 6, 20, 61, 57, 102, 127, 127, 112, 127, 127, 85, 127, 116, 90, 37,
                -3, 40, 23, 74, 21, 43, 97, 72, 67, 76, 108, 61, 68, 70, 68, 29, 64, 73, 121,
                127, 107, 86, 35, 16, 14, 37, 1, -50, -19, 32, 13, 29, 39, 56, 74, 36, 75, 100,
                83, 37, 64, 58, 29, 72, 79, 74, 125, 127, 97, 88, 61, 66, 113, 91, 28, 34, -20,
                -65, -73, -30, -35, 19, 53, 8, 61, 1, 25, 66, 16, 15, 33, 61, 93, 80, 116, 109,
                109, 123, 65, 15, -43, -89, -52, -21, -47, -97, -103, -128, -95, -94, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -128, -94, -61, -74, -70, -100, -111, -78, -120, -57, -51,
                -36, -80, -98, -42, -5, -55, -100, -39, 6, 39, 52, 67, 70, 117, 91, 113, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 108, 111, 127, 127, 127, 127, 127, 127, 127, 127, 127, 115,
                90, 96, 61, 77, 24, 28, 46, 39, 76, 127, 113, 120, 127, 103, 75, 61, 8, -10,
                -54, -108, -113, -71, -80, -128, -110, -71, -17, -60, -72, -82, -92, -61, -77,
                -65, -81, -21, -23, 25, 38, -12, 21, 40, 26, 71, 67, 78, 42, 95, 63, 107, 127,
                127, 111, 47, 67, 19, 55, 77, 48, 2, 26, 65, 50, 13, -18, -73, -99, -46, -47,
                -77, -97, -128, -124, -104, -57, -97, -49, -2, 15, -28, -82, -84, -84, -58, -24,
                16, -30, -50, -58, -108, -102, -41, -71, -65, -29, -18, 37, 13, -5, -49, -71,
                -54, -98, -124, -86, -63, -68, -96, -81, -72, -9, -42, -84, -84, -116, -128,
                -121, -83, -45, -32, -64, -105, -114, -123, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -113, -128, -128, -128,
                -128, -128, -128, -102, -86, -125, -128, -128, -128, -128, -128, -99, -51, -57,
                -89, -55, -94, -106, -124, -109, -123, -78, -66, -46, 10, 10, 9, 14, -21, -51,
                -99, -70, -82, -92, -97, -128, -128, -128, -128, -128, -128, -123, -128, -114,
                -87, -25, -47, -70, -85, -115, -128, -128, -115, -57, -67, -34, -17, 7, -17, 33,
                -24, -56, -42, -95, -75, -90, -128, -109, -86, -58, -49, -41, -19, 10, 49, -8,
                -61, -82, -47, -79, -117, -128, -128, -80, -32, 8, -50, -23, -55, -52, -9, -53,
                -73, -87, -60, -29, -84, -101, -51, -40, -50, -61, -11, -43, -57, -100, -37, 10,
                45, 55, 19, 44, 92, 72, 12, -23, -10, -36, -69, -44, -81, -21, 20, 19, -6, -36,
                -27, -19, 36, 20, 62, 70, 33, -21, 2, 9, 9, 25, 77, 54, 32, 49, 22, 50, 79, 98,
                95, 75, 103, 102, 120, 76, 121, 83, 41, 81, 67, 32, 74, 58, 70, 66, 61, 112,
                127, 127, 127, 127, 127, 127, 127, 101, 123, 60, 105, 127, 127, 127, 127, 127,
                127, 127, 127, 109, 127, 92, 55, 102, 127, 127, 107, 57, 76, 56, 14, 10, 51, 73,
                94, 93, 45, 58, 7, 35, 44, 2, -12, -30, -42, -28, -23, -25, -28, -46, -77, -77,
                -33, 23, 14, 5, -21, -32, 13, 60, 81, 37, 67, 63, 105, 115, 122, 127, 127, 127,
                127, 127, 127, 127, 120, 127, 61, 92, 127, 88, 92, 38, 93, 102, 74, 33, 76, 38,
                35, 82, 78, 79, 107, 65, 81, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                123, 127, 127, 121, 114, 127, 127, 127, 127, 127, 75, 105, 91, 29, 43, -2, -5,
                27, 4, 13, 65, 66, 91, 120, 127, 123, 112, 127, 90, 127, 97, 100, 88, 115, 127,
                127, 118, 84, 108, 98, 127, 127, 127, 123, 108, 95, 68, 50, 64, 12, 58, 52, 79,
                29, 74, 82, 44, 9, 47, 64, 82, 73, 126, 127, 86, 92, 53, 34, 89, 115, 84, 67,
                44, 13, 18, -31, -16, -71, -58, -63, -96, -49, -12, -30, 1, -15, 18, 35, -6,
                -22, -39, -35, 3, -11, 32, 43, -17, 3, -50, -85, -115, -114, -75, -104, -107,
                -128, -124, -117, -96, -126, -128, -113, -59, -41, -18, -49, -1, 47, 81, 26, 67,
                25, 21, 35, 12, -9, -28, 15, -37, -32, 3, -44, -88, -63, -113, -58, -14, 23,
                -13, -22, -40, -85, -110, -112, -128, -91, -119, -123, -128, -126, -70, -41, -3,
                -26, 2, 49, 62, 88, 31, -10, -13, 19, 15, -11, 8, 32, 86, 57, 33, -5, 36, 64,
                13, 24, 41, 33, 31, 40, -18, -74, -118, -128, -94, -109, -107, -63, -117, -77,
                -107, -43, -77, -85, -126, -70, -25, -39, -29, -1, -32, -49, -94, -125, -89,
                -42, 12, -26, 15, 70, 113, 93, 108, 86, 83, 44, 94, 113, 54, 35, 13, 3, -26, 25,
                9, -36, -38, -57, -89, -109, -86, -42, -75, -29, -25, -30, -28, -34, -3, -6,
                -48, 7, 22, -12, 7, -17, 9, -24, 2, 42, -15, -37, -51, -63, -20, 6, 56, 106, 59,
                94, 127, 73, 104, 86, 127, 127, 127, 127, 127, 91, 67, 51, 36, 70, 69, 43, -17,
                -21, -65, -15, -45, -52, -2, -10, 37, -1, -33, -5, -57, -74, -69, -70, -111,
                -86, -112, -93, -72, -21, 38, 91, 55, 72, 25, -35, -77, -85, -45, -12, 27, 70,
                10, 47, 94, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 117, 55, 8, 43, 91, 49, -7, -11, 3, 53,
                65, 24, -4, 52, 32, 82, 115, 79, 110, 110, 53, 99, 51, 97, 104, 127, 69, 119,
                89, 61, 35, 60, 10, -21, -69, -55, -40, 12, -40, 9, 65, 111, 56, 96, 114, 88,
                63, 37, 29, -14, -34, -84, -78, -123, -87, -126, -128, -128, -128, -128, -110,
                -121, -128, -128, -128, -123, -61, -75, -22, -78, -110, -128, -128, -119, -79,
                -98, -79, -118, -118, -74, -83, -53, 4, -45, 8, -5, -42, 8, 26, 42, 43, 4, 49,
                11, 11, 45, 67, 35, -8, -22, -43, 6, 46, 28, -16, -45, -34, -57, -58, -58, 2,
                -30, -25, -19, -12, -41, -9, -46, -20, 7, 16, 36, 66, 69, 99, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 118, 52, 99, 40, 28, 12, 26, -30, 10, -42, -20, 1, -18, 13,
                -6, 35, 60, 100, 83, 57, -5, 35, -16, 16, 23, 34, 8, -7, -52, 9, -12, -55, -65,
                -116, -123, -128, -93, -85, -101, -122, -111, -65, -67, -73, -29, -74, -72, -66,
                -84, -122, -117, -128, -128, -128, -128, -128, -122, -128, -67, -91, -128, -87,
                -128, -78, -53, -93, -31, -17, 40, 1, 26, 16, 44, 58, 30, 2, -57, -45, -54, -94,
                -125, -128, -128, -121, -93, -123, -75, -71, -101, -73, -122, -74, -21, -73,
                -90, -39, -66, -28, 18, 52, 49, 67, 105, 115, 117, 127, 112, 127, 111, 121, 105,
                40, 69, 47, 29, 37, 19, 46, 12, 69, 119, 97, 78, 46, 40, 29, 38, 58, 105, 127,
                127, 127, 127, 60, 97, 127, 114, 127, 127, 127, 127, 127, 127, 127, 91, 78, 102,
                127, 108, 68, 28, 55, 93, 108, 127, 76, 127, 127, 88, 36, 89, 37, 4, 60, 64, 98,
                114, 91, 103, 72, 29, 62, 73, 102, 96, 89, 42, 40, 21, -36, 15, -19, -67, -88,
                -80, -68, -65, -105, -46, -21, 2, -54, -106, -128, -128, -128, -94, -100, -45,
                -10, 34, 65, 14, 25, -25, -66, -97, -62, -101, -111, -114, -104, -49, -4, 32,
                38, 7, -15, 16, 54, -4, 8, -40, -46, -24, -60, -104, -41, -38, -8, 40, 20, -27,
                -45, -87, -42, -16, 8, 19, 62, 106, 88, 93, 90, 76, 94, 41, 82, 27, 47, 91, 27,
                -32, -62, -14, 35, 89, 122, 127, 127, 127, 127, 127, 127, 127, 96, 65, 5, 14,
                -8, 27, 55, 14, -2, -26, -69, -8, -30, -44, 7, 17, -16, -21, -34, -35, -67,
                -105, -117, -122, -128, -111, -59, -25, -12, 41, -14, -42, -90, -26, -15, -65,
                -93, -108, -44, -86, -47, -90, -127, -128, -128, -128, -128, -110, -112, -64,
                -109, -80, -31, -73, -67, -66, -85, -109, -47, -94, -81, -80, -113, -63, -3, 8,
                11, 28, -21, 36, -6, -47, -90, -125, -109, -76, -98, -128, -109, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -124, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128,
                -128, -128, -124, -128, -128, -128, -128, -128, -114, -81, -122, -93, -115, -82,
                -26, 29, 6, 6, 62, 33, -7, -38, -70, -67, -31, 7, 57, 28, 44, 1, -7, 44, -12, 6,
                45, 58, 10, 5, 58, 90, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                121, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 123, 127, 105, 66, 42, 26, 28, 33, -10,
                11, -19, -55, -104, -63, -23, -18, -42, -63, -34, -58, -29, 18, 35, 4, 54, 77,
                28, 9, -42, -60, -38, -72, -17, 35, -2, -15, -44, 17, 15, 57, 26, 46, 5, -4,
                -16, 16, 37, 65, 9, -25, -54, -21, -55, -33, -80, -116, -128, -128, -91, -128,
                -128, -128, -87, -128, -109, -87, -45, -62, -46, 6, -6, -33, 6, 37, 93, 111, 99,
                46, 3, -45, -38, -51, 5, 50, 88, 66, 7, -35, 17, 18, 67, 47, -1, 12, -32, 23,
                26, -5, -55, -36, -11, 15, 72, 88, 109, 73, 23, 10, 35, -19, -64, -4, -55, -89,
                -39, -68, -12, -42, 3, 25, 80, 60, 60, 77, 52, 16, 71, 79, 80, 19, -6, -54, 0,
                -42, -44, -61, -114, -47, -98, -67, -8, -15, -34, -81, -24, 3, -37, -19, -49,
                10, -49, -1, 21, 28, 6, -3, 54, -7, 36, 22, 76, 78, 18, -34, -47, -27, 1, -32,
                -81, -97, -37, 1, 34, 54, 2, 59, 77, 66, 84, 97, 123, 69, 102, 68, 85, 47, 17,
                -4, -40, -6, 31, 9, -28, 31, 55, 88, 92, 104, 90, 100, 72, 111, 45, 61, 36, -25,
                -31, 14, 48, 35, 29, 5, 7, 47, 48, 14, -27, -78, -44, -56, -29, -19, 24, 74,
                115, 115, 67, 41, 53, 72, 123, 122, 103, 89, 52, 65, 117, 127, 77, 127, 99, 105,
                49, 2, 31, 50, 29, -7, 20, -2, 0, -51, -50, -20, -25, 30, -14, -23, -66, -114,
                -128, -119, -128, -128, -128, -128, -128, -87, -101, -74, -91, -128, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -94, -82, -18, 4, -48, -46, -94, -89,
                -75, -23, -65, -36, -1, 53, 57, 47, 91, 69, 86, 99, 59, 24, -6, 25, 49, 55, 78,
                43, 14, 40, 58, 57, 3, 30, 25, 46, -6, -36, 24, -29, -75, -115, -50, -74, -80,
                -62, -64, -74, -50, -2, -3, 35, 12, -2, 36, 85, 91, 75, 43, 85, 54, 68, 80, 67,
                27, 15, 63, 85, 62, 113, 95, 112, 52, 7, 56, 5, 10, -21, -22, -44, -49, -23,
                -10, 4, -8, -26, -60, -50, 0, 28, 10, 38, 63, 108, 112, 116, 127, 126, 127, 127,
                127, 100, 127, 127, 127, 127, 127, 127, 120, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 114, 101, 45, 72, 103, 44, 91, 82, 116,
                110, 127, 127, 127, 106, 56, 11, 2, -35, -40, -32, -2, -54, -79, -128, -128,
                -128, -128, -128, -128, -128, -128, -128, -109, -59, -2, -26, 7, -28, 31, 44,
                13, -26, 22, 7, -25, 14, -18, -23, 36, 38, 6, -12, -46, -46, -73, -11, -10, -7,
                -3, 24, 50, -2, 23, 19, 18, 4, 20, -35, 12, 34, 8, 60, 5, 20, 73, 31, -5, -52,
                -97, -45, -7, 24, 63, 110, 127, 127, 127, 127, 122, 96, 117, 125, 63, 14, 49, 5,
                38, 80, 49, 96, 97, 31, 17, -9, -41, -94, -128, -128, -128, -128, -128, -128,
                -128, -123, -105, -42, -16, -59, -57, -78, -49, -8, -33, -7, -31, -32, -15, -57,
                -17, 27, 36, 50, 35, -1, 45, 67, 119, 78, 67, 109, 127, 106, 118, 127, 127, 127,
                127, 127, 90, 117, 127, 91, 40, 8, -36, -23, -37, -48, -28, 29, 56, 10, 18, 26,
                -17, 34, 51, 28, -27, -5, -40, 5, 28, 39, 92, 127, 127, 127, 127, 94, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 116, 94, 71, 98, 127, 73, 116, 127, 127, 127,
                77, 84, 106, 120, 127, 107, 111, 67, 59, 95, 127, 120, 123, 99, 77, 47, 92, 90,
                90, 127, 127, 94, 109, 91, 41, 85, 22, -33, 7, 57, 53, 65, 90, 127, 127, 94,
                122, 109, 92, 127, 127, 127, 127, 110, 127, 100, 50, 88, 127, 103, 126, 127,
                127, 118, 127, 113, 92, 116, 51, 2, -22, 12, 41, -5, -58, -87, -80, -96, -90,
                -115, -87, -69, -57, -44, 4, 53, 56, 105, 127, 127, 127, 127, 123, 76, 99, 118,
                107, 69, 57, 35, -20, 25, 51, 3, 10, -30, -12, -2, -26, 17, 41, 37, -1, -30,
                -39, -94, -52, -12, 31, 59, 35, 3, 35, 9, 53, 105, 122, 127, 127, 127, 114, 127,
                73, 33, 42, 50, 44, 53, 58, 37, 10, 49, 78, 109, 62, 76, 31, 6, 35, 12, -22,
                -49, 13, 21, 56, 9, -45, 3, 4, -1, 17, 10, 35, -26, -19, 28, 67, 16, 47, 31, 46,
                4, -47, -43, -41, -9, -15, -56, -109, -128, -128, -104, -62, -34, 9, 50, 97,
                127, 122, 58, 38, 1, -15, -64, -89, -102, -114, -128, -63, -14, -25, -34, -66,
                -66, -43, -36, -23, 15, -19, 27, -32, -53, -90, -62, -89, -112, -83, -50, -7,
                -52, -41, -93, -58, -109, -61, -27, -5, 20, 59, 50, 47, 70, 98, 92, 66, 83, 39,
                75, 51, -3, -28, -71, -26, -48, -49, -67, -47, -48, -71, -108, -63, -81, -66,
                -51, -33, -46, -87, -37, -30, -50, -45, -51, -103, -95, -69, -84, -37, -85, -80,
                -80, -33, -88, -81, -111, -128, -97, -52, -39, -40, -6, -44, -94, -57, 4, -43,
                2, 22, 69, 14, 42, 83, 106, 60, 114, 97, 100, 94, 69, 19, -21, 31, 35, 65, 60,
                18, -3, -56, -12, 12, 32, 39, -19, -55, -92, -121, -128, -128, -128, -128, -128,
                -128, -107, -123, -124, -68, -69, -62, -88, -66, -112, -65, -4, -21, -25, 7,
                -11, -6, -61, -5, -25, -78, -61, -28, -45, -7, 8, 58, 94, 127, 85, 52, 37, 29,
                64, 116, 117, 51, 91, 88, 112, 68, 77, 75, 47, 97, 127, 127, 125, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 89, 62, 89, 93,
                71, 59, 79, 97, 90, 125, 103, 59, 69, 52, 5, -36, -36, -58, -95, -111, -128,
                -128, -126, -81, -123, -65, -44, -43, -95, -112, -121, -97, -70, -109, -80, -41,
                6, -43, -12, -69, -73, -101, -128, -101, -69, -94, -128, -102, -128, -128, -128,
                -128, -128, -128, -128, -100, -74, -122, -65, -80, -116, -52, -104, -51, -41,
                -24, 22, 42, 74, 70, 41, 37, -12, 37, 64, 24, -3, 50, 11, 14, -12, 37, 79, 70,
                38, 28, -7, -22, -54, -81, -55, -19, -25, -38, -74, -63, -92, -77, -25, -80,
                -48, -54, -69, -93, -86, -94, -72, -14, 3, -9, 15, -5, 48, 28, 3, -17, 0, 28,
                -3, -46, 15, 52, 69, 57, 89, 95, 100, 87, 107, 97, 72, 26, 22, 51, 46, 62, 12,
                62, 31, -23, 14, -16, 10, -17, 0, -27, -74, -115, -128, -111, -77, -115, -104,
                -94, -128, -110, -128, -128, -128, -118, -128, -104, -114, -64, -27, 2, -30,
                -52, -29, 20, 54, 22, 47, 29, 27, -32, 13, -18, 36, 10, -11, -41, -83, -22, 14,
                -13, 47, 45, 84, 127, 127, 127, 110, 127, 127, 94, 127, 85, 127, 127, 127, 76,
                94, 127, 127, 121, 124, 127, 108, 115, 127, 89, 79, 114, 93, 79, 39, 72, 124,
                127, 127, 127, 118, 127, 106, 88, 75, 62, 63, 20, 0, -47, -32, -58, -62, 0, -3,
                25, 50, 63, 109, 98, 127, 127, 127, 127, 127, 122, 100, 46, 59, 54, -7, -39,
                -66, -69, -25, -1, -57, -85, -45, -99, -38, -69, -34, -46, -23, -6, -26, -23,
                -18, -23, -14, -48, 5, -36, -15, 15, -20, 10, 22, 46, 43, 30, 74, 86, 78, 91,
                91, 127, 82, 52, 82, 31, 22, 52, 78, 23, -19, -63, -57, -28, -20, -32, -10, 38,
                65, 2, 13, -17, -15, -29, -80, -87, -72, -122, -128, -128, -128, -128, -85,
                -119, -128, -128, -128, -128, -128, -108, -91, -111, -128, -90, -128, -114, -64,
                -72, -31, -67, -21, 1, -15, 39, 43, 3, -10, 11, 7, -21, -28, 13, 31, 82, 95, 99,
                62, 103, 59, 1, 28, -11, 39, 82, 50, 8, 35, 62, 22, 55, 40, 35, 3, -54, -13,
                -26, 11, -41, -26, -46, -34, -45, -15, -29, 26, 7, 26, 18, -28, -71, -17, -20,
                17, -3, 34, -5, -5, -8, 8, -5, 53, 1, 45, 25, -23, 15, -23, -60, -17, -15, -1,
                30, 52, 49, 16, -11, -51, -41, -53, -87, -30, -15, 28, 31, 72, 57, 63, 25, 31,
                27, 29, -27, 29, 28, 72, 30, 11, -36, -51, -44, 14, 8, 23, 41, 85, 120, 87, 26,
                23, -20, -1, 9, -47, 12, -44, 5, -30, 1, -21, 26, -21, -21, -20, 8, -7, -12,
                -28, -76, -21, 17, -22, -18, -16, -18, 9, 13, 44, 38, 57, 86, 110, 81, 103, 71,
                15, 6, 47, -5, 27, -3, 52, -1, -49, -69, -115, -128, -128, -118, -114, -102,
                -128, -86, -58, 1, -31, -47, -75, -74, -83, -39, -3, -36, -86, -122, -127, -128,
                -106, -92, -62, -18, -37, -47, -62, -83, -95, -104, -68, -109, -44, -93, -55, 2,
                3, -4, 19, -30, 12, -24, 32, 38, 85, 94, 79, 75, 22, 65, 64, 3, 29, 27, 49, 72,
                62, 56, 10, 39, 9, 59, 77, 112, 104, 127, 98, 127, 127, 111, 70, 68, 111, 112,
                109, 77, 111, 122, 73, 117, 91, 81, 121, 111, 127, 66, 44, 43, 93, 39, 17, -9,
                -15, -7, -25, 14, -19, -50, -13, 24, -23, -68, -8, -28, -40, -16, -46, -28, -41,
                -11, -4, 22, -8, -50, -46, -37, -73, -33, -61, -113, -90, -83, -123, -102, -128,
                -125, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -90, -40, -26,
                -29, 31, 34, 30, 9, 35, -24, 31, 36, 51, 83, 94, 42, 51, 67, 106, 81, 124, 101,
                54, 21, -27, 12, 43, 5, -33, -33, 27, 25, 49, 32, 21, 12, -40, -10, -46, -99,
                -128, -120, -102, -55, -59, -71, -87, -87, -51, -42, -61, -93, -92, -114, -86,
                -52, -38, -26, -14, 11, 39, 70, 40, 64, 44, 94, 91, 68, 21, 39, 32, -27, -42, 2,
                -10, -61, -91, -123, -128, -124, -63, -49, -32, -13, -63, -92, -128, -128, -128,
                -128, -128, -115, -122, -120, -122, -104, -78, -128, -121, -61, -24, 16, 55, -4,
                5, 63, 76, 20, 74, 89, 68, 52, 97, 48, -13, 28, 80, 85, 39, 17, 46, 76, 40, 30,
                72, 36, 19, -33, 2, -23, -73, -40, -88, -95, -127, -128, -128, -128, -128, -83,
                -60, -102, -105, -128, -91, -47, -92, -99, -84, -76, -52, -97, -74, -57, -31,
                -28, -6, 41, 25, 29, -28, -10, -18, -27, 22, 62, 54, 101, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 115, 122, 127, 93,
                71, 75, 72, 108, 123, 127, 127, 127, 127, 80, 122, 78, 101, 71, 68, 66, 96, 122,
                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                127, 127, 127, 127, 127, 127, 127, 127, 109, 127, 127, 90, 38, 47, 77, 56, 25,
                -14, 37, 75, 38, 30, -6, 43, 52, 104, 127, 74, 96, 31, -4, -10, 30, -21, 25, 9,
                49, 101, 127, 83, 31, 15, 8, 32, 61, 17, -42, -32, -8, 9, 10, -3, 4, 37, 2, -41,
                -95, -111, -117, -89, -60, -45, -78, -90, -115, -88, -128, -128, -128, -91, -89,
                -38, 22, -18, 23, 64, 69, 8, 3, 43, -18, -63, -17, -8, -38, -58, -42, -91, -96,
                -128, -110, -128, -118, -127, -65, -44, -16, -4, 53, 35, 25, -2, -9, -26, -22,
                -36, -63, -13, -16, 34, 61, 73, 87, 87, 74, 100, 106, 66, 13, -14, -39, -35,
                -40, -86, -96, -59, -93, -35, 0, -1, 51, 37, 58, 105, 127, 80, 103, 120, 94, 74,
                13, -34, -14, -41, -49, -66, -73, -39, 15, 50, 77, 107, 127, 65, 26, 59, 110,
                127, 127, 127, 127, 84, 55, 69, 62, 57, 18, -21, -8, -22, -7, -26, -47, -47,
                -60, -110, -128, -128, -100, -124, -128, -128, -128, -100, -67, -8, -26, -30,
                -38, -14, -54, -2, -24, -46, -15, -7, 23, 55, 72, 22, -19, 17, 38, -22, 36, -1,
                6, -50, -7, 5, -16, -65, -100, -70, -99, -128, -128, -90, -51, 3, 24, 21, 17, 8,
                -7, 45, 97, 97, 52, 11, -17, -61, -114, -94, -31, -57, -10, -48, -37, -6, -51,
                -50, -58, -12, -31, 0, -23, -6, -33, -57, -83, -19, -42, 4, 62, 37, 15, -14,
                -32, 17, 29, -12, -8, 13, 6, -20, -32, 0, -54, -41, -90, -68, -111, -48, -85,
                -57, -78, -36, -50, -60, -15, 2, 21, 5, 10, -8, -18, -30, 28, 1, 58, 100, 96,
                52, 65, 98, 127, 90, 75, 61, 94, 113, 64, 66, 61, 106, 122, 127, 127, 127, 79,
                32, 30, 80, 112, 127, 127, 127, 127, 72, 27, 52, 105, 53, 83, 47, -5, -34, -81,
                -23, -10, -15, 39, 57, 7, -28, 17, 19, 45, 35, 24, 77, 40, 4, -47, 12, 30, 18,
                64, 79, 24, -34, -7, 7, -37, -43, -52, -91, -44, -96, -105, -96, -40, -78, -62,
                -96, -90, -37, -4, -27, -53, -6, 17, 11, -28, -75, -20, -55, -76, -115, -84,
                -86, -59, -91, -66, -36, -27, -81, -120, -128, -128, -128, -128, -128, -85, -62,
                -101, -128, -128, -128, -128, -128, -128, -96, -111, -71, -68, -13, 11, 41, 26,
                -6, -3, -29, -39, 19, 76, 102, 67, 83, 59, 104, 112, 108, 57, 96, 112, 127, 127,
                127, 87, 39, 77, 38, 83, 97, 86, 104, 96, 45, 36, -13, 5, 31, 37, -2, -44, -2,
                -7, 34, 29, 80, 63, 115, 127, 127, 127, 127, 127, 111, 95, 49, 3, 34, 56, 40,
                19, -35, -6, 29, 75, 71, 100, 41, 46, 92, 53, 90, 48, 42, 13, -1, 20, -8, -14,
                -41, -25, 13, -39, -86, -67, -30, -38, -48, 3, 15, 33, 88, 89, 122, 69, 61, 27,
                21, -20, -14, -34, 18, 29, 44, 2, 10, 58, 9, 3, -20, -4, 46, -6, 6, -39, -68,
                -61, -54, -41, -45, -17, 3, -15, 0, 44, 84, 100, 41, 67, 28, 62, 89, 118, 127,
                127, 127, 127, 127, 96, 66, 78, 97, 126, 89, 45, 40, 83, 127, 93, 96, 53, 22,
                18, -24, -40, -48, -71, -87, -35, -29, 12, 69, 50, 91, 90, 127, 127, 127, 127,
                127, 127, 127, 127, 114, 127, 127, 127, 127, 76, 42, 20, 57, 80, 102, 64, 24, 2,
                -42, -95, -112, -101, -61, -51, -65, -114, -96, -110, -116, -91,
        };

#endif /* BROWNNOISE8192_H_ */
