#ifndef CHUM78_H_
#define CHUM78_H_

#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
#include "mozzi_pgmspace.h"

/* A sampled guitar sound
*/

#define CHUM78_NUM_CELLS 8193
#define CHUM78_SAMPLERATE 16384

CONSTTABLE_STORAGE(int8_t) CHUM78_DATA []  =
        {
                -12, -28, -24, -14, -15, -14, -15, -23, -21,
                -13, -10, -25, -47, -49, -37, -37, -47, -46, -35, -28, -30, -27, -27, -48, -57,
                -52, -34, -30, -56, -59, -44, -38, -38, -37, -35, -39, -59, -65, -56, -61, -57,
                -41, -36, -37, -41, -32, -16, -10, -21, -25, 2, 7, -13, -17, -11, -24, -30, -14,
                -2, -8, -25, -16, 1, -7, -12, 2, 13, -2, -18, 1, 11, 12, 12, 12, 25, 9, -14,
                -12, -5, -6, -1, 12, 1, -15, -2, 20, 28, 25, 7, 9, 30, 15, 2, -1, 1, 21, 30, 27,
                33, 26, 14, 14, 20, 32, 35, 23, 21, 25, 32, 43, 42, 49, 42, 23, 23, 21, 23, 16,
                9, 12, 12, 21, 33, 29, 12, 11, 10, 10, 14, 18, 29, 23, 6, -9, 8, 22, 16, 6, -19,
                -25, -20, 4, 4, -15, -14, -19, -3, 5, 2, -4, -21, -22, 1, 13, -7, -24, -21, -20,
                0, 8, -10, -15, -16, -17, -21, -15, -12, -19, -22, -19, -20, -19, -10, -14, -10,
                -11, -30, -40, -41, -41, -40, -45, -34, -17, -27, -31, -26, -24, -22, -22, -32,
                -45, -44, -42, -43, -43, -52, -48, -29, -25, -41, -61, -62, -61, -58, -40, -40,
                -54, -61, -49, -29, -23, -24, -16, -14, -27, -16, -12, -8, -8, -22, -21, -21,
                -19, -31, -26, -9, -20, -12, 6, 1, -12, -22, -10, 12, 8, 10, 17, 14, 18, 19, 22,
                13, 0, 22, 25, 11, 5, 2, 29, 47, 48, 49, 41, 34, 19, 24, 41, 41, 37, 41, 53, 43,
                34, 46, 42, 31, 28, 24, 30, 39, 41, 50, 57, 59, 61, 62, 54, 36, 33, 32, 24, 20,
                17, 15, 30, 47, 38, 23, 22, 20, 9, 8, 5, 10, 15, 11, 23, 33, 22, 10, 14, 4, -7,
                -8, -18, -21, -23, -31, -27, -22, -11, 1, -11, -22, -21, -26, -37, -38, -44,
                -43, -30, -27, -29, -39, -37, -37, -50, -41, -32, -38, -42, -52, -63, -55, -59,
                -57, -42, -43, -49, -53, -51, -54, -57, -58, -68, -69, -61, -50, -38, -44, -45,
                -28, -25, -28, -34, -54, -51, -36, -32, -37, -47, -35, -25, -19, -20, -43, -47,
                -39, -35, -35, -31, -37, -43, -29, -18, -9, -3, -2, 1, -7, 11, 19, 12, 18, 3, 1,
                -2, 9, 23, 6, 7, 10, 3, -1, -1, 0, 13, 33, 35, 37, 38, 37, 38, 40, 46, 47, 44,
                46, 35, 20, 23, 23, 35, 52, 60, 66, 55, 48, 48, 45, 47, 45, 45, 48, 46, 53, 55,
                51, 48, 51, 54, 38, 36, 35, 36, 44, 48, 59, 67, 66, 71, 59, 40, 43, 40, 36, 32,
                23, 32, 44, 40, 46, 45, 25, 23, 22, 20, 15, 25, 33, 24, 25, 22, 21, 21, 15, -2,
                -8, -3, -3, -8, -11, -14, -19, -8, 4, 2, -11, -19, -18, -20, -23, -27, -30, -27,
                -24, -29, -33, -31, -31, -30, -31, -32, -32, -34, -35, -39, -39, -41, -42, -41,
                -47, -56, -58, -56, -56, -52, -53, -57, -62, -63, -62, -62, -62, -55, -51, -51,
                -46, -50, -65, -69, -62, -58, -56, -65, -68, -53, -46, -44, -48, -59, -70, -69,
                -66, -69, -72, -72, -69, -64, -48, -40, -44, -39, -34, -32, -27, -19, -15, -19,
                -32, -27, -8, -1, -2, -19, -28, -23, -21, -16, -16, -16, -3, 17, 23, 23, 25, 23,
                24, 29, 36, 37, 29, 25, 31, 32, 30, 41, 49, 52, 51, 48, 50, 53, 53, 50, 56, 64,
                71, 72, 72, 69, 72, 81, 83, 85, 66, 53, 58, 56, 55, 51, 61, 78, 80, 81, 84, 80,
                62, 53, 57, 52, 54, 58, 55, 54, 55, 54, 56, 49, 40, 36, 31, 24, 17, 14, 21, 30,
                28, 29, 27, 27, 15, 1, -1, -11, -13, -5, -9, -10, 4, 5, -1, -19, -24, -17, -29,
                -31, -35, -39, -26, -28, -35, -34, -38, -41, -36, -36, -38, -39, -40, -40, -41,
                -42, -43, -54, -61, -56, -54, -57, -53, -47, -58, -61, -54, -56, -56, -57, -63,
                -65, -52, -45, -46, -46, -45, -41, -41, -43, -50, -54, -56, -54, -38, -22, -21,
                -22, -32, -40, -35, -42, -47, -41, -41, -43, -44, -36, -22, -20, -14, -10, -10,
                -4, -1, 9, 13, 8, 8, 12, 22, 17, 3, 2, -2, -2, 0, 8, 14, 6, 15, 29, 31, 33, 37,
                42, 34, 32, 42, 45, 42, 41, 50, 52, 51, 54, 54, 51, 54, 61, 69, 73, 71, 69, 68,
                66, 68, 72, 74, 76, 82, 88, 88, 72, 56, 55, 56, 62, 59, 60, 69, 68, 78, 83, 77,
                65, 54, 50, 37, 46, 68, 63, 50, 49, 49, 55, 49, 34, 27, 17, 17, 21, 24, 15, 13,
                26, 32, 34, 33, 9, -11, -8, -13, -7, -10, -25, -30, -25, -17, -33, -41, -40,
                -47, -47, -46, -41, -43, -58, -63, -54, -51, -46, -60, -75, -70, -73, -75, -73,
                -69, -68, -70, -68, -72, -84, -88, -85, -77, -73, -78, -87, -85, -77, -80, -77,
                -75, -80, -92, -90, -74, -70, -62, -53, -58, -68, -68, -62, -64, -58, -65, -73,
                -48, -33, -36, -46, -56, -62, -63, -51, -46, -53, -61, -60, -50, -37, -32, -20,
                -11, -18, -18, -6, 1, 5, 6, 7, 16, 17, 5, -8, -7, -5, -3, 9, 7, -3, 3, 17, 29,
                36, 30, 32, 43, 35, 29, 33, 33, 45, 51, 48, 53, 53, 45, 43, 50, 61, 63, 58, 54,
                55, 63, 71, 73, 78, 70, 62, 68, 74, 75, 71, 67, 57, 63, 80, 82, 78, 65, 67, 72,
                72, 71, 72, 84, 71, 51, 48, 69, 76, 72, 65, 53, 59, 56, 68, 55, 31, 31, 28, 35,
                34, 30, 30, 36, 37, 42, 42, 16, 0, -4, -6, 3, 0, -18, -21, -22, -26, -27, -27,
                -36, -42, -45, -51, -52, -51, -45, -48, -53, -56, -68, -73, -74, -77, -77, -82,
                -80, -72, -74, -74, -76, -79, -80, -80, -86, -96, -94, -93, -96, -95, -96, -93,
                -85, -87, -96, -103, -100, -90, -80, -70, -71, -82, -90, -80, -77, -77, -75,
                -74, -71, -78, -59, -44, -45, -56, -73, -70, -70, -66, -70, -73, -69, -68, -49,
                -30, -36, -42, -37, -26, -14, -10, -6, -2, 1, 6, 9, 15, 8, -2, 4, 5, 1, 2, 1,
                12, 21, 27, 40, 45, 45, 39, 34, 44, 54, 52, 54, 58, 54, 52, 59, 60, 56, 57, 59,
                63, 70, 74, 78, 81, 82, 81, 86, 82, 74, 79, 81, 84, 83, 74, 74, 86, 96, 87, 77,
                73, 70, 76, 81, 79, 87, 89, 87, 89, 88, 88, 86, 85, 76, 71, 74, 74, 71, 52, 45,
                47, 44, 48, 51, 41, 41, 48, 46, 42, 39, 32, 29, 26, 17, 10, -3, -10, -10, -16,
                -20, -20, -22, -28, -32, -36, -39, -47, -46, -41, -45, -52, -64, -68, -72, -75,
                -77, -79, -79, -84, -82, -75, -78, -81, -80, -83, -84, -91, -97, -96, -98, -99,
                -102, -100, -92, -92, -92, -97, -107, -106, -106, -102, -99, -99, -98, -99, -92,
                -91, -91, -91, -89, -90, -98, -79, -65, -70, -76, -91, -90, -90, -86, -78, -89,
                -89, -84, -81, -76, -71, -62, -55, -44, -39, -35, -29, -24, -19, -15, -10, -5,
                -1, 3, -7, -20, -15, -12, 0, 8, 7, 13, 20, 34, 40, 41, 45, 46, 49, 51, 54, 58,
                61, 66, 68, 71, 68, 62, 66, 67, 75, 86, 84, 90, 93, 93, 98, 92, 87, 91, 92, 92,
                92, 92, 100, 105, 104, 105, 100, 91, 89, 86, 89, 92, 99, 105, 102, 103, 102,
                101, 101, 100, 89, 87, 88, 87, 84, 66, 60, 59, 64, 71, 63, 50, 46, 53, 54, 52,
                49, 43, 37, 27, 15, 9, 4, -2, -7, -11, -16, -18, -24, -31, -34, -38, -42, -47,
                -52, -56, -60, -64, -70, -73, -77, -80, -83, -86, -89, -91, -94, -96, -92, -89,
                -92, -93, -95, -104, -108, -109, -109, -110, -112, -111, -104, -101, -103, -105,
                -111, -115, -115, -115, -115, -114, -113, -113, -111, -105, -100, -100, -99,
                -98, -94, -84, -76, -74, -80, -94, -91, -81, -79, -79, -88, -89, -85, -83, -78,
                -74, -64, -47, -39, -37, -32, -28, -23, -18, -12, -7, -2, 4, 8, 11, 1, -7, 4,
                12, 14, 18, 21, 25, 36, 49, 52, 55, 58, 60, 64, 66, 69, 73, 75, 78, 81, 73, 71,
                74, 75, 78, 78, 86, 95, 97, 97, 101, 101, 93, 91, 95, 92, 99, 107, 106, 106,
                107, 107, 109, 104, 94, 88, 85, 88, 92, 93, 98, 104, 103, 102, 101, 101, 91, 84,
                86, 86, 79, 65, 59, 64, 76, 78, 68, 55, 53, 54, 52, 50, 46, 43, 37, 29, 21, 14,
                8, 3, -3, -7, -12, -17, -22, -26, -31, -36, -41, -45, -50, -55, -59, -63, -61,
                -58, -68, -78, -80, -82, -85, -88, -91, -91, -84, -82, -87, -87, -89, -94, -95,
                -99, -104, -104, -104, -106, -98, -92, -95, -94, -101, -108, -106, -107, -107,
                -104, -106, -107, -107, -101, -93, -94, -92, -91, -89, -84, -79, -77, -77, -76,
                -74, -76, -75, -77, -86, -84, -82, -80, -76, -72, -66, -59, -45, -36, -34, -30,
                -25, -20, -15, -10, -5, 0, 5, 9, 10, 5, 3, 8, 12, 14, 20, 22, 26, 37, 49, 54,
                56, 60, 61, 64, 67, 70, 73, 76, 80, 74, 70, 73, 75, 77, 78, 87, 95, 95, 98, 100,
                101, 95, 91, 94, 94, 102, 108, 107, 108, 109, 109, 111, 107, 99, 100, 98, 93,
                89, 90, 94, 102, 109, 105, 105, 105, 93, 89, 89, 87, 87, 80, 74, 72, 77, 80, 76,
                73, 71, 69, 67, 65, 62, 55, 49, 46, 43, 39, 39, 25, 14, 12, 6, 3, -2, -7, -12,
                -16, -21, -26, -31, -36, -40, -46, -48, -50, -59, -64, -66, -71, -74, -77, -80,
                -84, -83, -77, -79, -82, -83, -88, -96, -101, -101, -102, -104, -105, -104, -99,
                -95, -99, -105, -111, -111, -112, -112, -111, -113, -112, -113, -109, -101,
                -101, -100, -99, -99, -97, -94, -91, -88, -87, -85, -84, -84, -87, -94, -93,
                -91, -91, -89, -87, -83, -79, -72, -57, -48, -46, -41, -37, -31, -25, -21, -16,
                -10, -5, 0, 1, -3, -4, -1, 4, 8, 12, 17, 23, 34, 46, 49, 51, 55, 57, 61, 63, 67,
                70, 74, 74, 72, 78, 84, 87, 89, 91, 95, 97, 102, 104, 106, 109, 104, 100, 105,
                114, 117, 117, 118, 119, 120, 121, 123, 116, 110, 112, 110, 103, 103, 107, 114,
                120, 118, 118, 113, 102, 100, 100, 99, 97, 90, 81, 75, 72, 73, 77, 78, 74, 71,
                68, 64, 58, 51, 46, 43, 39, 34, 24, 15, 11, 6, 1, -3, -8, -14, -18, -23, -30,
                -34, -39, -45, -49, -54, -59, -63, -68, -72, -76, -79, -82, -86, -88, -91, -94,
                -90, -87, -90, -94, -100, -106, -108, -109, -110, -111, -112, -113, -113, -107,
                -104, -106, -111, -116, -118, -118, -117, -118, -118, -119, -116, -108, -105,
                -105, -103, -101, -99, -95, -92, -89, -87, -87, -87, -87, -84, -85, -91, -92,
                -90, -88, -86, -84, -81, -76, -68, -56, -49, -44, -39, -34, -29, -25, -20, -15,
                -9, -5, 0, 0, -4, -4, 1, 5, 9, 12, 16, 23, 35, 45, 48, 50, 53, 57, 59, 62, 65,
                68, 71, 72, 76, 79, 81, 83, 83, 85, 91, 97, 100, 102, 104, 107, 109, 111, 113,
                114, 115, 116, 118, 119, 121, 121, 113, 111, 113, 112, 109, 108, 111, 118, 122,
                121, 120, 120, 118, 115, 108, 103, 102, 101, 94, 86, 82, 81, 85, 87, 83, 80, 78,
                76, 73, 70, 67, 64, 59, 53, 44, 34, 27, 23, 19, 14, 9, 4, -2, -7, -11, -16, -21,
                -26, -32, -37, -42, -48, -53, -57, -62, -65, -69, -74, -77, -81, -84, -87, -88,
                -89, -94, -97, -99, -101, -104, -106, -108, -110, -112, -113, -110, -107, -109,
                -115, -120, -121, -121, -122, -123, -123, -124, -122, -119, -118, -115, -111,
                -106, -102, -97, -93, -90, -87, -86, -88, -88, -87, -84, -83, -88, -90, -88,
                -87, -85, -83, -80, -75, -66, -55, -48, -43, -36, -32, -27, -23, -18, -12, -7,
                -3, 3, 4, 1, 1, 4, 7, 11, 15, 21, 30, 42, 48, 50, 54, 57, 59, 62, 66, 69, 72,
                74, 77, 79, 82, 84, 87, 88, 88, 93, 99, 101, 104, 107, 109, 112, 113, 115, 117,
                118, 119, 120, 122, 121, 113, 111, 111, 108, 101, 96, 98, 107, 114, 116, 114,
                113, 110, 108, 102, 96, 94, 94, 92, 87, 79, 74, 73, 71, 72, 73, 71, 68, 66, 63,
                60, 56, 51, 45, 37, 29, 22, 17, 13, 9, 4, -2, -6, -11, -16, -21, -26, -31, -35,
                -41, -46, -51, -55, -60, -64, -68, -72, -76, -79, -82, -86, -89, -92, -96, -98,
                -100, -103, -105, -107, -109, -110, -112, -114, -115, -112, -109, -111, -115,
                -119, -120, -121, -122, -123, -124, -124, -123, -122, -121, -119, -114, -109,
                -105, -101, -97, -92, -89, -87, -88, -89, -89, -87, -83, -83, -88, -89, -87,
                -85, -83, -81, -77, -72, -64, -54, -48, -42, -36, -31, -27, -23, -18, -13, -8,
                -2, 0, -2, -4, -2, 1, 5, 9, 12, 17, 26, 37, 44, 47, 50, 52, 55, 58, 61, 64, 67,
                70, 72, 74, 77, 80, 82, 81, 82, 87, 92, 96, 100, 102, 104, 106, 108, 110, 111,
                113, 114, 116, 114, 108, 107, 109, 109, 106, 100, 99, 104, 111, 114, 112, 111,
                109, 105, 102, 99, 96, 94, 93, 91, 86, 78, 72, 70, 72, 75, 74, 70, 69, 66, 64,
                62, 59, 56, 53, 44, 34, 28, 23, 19, 15, 10, 6, 1, -4, -8, -14, -19, -24, -28,
                -34, -38, -41, -44, -48, -54, -60, -64, -67, -71, -74, -78, -81, -83, -86, -88,
                -91, -94, -97, -99, -101, -103, -105, -106, -106, -106, -107, -110, -111, -113,
                -115, -117, -118, -119, -119, -120, -120, -119, -116, -113, -108, -104, -101,
                -97, -92, -87, -85, -84, -84, -84, -83, -81, -79, -79, -83, -85, -84, -83, -81,
                -80, -77, -73, -64, -53, -46, -40, -34, -30, -26, -22, -17, -13, -8, -3, 1, 0,
                -4, -3, 1, 5, 8, 11, 14, 20, 31, 42, 46, 48, 51, 53, 56, 59, 62, 64, 67, 70, 72,
                75, 78, 81, 82, 82, 83, 87, 94, 98, 100, 103, 105, 106, 107, 109, 111, 112, 113,
                112, 110, 112, 112, 109, 106, 105, 107, 111, 116, 119, 117, 114, 112, 111, 111,
                108, 104, 100, 99, 97, 90, 81, 75, 73, 75, 79, 79, 77, 73, 71, 68, 65, 62, 60,
                55, 47, 40, 34, 29, 25, 20, 15, 10, 4, -1, -5, -9, -15, -20, -25, -30, -35, -37,
                -42, -48, -53, -58, -62, -66, -69, -73, -76, -80, -83, -86, -88, -91, -94, -96,
                -98, -100, -102, -104, -106, -107, -109, -110, -112, -113, -115, -118, -118,
                -119, -121, -122, -122, -122, -122, -120, -117, -114, -109, -104, -99, -92, -87,
                -85, -83, -83, -83, -83, -81, -80, -81, -83, -84, -83, -80, -78, -77, -73, -67,
                -58, -48, -42, -36, -30, -26, -22, -18, -14, -8, -4, 2, 5, 4, 1, 2, 5, 9, 12,
                15, 19, 26, 37, 46, 50, 52, 55, 58, 60, 63, 66, 68, 70, 73, 75, 77, 80, 83, 84,
                84, 87, 93, 97, 99, 102, 104, 106, 107, 109, 111, 112, 113, 111, 108, 108, 108,
                106, 102, 101, 101, 102, 105, 111, 112, 107, 105, 104, 104, 102, 97, 94, 92, 91,
                85, 76, 69, 65, 64, 66, 68, 69, 66, 64, 61, 59, 56, 53, 49, 43, 37, 32, 29, 26,
                23, 20, 15, 8, 1, -5, -9, -13, -17, -22, -26, -28, -29, -31, -34, -41, -49, -55,
                -58, -60, -64, -67, -70, -73, -76, -79, -82, -85, -88, -90, -92, -94, -95, -96,
                -98, -99, -101, -102, -105, -107, -109, -111, -112, -113, -114, -115, -115,
                -115, -115, -115, -113, -111, -107, -103, -96, -89, -84, -80, -79, -79, -79,
                -78, -77, -76, -78, -81, -81, -79, -77, -76, -74, -71, -66, -58, -52, -47, -41,
                -33, -27, -24, -20, -16, -12, -7, -2, 0, -3, -6, -4, -1, 2, 5, 8, 11, 15, 24,
                34, 40, 43, 45, 48, 51, 53, 55, 58, 60, 63, 65, 67, 70, 73, 74, 77, 82, 85, 88,
                91, 94, 96, 98, 100, 102, 103, 105, 106, 105, 103, 103, 104, 101, 99, 98, 98,
                101, 106, 111, 112, 110, 110, 108, 106, 102, 98, 97, 96, 95, 90, 81, 76, 75, 77,
                78, 78, 77, 74, 72, 70, 67, 64, 62, 59, 55, 49, 44, 41, 38, 36, 33, 28, 21, 14,
                8, 3, -1, -5, -7, -8, -9, -11, -15, -20, -29, -37, -43, -45, -49, -52, -55, -58,
                -62, -65, -68, -71, -74, -77, -80, -81, -83, -83, -84, -85, -86, -89, -92, -96,
                -99, -101, -103, -104, -105, -106, -107, -108, -109, -109, -108, -106, -104,
                -101, -96, -89, -83, -78, -76, -75, -76, -76, -75, -74, -73, -74, -76, -76, -74,
                -73, -71, -69, -66, -59, -51, -46, -41, -35, -28, -23, -20, -15, -11, -7, -2, 3,
                6, 4, 1, 1, 3, 7, 10, 12, 16, 22, 30, 39, 44, 47, 50, 52, 54, 56, 59, 61, 63,
                65, 67, 69, 68, 67, 68, 72, 79, 84, 86, 89, 91, 92, 94, 95, 97, 99, 100, 101,
                101, 99, 98, 95, 89, 88, 88, 89, 91, 96, 102, 103, 101, 99, 97, 93, 89, 87, 86,
                85, 83, 78, 71, 68, 67, 69, 70, 69, 67, 65, 63, 61, 59, 57, 54, 52, 49, 45, 41,
                38, 35, 32, 28, 23, 16, 10, 4, 0, -4, -7, -10, -12, -13, -16, -19, -26, -34,
                -40, -44, -47, -51, -54, -58, -61, -63, -67, -70, -73, -76, -79, -81, -83, -84,
                -85, -85, -86, -88, -90, -94, -97, -100, -102, -104, -105, -105, -106, -107,
                -108, -108, -108, -106, -104, -102, -100, -96, -89, -81, -78, -78, -76, -75,
                -76, -77, -75, -75, -77, -79, -79, -78, -76, -73, -69, -69, -68, -59, -53, -53,
                -50, -45, -35, -27, -25, -27, -21, -11, -6, -11, -23, -18, -10, -11, -9, -2, -1,
                -3, 2, 20, 31, 17, 5, 18, 37, 36, 36, 41, 45, 40, 44, 49, 50, 43, 27, 48, 59,
                59, 66, 67, 70, 69, 73, 74, 82, 70, 66, 83, 84, 75, 60, 73, 85, 75, 66, 72, 80,
                66, 72, 87, 87, 85, 87, 86, 81, 72, 57, 71, 76, 71, 73, 56, 41, 48, 63, 64, 51,
                34, 49, 56, 47, 47, 49, 40, 18, 29, 40, 33, 14, 4, 21, 28, 19, 11, 17, 4, -13,
                -1, 11, -3, -23, -19, -2, -7, -28, -37, -23, -15, -37, -45, -39, -43, -47, -49,
                -35, -36, -58, -60, -50, -50, -63, -65, -63, -62, -61, -62, -66, -72, -73, -74,
                -76, -80, -82, -83, -84, -85, -84, -70, -66, -85, -90, -79, -64, -59, -73, -76,
                -72, -59, -46, -45, -52, -64, -57, -39, -35, -54, -66, -61, -48, -37, -35, -44,
                -52, -45, -34, -15, -11, -27, -32, -16, -2, -2, -1, 1, 7, 12, 16, 24, 11, 4, 11,
                18, 39, 29, 17, 25, 25, 39, 49, 51, 50, 49, 57, 57, 60, 54, 52, 64, 59, 57, 60,
                63, 69, 72, 77, 79, 79, 80, 84, 85, 86, 88, 90, 92, 91, 89, 86, 87, 79, 68, 78,
                91, 82, 72, 80, 95, 95, 92, 92, 90, 87, 83, 81, 79, 77, 73, 75, 78, 72, 64, 63,
                67, 68, 66, 64, 64, 56, 55, 59, 54, 44, 35, 42, 45, 30, 20, 19, 16, 9, 11, 22,
                22, 13, 5, 6, 9, 3, -3, -10, -19, -25, -27, -32, -37, -39, -42, -44, -48, -52,
                -54, -56, -59, -63, -65, -68, -71, -73, -74, -75, -75, -76, -77, -79, -82, -85,
                -89, -91, -93, -95, -96, -96, -97, -99, -100, -97, -90, -87, -96, -98, -94, -84,
                -70, -70, -81, -86, -81, -68, -58, -57, -58, -64, -70, -68, -68, -70, -70, -70,
                -69, -62, -55, -53, -54, -54, -46, -30, -24, -28, -27, -20, -16, -20, -18, -20,
                -23, -19, -11, -3, -11, -11, -6, -4, -4, 2, 11, 10, 9, 20, 28, 26, 28, 32, 33,
                32, 30, 31, 31, 30, 34, 38, 45, 50, 51, 54, 56, 58, 59, 63, 65, 70, 71, 72, 65,
                49, 48, 55, 62, 59, 54, 53, 54, 54, 56, 69, 72, 71, 66, 63, 61, 44, 36, 48, 62,
                56, 52, 47, 45, 49, 47, 49, 45, 45, 32, 29, 50, 49, 42, 40, 38, 40, 35, 32, 33,
                26, 12, 5, 11, 9, -2, -9, -5, 7, 5, 3, -11, -19, -2, 0, -4, -17, -21, -11, -14,
                -14, -25, -36, -33, -35, -36, -41, -45, -44, -47, -51, -51, -48, -47, -48, -48,
                -39, -31, -31, -46, -58, -58, -61, -57, -59, -58, -52, -60, -50, -43, -57, -66,
                -54, -41, -55, -59, -37, -26, -28, -47, -47, -21, -20, -20, -30, -45, -44, -40,
                -21, -16, -29, -39, -41, -20, 1, 0, 0, 3, 3, -8, 2, 18, 3, -7, 5, 23, 29, 17,
                16, 34, 38, 28, 25, 39, 41, 28, 35, 55, 56, 54, 59, 56, 49, 48, 57, 60, 61, 49,
                43, 56, 57, 58, 64, 66, 72, 68, 55, 68, 77, 76, 78, 75, 77, 72, 55, 50, 52, 49,
                52, 54, 53, 53, 47, 51, 67, 65, 47, 41, 55, 61, 42, 35, 47, 50, 49, 29, 20, 18,
                13, 26, 32, 24, 7, 16, 31, 29, 25, 9, 0, 6, 15, 14, -1, -15, -14, -16, -15, -13,
                -22, -26, -27, -29, -24, -27, -30, -21, -21, -24, -24, -27, -29, -27, -40, -51,
                -52, -47, -34, -37, -46, -48, -53, -44, -34, -34, -35, -37, -34, -29, -29, -25,
                -23, -33, -38, -38, -33, -31, -43, -46, -44, -32, -19, -29, -41, -42, -39, -31,
                -24, -22, -26, -33, -32, -19, -15, -22, -20, -10, -6, -18, -23, -21, -28, -20,
                -13, -16, -19, -23, -26, -27, -18, -6, 0, 2, 4, 1, 2, 7, 10, 13, 13, 17, 16, 10,
                7, 4, 7, 8, 9, 11, 12, 14, 16, 23, 30, 31, 24, 16, 15, 15, 13, 14, 24, 31, 22,
                10, 11, 20, 18, 10, 8, 11, 11, 20, 32, 29, 30, 30, 31, 33, 32, 35, 25, 10, 12,
                13, 11, 13, 14, 27, 38, 36, 35, 37, 38, 41, 41, 42, 34, 19, 19, 21, 21, 19, 15,
                13, 22, 27, 28, 20, 3, 5, 4, 8, 18, 18, 16, 13, 12, 10, 9, 6, -9, -16, -14, -13,
                -18, -22, -24, -19, -7, -11, -13, -14, -15, -16, -17, -17, -17, -25, -36, -34,
                -33, -35, -38, -41, -36, -37, -40, -42, -42, -41, -45, -45, -48, -51, -49, -44,
                -40, -46, -51, -52, -49, -46, -47, -54, -58, -57, -53, -43, -40, -50, -60, -61,
                -62, -59, -56, -58, -59, -57, -46, -36, -34, -35, -32, -27, -25, -25, -31, -30,
                -27, -25, -28, -27, -20, -18, -14, -8, -17, -23, -11, -2, 8, 5, -5, 4, 14, 14,
                17, 6, 4, 16, 18, 21, 12, 10, 14, 13, 15, 16, 19, 14, 21, 28, 24, 21, 13, 15,
                19, 24, 17, 4, -3, 6, 23, 17, 18, 25, 19, 22, 28, 29, 32, 27, 16, 31, 37, 37,
                33, 11, 3, 10, 35, 42, 23, 7, 23, 41, 41, 41, 26, 13, 8, 32, 48, 40, 30, 10, 20,
                40, 42, 36, 24, 12, 12, 33, 44, 34, 15, 11, 34, 36, 24, 16, 11, 24, 24, 19, 24,
                25, 22, 21, 30, 31, 21, 21, 24, 24, 21, 20, 20, 17, 14, 9, 1, -3, -3, -5, -1, 8,
                9, 7, 7, 4, 6, 8, -3, -16, -13, 4, 1, -12, -19, -25, -27, -16, 2, -5, -21, -21,
                -13, -4, 4, -2, -11, -11, -9, -2, -2, -15, -25, -23, -17, -3, -8, -26, -29, -23,
                -16, -1, 8, 4, 5, 8, 10, 13, 4, -1, -11, -21, -7, -15, -14, 5, 0, 2, -1, -7, -4,
                -3, -3, -8, -9, -4, 8, 17, 8, 6, 15, 20, 5, -3, -1, -10, -3, 8, 19, 15, -6, -8,
                1, 11, 16, 3, -6, -3, -9, 0, 8, -5, -19, -9, 15, 15, 12, 0, -10, -9, -8, 16, 8,
                -3, -5, -3, 13, -11, -16, -10, -9, -5, -10, 3, 8, -13, -18, 1, 16, 5, -17, -22,
                -20, -13, -21, -23, -5, -7, -10, -4, 6, 0, -17, -13, 7, 11, -5, -15, -8, 0, -9,
                -7, 1, -4, -22, -29, -27, -26, -8, -7, -7, -6, -11, 3, 15, 17, 24, 31, 24, 13,
                12, 9, -6, -9, -6, 0, 10, -2, -11, 2, 3, -7, 3, 14, 15, 1, -10, -6, -7, -1, 5,
                15, 18, -1, -19, -15, -4, -2, 12, 20, 0, -13, 2, 14, 13, 15, 13, 12, 9, -10,
                -14, -8, -16, -3, 18, 17, 18, 14, 0, 0, 8, 12, 10, 5, -8, -7, 6, 9, 5, 13, 13,
                -13, -21, -16, -16, -14, -13, -12, -18, -5, 12, 14, 6, 4, 1, -11, -8, -5, 11, 5,
                -14, -8, -5, 9, 12, -6, -14, -13, -14, 7, 4, -16, -26, -33, -9, 3, -6, -21, -28,
                -22, -11, -1, -15, -26, -22, -27, -7, -3, -28, -34, -31, -19, -18, -21, -28,
                -33, -30, -29, -31, -25, -11, -19, -19, -6, -9, -26, -33, -32, -30, -31, -24,
                -10, -14, -14, -11, -2, 1, -3, -11, -23, -10, -6, -8, -16, -25, -18, 3, 14, -13,
                -30, -24, -21, -14, -5, -13, -27, -24, -7, 3, 9, 13, 12, 11, 16, 19, 13, 15, 7,
                -2, 5, -2, -11, -10, -8, -7, -1, 12, 14, 9, -7, -9, 17, 15, 4, 13, 16, 7, 5, 18,
                24, 7, -12, 5, 11, 5, 10, 1, 17, 23, 26, 38, 35, 19, -3, -3, 10, 33, 30, 32, 27,
                8, 12, 25, 38, 17, -5, 1, 19, 37, 30, 30, 40, 43, 36, 37, 39, 20, 8, 13, 22, 17,
                14, 14, 27, 30, 13, 13, 13, 8, 2, 6, 7, 15, 26, 25, 26, 26, 24, 18, 25, 13, -5,
                -1, -3, 0, 1, -16, -17, -20, -20, -1, -13, -27, -27, -33, -29, -23, -30, -31,
                -22, -17, -14, -39, -46, -30, -34, -36, -42, -48, -52, -54, -47, -42, -55, -59,
                -35, -25, -34, -51, -61, -61, -59, -54, -53, -59, -68, -63, -53, -51, -45, -41,
                -41, -36, -53, -59, -51, -52, -45, -46, -46, -28, -24, -24, -26, -52, -59, -56,
                -55, -43, -37, -36, -36, -27, -13, -2, 1, 1, 5, 4, 13, 18, 21, 20, -6, -11, -8,
                5, 21, 3, 1, 5, 7, 17, 13, 1, 11, 24, 23, 29, 32, 27, 23, 25, 32, 35, 32, 31,
                20, 16, 13, 11, 28, 33, 41, 50, 46, 43, 41, 36, 28, 37, 47, 50, 53, 56, 55, 56,
                59, 59, 56, 40, 41, 41, 48, 57, 52, 55, 57, 60, 62, 51, 33, 34, 37, 36, 35, 30,
                39, 41, 36, 41, 29, 16, 19, 13, 7, 7, 14, 25, 15, 10, 14, 9, 18, 21, -2, -8, -8,
                -11, -10, -15, -15, -24, -27, -10, -15, -33, -36, -38, -33, -29, -31, -30, -25,
                -15, -28, -41, -37, -44, -53, -52, -51, -51, -52, -56, -57, -53, -51, -51, -59,
                -70, -71, -72, -71, -65, -63, -65, -67, -67, -68, -70, -73, -81, -79, -61, -56,
                -57, -57, -71, -70, -61, -58, -56, -60, -54, -41, -36, -33, -28, -36, -57, -62,
                -55, -55, -54, -45, -44, -46, -36, -24, -17, -12, -6, -5, -5, -1, -1, -3, -15,
                -19, -3, 5, 8, -4, -9, -5, -7, -5, -3, 11, 23, 19, 15, 14, 15, 16, 19, 24, 23,
                23, 27, 30, 34, 26, 29, 42, 42, 47, 53, 58, 59, 59, 59, 56, 60, 68, 73, 71, 67,
                69, 82, 86, 84, 84, 61, 55, 66, 63, 61, 53, 60, 80, 86, 80, 73, 72, 54, 40, 43,
                37, 40, 50, 54, 62, 62, 50, 47, 43, 32, 27, 20, 13, 15, 13, 17, 29, 33, 31, 26,
                29, 18, 3, 1, -6, -7, -7, -13, -5, 6, 0, -12, -26, -19, -16, -27, -32, -32, -25,
                -25, -27, -38, -44, -43, -39, -35, -38, -43, -56, -59, -51, -48, -51, -61, -67,
                -64, -59, -56, -57, -60, -56, -56, -62, -63, -68, -76, -70, -63, -64, -50, -43,
                -44, -38, -42, -45, -47, -48, -47, -46, -45, -36, -21, -16, -14, -13, -28, -44,
                -46, -44, -37, -21, -23, -29, -28, -19, 0, -1, -4, 1, 11, 20, 15, 10, 11, 15,
                17, 21, 34, 21, 1, 11, 15, 16, 21, 21, 20, 27, 36, 38, 38, 37, 36, 39, 45, 48,
                43, 39, 42, 43, 44, 52, 58, 57, 61, 70, 70, 67, 70, 72, 66, 58, 62, 66, 70, 80,
                84, 82, 74, 72, 77, 67, 52, 52, 50, 53, 68, 78, 75, 72, 79, 80, 71, 56, 42, 39,
                33, 40, 64, 64, 50, 46, 49, 56, 54, 31, 16, 17, 19, 28, 26, 11, 9, 28, 35, 35,
                33, 5, -10, -8, -7, 0, -15, -25, -26, -20, -18, -36, -42, -41, -44, -50, -48,
                -41, -47, -61, -63, -55, -53, -45, -55, -73, -76, -75, -77, -73, -63, -67, -71,
                -75, -74, -79, -87, -80, -71, -72, -85, -90, -81, -77, -82, -82, -79, -79, -90,
                -90, -74, -68, -59, -57, -66, -71, -70, -68, -63, -61, -61, -54, -44, -35, -33,
                -38, -56, -64, -59, -53, -44, -51, -58, -58, -48, -31, -19, -11, -9, -12, -10,
                2, 5, 8, 11, 14, 20, 15, 3, -6, -2, 0, 10, 19, 7, 3, 12, 26, 38, 41, 39, 41, 44,
                36, 34, 38, 37, 46, 55, 52, 56, 55, 46, 48, 61, 67, 68, 67, 59, 59, 68, 75, 78,
                80, 77, 69, 71, 75, 75, 75, 70, 57, 54, 63, 67, 69, 72, 80, 75, 65, 68, 67, 78,
                66, 41, 41, 46, 63, 70, 59, 52, 52, 51, 62, 50, 22, 21, 20, 27, 32, 20, 15, 26,
                32, 36, 33, 5, -5, -3, -4, 2, -7, -23, -27, -26, -26, -26, -29, -40, -45, -47,
                -50, -55, -52, -48, -52, -53, -56, -60, -69, -74, -74, -76, -78, -73, -65, -71,
                -74, -74, -75, -77, -77, -80, -92, -90, -91, -91, -88, -93, -92, -84, -81, -90,
                -98, -97, -90, -77, -67, -70, -85, -85, -77, -75, -75, -75, -72, -70, -62, -46,
                -44, -45, -51, -66, -66, -67, -66, -65, -67, -65, -56, -33, -25, -28, -35, -30,
                -15, -10, -6, -1, 1, 5, 11, 14, 14, 0, -8, 4, 2, -2, 2, 3, 14, 18, 28, 40, 41,
                36, 29, 32, 34, 43, 46, 47, 46, 39, 46, 55, 59, 55, 50, 50, 58, 71, 69, 71, 75,
                76, 78, 81, 78, 71, 74, 76, 80, 82, 77, 74, 80, 83, 71, 69, 71, 73, 75, 75, 74,
                80, 86, 83, 85, 84, 83, 84, 81, 73, 70, 73, 71, 70, 65, 48, 46, 46, 47, 53, 42,
                40, 49, 49, 45, 39, 34, 35, 34, 21, 14, 4, -3, -7, -10, -9, -13, -21, -27, -30,
                -35, -38, -43, -40, -35, -41, -47, -59, -62, -64, -68, -70, -75, -75, -79, -78,
                -75, -79, -79, -79, -79, -82, -92, -98, -98, -100, -100, -99, -96, -91, -91,
                -92, -96, -104, -105, -108, -107, -102, -102, -99, -99, -97, -93, -92, -91, -91,
                -91, -91, -75, -63, -64, -69, -87, -88, -87, -82, -73, -82, -84, -80, -74, -72,
                -67, -60, -46, -35, -34, -28, -25, -22, -15, -11, -4, -1, 5, 4, -17, -19, -13,
                -11, 1, 6, 11, 20, 31, 36, 38, 40, 40, 45, 50, 51, 53, 56, 58, 64, 65, 69, 70,
                61, 65, 70, 78, 87, 87, 89, 92, 95, 97, 93, 87, 89, 91, 93, 93, 96, 103, 105,
                104, 106, 101, 92, 92, 91, 93, 92, 95, 104, 100, 100, 103, 102, 103, 100, 90,
                88, 90, 89, 89, 84, 75, 69, 72, 78, 71, 54, 49, 53, 55, 55, 54, 51, 51, 50, 31,
                17, 13, 7, 5, 3, 0, -4, -14, -20, -24, -28, -33, -36, -41, -46, -51, -56, -60,
                -63, -65, -71, -75, -77, -81, -84, -86, -90, -90, -84, -84, -87, -92, -102,
                -105, -105, -106, -106, -108, -104, -98, -98, -99, -99, -103, -111, -113, -111,
                -112, -112, -108, -110, -111, -105, -99, -97, -97, -95, -91, -81, -72, -71, -75,
                -89, -90, -80, -79, -79, -86, -88, -84, -81, -76, -71, -60, -45, -37, -35, -31,
                -25, -21, -15, -10, -7, -1, 3, 8, 6, -6, -3, 6, 8, 12, 17, 22, 30, 42, 48, 50,
                53, 54, 57, 61, 64, 67, 70, 71, 74, 75, 69, 68, 73, 74, 75, 77, 88, 96, 95, 97,
                98, 98, 91, 89, 92, 90, 97, 105, 106, 105, 106, 106, 107, 104, 92, 91, 96, 96,
                94, 93, 95, 102, 104, 103, 104, 103, 94, 88, 90, 87, 85, 84, 79, 84, 91, 89, 77,
                64, 63, 61, 60, 58, 56, 56, 53, 48, 41, 34, 28, 20, 14, 9, 4, 0, -7, -11, -16,
                -21, -26, -31, -36, -40, -44, -49, -51, -49, -57, -67, -69, -74, -76, -79, -82,
                -84, -81, -79, -84, -84, -87, -95, -98, -100, -102, -104, -105, -102, -96, -95,
                -97, -97, -102, -110, -109, -109, -110, -103, -107, -112, -111, -107, -97, -96,
                -97, -96, -95, -89, -82, -78, -78, -76, -75, -79, -76, -81, -89, -85, -83, -82,
                -80, -77, -72, -61, -46, -39, -37, -35, -30, -24, -20, -15, -11, -6, -1, 5, -2,
                -7, -2, 3, 6, 9, 11, 16, 24, 36, 43, 44, 49, 53, 54, 58, 61, 63, 66, 68, 71, 68,
                63, 66, 69, 72, 80, 88, 90, 91, 94, 95, 98, 94, 86, 91, 91, 95, 104, 106, 105,
                106, 108, 109, 106, 97, 96, 97, 97, 98, 97, 97, 100, 109, 108, 106, 107, 98, 93,
                93, 91, 89, 88, 86, 85, 91, 87, 80, 79, 77, 75, 69, 64, 60, 56, 52, 52, 51, 51,
                55, 47, 31, 27, 23, 18, 9, 1, -3, -8, -11, -15, -21, -25, -29, -34, -39, -43,
                -49, -52, -56, -61, -65, -69, -73, -77, -78, -73, -73, -77, -81, -88, -96, -97,
                -99, -100, -101, -103, -102, -97, -96, -97, -102, -110, -112, -112, -114, -114,
                -115, -115, -117, -111, -103, -104, -104, -102, -102, -99, -96, -92, -88, -86,
                -83, -85, -86, -91, -98, -96, -94, -93, -92, -91, -88, -85, -74, -60, -54, -49,
                -44, -40, -35, -31, -26, -20, -15, -10, -8, -11, -15, -12, -7, -3, 1, 5, 11, 19,
                30, 37, 40, 43, 45, 48, 52, 54, 58, 61, 65, 65, 60, 62, 67, 70, 75, 81, 86, 88,
                90, 93, 95, 98, 94, 87, 89, 94, 102, 106, 106, 107, 108, 109, 111, 107, 99, 100,
                99, 98, 99, 98, 100, 110, 110, 109, 107, 97, 94, 94, 93, 92, 90, 87, 84, 84, 87,
                87, 84, 78, 74, 71, 67, 62, 57, 54, 53, 54, 51, 47, 40, 33, 29, 27, 21, 12, 4,
                -1, -5, -10, -15, -20, -25, -30, -35, -40, -44, -49, -53, -58, -62, -66, -70,
                -74, -77, -81, -79, -76, -79, -84, -92, -97, -99, -101, -103, -104, -107, -108,
                -106, -100, -100, -101, -104, -111, -115, -117, -117, -117, -118, -118, -114,
                -106, -105, -106, -105, -104, -101, -99, -95, -92, -89, -87, -87, -88, -88, -91,
                -96, -96, -94, -93, -92, -91, -89, -84, -74, -63, -57, -51, -45, -42, -37, -33,
                -28, -23, -18, -14, -15, -19, -18, -15, -11, -6, -2, 2, 8, 16, 26, 33, 36, 39,
                42, 44, 48, 51, 54, 57, 60, 61, 62, 65, 67, 70, 75, 80, 84, 86, 90, 93, 95, 98,
                100, 103, 105, 107, 108, 110, 111, 113, 115, 117, 114, 106, 107, 108, 109, 109,
                108, 113, 118, 118, 117, 117, 116, 115, 111, 105, 102, 102, 100, 98, 96, 96, 94,
                91, 88, 85, 83, 81, 79, 76, 71, 69, 66, 62, 57, 51, 46, 41, 38, 33, 26, 18, 11,
                6, 1, -4, -9, -14, -20, -25, -30, -35, -40, -45, -50, -54, -59, -63, -67, -72,
                -76, -80, -83, -86, -89, -93, -97, -99, -102, -104, -107, -109, -112, -113,
                -109, -106, -108, -114, -119, -122, -123, -124, -125, -125, -126, -125, -123,
                -122, -120, -115, -113, -111, -108, -104, -99, -94, -91, -91, -90, -91, -90,
                -93, -98, -97, -95, -95, -93, -91, -87, -79, -68, -60, -54, -47, -42, -38, -33,
                -29, -24, -19, -14, -9, -5, -7, -8, -5, -2, 2, 7, 14, 21, 29, 38, 43, 46, 49,
                52, 55, 57, 60, 64, 67, 70, 73, 76, 79, 82, 85, 87, 91, 95, 97, 100, 103, 105,
                107, 109, 111, 113, 114, 116, 118, 119, 120, 122, 122, 118, 117, 117, 113, 111,
                112, 114, 116, 119, 120, 120, 119, 117, 113, 108, 105, 103, 102, 100, 98, 97,
                96, 92, 89, 87, 85, 83, 80, 77, 73, 70, 67, 64, 59, 54, 49, 45, 41, 38, 34, 28,
                21, 13, 6, 1, -4, -8, -14, -19, -25, -30, -35, -40, -45, -49, -54, -58, -62,
                -67, -71, -75, -79, -82, -86, -90, -93, -96, -99, -101, -104, -106, -109, -111,
                -107, -104, -107, -111, -116, -118, -120, -122, -123, -124, -124, -125, -124,
                -123, -122, -119, -114, -112, -110, -107, -102, -98, -93, -91, -90, -90, -91,
                -90, -94, -99, -98, -97, -95, -94, -92, -88, -79, -69, -62, -55, -49, -44, -40,
                -36, -32, -27, -22, -17, -14, -16, -18, -17, -14, -9, -5, -2, 1, 6, 13, 23, 32,
                35, 37, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 68, 70, 72, 78, 82, 84, 88, 90,
                93, 96, 98, 100, 102, 104, 106, 108, 109, 111, 112, 113, 115, 115, 113, 111,
                111, 112, 114, 114, 115, 117, 117, 116, 114, 112, 110, 108, 105, 103, 101, 100,
                98, 95, 93, 91, 89, 87, 84, 82, 80, 78, 75, 73, 70, 65, 60, 55, 51, 47, 44, 39,
                34, 26, 17, 11, 6, 2, -4, -9, -14, -19, -22, -26, -31, -37, -44, -48, -53, -57,
                -61, -65, -69, -73, -77, -80, -84, -88, -91, -94, -97, -99, -102, -105, -105,
                -104, -105, -107, -109, -111, -115, -118, -120, -121, -122, -123, -124, -124,
                -123, -121, -119, -115, -113, -111, -107, -103, -98, -95, -92, -90, -90, -90,
                -90, -96, -100, -99, -97, -96, -94, -92, -89, -82, -71, -62, -55, -49, -44, -41,
                -37, -32, -28, -23, -18, -14, -13, -14, -13, -12, -9, -5, -1, 2, 8, 15, 26, 34,
                37, 39, 42, 45, 48, 51, 54, 57, 59, 62, 65, 68, 71, 73, 76, 80, 83, 86, 90, 93,
                95, 98, 100, 102, 104, 106, 107, 109, 110, 112, 113, 115, 114, 111, 110, 110,
                114, 118, 118, 117, 115, 113, 113, 114, 115, 115, 114, 111, 109, 107, 106, 103,
                97, 93, 92, 92, 90, 88, 86, 84, 81, 78, 76, 73, 70, 64, 59, 55, 50, 46, 41, 36,
                30, 22, 14, 9, 4, -1, -6, -11, -17, -22, -28, -33, -38, -43, -48, -53, -57, -62,
                -66, -71, -74, -78, -82, -86, -90, -93, -96, -99, -102, -105, -107, -109, -110,
                -111, -111, -112, -114, -117, -121, -123, -124, -126, -127, -128, -128, -128,
                -128, -126, -124, -121, -117, -113, -108, -103, -98, -94, -91, -88, -86, -86,
                -88, -93, -97, -97, -95, -93, -91, -89, -84, -76, -65, -56, -50, -44, -40, -37,
                -32, -28, -23, -18, -14, -8, -6, -6, -7, -6, -4, -1, 3, 7, 11, 18, 28, 36, 40,
                42, 45, 48, 50, 53, 56, 58, 61, 64, 66, 69, 72, 75, 77, 80, 83, 86, 89, 92, 94,
                97, 99, 101, 103, 104, 106, 107, 109, 110, 111, 111, 110, 107, 105, 106, 109,
                112, 114, 112, 111, 110, 111, 112, 113, 112, 109, 106, 106, 105, 103, 97, 93,
                91, 90, 89, 87, 85, 83, 81, 79, 77, 74, 72, 69, 66, 62, 59, 56, 52, 48, 43, 36,
                27, 19, 14, 9, 4, -1, -5, -10, -13, -16, -21, -27, -33, -40, -44, -49, -53, -57,
                -61, -66, -70, -74, -78, -81, -85, -88, -91, -94, -97, -99, -101, -103, -104,
                -105, -107, -110, -114, -116, -118, -120, -122, -123, -124, -125, -126, -126,
                -125, -123, -121, -117, -113, -109, -104, -100, -96, -94, -92, -91, -91, -95,
                -99, -101, -101, -100, -98, -96, -94, -90, -83, -74, -67, -62, -56, -50, -45,
                -41, -37, -33, -28, -23, -21, -21, -21, -21, -19, -16, -12, -9, -6, -2, 3, 11,
                19, 26, 30, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 60, 63, 66, 69, 73, 76, 79,
                82, 85, 88, 90, 92, 94, 96, 98, 100, 102, 104, 105, 106, 103, 100, 99, 100, 104,
                109, 112, 111, 110, 110, 111, 111, 109, 108, 106, 106, 106, 104, 101, 96, 93,
                92, 91, 89, 87, 86, 84, 82, 79, 77, 74, 72, 69, 66, 63, 60, 58, 55, 52, 48, 42,
                33, 25, 18, 13, 9, 4, 0, -3, -6, -11, -16, -24, -30, -34, -39, -43, -48, -52,
                -57, -61, -65, -69, -73, -76, -80, -84, -87, -90, -92, -94, -95, -96, -96, -98,
                -101, -104, -107, -110, -112, -114, -115, -117, -118, -119, -120, -120, -118,
                -116, -112, -108, -102, -96, -92, -87, -84, -81, -78, -76, -75, -76, -80, -83,
                -83, -83, -80, -77, -73, -67, -59, -52, -45, -40, -34, -29, -25, -21, -17, -12,
                -8, -3, 1, 3, 2, 1, 1, 3, 6, 9, 12, 15, 20, 28, 37, 42, 44, 46, 48, 50, 52, 54,
                57, 59, 61, 63, 65, 66, 67, 70, 74, 78, 80, 82, 85, 87, 89, 91, 93, 95, 96, 98,
                99, 100, 101, 100, 96, 92, 89, 89, 89, 92, 96, 100, 101, 100, 100, 99, 98, 97,
                95, 94, 94, 93, 92, 88, 84, 81, 80, 79, 78, 76, 75, 73, 71, 69, 67, 65, 62, 60,
                58, 56, 54, 51, 49, 46, 42, 36, 29, 22, 15, 10, 6, 3, 1, -1, -3, -7, -11, -18,
                -26, -32, -37, -40, -44, -48, -52, -56, -59, -63, -67, -71, -74, -77, -80, -83,
                -86, -87, -88, -89, -90, -92, -96, -99, -103, -105, -108, -110, -111, -113,
                -114, -116, -116, -116, -115, -113, -109, -104, -99, -95, -91, -88, -86, -85,
                -84, -83, -85, -89, -93, -93, -93, -92, -91, -89, -88, -85, -81, -75, -68, -65,
                -60, -55, -49, -45, -40, -37, -34, -32, -31, -31, -32, -31, -29, -25, -23, -20,
                -17, -15, -12, -6, 1, 8, 14, 18, 20, 23, 25, 27, 30, 33, 36, 39, 41, 43, 46, 50,
                54, 58, 61, 64, 67, 70, 73, 76, 79, 81, 83, 86, 88, 90, 92, 93, 91, 88, 86, 87,
                89, 93, 98, 101, 102, 102, 103, 103, 102, 101, 101, 100, 100, 100, 100, 98, 94,
                91, 89, 88, 87, 85, 84, 82, 81, 80, 79, 77, 73, 70, 68, 66, 64, 61, 59, 57, 54,
                50, 44, 38, 32, 27, 23, 19, 16, 13, 9, 4, -2, -9, -15, -20, -24, -28, -33, -37,
                -42, -46, -50, -54, -58, -62, -66, -70, -73, -76, -79, -80, -82, -83, -85, -87,
                -90, -93, -97, -100, -102, -105, -107, -109, -110, -112, -113, -113, -111, -108,
                -104, -99, -93, -89, -85, -82, -79, -77, -76, -74, -73, -76, -79, -80, -80, -80,
                -79, -77, -73, -69, -66, -60, -52, -46, -42, -38, -32, -27, -24, -20, -16, -12,
                -10, -9, -10, -10, -10, -8, -5, -3, -1, 3, 6, 7, 13, 24, 31, 33, 34, 36, 38, 40,
                42, 45, 47, 46, 44, 47, 53, 57, 57, 59, 65, 70, 72, 74, 75, 75, 77, 82, 87, 85,
                82, 85, 90, 93, 79, 83, 97, 80, 71, 81, 97, 98, 79, 70, 85, 97, 88, 87, 89, 71,
                61, 77, 83, 72, 50, 47, 65, 68, 58, 39, 37, 44, 47, 46, 45, 36, 13, 22, 34, 27,
                6, -1, 19, 20, 12, -6, -10, -10, -23, -12, -3, -7, -27, -32, -13, -21, -42, -49,
                -39, -25, -42, -58, -55, -57, -59, -64, -51, -44, -65, -71, -49, -56, -77, -75,
                -74, -72, -71, -72, -72, -74, -72, -75, -77, -79, -83, -85, -87, -67, -71, -94,
                -91, -91, -79, -62, -58, -63, -77, -78, -68, -50, -45, -56, -66, -55, -36, -35,
                -50, -60, -61, -54, -42, -38, -35, -49, -52, -40, -25, -16, -26, -23, -8, -15,
                -26, -8, 3, -13, -14, 7, 18, 3, -6, 1, 11, 17, 6, 7, 13, 12, 14, 18, 33, 21, 11,
                34, 40, 33, 18, 19, 37, 38, 34, 32, 34, 41, 46, 47, 47, 53, 57, 58, 59, 59, 64,
                67, 68, 62, 63, 72, 72, 70, 57, 60, 73, 62, 58, 60, 64, 80, 80, 79, 69, 55, 71,
                77, 76, 76, 73, 79, 75, 70, 58, 52, 54, 58, 60, 59, 57, 42, 50, 57, 52, 52, 48,
                46, 43, 41, 40, 38, 22, 26, 36, 32, 29, 11, 3, 3, -6, -1, 7, -2, -16, -10, -2,
                -13, -27, -34, -25, -19, -26, -35, -46, -49, -52, -57, -61, -60, -61, -66, -68,
                -71, -71, -72, -77, -75, -73, -78, -80, -83, -86, -87, -90, -93, -95, -95, -95,
                -98, -97, -98, -102, -102, -100, -94, -82, -85, -96, -94, -93, -84, -71, -72,
                -74, -74, -84, -91, -88, -87, -87, -86, -83, -70, -67, -72, -69, -65, -59, -53,
                -43, -35, -41, -55, -53, -32, -17, -28, -38, -30, -18, -7, 5, 0, -11, -13, -13,
                10, 19, 1, -5, 4, 19, 18, 22, 31, 32, 28, 10, 23, 36, 26, 29, 34, 42, 46, 42,
                49, 50, 36, 37, 48, 61, 58, 40, 39, 41, 55, 67, 65, 66, 67, 67, 70, 65, 48, 47,
                46, 56, 69, 64, 59, 63, 71, 68, 69, 57, 51, 51, 45, 54, 59, 55, 54, 53, 51, 53,
                43, 27, 26, 18, 11, 10, 5, 2, -5, 7, 16, 16, 7, -13, -16, -13, -8, -12, -13,
                -10, -17, -16, -22, -38, -42, -40, -40, -42, -46, -47, -49, -55, -50, -37, -37,
                -39, -39, -40, -41, -40, -50, -61, -58, -57, -58, -56, -59, -52, -36, -31, -32,
                -31, -32, -30, -26, -29, -29, -26, -26, -25, -33, -32, -18, -21, -29, -24, -13,
                5, 1, -17, -15, -15, 2, 14, 6, 11, 8, 4, 6, 9, 0, -12, -14, 1, 20, 21, 25, 15,
                9, 24, 27, 29, 32, 28, 33, 41, 39, 43, 48, 46, 45, 43, 43, 40, 35, 36, 35, 33,
                38, 53, 56, 44, 35, 44, 56, 51, 55, 43, 25, 40, 45, 44, 38, 24, 31, 40, 39, 31,
                30, 27, 30, 38, 30, 19, 30, 42, 42, 35, 19, 16, 18, 28, 38, 36, 32, 22, 29, 40,
                40, 39, 39, 41, 41, 41, 45, 44, 32, 30, 35, 44, 49, 44, 46, 45, 39, 44, 48, 47,
                33, 21, 22, 20, 15, 13, 13, 7, 11, 25, 21, 16, 15, 13, 13, 10, 7, 6, 5, 4, 5,
                -1, -5, -7, -11, -15, -19, -22, -23, -16, -14, -18, -25, -25, -18, -20, -19,
                -26, -42, -42, -42, -42, -40, -42, -31, -28, -37, -45, -44, -30, -26, -29, -43,
                -55, -51, -53, -54, -55, -58, -59, -59, -55, -56, -60, -59, -57, -56, -49, -41,
                -50, -60, -54, -44, -45, -48, -45, -45, -47, -48, -48, -49, -51, -54, -51, -46,
                -43, -44, -40, -25, -21, -25, -19, -15, -11, -17, -29, -26, -25, -23, -19, -19,
                -17, -17, -9, 4, 5, 4, 10, 13, 11, 5, 5, 13, 21, 25, 26, 20, 10, 15, 26, 29, 26,
                17, 17, 35, 45, 44, 45, 37, 27, 24, 37, 49, 47, 50, 50, 52, 54, 56, 58, 43, 37,
                43, 38, 45, 57, 53, 57, 61, 57, 62, 57, 42, 42, 44, 42, 47, 44, 34, 39, 49, 46,
                44, 45, 42, 38, 33, 22, 13, 11, 19, 27, 22, 9, 1, 12, 17, 12, 11, 8, -2, 0, 5,
                3, -4, -23, -27, -20, -8, -10, -29, -32, -32, -33, -19, -21, -42, -46, -48, -44,
                -31, -31, -40, -55, -55, -54, -54, -55, -57, -55, -57, -43, -33, -36, -35, -33,
                -36, -35, -41, -56, -57, -56, -48, -42, -52, -52, -40, -31, -28, -22, -35, -44,
                -25, -14, -18, -30, -26, -11, -11, -14, -14, -16, -32, -31, -12, -13, -25, -27,
                -27, -19, 1, 6, -3, -15, -15, 0, 12, 13, 3, -13, -11, -6, 6, 15, 0, -4, -1, -1,
                13, 20, 18, 22, 24, 26, 26, 26, 27, 27, 34, 38, 37, 32, 31, 27, 16, 17, 24, 24,
                27, 35, 32, 39, 43, 25, 22, 32, 31, 27, 25, 16, 20, 27, 27, 40, 40, 19, 4, 12,
                25, 14, 10, 15, 15, 17, 22, 31, 17, -8, 1, 30, 23, -1, -17, -7, 12, 11, 13, 17,
                14, 7, 10, 25, 9, -17, -21, 0, 22, 6,
        };

#endif /* CHUM78_H_ */
