#ifndef NOISE_STATIC_1_16384_H_
#define NOISE_STATIC_1_16384_H_

#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
#include "mozzi_pgmspace.h"

/* static noise from needle on old record
*/

#define NOISE_STATIC_1_16384_NUM_CELLS 16384
#define NOISE_STATIC_1_16384_SAMPLERATE 16384

CONSTTABLE_STORAGE(int8_t) NOISE_STATIC_1_16384_DATA []  =
        {
                -5, -8, -8, 1, 4, -1, 5, 3, 3,
                0, -4, 7, 1, -1, 0, -9, -3, -2, 2, 2, -2, 1, -8, -7, -5, -4, -1, -3, -6, -14, 0,
                5, -5, -4, 1, -2, -4, 3, -6, 4, 13, -15, -14, 1, -2, -3, -7, -4, -1, -7, -1,
                -12, -12, 6, -4, 0, -8, 0, 4, -21, 3, 0, -6, -4, -9, -1, -6, -3, -8, -1, 4, -6,
                -5, -8, -6, -12, -12, -1, -5, -3, -4, 2, -4, -18, 0, -3, -5, -1, -7, -4, -6, -1,
                -1, -8, -3, -4, -5, 1, 1, 1, -2, 45, 25, -27, -4, -6, -5, -4, -4, 0, 6, 7, 5,
                -2, -16, -5, 2, 4, -3, -3, 1, -10, 1, 1, -1, 6, 6, 0, -2, 4, -9, -13, -1, -1, 8,
                -2, 18, 5, -14, 3, 2, 36, -18, -30, -5, 5, -26, -58, 24, 5, 1, -17, -29, 12, 8,
                4, -16, 5, 4, -47, -21, 26, 10, 11, 12, 6, -9, 3, 21, -1, 5, 12, 4, -5, 1, 2, 6,
                14, 7, 1, 0, -4, 2, 9, -1, 7, 2, -3, 9, 6, 6, 3, -1, 6, 9, 3, 4, -2, -6, 7, 19,
                12, -3, -10, -13, -4, 5, -2, -6, -3, 2, 7, -1, -4, 1, 5, -1, -4, 3, 4, 1, -3, 5,
                5, -9, -4, -9, -16, -13, -10, -1, 4, 2, -4, 2, 5, -7, -3, 1, 5, 8, -4, 6, -4,
                -12, 2, 4, 14, 9, -10, -13, 6, 5, 4, 2, -11, 2, -6, -8, 1, 1, 6, -1, -4, -7, -2,
                7, -3, -4, 1, 4, 13, 4, 10, 16, -4, 6, 9, -5, 0, 6, 0, -2, 8, 0, -2, 2, 6, 11,
                2, 0, 3, 4, 4, 11, -14, -8, 25, 8, -4, 5, 13, -11, 2, 11, 2, 13, 11, 1, -1, 6,
                7, 19, 2, -2, -8, 4, 20, 5, 5, 1, 4, -1, 3, -4, -2, 8, 10, 9, -3, 1, 5, 6, 0, 1,
                -3, -8, -1, 2, 1, 1, 2, 2, 5, 2, 6, 7, 0, 5, 4, 1, 2, -7, -1, 8, 0, -3, -6, -3,
                6, 2, 2, 11, 14, 1, 2, 13, -8, -5, 12, 5, 10, 14, 11, 3, 9, 7, 11, 5, 1, 16, 6,
                8, 4, 7, 8, 11, 13, 4, 15, 13, 8, 7, 14, 11, 5, 16, 17, 13, 11, 12, 12, 12, 5,
                10, 21, 9, 17, 21, 6, 10, 18, 10, 19, 24, 4, 11, 7, 11, 17, 11, 13, 12, 20, 16,
                11, 12, 7, 13, 15, 1, 19, 32, 15, 15, 10, 11, 18, 13, 10, 13, 15, 9, 8, 4, 6, 9,
                17, 18, 12, 10, 4, 14, 13, 11, 13, 7, 14, 18, 17, 15, 6, 4, 9, 12, 14, 11, 3,
                14, 20, 7, 10, 10, 9, 9, 13, 22, 12, 13, 7, 3, 10, 10, 12, 0, 4, 8, 12, 16, 6,
                17, 13, 4, 13, 4, 2, 5, 13, 19, 17, 15, 4, 11, 14, 3, 3, 6, 9, -6, -4, 16, 13,
                8, 8, 6, 10, 10, 10, 8, 6, 10, 1, 6, 7, 7, 11, 7, 15, 5, 4, 5, -6, 14, 14, 9, 7,
                -9, 4, 9, 2, 6, 8, 13, 13, 8, 7, 13, 17, 8, -5, 1, -2, -3, 11, -2, 4, 5, 2, 3,
                2, 14, 5, 0, -9, 7, 12, -6, 6, 3, 0, 5, -1, -3, 2, 3, 5, 9, 6, 10, 6, 7, 7, -2,
                5, 3, -6, -1, 2, 6, 0, 4, 2, 2, 6, -13, 10, 10, 2, 4, -7, 3, 0, 2, 5, 0, -6, 2,
                5, -8, 8, 10, -15, -24, -27, -15, 6, 26, 36, 16, -6, -8, 3, -28, -26, 29, 15,
                -30, -19, 2, 4, -4, -15, 22, 43, 12, 9, 6, -3, 13, 2, -8, -8, -5, 1, -9, -15,
                -24, -20, -6, 10, 2, -4, 1, -7, -2, 9, -9, -18, -14, -1, -17, -41, -5, -6, -12,
                -21, -19, 3, -8, -11, -16, -15, -12, -14, -5, -12, -20, -9, -20, -15, 0, -13,
                -9, -23, -33, -15, -13, -15, -17, -21, -14, -8, 1, -4, -28, -14, -11, -18, -16,
                -10, -2, -17, -13, -4, -7, -16, -9, -16, -23, -8, -17, -16, -12, -15, -14, -18,
                -12, -11, -15, -22, -17, -13, -17, -9, -18, -12, -13, -30, -11, -10, -18, -19,
                -20, -16, -18, -19, -18, -21, -16, -6, -19, -9, -13, -33, 2, -17, -28, -2, -22,
                -16, -22, -25, -14, -19, -14, -19, -17, -14, -23, -24, -9, -14, -27, -14, -17,
                -21, -18, -21, -31, -16, -1, -16, -17, -29, -26, -16, -18, -20, -22, -16, -15,
                -11, -11, -25, -21, -16, -24, -23, -26, -14, -6, -22, -25, -20, -25, -17, -3,
                -22, -28, -14, -28, -29, -20, -20, -28, -17, -4, -22, -26, -25, -26, -21, -21,
                -28, -18, -17, -24, -25, -17, -15, -25, -13, -11, -27, -36, -20, -16, -23, -25,
                -22, -17, -24, -28, -19, -14, -22, -23, -19, -23, -34, -25, -18, -25, -25, -14,
                -18, -28, -14, -22, -28, -24, -16, -26, -25, -15, -25, -18, -28, -26, -29, -25,
                -15, -30, -34, -23, -17, -26, -18, -22, -20, -22, -31, -23, -29, -29, -34, -30,
                -25, -32, -41, -39, -27, -24, -29, -31, -8, -13, -36, -26, -24, -32, -29, -29,
                -26, -22, -25, -27, -25, -34, -30, -18, -35, -25, -38, -31, -19, -39, -20, -24,
                -25, -29, -34, -24, -35, -27, -12, -15, -17, -20, -28, -22, -25, -28, -19, -20,
                -19, -33, -28, -13, -22, -16, -23, -23, -25, -25, -15, -23, -26, -26, -25, -25,
                -22, -25, -24, -13, -15, -25, -16, -15, -23, -13, -33, -31, -23, -24, -14, -23,
                -24, -33, -15, -10, -27, -18, -21, -19, -9, -13, -18, -14, -17, -15, -18, -22,
                -22, -16, -17, -20, -5, -9, -18, -10, -12, -18, -9, -13, -21, -14, -8, -6, -9,
                -14, -15, -6, -2, -10, -11, -14, -10, 5, 1, -22, -15, -5, -10, -15, -19, -6,
                -10, -10, 6, 1, -5, -13, -17, -10, -11, -13, 1, 5, 1, -3, -7, -1, -1, -7, -1, 6,
                -11, -7, -3, -4, -2, -14, -2, -2, -10, -2, 2, 2, 1, -5, -7, -4, -1, -7, 0, 12,
                2, -4, -4, 5, 10, -12, -23, 6, 9, -8, 0, 9, 14, 14, 16, -1, 0, 9, -1, 4, 11, 10,
                10, 10, 12, 10, 4, 4, 12, 17, 10, 4, 12, 12, 6, 16, 23, 11, 0, 4, 5, 8, 12, 5,
                14, 16, 14, 16, 11, 14, 9, 11, 22, 11, 7, 21, 25, 25, 23, 29, 21, 14, 50, 28,
                -9, 14, 15, 4, 7, 22, 23, 16, 24, 28, 23, 25, 17, 20, 25, 26, 37, 12, 19, 34,
                28, 33, 18, 20, 34, 29, 21, 24, 24, 17, 25, 29, 21, 31, 30, 30, 34, 27, 32, 33,
                28, 21, 23, 26, 13, 32, 40, 32, 42, 35, 35, 22, 30, 33, 37, 54, 17, 22, 29, 25,
                23, 25, 56, 9, 4, 74, 30, 2, 35, 34, 48, 37, 38, 48, 31, 37, 43, 38, 40, 39, 45,
                37, 34, 42, 38, 42, 54, 41, 35, 45, 35, 36, 49, 44, 41, 48, 30, 26, 40, 28, 36,
                53, 34, 36, 36, 36, 52, 20, 32, 56, 40, 38, 31, 37, 39, 48, 39, 37, 39, 31, 50,
                21, 14, 43, 40, 32, 34, 38, 27, 33, 36, 36, 47, 34, 22, 28, 34, 33, 37, 36, 35,
                29, 34, 40, 22, 31, 39, 29, 29, 38, 29, 35, 35, 26, 42, 31, 31, 42, 34, 30, 32,
                36, 34, 34, 43, 21, 55, 11, -19, 80, 31, 17, 36, 30, 22, 22, 38, 28, 45, 19, 39,
                21, -1, 46, 39, 37, 32, 33, 37, 23, 28, 26, 30, 37, 27, 35, 27, 32, 58, 38, 24,
                30, 24, 22, 26, 24, 27, 27, 27, 36, 26, 21, 45, 39, 21, 16, 32, 32, 13, 35, 32,
                24, 33, 26, 25, 25, 39, 60, 20, 1, 29, 26, 24, 25, 15, 22, 32, 31, 25, 19, 23,
                22, 21, 23, 20, 24, 32, 32, 17, 20, 13, 23, 27, 11, 34, 19, 14, 21, 20, 10, 4,
                51, 27, 4, 19, 17, 20, 7, 14, 12, 10, 24, 14, 3, 19, 19, 6, 10, 15, 8, 9, 17,
                12, 15, 10, 35, 22, 9, 26, 6, 15, 10, 12, 21, 14, 17, 10, 12, 19, 17, 9, 0, 19,
                18, 15, 7, 3, 10, -2, 6, 14, 5, 8, 32, 13, -2, 11, 10, 3, 4, 8, -1, -1, 6, 12,
                1, -6, 4, 9, 5, 9, 16, 6, 8, 3, -4, -1, 1, -1, 3, 19, 6, -1, -4, 5, 3, -11, 7,
                -2, -12, -12, -4, -1, 2, 11, -3, 5, 8, -6, -8, -4, -2, -3, -1, -6, -7, -4, -4,
                -13, -12, -12, -5, -4, -13, -13, -4, 7, -6, -9, -1, -6, 5, -1, -19, -1, -8, 1,
                9, -14, -4, 3, -10, -10, -1, 0, 0, -19, -4, -6, -6, 5, -23, -3, 0, -19, -16,
                -12, -9, -10, 1, -16, -24, -13, -10, -14, -27, -4, -5, -6, -18, -18, -5, -21,
                -19, -14, -3, -14, -23, -18, -21, -12, -2, -15, -19, -16, -15, -23, -23, -20,
                -14, -23, -57, -25, -3, -12, -9, -9, -17, -21, -6, -13, -11, -4, -18, -23, -18,
                -17, -21, -31, -32, -15, -14, -27, -23, -4, -8, -28, -14, -12, -22, -11, -17,
                -23, -22, -25, -18, -15, -16, -15, -19, -27, -14, -14, -20, -17, -22, -12, -11,
                -16, -16, -15, -20, -25, -25, -25, -22, -16, -18, -18, -16, -22, -27, -27, -20,
                -19, -18, -12, -15, -34, -30, -17, -27, -26, -31, -22, -22, -33, -26, -24, -14,
                -9, -22, -33, -28, -27, -37, -29, -25, -27, -25, -31, -31, -25, -35, -34, -28,
                -29, -24, -30, -24, -36, -42, -29, -30, -20, -23, -39, -21, -15, -28, -30, -27,
                -24, -28, -29, -25, -22, -36, -33, -29, -22, -17, -22, -30, -38, -24, -28, -29,
                -22, -27, -34, -35, -25, -36, -28, -11, -38, -41, -22, -35, -43, -32, -26, -40,
                -27, -19, -30, -31, -42, -36, -34, -39, -35, -34, -28, -33, -47, -34, -39, -38,
                -32, -48, -33, -24, -32, -29, -29, -31, -31, -29, -30, -34, -31, -36, -35, -31,
                -31, -33, -35, -32, -30, -34, -32, -26, -34, -29, -29, -40, -39, -29, -18, -38,
                -42, -22, -50, -28, -13, -37, -29, -35, -35, -31, -27, -26, -14, -25, -40, -28,
                -34, -27, -26, -41, -29, -23, -27, -29, -31, -31, -39, -30, -28, -23, -30, -39,
                -21, -42, -40, -24, -32, -24, -23, -21, -29, -33, -28, -28, -18, -28, -31, -23,
                -32, -33, -28, -31, -27, -21, -34, -24, -27, -58, -19, 2, -20, -23, -27, -15,
                -18, -24, -21, -26, -31, -29, -29, -23, -23, -22, -21, -27, -18, -20, -30, -35,
                -26, -23, -27, -20, -27, -25, -24, -16, -15, -16, -17, -26, -23, -37, -23, -23,
                -35, -23, -10, -16, -23, -25, -30, -15, -23, -32, -23, -17, -22, -15, -14, -22,
                -19, -23, -22, -17, -16, -23, -23, -19, -11, -26, -21, 0, -12, -15, -13, -13,
                -17, -14, -14, -15, -10, -18, -15, -16, -16, -6, -15, -15, -5, -11, -17, -5, -7,
                -17, -10, -4, -8, -2, 1, -33, -20, 3, -12, -3, -1, 0, -2, 5, -5, -11, 7, -6, -7,
                -6, -2, 4, -9, -5, -5, -5, 7, -10, -14, 4, 0, -2, -1, 7, 6, -2, 2, 2, 0, 5, 15,
                5, 6, 6, 1, -1, 2, 24, -14, -3, 26, -5, 9, 11, -1, -2, 14, 13, -1, 6, 7, 3, 7,
                16, 10, 2, 6, 15, 10, 0, 15, 15, 4, -6, -2, 18, 13, -2, 9, 20, 6, 16, 21, 11,
                13, 16, 13, 12, 10, 3, 9, 15, 17, 10, 4, 14, 11, 7, 7, 5, 9, 18, 15, 16, 8, 5,
                20, 8, 12, 23, 13, 16, 19, 14, 24, 17, 16, 13, 16, 18, 3, 38, 18, 12, 28, 4, 14,
                17, 12, 18, 26, 14, 19, 21, 11, 18, 17, 18, 12, 26, 17, 11, 25, 24, 11, 8, 23,
                15, 18, 11, 28, 28, 12, 24, 27, 15, 2, 13, 18, 27, 17, 13, 8, 10, 35, 25, 12,
                20, 24, 15, 10, 17, 10, 15, 35, 12, 7, 18, 20, 24, 13, 16, 25, 19, 26, 18, 0,
                11, 13, 26, 22, 16, 27, 21, 21, 0, 22, 41, 17, 16, 22, 20, 14, 17, 30, 44, 30,
                11, 14, 24, 30, 12, 20, 27, 22, 17, -6, 31, 37, 22, 25, 12, 26, 22, 23, 28, 24,
                22, 27, 23, 21, 31, 16, 23, 36, 28, 27, 14, 23, 33, 17, 18, 28, 23, 21, 30, 33,
                13, 17, 29, 29, 26, 25, 28, 25, 19, 28, 32, 24, 33, 28, 22, 28, 26, 30, 27, 25,
                33, 27, 24, 31, 29, 24, 22, 30, 27, 22, 29, 27, 20, 17, 16, 24, 29, 15, 13, 26,
                26, 21, 25, 26, 17, 29, 34, 19, 23, 31, 29, 20, 26, 17, 18, 21, 15, 28, 15, 26,
                31, 12, 33, 27, 15, 22, 16, 22, 25, 12, 9, 32, 33, 27, 27, 15, 23, 24, 21, 25,
                20, 23, 24, 21, 12, 21, 22, 10, 19, 13, 14, 23, 25, 17, 24, 31, 17, 12, 21, 34,
                21, 18, 25, 18, 18, 13, 24, 18, 0, 23, 17, 11, 35, 20, 21, 31, 10, 19, 24, 16,
                14, 13, 27, 13, 6, 16, 12, 32, 19, 7, 17, 17, 23, 14, 6, 17, 13, 14, 24, 17, 22,
                13, 6, 8, 8, 16, 12, 16, 11, -13, 8, 22, 5, 8, 25, 23, 9, 14, 13, 15, 9, -3, 5,
                8, 12, 9, 8, 9, 3, 41, 13, -11, 59, 6, -17, 31, 0, 0, 11, 13, 12, 20, 15, -10,
                16, 21, 10, 22, 12, 12, 17, 14, 17, 17, 15, 19, 24, 18, 20, 20, 12, 12, 10, 13,
                26, 24, 10, 11, 10, 9, 16, 9, 32, 24, -14, 2, 19, 18, 3, 17, 21, 10, 14, 9, 3,
                13, 28, 4, 7, 11, 5, 24, 6, -2, 21, 8, 10, 14, -11, -9, 20, 17, -10, -2, 10, 16,
                9, -13, 10, 15, 0, 8, 11, 7, 4, 13, 6, -5, -5, 4, -2, -4, 6, 0, -5, -14, -3, 0,
                2, 11, -4, -4, 9, 3, 7, 5, -20, -12, 10, 12, 3, 0, -2, -4, -5, 5, 15, 2, 9, -2,
                -2, 5, -20, 4, 7, -8, 7, 4, -8, -11, 6, -2, -21, 3, 1, -14, 8, 3, -6, -2, -5,
                -3, -6, -10, -8, -6, -28, -10, 18, -7, -20, -6, -17, -16, 3, -5, -4, -2, -13,
                -12, -13, -13, 2, 2, -5, 1, -15, -20, -4, -14, -12, -6, -14, -13, -3, -7, -26,
                -15, -12, -21, -10, -14, -14, -20, -17, -4, -15, -21, -21, -10, -10, -18, -17,
                -7, -5, -16, -11, -20, -9, -14, -30, -9, -16, -24, -23, 3, -16, -35, 5, -11,
                -21, -11, -23, -8, -17, -31, -26, -15, -21, -22, 15, -23, -35, -12, -25, -23,
                -35, -23, -11, -17, -19, -25, -11, -27, -34, -12, -11, -18, -24, -20, -20, -27,
                -27, -12, -11, -20, -13, -26, -37, -24, -12, -16, -18, -29, -20, -12, -24, -16,
                -22, -34, -25, -19, -15, -17, -22, -18, -28, -18, -8, -22, -17, -15, -19, -17,
                -20, -21, -28, -23, -20, -24, -12, -24, -27, -15, -26, -12, -26, -43, -7, -28,
                -37, -13, -20, -32, -31, -21, -38, -28, -22, -31, -26, -18, -22, -24, -37, -31,
                -11, -46, -45, -15, -18, -33, -25, -13, -19, -36, -38, -24, -29, -28, -30, -29,
                -35, -39, -20, -41, -36, -21, -32, -18, -19, -30, -27, -27, -32, -37, -35, -30,
                -37, -24, -19, -37, -29, -27, -38, -28, -27, -32, -23, -35, -44, -18, -18, -31,
                -22, -21, -22, -29, -30, -23, -30, -33, -31, -38, -35, -31, -27, -27, -23, -25,
                -25, -19, -42, -35, -21, -26, -28, -21, -20, -24, -13, -26, -30, -32, -27, -25,
                -31, -28, -35, -29, -25, -24, -34, -45, -26, -13, -26, -23, -29, -32, -24, -32,
                -7, -30, -44, -8, -18, -31, -21, -43, -98, -40, 15, -19, -26, -25, -26, -23,
                -11, -19, -30, -24, -27, -26, -7, -22, -33, -7, -15, -28, -19, -23, -16, -13,
                -20, -17, -29, -20, -16, -20, -19, -28, -12, -11, -27, -19, -3, -26, -28, -7,
                -31, -30, -4, -2, -33, -34, -17, -23, -17, -14, -9, -13, -23, -11, -12, -18,
                -14, -11, 0, -13, -19, -14, -18, -22, -16, -17, -16, -10, -13, -16, -13, -1, -9,
                -12, -15, -18, -15, -30, -11, 0, -18, -11, -6, -10, -18, -11, -22, -1, 18, -36,
                -14, -2, -26, -21, -26, -16, -21, -38, -71, -72, -19, -2, -14, -20, -1, 20, 6,
                -4, 3, 3, -9, -13, -8, -8, -15, -11, 8, -9, -5, 7, -6, -10, -12, -3, -1, 3, 3,
                -2, 1, -5, -7, 2, -9, -17, 16, 11, -14, -9, -16, -10, -16, -5, 17, -2, -12, -15,
                -8, -5, -11, 15, 0, -11, -1, -7, -1, -4, 1, -5, -11, -7, -6, -5, -1, 12, 5, -13,
                -12, -9, -21, -1, 6, -7, 11, 9, 6, 3, 2, 5, -2, 2, 3, 0, 0, 0, 9, 13, -3, -3,
                12, 8, 0, -9, -2, 3, 9, -4, -16, 14, 15, 1, -3, 1, 14, -3, -18, 3, 11, 8, 13,
                14, 10, 8, 4, 9, 5, 8, 6, 9, 37, 0, -4, -7, 1, 23, 5, 12, 13, 15, 16, 12, 5, 16,
                12, 2, 5, -1, 8, 23, 9, 2, 15, 14, 6, -15, 28, 26, -14, 11, 7, 3, 2, 3, 2, 3,
                23, 23, 13, 17, 13, 5, 13, 21, 1, 5, 18, 6, 5, 10, 16, 14, 13, 7, 0, 12, 12, 15,
                22, 6, 18, 5, -11, 19, 30, 13, 8, 15, 10, 11, -3, 12, 17, 7, 11, 7, 15, 18, 17,
                11, 10, 10, 3, 11, 6, -2, 20, 17, 8, 9, 3, 14, 7, 7, 20, 3, 15, 20, 1, 14, 9,
                11, 21, 13, 8, 15, 21, 15, 11, 11, 14, 14, 12, 17, 16, 14, 18, 23, 20, 19, 20,
                14, 19, 19, 14, 19, 18, 16, 13, 10, 13, 7, 23, 17, 5, 30, 10, 10, 20, 10, 8, 14,
                37, 20, 10, 29, 12, 11, 35, 14, 4, 14, 12, 9, 9, 16, 19, 9, 6, 17, 25, 14, 9,
                18, 20, 13, 1, 23, 19, 1, 4, 17, 10, 12, 51, 4, 1, 15, 2, 20, -1, 14, 11, 5, 27,
                13, 20, 13, 17, 15, -11, 11, 17, 9, 9, 2, 8, 13, 12, 11, 21, 14, -1, 24, -2, 4,
                19, -2, 15, -1, 7, 11, 7, 16, 12, 26, 18, 0, 9, 13, 13, 13, 5, 13, 21, 15, 11,
                20, 19, 3, 13, 19, 6, 14, 12, 16, 15, 4, 6, 8, 19, 15, 9, 9, 14, 21, 12, 7, 19,
                13, 9, 18, 9, 17, 19, 12, 11, 8, 22, 16, 5, 4, 11, 22, 15, 13, 16, 22, 21, 7,
                12, 9, 5, 30, 16, 2, 8, 11, 22, -3, 3, 23, 14, 10, 17, 20, 2, 4, 22, 19, 9, 12,
                16, 15, 13, 17, 12, 5, 20, 18, 14, 14, 15, 18, 11, 16, 13, 13, 7, 12, 23, 7, 10,
                14, 7, 12, 14, 8, 5, 2, 15, 15, -1, 17, 11, -6, 7, 7, 17, 6, -3, 7, 5, 4, -3,
                -1, 6, 5, -8, 14, 18, -9, 2, 6, 2, -5, -4, -1, -6, 1, 3, -2, -4, -6, -3, -1,
                -10, -1, -5, -8, 5, 3, 0, 9, 6, -14, -4, -3, 0, 3, -5, -1, -15, -7, -2, -8, 4,
                -8, -8, -6, -19, -12, -9, -10, -9, -10, -3, -6, -12, -8, -11, -12, -6, -16, -10,
                -2, -7, -14, -22, -19, -20, -14, -12, -10, -6, -31, -15, 2, -28, -24, -23, -16,
                -15, -19, -7, -13, -4, -19, -28, -14, -21, -24, -18, -17, -20, -16, -26, -25,
                -26, -17, 0, -8, -14, -4, -12, -28, 6, -7, -26, -12, -6, -16, -19, -3, -7, -9,
                -16, -15, -15, -17, -6, -3, -12, -8, -5, -13, -1, 2, -17, -10, -12, -24, -5,
                -17, -19, -4, -6, -5, -36, -8, -12, -30, 13, -10, -12, -17, -27, -2, -8, -14,
                -9, -11, 1, -25, -21, -5, -34, -14, -7, -10, -11, -17, -15, -19, -15, -19, -17,
                -11, -12, -21, -25, -17, -17, -18, -14, -21, -21, -16, -23, -7, -17, -44, -23,
                -14, -20, -22, -23, -18, -22, -22, -21, -23, -21, -21, -22, -20, -16, -17, -30,
                -18, -11, -23, -17, -18, -19, -24, -20, -15, -28, -23, -23, -25, -21, -29, -20,
                -17, -32, -30, -31, -28, -13, -18, -12, -7, -3, -26, -40, -21, -30, -24, -25,
                -23, -24, -38, -26, -24, -16, -22, -18, -18, -58, -33, 7, -17, -44, -30, -39,
                -34, -22, -31, -27, -18, -21, -28, -23, -33, -24, -25, -27, -17, -26, -32, -24,
                -28, -26, -18, -27, -27, -15, -10, -21, -16, -20, -29, -17, -21, -19, -12, -21,
                -22, -24, -25, -28, -29, -35, -22, -13, -23, -21, -31, -28, -28, -16, -21, -27,
                -20, -16, -23, -48, -15, -17, -30, -15, -31, -13, -19, -19, -8, -33, -31, -31,
                -21, -29, -31, -7, -19, -18, -17, -25, -14, -14, -20, -24, -18, -22, -20, -12,
                -22, -25, -26, -20, -17, -16, -18, -25, -14, -10, -12, -20, -29, -16, -16, -11,
                -4, -11, -18, -29, -13, -10, -19, -10, -17, -18, -18, -16, -17, -17, -4, -19,
                -23, -13, -32, -26, -8, -21, -32, -30, -19, -19, -14, -22, -31, -18, -24, -31,
                -20, -18, -19, -23, -28, -17, -28, -31, -21, -28, -20, -19, -36, -24, -17, -33,
                -20, -26, -25, -23, -28, -8, -19, -31, -20, -20, -29, -24, -20, -21, -15, -6,
                -16, -27, -13, -23, -33, -20, -29, -15, -8, -32, -19, -28, -24, -12, -21, -16,
                -23, -19, -18, -26, -24, -18, -26, -27, -13, -25, -32, -12, -21, -20, -14, -25,
                -16, -22, -25, -20, -21, -20, -12, -14, -23, -12, -19, -17, -13, -15, -9, -17,
                -12, -13, -12, -5, -7, -15, -13, -14, -20, -8, -15, -13, -7, -7, -8, -14, -10,
                -5, -5, -8, -10, -16, 1, 2, -4, -9, -15, -4, -6, -10, -14, -3, -2, -6, -1, -12,
                -3, -3, -11, -4, -20, -12, 3, -10, -10, -9, -3, -4, -3, 4, -6, -10, 2, 0, -12,
                -3, 8, 8, -1, -12, -3, -1, -9, -5, -6, 4, 3, -3, 5, 8, -8, -19, 5, 21, 3, -17,
                4, 17, -6, -6, 9, 3, -12, 12, 23, -7, 3, 12, 1, 7, 6, -2, 9, 16, 7, 13, 10, 4,
                -1, 6, 16, 10, 9, 3, 8, 12, 1, 3, 7, 12, 9, 11, 20, 5, 13, 10, 2, 18, 7, 10, 17,
                14, 6, 6, 8, 4, 16, 19, 20, 9, 14, 19, 10, 17, 8, 12, 10, 7, 15, 8, 28, 20, 2,
                21, 14, -4, 6, 26, 9, 11, 21, 6, 11, 17, 15, 22, 26, 6, 15, 24, 12, 9, 7, 11, 5,
                13, 19, 19, 15, 9, 12, 16, 4, 4, 20, 15, 8, 0, 16, 17, -6, 15, 12, 2, 16, 17,
                17, 27, 12, 3, 15, 1, 9, 23, 17, 15, 15, 6, 9, 19, 19, 11, 19, 26, 8, 18, 18, 8,
                11, 12, 12, 14, 31, 23, 10, 8, 12, 19, 12, 20, 30, 19, 10, 23, 17, 12, 24, 18,
                22, 19, 16, 17, 23, 21, 23, 25, 12, 18, 23, 16, 16, 26, 23, 20, 14, 9, 16, 22,
                26, 22, 23, 17, 22, 28, 19, 21, 14, 13, 21, 24, 27, 24, 29, 23, 16, 22, 33, 23,
                6, 27, 25, 35, 40, 12, 19, 28, 29, 21, 23, 32, 18, 39, 47, 12, 24, 47, 16, 12,
                23, 28, 32, 22, 24, -8, 30, 52, 23, 44, 29, 22, 29, 15, 21, 31, 16, 31, 27, 6,
                34, 41, 16, 17, 39, 11, 14, 31, 15, 17, 19, 17, 29, 40, 13, 17, 20, 20, 23, 11,
                10, 24, 19, 13, 27, 17, 22, 18, 12, 18, 17, 7, 15, 23, 6, 44, 22, -1, 20, 8, 13,
                14, 16, 9, 8, 18, 12, 6, 10, 8, 8, 7, 1, 3, 7, 17, 11, 2, 10, 14, 0, -10, -6, 0,
                6, 3, 11, 12, 3, 13, 3, -3, 8, 7, 1, -8, -1, 5, 9, 18, 6, 5, 13, -4, -2, 9, -1,
                8, 8, -9, 10, 18, -4, 6, 11, -6, 5, 4, -5, 4, 6, 4, 7, 8, 12, -3, -18, 10, 5,
                -5, 5, -6, -6, -8, 3, -7, -1, 12, -4, 9, 2, -3, 9, -13, -15, 7, 1, 2, 2, 2, 3,
                -2, 3, -2, -8, -1, 1, -3, -5, -9, -9, -4, 0, 6, 3, -14, -7, 11, -12, -9, 9, 1,
                -8, -13, 5, -1, -11, -4, 2, -1, 0, 5, 4, -20, -29, 8, 3, -4, 3, 6, -4, -15, 2,
                -2, 0, 3, -6, 6, 3, 0, 0, 1, 7, -9, -17, 19, 18, -11, 11, 2, -12, 4, 2, 5, 1,
                -4, -11, -1, -1, -68, -23, 37, 2, 18, 23, 6, -3, -6, 0, -10, -2, -3, 6, 8, -5,
                -4, -2, 6, 0, 6, 0, -2, -7, -10, 2, -12, -6, 9, 2, -8, 5, 7, -5, -4, 3, -2, -12,
                4, -8, -7, 3, -17, -11, 2, -5, -4, 1, -3, -3, -14, -11, -5, 0, -4, -13, -7, -6,
                -1, -8, 1, 4, 0, 0, -17, -9, -1, 2, -3, -11, -1, -1, -5, -10, -10, 9, -2, -15,
                -9, -7, 0, 0, -14, -15, -5, -20, -20, -7, -6, 1, -11, -8, -17, -21, -3, -9, 1,
                0, -4, 9, -22, -10, 33, -8, -35, -13, -6, -10, -7, -10, 0, -5, -14, -10, -22, 9,
                3, -12, -8, -20, -9, -14, -14, 10, -3, -15, 3, -5, -14, -15, -4, 6, -1, -2, -4,
                -5, -9, -17, -9, -3, -10, -16, -8, -9, -11, -4, -5, 1, 3, -11, -11, -9, -5, 0,
                -7, -3, -6, -5, 5, -3, -7, -9, -11, -3, -9, -15, -8, 2, -7, -10, -3, -11, -2, 0,
                -4, -5, -6, -16, -15, 5, -12, -15, 1, -3, 0, -4, -9, -2, 0, -8, 0, 3, -12, -7,
                5, 7, -4, -10, -11, -6, 1, 1, -7, -2, -5, -18, -6, 0, 1, -10, -11, -1, -4, -7,
                -9, -10, -13, 8, 5, -9, 11, 0, -16, -4, -6, -4, -7, -8, 3, -2, 3, -5, -15, -2,
                -4, -11, -7, -9, -7, 0, -2, -4, -8, -12, -13, -14, 2, -2, -6, 2, -10, -9, -12,
                -13, -5, -14, -9, -5, 10, 7, -24, -9, -6, -3, 10, -10, -5, -7, -11, -5, -11, -5,
                -7, -11, -7, -7, 1, -6, -7, -2, -6, 0, -12, -21, -13, -7, -17, -13, -3, -5, -2,
                -11, -11, -6, -26, -22, -2, -9, -7, -3, -7, -9, -5, -8, -10, -5, -6, -3, -12,
                -9, -3, -9, 1, -6, -10, -10, -6, 1, -11, 0, 3, -22, -13, 1, -5, -2, -9, -16,
                -10, -6, -12, -14, -2, -11, -11, -6, -11, -8, 2, 2, -16, -2, 2, -13, -1, -3, 6,
                5, -5, -1, -2, 4, 10, -6, -4, 10, -8, -2, 8, 5, 4, -2, 2, 6, -3, 8, 15, -4, -3,
                1, -1, 9, 5, -6, 1, -4, 2, 6, 0, 6, 1, -8, -14, -2, -4, -12, 1, 5, 3, -4, -13,
                -1, 4, 4, 1, -4, 5, 4, -4, -4, 7, -11, -9, 5, 3, -6, -6, 2, -13, -4, 3, -4, -7,
                -6, 5, 3, -1, 0, -2, -5, -2, 1, 2, 4, 6, 4, -5, -7, 5, 11, 7, 3, 0, -2, 2, 12,
                -6, -15, 4, 1, 4, 0, 4, 0, 2, 49, -30, -48, 19, -2, -1, 2, -6, -9, 1, 3, -2, 1,
                2, -7, -6, 8, -1, -6, 0, 1, -9, -9, 2, -5, -8, -5, -3, -7, -2, -4, -5, 7, -2, 5,
                4, 9, 8, -3, 2, -5, -2, 1, 2, -7, -11, 0, -2, 1, 0, 7, 7, -8, -5, 5, 3, 8, 9, 6,
                -5, -12, 2, 0, 0, -8, 6, 9, -8, 10, 4, -6, 2, 0, 9, 38, -1, -17, 0, 4, 22, -7,
                -8, -4, -2, 5, 2, 5, -7, 0, 8, 4, 4, 5, 1, -1, 8, 3, 3, 3, 0, -3, -6, 6, 2, 9,
                7, 4, -3, 13, 25, -3, 12, 3, -7, 8, 11, 3, 3, 4, 1, 0, 3, 0, -2, 6, 5, 4, -2,
                -3, -4, 5, 12, 13, 6, 2, 7, 5, 25, 28, -11, -10, 14, 1, 19, 16, -1, -10, -4, 27,
                9, -2, 18, 21, 12, 5, 11, 20, 10, 17, 14, 5, 9, 9, 20, 14, 10, 12, 2, 10, 28,
                28, 19, 12, 16, 18, 8, 2, 10, 26, 23, 25, 25, 13, 4, 23, 11, 47, 80, -10, 4, 20,
                1, 14, 5, 34, 36, 18, 23, 12, 12, 19, 24, 23, 16, 23, 23, 13, 10, 18, 17, 17,
                18, 13, 22, 25, 15, 29, 25, 35, 18, 0, 38, 27, 28, 13, 4, 25, 13, 14, 22, 35,
                35, 17, 20, 22, 18, 27, 21, 24, 29, 25, 25, 24, 25, 26, 26, 21, 31, 31, 20, 28,
                30, 26, 17, 24, 32, 21, 31, 37, 22, 27, 36, 29, 20, 30, 34, 43, 31, 13, 25, 20,
                21, 21, 38, 28, 9, 25, 20, 28, 32, 22, 17, 21, 23, 32, 24, 20, 28, 18, 29, 33,
                21, 23, 29, 14, 18, 20, 20, 34, 29, 32, 18, 26, 3, -2, 48, 23, 24, 44, 23, 13,
                29, 27, 18, 24, 15, 20, 33, 26, 30, 28, 17, 23, 32, 28, 27, 24, 26, 24, 21, 38,
                29, 19, 27, 36, 30, 25, 34, 24, 30, 32, 29, 36, 30, 32, 24, 35, 21, 15, 40, 37,
                37, 32, 27, 32, 37, 27, 26, 27, 27, 37, 33, 33, 32, 35, 28, 19, 42, 43, 35, 41,
                34, 27, 31, 39, 36, 34, 35, 32, 36, 37, 30, 33, 31, 38, 36, 22, 29, 31, 38, 36,
                28, 35, 33, 35, 33, 29, 37, 32, 32, 33, 34, 33, 26, 29, 27, 32, 25, 26, 42, 38,
                39, 37, 27, 35, 38, 32, 29, 32, 41, 32, 24, 36, 26, 34, 27, 77, 93, -6, 16, 37,
                18, 31, 29, 30, 24, 27, 32, 38, 34, 27, 34, 32, 19, 17, 28, 33, 26, 35, 28, 23,
                35, 27, 28, 29, 19, 26, 38, 18, 57, 63, -5, 18, 29, 26, 38, 21, 18, 34, 32, 17,
                21, 16, 18, 29, 22, 9, 18, 32, 19, 19, 35, 24, 29, 25, 5, 27, 33, 23, 15, 24,
                26, 28, 44, 9, 12, 25, 13, 25, 17, 19, 23, 18, 21, 22, 18, 14, 16, 22, 34, 8,
                11, 26, 0, 22, 15, 11, 21, 9, -3, 16, 36, -1, -1, 14, 19, 16, 8, 6, 10, 8, 0,
                11, 18, 9, 6, 9, 14, 12, -2, 2, 5, 8, 8, 2, 9, 3, 3, 5, 15, 12, -3, 14, 15, -2,
                3, 5, -1, 13, 6, -12, 2, 12, 2, 0, 1, -2, 2, 4, 6, -6, 1, 6, -12, -4, 1, -7,
                -13, -3, 4, -2, -3, -3, -3, -8, -6, -12, -7, -3, -15, 4, 2, -8, 2, -7, -7, -10,
                -10, -3, -2, -8, -16, -9, -9, -17, -11, -6, -1, 4, -13, -10, -1, -8, -8, -10,
                -8, -11, -17, -4, -8, -17, -7, -13, -9, 23, 58, 39, 19, 41, 8, 7, 13, -11, 24,
                26, -17, 9, 24, 4, 12, 4, 6, 8, 25, 10, -38, -26, -12, -18, -26, -44, -36, -22,
                -40, -20, -12, -21, -10, -34, -31, -22, -29, -29, -25, -23, -28, -16, -8, -12,
                -25, -34, -28, -35, -28, -27, -32, -14, -17, -14, -13, -20, -15, -24, -20, -15,
                -14, -13, -17, -14, -29, -27, -15, -13, -11, -21, -24, -21, -24, -24, -25, -19,
                -7, -20, -29, -18, -22, -14, -13, -26, -19, -22, -21, -21, -22, -10, -19, -23,
                -10, -15, -19, -14, -14, -18, -19, -15, -21, -18, -12, -19, -14, -17, -21, -16,
                -24, -38, -16, 0, -24, -18, -21, -18, -20, -29, -21, -34, -29, -11, -13, -27,
                -26, -12, -20, -23, -15, -17, -18, -27, -37, -25, -17, -8, -20, -46, -18, -10,
                -28, -23, -33, -39, -22, -33, -25, -16, -25, -7, -27, -30, -21, -31, -20, -17,
                -27, -30, -28, -25, -26, -25, -22, -19, -22, -25, -21, -27, -28, -16, -14, -15,
                -16, -18, -19, -24, -24, -20, -21, -15, -19, -32, -9, -10, -27, -24, -22, -33,
                -32, -11, -21, -23, -23, -29, -20, -18, -36, -33, -18, -22, -18, -23, -24, -19,
                -19, -23, -20, -7, -16, -24, -18, -21, -19, -14, -26, -19, -11, -19, -23, -16,
                -6, -25, -26, -16, -24, -13, -21, -27, -19, -19, -17, -23, -22, -26, -5, -4,
                -33, -19, -20, -22, -15, -18, -17, -26, -22, -16, -15, -16, -27, -6, -2, -22,
                -21, -21, -7, -17, -23, -13, -15, -9, -20, -25, -21, -17, -22, -26, -23, -28,
                -16, -9, -15, -20, -20, -17, -31, -28, -16, -20, -17, -24, -35, -23, -23, -22,
                -20, -22, -15, -20, -34, -22, -15, -24, -13, -23, -27, -28, -25, -16, -30, -36,
                -28, -17, -27, -32, -24, -17, -23, -17, -14, -22, -27, -32, -10, -25, -24, -11,
                -29, -16, -19, -27, -20, -20, -14, -9, -16, -24, -13, -17, -22, -16, -37, -20,
                -8, -17, 2, -18, -18, -8, -6, 5, -19, -18, -10, -14, -9, -19, -18, -8, -7, -11,
                -8, -9, -40, -13, 11, -17, -6, -10, -13, -15, -31, -6, -7, -15, -1, -15, -11,
                -1, -1, -3, -14, -11, -7, -6, -3, -8, -6, -5, -7, 3, -5, -7, -1, -9, -2, -1, -5,
                -2, -16, -10, 8, -3, -17, -14, 4, 3, 1, -8, 2, 14, -5, 3, -8, 5, 8, -11, 3, -2,
                4, -2, -3, 5, -7, 0, 0, 1, -2, -9, 2, -5, -1, 5, 2, 1, 2, -8, -6, 5, 5, 6, -1,
                0, 5, 0, -7, 1, 9, -1, 1, 5, 0, -1, -7, -3, 2, -6, 6, 8, -4, -3, -3, 5, 2, 0,
                -5, 5, 4, -27, 6, 20, -6, 7, 2, -4, 7, -3, 1, 8, 10, 3, 0, 14, 2, 21, 9, -14, 8,
                8, 6, 8, 7, 0, 5, 15, 4, 2, 19, 7, 2, 4, 2, 2, 1, 8, 9, 11, 2, 2, 5, 9, 11, -1,
                10, 14, 5, 12, 7, 4, 2, -13, 7, 11, 5, 6, 3, 10, 5, 10, 11, 2, 4, -4, -1, 15,
                12, 9, 8, 16, 7, -13, 15, 11, 8, 23, 13, 13, 10, 4, 3, 7, 10, 14, 6, 6, 15, 10,
                6, 8, 9, 12, 12, -1, 2, 17, 17, 12, 8, 3, 7, 7, 13, 19, 2, 7, 6, -5, 12, 14, 9,
                11, 9, 4, 2, 12, 7, 4, 16, 3, 2, 15, 5, 11, 14, 0, 8, 19, 18, 10, 7, 16, -10,
                -5, 20, 9, 7, 11, 11, 15, 22, -3, 5, 16, 7, 16, 7, 14, 7, 5, 17, 11, 15, 18, 8,
                6, 15, 14, 17, 25, 20, 19, 19, 6, 10, 15, 21, 21, 11, 13, -2, 2, 12, 15, 8, 7,
                21, 10, 11, 14, 11, 14, 11, 13, 11, 13, 1, 1, 25, 12, 4, 11, 4, 10, 15, 7, 8, 9,
                14, 13, 11, 9, 13, 15, 14, 14, 15, 30, 13, 23, 12, -21, 7, 12, 6, 14, 12, -5, 8,
                15, 2, 7, 4, 3, 11, 7, 1, 6, 6, 16, 0, -9, 13, 9, 5, 6, 5, -2, 10, 18, 6, 5, 9,
                9, 5, 11, 17, 4, 20, 25, 7, 9, -5, 0, 3, -2, 9, 3, 0, 15, 4, -3, 13, 2, 5, 11,
                11, 9, 4, 8, 9, 4, 4, 5, 6, 8, -3, -9, -5, 10, 5, 12, 15, -13, 3, 16, 8, -4, -2,
                8, 7, 21, 0, -18, 12, 19, 8, 3, -9, -5, 8, 0, 8, 15, 3, 3, 12, 4, -11, -6, 13,
                8, 4, 9, -1, 2, -1, 10, 19, -6, -2, 7, -5, 8, 14, 10, 18, 4, 14, -7, 12, 40,
                -47, 3, 27, -20, 26, 27, -2, -5, 13, 3, 1, 9, 5, 6, -1, 5, 5, 5, 15, -1, 8, 18,
                8, 8, 0, 17, 11, -5, 8, 7, 1, 8, 5, -2, 5, 7, -1, 4, 16, 13, 6, 2, 12, 10, 1,
                13, 9, 4, 14, 4, -2, 12, 8, 1, 8, 14, 14, 5, -3, 6, 11, 0, 8, 6, 1, 9, 5, 0, 3,
                10, 10, 11, 7, 7, 10, 8, 4, 7, 14, 12, -1, -4, 13, -27, -4, 44, 3, 2, 7, 7, 11,
                3, 1, 10, 19, 11, 13, 13, 6, 5, 7, 6, 0, -1, 6, 7, 0, 0, -2, 3, 2, 2, 3, -13, 3,
                8, -3, 4, -8, -1, 5, 6, 14, 4, -4, -5, -9, -8, 11, 0, -9, 1, -3, -3, -1, -5, -1,
                3, -9, -3, -6, -10, 11, 0, -3, -26, -20, 8, -13, -11, -16, -15, -4, -3, -12, -9,
                -4, -4, 8, 15, -4, -25, -22, -16, -14, -34, -4, 16, -18, -8, -12, -18, -5, 3,
                -6, -18, -11, -17, -15, 2, -7, -24, -6, -10, 0, -2, -17, -5, -17, 0, -2, -17, 0,
                -2, -10, -2, 4, -7, -13, -6, -7, -8, 0, -4, -6, -8, -14, 0, 4, -3, -5, -10, -1,
                1, -2, 1, -2, 4, -3, -6, 3, -2, 1, -6, -8, -4, -5, -5, -3, -2, -8, -6, -4, -3,
                0, -4, -12, 1, 2, -12, -2, -6, -6, -3, 0, -3, -8, -3, -16, -12, -15, 13, 32,
                -28, -25, -5, -11, -15, -5, -4, -8, 4, -13, -12, -17, -14, 10, -10, -41, -18,
                15, -12, -17, -7, -10, -8, -13, -6, -4, -18, -11, 3, -1, -14, -21, -13, -7, -12,
                -19, -16, -13, -11, -21, -17, -7, 3, -9, -19, -15, -19, -10, -13, -10, -13, -12,
                -22, -29, 5, -24, -16, 41, -20, -31, -5, -21, -20, -17, -3, -15, -22, -16, -10,
                -11, -11, -5, -17, -19, -11, -22, -27, -5, -7, -19, -14, -15, -7, -10, -24, -17,
                -11, -14, -13, -14, -11, -2, -5, -21, -28, -21, -14, -16, -23, -14, -10, -21,
                -20, -17, -19, -12, -14, -15, -6, -13, -18, -19, -16, -17, -10, -11, -16, 1,
                -14, -21, -8, -13, -16, -17, -19, -11, -2, -7, 6, 4, -36, -22, -2, -10, -3, -14,
                2, 3, -36, -16, -11, -12, -6, -13, -11, -15, 4, 20, 2, -25, -13, -8, -16, -8,
                -9, -1, 4, 0, -13, -13, -7, -8, -16, -18, -5, -7, 3, -12, -12, -3, -15, 18, -2,
                -17, 1, -9, -3, -8, -11, -3, -4, -6, -2, -5, -12, -16, 1, -5, -23, -1, -8, -10,
                -7, -9, 3, -4, -7, -13, -3, -3, -15, -5, -3, -2, -6, -15, -18, 2, 8, -8, -8, -8,
                -5, -3, -2, -12, -18, -10, -12, 5, 4, -4, -5, -9, -2, -5, -6, -12, -4, -19, -19,
                7, -1, -2, -13, -15, -2, 0, -4, -11, -6, -12, -11, -4, -13, -11, -9, -3, -7, -9,
                -2, -7, -8, -14, -8, -3, -15, -8, -1, -13, -5, -6, -13, -4, -10, -2, 7, -1, -4,
                1, 0, -9, -17, -9, -8, -14, -10, -7, 7, -16, -17, -9, -37, 7, 4, -15, -9, -14,
                8, -10, -15, -4, -11, -5, -5, 3, 4, -9, -6, -2, -12, -3, 2, -17, -13, -2, 0, -9,
                -4, 1, 0, 8, -8, -10, -4, -15, -3, -4, 2, -2, -10, 4, 3, -6, 2, -7, 13, 37, -20,
                -10, 2, -16, -7, 9, -1, -13, 6, -9, -10, -3, -7, -1, 4, 6, 4, -9, -7, 0, 0, 5,
                -3, 6, -3, -10, -6, -22, 4, 15, -2, 1, 15, 11, -10, -6, 8, -2, -1, 5, -9, -11,
                4, 7, 0, 3, 5, 6, 8, 6, 4, 10, -4, 2, 12, -4, -2, 2, 6, 13, 11, 2, 12, 3, 3, 4,
                9, 29, 8, 2, -1, 10, 4, -10, 22, 18, 4, 6, 3, 7, 15, 3, 0, 10, 0, -2, 0, 3, 9,
                0, 8, 13, 5, 11, 13, 1, -1, 10, 3, 6, 6, -4, 8, 13, 15, 15, 8, 4, 8, 14, 11, 17,
                7, 5, 15, 13, 1, 9, 29, 4, 0, 5, 4, 19, 24, 13, 2, 13, 16, 2, 7, 14, 4, 16, 10,
                8, 21, 8, -3, -2, 15, 15, 6, 12, 6, 6, 9, 8, 11, 1, 5, 11, 10, 15, 8, 5, 9, 5,
                2, 0, 5, 10, -7, 11, 20, 0, 7, -9, 0, 8, -7, 0, -4, 3, 14, 12, 10, -1, 2, 11, 2,
                -1, 3, 7, 17, 8, 1, 2, -24, -5, 22, 2, 3, 5, 8, 13, 4, 13, 9, 7, 2, -1, 16, 9,
                7, 21, 16, 6, 10, 4, 0, 7, 0, 11, 9, -9, 14, 8, 4, 5, 8, 8, -8, 12, 13, 11, 6,
                10, 38, 27, 9, 1, 6, 14, 7, 13, 12, -6, 7, 13, 5, 6, 0, 3, 13, 5, -4, 13, 9, -4,
                -4, 10, 13, 5, 19, 3, -2, 4, 0, -5, -4, 23, 6, -5, 9, 10, 4, -2, 9, 8, 11, 3, 1,
                13, 2, 1, 11, 3, 10, 2, -11, 20, 13, 9, 21, 12, 11, 2, 3, 9, 12, 10, 17, 15, 1,
                6, 10, 18, 7, 11, 13, 7, 22, -7, 4, 11, 5, 23, 0, 7, 13, 1, 5, 15, 14, 1, 7, 3,
                8, 16, -7, 13, 12, 4, 19, 14, 8, -1, 4, 14, 16, 37, 43, -4, 9, 21, 3, 11, 9, 4,
                10, 13, 4, 9, 11, 11, 15, 11, 5, 6, 10, 6, 7, 16, -5, -2, 4, 10, 20, 5, 23, 9,
                -8, -2, 0, 5, 13, 16, 1, 2, 12, 16, 14, 12, 1, 5, 18, 11, 10, 7, 6, 5, 10, 18,
                13, 6, 6, 12, 6, 7, 17, 9, 12, 3, 2, 21, 7, 4, 10, 10, 10, -3, -5, 13, 8, 11,
                17, 8, 18, 2, 7, 16, 9, 5, 3, 10, -14, 7, 23, 4, 5, 3, 9, 9, 16, 4, -8, 13, 17,
                6, -2, -3, 3, 4, 6, 1, -2, 7, 7, 4, 6, 1, 2, 2, 5, -5, -7, 16, 3, 0, 13, -4, -8,
                10, 0, 0, -13, -11, 31, 19, 1, 5, 0, -1, 2, -5, 6, 16, 8, -7, -2, 2, -10, 6, 0,
                4, 11, -12, 0, 8, -1, 7, -7, 1, 13, -6, -1, 5, 6, 6, 4, 12, 3, -2, 1, -4, 10,
                12, 1, 5, 6, -1, 5, 14, -2, 4, 10, 0, 15, -1, 4, 18, -11, 3, 13, -3, 2, 10, 1,
                -4, 4, 0, 4, 5, 2, 3, -3, 14, 9, -2, 0, -8, -13, 4, 15, -1, 0, 7, 5, 4, 0, 4, 7,
                -1, 6, -4, -12, -2, 0, 6, 3, 7, -3, -4, -3, -2, -1, -9, 6, -9, -9, 1, -11, -3,
                -3, 0, -5, -10, 4, 15, 9, -6, -8, -5, -2, -3, -4, -4, -5, -9, -6, -12, -3, 11,
                -20, -16, -9, -21, -7, -7, -12, -8, -13, -9, -2, -19, -19, -6, -14, -6, -9, -12,
                -8, -13, -9, -17, -16, -9, -13, -20, -16, -13, -20, -17, -17, -23, -21, -14,
                -16, -19, -16, -13, -10, -22, -14, -21, -27, -21, -22, -17, -24, -20, -20, -15,
                -18, -31, -19, -23, -27, -27, -23, -17, -23, -17, -23, -26, -14, -20, -27, -23,
                -23, -10, -4, -25, -20, -17, -29, -22, -17, -24, -33, -18, -7, -6, -19, -14, -9,
                -23, -16, -14, -19, -26, -24, -17, -19, -15, -21, -29, -13, -20, -37, -21, -6,
                -16, -23, -16, -19, -17, -16, -20, -15, -15, -16, -20, -18, -12, -16, -18, -7,
                -19, -28, -19, -18, -14, -21, -12, -9, -22, -16, -7, -7, -13, -14, -18, -24, 3,
                -2, -20, -7, -21, -11, -1, -22, -25, -16, -10, -10, -8, -11, -18, 0, -6, -24,
                -8, -11, -13, -6, -8, -6, -10, -13, -9, -8, -14, -18, -15, -5, -11, -18, -8, -5,
                -3, -18, -19, -12, -18, -10, -12, -15, -2, -7, -18, -23, -13, -14, -6, 12, -12,
                2, -9, -33, -10, -8, -23, -14, -7, -18, -12, -1, -4, -17, -14, -10, -14, -17,
                -9, -3, -7, 2, -4, -15, -10, -6, -3, -4, -17, -12, -2, -9, -5, -3, -12, -4, -1,
                -3, -3, -12, 3, 2, -12, -9, -5, 1, -10, -13, 0, -20, -9, 8, -5, 5, -7, 4, -2,
                -13, 5, 0, -5, -6, -2, -1, 0, -6, -4, -1, -6, -10, -3, -6, -15, -13, -4, 0, -13,
                -1, 2, -4, -8, -18, -15, 0, -14, -23, 5, -1, -6, -6, -8, -3, -7, -2, -2, -7, -4,
                -2, 5, -20, -26, 5, 2, 4, -4, -4, 7, -7, 25, 8, -21, 8, -4, -11, -1, -5, -9, -1,
                -4, 1, 3, -4, 18, -1, -20, -3, -13, -6, -1, -8, -3, -14, -2, -3, -16, 7, -11,
                -12, -5, -5, 2, -11, 0, -9, 27, -4, -25, -9, -98, 5, 37, -22, 8, -9, 3, -7, -8,
                -5, -9, 2, -5, -5, -4, -20, -12, -2, -7, 1, -3, -13, -7, 0, -6, -21, -21, -10,
                -13, -2, -1, -1, -3, -18, -9, -11, -12, -10, -6, -5, -11, 1, -1, -7, -1, -9,
                -12, 0, -2, -18, -4, 3, -22, -9, -1, -3, 4, -7, -17, -19, -4, 9, -8, -12, -10,
                0, 8, -14, -3, 2, -8, -10, -6, 0, -5, 6, 3, -5, 1, -4, -11, -8, 5, 4, -10, -3,
                3, 0, 11, 6, 2, 0, -11, 2, 4, 10, 3, -6, 15, -4, -11, 7, 2, 3, -1, 4, 25, -1,
                -7, 17, -12, -16, -5, 7, 16, -9, 3, 2, -10, 10, 1, 2, -8, -2, 25, 0, -1, 5, -19,
                -11, 6, 4, 4, 4, 5, 12, -1, -13, 6, 9, 7, 3, 0, 2, 6, 10, 1, 3, -3, 11, 9, -2,
                12, -4, 1, 13, 4, 6, 3, -8, -5, 11, 7, -1, -1, -2, 0, -1, 1, 7, -1, -5, -2, 7,
                0, -6, 10, 7, -8, 5, 11, -5, 8, 7, 0, -2, -1, 2, 0, 4, -7, 6, 19, 8, 8, -2, -9,
                -4, -3, 5, 5, -6, 7, 8, -5, 6, 5, -3, 4, 4, -1, 1, 3, -3, -1, 4, -4, -1, -4, -3,
                2, 3, 9, -1, -5, -10, -10, -8, -6, -6, -7, -4, -6, -1, -5, -4, -4, 3, 3, -4, -3,
                -1, 2, -6, -2, 6, 1, -3, 0, 3, 4, 7, 2, -4, -10, 3, 2, -1, 10, 7, -7, -18, -6,
                9, 2, 10, 6, -16, 10, 9, -13, -4, -1, 5, 2, 1, 8, 0, 2, -2, 1, 12, -2, 1, 4, 5,
                4, -1, -13, -11, 0, -5, -8, -8, -6, 4, 15, 7, 2, -20, 0, 7, 0, 9, -6, 5, -12, 5,
                17, -11, 11, 5, -17, 10, -14, -18, 28, -8, 1, 17, -6, 0, -11, 3, 3, -15, 7, 7,
                -6, 16, 19, -5, 0, 4, -2, -4, -13, -6, 4, 1, 7, 14, 2, -6, 13, -1, -9, 3, -19,
                -1, 20, 10, 10, 5, -5, -2, 3, 5, -2, -4, -8, -8, 2, -6, -2, -1, -8, -12, -13,
                -3, -15, -18, 7, -3, -11, -7, 6, 0, -15, -3, -10, -7, -7, -11, -6, -11, -15, -3,
                -5, -24, 3, 6, -8, -2, -7, 14, 16, -22, -15, -1, -17, -8, -10, -15, -11, -11,
                -10, -9, -8, -17, -11, 2, -9, -26, -21, 0, -17, -23, -3, -15, -19, -2, 11, -13,
                -20, -2, -10, -15, -11, -3, -13, -14, 3, -77, -46, 44, -5, -9, -4, -8, -9, -13,
                15, -1, -15, 11, 4, -6, -2, -2, -6, -8, -3, -10, 1, 0, -17, -14, -9, 8, -4, -19,
                -6, 0, 1, -2, 3, -3, -15, -8, -6, -7, -14, -16, -2, -11, -6, -24, -23, 12, -15,
                -6, -6, -22, 2, -5, -4, 5, -13, -11, -6, -20, -19, -2, -4, -9, -4, 1, -5, -15,
                -4, 1, 4, -4, -15, -6, 4, 1, -11, -3, 1, -11, -21, 0, 0, -8, -1, 0, 8, -6, -9,
                3, -3, -17, -15, -5, -4, -3, -15, -18, -1, -2, -12, 11, 5, -3, 3, -9, -3, -4,
                -4, -5, -1, 0, 1, -3, 0, 2, -5, -8, -8, 10, -9, -14, -13, -1, 20, -5, -23, -10,
                0, -9, -12, -3, -11, -23, -2, 8, -17, -22, 4, -2, -5, -2, -5, 4, -3, 13, -40,
                -40, 31, 10, 6, 3, 1, 4, 2, 2, -2, 3, 4, 1, -9, -11, -4, 3, 12, -6, -5, 10, 18,
                5, 0, 22, 5, -3, -2, 5, 7, 4, 14, 2, 8, 7, 1, 8, -4, 7, 4, 4, 13, 8, -4, -17, 1,
                5, 2, -5, -4, 9, -3, 6, 9, 4, 11, 7, 3, -2, 1, 2, 0, 6, -3, -3, 5, -7, 7, 8,
                -15, -3, 9, -2, -1, 3, 2, -1, 7, 11, -6, 2, 2, -5, 4, 3, 11, -1, -8, 7, -3, -4,
                -1, -1, -3, -11, 5, 1, -12, -4, 1, -1, 1, 6, 4, -5, -23, -3, 18, 11, 4, 3, -3,
                -9, 3, 4, -2, -9, 5, 2, 4, 17, -6, 0, 0, -2, 5, -3, 7, 6, -6, 2, 11, 6, -6, -8,
                6, 9, 2, -4, -6, -4, 8, 7, -17, 0, 7, 3, 10, -2, 1, 6, 4, 1, 7, -2, -5, 7, -1,
                4, 5, 0, 4, 6, 10, 3, 1, 1, -7, -1, 6, 2, 4, 6, -1, 14, 19, -17, -4, -16, -5,
                26, -16, 3, 19, -7, -21, 6, 11, -1, 1, -3, 5, -15, 2, 20, 2, 2, 6, -4, -2, 2,
                -9, 12, -12, -12, 33, 2, 8, 1, -7, 18, -12, -12, 3, -2, -14, -9, 14, 0, -1, 15,
                -3, -6, -14, -2, 15, 5, 5, -12, -13, 1, -4, -9, 4, 5, -4, -2, -4, 0, 0, -5, -1,
                6, 10, -9, -6, -17, 5, -11, -49, 27, 18, -2, 8, -2, 3, -3, -9, 9, 5, -6, 2, -8,
                22, 0, -22, 4, 4, 3, -3, 3, 5, 8, 12, 10, 2, -6, 0, -4, -12, 6, 9, 0, 9, 10, 17,
                2, 2, 18, -4, -4, -2, -4, 0, 2, 6, 0, 21, 15, -12, 8, 8, 12, 20, 19, 6, 2, 11,
                7, 8, -1, 10, 15, 1, 6, 19, 13, 2, 7, 11, 10, -6, 10, 25, 14, 6, 11, 20, 8, 3,
                9, 2, 11, 22, 8, -4, 3, 25, 13, 1, 11, 15, 10, 3, 2, 12, 9, 0, 4, -2, 13, 15, 8,
                16, 4, 14, 10, 0, 22, 5, 22, 40, -8, 1, 17, 1, 3, 8, 8, 6, 3, 10, 11, 2, 3, 5,
                3, 3, 10, -5, -8, 2, 8, 19, 5, -4, -4, 7, 2, -2, 11, 4, 4, 7, -19, -4, 7, -4,
                22, 9, 1, 6, 2, 7, -4, 2, 4, -13, 2, 3, -11, -7, 2, -1, -6, -1, 3, 0, 3, 14, 6,
                -4, -3, -5, -5, -4, 1, 0, 2, 7, -6, -3, 1, -6, 0, 6, -5, -3, 6, 0, -7, 1, 22, 4,
                -6, -4, -9, 4, 1, -3, -12, -10, 3, -7, -1, 3, -11, 0, 2, -1, -2, -7, 1, 1, -3,
                -4, 4, -2, -3, -3, -15, -2, -2, -3, -2, -12, -11, -8, -6, -9, 2, 2, -8, 0, -9,
                -12, 6, -6, -12, 0, 4, -6, -8, 3, -4, 4, -1, -13, -1, -11, -8, -4, -7, 8, -4,
                -5, -3, -7, -1, -4, 0, -4, -6, -15, -18, 6, 0, -3, 9, 4, -6, -1, 6, 1, 4, 7, -3,
                -1, 11, 7, 0, 7, -4, -9, 12, 2, 2, -4, -1, 10, -5, -1, 4, 1, -2, -6, 2, 1, -2,
                7, 0, 4, 2, -6, 5, 6, 1, -56, -25, 29, 9, -4, -6, 8, -7, 7, 0, -5, 1, 15, -6,
                -27, 19, -1, -7, 5, -8, -10, 0, 7, -4, -5, 2, -2, -2, 1, -1, 3, 11, 11, -5, -14,
                3, 3, -4, 12, -3, 5, 2, -12, 2, 3, 4, -9, -2, 2, -14, 2, 3, 8, 21, -5, 1, 7, -4,
                -2, -7, 3, 1, 11, 8, -7, 11, -13, 1, 15, -8, 16, 8, -2, 4, -9, -6, 9, 3, 2, 11,
                6, 3, 7, 11, 0, 1, 22, 12, -4, -12, -9, 11, 14, 5, 11, 0, -26, 6, 4, -1, 5, -4,
                29, 5, -6, -2, -4, 17, 4, -1, -6, 1, 8, 1, 26, 17, -5, 9, 5, 8, 5, -1, -1, -1,
                2, 0, 0, 17, 14, -3, -2, 2, 10, -3, 11, 14, 1, 12, 4, 9, 5, -7, -3, 6, 11, 5, 5,
                7, 10, 8, 7, 17, 1, -4, 14, 4, 12, 18, 4, -8, 4, 15, 5, 16, 10, 5, 13, 7, 2, 5,
                17, 10, 2, 7, 2, -2, 10, 23, 8, 4, 20, 14, 2, 0, 7, 6, -8, 9, 8, -12, 8, 3, 0,
                12, -10, -6, 3, 1, 6, -3, 6, 7, -3, -1, 3, -5, -7, 6, 7, 8, -1, 8, 15, -3, 0,
                -1, -2, 7, 6, 10, 4, -3, 7, 5, -1, 0, 2, 6, 2, 3, 4, -7, -4, -1, -1, 5, 5, -1,
                3, -1, -15, 5, 11, -1, 9, 11, -4, -8, -1, -11, 2, 9, -4, 2, 7, 6, 6, -2, -3, -2,
                1, -1, -3, 0, -3, 8, -3, 3, 3, -8, 14, 2, -5, -1, -6, 3, 10, -1, 4, 18, 1, -5,
                -4, 3, 10, 7, 8, 0, -1, 7, 5, -2, -4, 9, 9, -9, -10, 1, -13, -12, 18, -4, -2,
                10, 4, 17, 10, 14, 10, 12, 13, -2, 11, 10, 7, 7, 3, 15, -1, 5, 5, -2, 4, -1, 14,
                5, 2, 14, -4, 0, 10, 3, 9, 6, -6, 14, 26, -2, -1, 17, 25, 8, -8, 11, 5, 2, 7, 7,
                6, 6, 13, 9, 0, 8, 6, 0, 18, 18, 1, 6, 6, 0, 14, 6, -3, 14, 12, 12, 10, 0, 16,
                9, 9, 18, -18, 4, 23, -9, 1, 10, 4, 6, 1, 9, 11, 4, 1, 3, 5, -1, 4, 6, 0, 9, 5,
                7, 6, 4, 13, 11, 0, -6, 6, 3, 2, 7, 5, -5, 5, 14, 5, 0, -9, 7, 0, -5, 3, -13,
                -4, 2, 3, 7, -2, 1, 3, 13, 18, 0, -1, -7, -4, 0, -5, -4, 2, 5, -4, -1, -6, -1,
                3, -5, 0, -6, 0, 0, -5, 7, 1, 18, 6, -21, -6, -2, 6, 4, -1, 3, -1, 1, -5, -3, 0,
                -11, -3, -3, -7, -8, -2, 6, 4, 2, -12, -11, 5, -5, -8, 1, -9, -3, 1, -6, -4, 0,
                -5, -11, -4, -1, 2, -1, -12, -4, 3, -2, 0, -5, -4, -6, 3, 38, -10, -28, 3, -13,
                -7, -9, -16, -8, -15, -7, 4, -6, -12, -13, -5, -7, -10, -2, -8, -6, 0, -13, -7,
                -3, -21, -1, -4, -22, -1, -3, -11, -7, -6, -4, -9, -5, -7, -11, -5, -16, -16,
                -10, -12, -12, -14, -17, -10, 0, -12, -18, -15, -14, -14, -5, -7, -6, -1, -29,
                -23, 11, 5, -2, -14, -14, -10, -20, 5, 0, -15, 4, -7, -12, -6, -12, -9, -2, -7,
                -15, -7, -2, -8, -4, -9, -21, -8, -19, -14, 0, -13, 4, 3, -4, -13, -23, -7, -7,
                -13, -16, -17, -8, -10, -14, -9, -2, -9, -10, -7, -7, -2, -19, -20, -10, -10,
                -8, -6, 1, -9, -5, -3, -19, -19, -20, -21, -16, -2, -10, -22, -6, -9, 3, -10,
                -10, 23, -33, -26, 6, -21, -11, -12, -18, -6, -23, -16, -2, -30, -14, -6, -18,
                -4, -17, -12, 0, -13, -20, -14, -7, -12, -9, -3, -12, -12, 1, -8, -15, -12, -15,
                -20, -16, -1, -6, -5, -2, -9, 0, 2, -10, -13, -6, 5, -12, -11, -3, -10, 2, -7,
                -13, -4, -9, -13, 2, -1, -7, -6, -9, -12, -9, -12, -14, 3, -2, 1, -1, -6, -6,
                -11, -8, -7, -6, -3, -5, -4, -1, -10, 0, 2, -9, -5, -1, -12, -12, -5, -5, 0, -5,
                -8, -2, -12, -24, 10, 1, -24, 9, 4, -8, -6, -15, -8, -9, -9, -3, 4, -6, -8, 9,
                -5, -15, -12, -1, 2, -17, -12, -1, -6, -1, -2, -7, 6, -3, -6, 0, 5, 7, -12, -9,
                -8, -8, -2, -3, 6, 1, -7, -6, -8, -8, 4, 1, -11, 3, -3, -13, -5, -4, -2, -3, -1,
                -16, -13, 5, -7, -4, -5, -21, -6, -6, -18, -2, 1, -5, -11, -9, 2, -5, -3, -9,
                -9, -3, -12, -4, -12, -8, -11, -4, 0, -14, 0, 4, -2, -4, 1, -21, -17, 1, -12,
                -5, -2, 1, 2, -4, -7, -9, -5, -7, -1, 1, 1, -14, -16, 4, -8, -5, 1, -4, 1, -15,
                -17, -13, -17, 1, 3, -6, -4, -11, -12, -7, -10, -4, -15, -2, 18, -11, -15, -8,
                -11, -5, 0, -2, -13, -4, -1, -18, -10, -8, -12, 8, -2, -13, -4, -13, -6, -15,
                -19, 0, -35, -11, 10, -6, 2, -12, 13, -2, -15, -3, 1, 1, -19, -9, -1, 8, 3, -5,
                2, -9, -9, -4, 2, 0, -5, 2, -1, 3, -4, -6, 0, -7, 1, -2, -8, 1, -5, -3, 7, -6,
                3, -4, 0, 1, -15, 6, -10, -16, 4, -1, -4, 0, 1, -6, 1, -5, -4, 7, -3, 2, -6, 6,
                8, -7, 4, -2, -5, 5, -1, -10, 8, 1, 5, -2, -12, 0, -4, 8, 5, -11, -6, -10, 8, 9,
                -14, 3, -26, 23, 32, -20, 7, -5, -12, -5, 5, -9, 3, 11, 1, 14, 4, 5, 0, -3, 10,
                3, -1, -4, 23, -3, -5, 74, 10, -15, 8, -9, -4, -7, 7, 9, 6, -1, 8, 6, -2, 9, -1,
                18, 10, 0, 4, 4, 19, -20, -4, 12, -2, 9, 4, 7, 12, 7, 4, 16, 8, 0, -2, 7, 15, 4,
                4, 3, 7, -3, 5, 12, -5, -4, 9, 12, 6, 7, -2, 7, 10, 6, 10, -4, 3, 8, 9, 11, -3,
                0, 8, 3, 8, 5, 1, 9, -2, -6, 9, 6, -2, 6, 4, -3, 4, 5, 4, 0, 9, 4, -3, 9, 1, -2,
                9, 7, 4, 9, 3, 3, -3, -1, 6, -1, 10, -3, -7, 9, 2, 1, 5, 7, 1, 0, 0, -1, 11, -2,
                2, 16, 4, -1, 3, 3, 2, 2, 3, 3, 24, 27, -8, -3, 5, 5, 2, 6, 10, -2, 9, 2, 7, 5,
                -6, 10, 8, 5, 9, 4, 3, 5, 2, 2, 4, 8, 11, 6, 4, 4, 2, 11, 6, 4, 9, 14, 9, -18,
                14, 23, 1, 10, 5, -2, 8, 17, 12, 20, 11, 5, 3, 4, 24, 20, 10, 9, 10, 4, -1, 7,
                6, 0, -4, -4, 6, 3, -2, 6, 5, 3, 4, -6, -1, 7, 1, -2, 11, 13, -4, -3, -3, -2, 5,
                10, 3, 2, -2, -4, 8, 3, 6, -1, -12, 3, -1, -6, 3, -7, 5, 2, -10, 10, 0, -1, 19,
                -5, -28, 5, 2, -21, -3, 0, -5, -3, 1, 14, 5, -5, 5, 3, -11, -8, 2, -8, -8, -14,
                -15, 3, -8, -16, -10, -16, -5, 6, 2, 0, -2, 11, -5, -19, 0, 7, 5, -7, -6, -8, 8,
                15, -3, -5, -4, 0, -5, -8, -4, -4, 0, 3, -1, 2, 0, 7, 2, -12, -1, 6, 8, -4, 3,
                17, 12, 11, -2, -3, 19, 5, -4, 12, 1, 10, 0, 22, 30, -25, 11, 22, -2, -1, -2, 8,
                1, 5, 9, 2, 1, 9, -3, -6, 15, 10, -5, 4, 7, 5, 15, -3, 2, 14, -9, 8, 13, 3, 5,
                -1, 6, 10, 7, 13, 8, -3, 5, 15, 10, 2, 4, 4, 5, 8, 12, 14, 7, 1, 9, 3, -8, 16,
                9, 4, 4, 7, 14, -6, 0, 0, 22, 22, -4, 5, -4, 0, 3, -2, 8, 4, 6, 3, 4, 4, 2, 12,
                10, 4, 4, 12, 9, 4, 5, 5, 0, -3, 8, 5, 13, 7, 8, 17, 1, 5, 3, 2, 9, 13, 3, 11,
                18, 5, 22, -10, 9, 54, -7, -2, 14, 0, 13, 4, 4, 6, 14, 21, 2, -8, 2, 7, 7, 8, 4,
                12, 13, 2, 1, 2, -2, 2, 17, 13, 3, 5, 5, 3, -6, 12, 23, 0, 12, 5, -1, 6, -5, 10,
                8, 2, 7, -3, 3, 8, 13, 21, 1, 11, 13, -10, 0, 6, -8, -10, 8, 16, 15, 9, 1, 1, 2,
                7, 10, 6, 6, 10, 3, 1, 12, 14, 7, 13, 11, -3, 0, -8, 31, 37, 15, 5, -7, 0, -8,
                6, 8, 1, 2, 4, 11, 2, -6, 3, 3, -7, 4, 5, 0, 8, 1, 14, 12, 9, 14, -5, -2, -2, 1,
                7, 0, 1, 12, 11, 2, 5, 0, 3, 7, 11, 1, -3, 15, 7, -1, -3, 7, 8, 0, 5, -2, 1, 3,
                9, 14, 4, 2, 4, 1, 7, 4, -10, 5, 18, -3, -2, 12, 4, -1, 1, 19, 9, 2, 14, 3, 6,
                0, -4, 8, 4, 9, 2, 0, 5, -3, 5, 4, 5, 1, -13, -2, 0, 4, 14, 7, -5, -8, -2, 0, 6,
                4, 13, 5, -12, 2, 4, 3, 8, -23, -14, 19, 8, 9, 8, 3, 6, -1, 3, 8, 4, 3, -3, 12,
                20, 3, 13, 26, 16, -13, -26, 4, 1, 4, 15, -17, 15, 9, -9, 7, 0, 14, -2, 0, 12,
                2, 11, 5, 2, 9, 5, 5, 2, -2, -4, 6, -3, -9, 7, -4, -5, -1, -2, -2, 6, 11, -9,
                -7, 4, -14, -11, 11, -14, -16, 17, 9, -3, 9, 2, -10, 5, 5, -10, -4, -6, -1, -2,
                10, 12, -16, 0, 1, -2, -2, -4, 7, -7, -1, 6, 5, 1, -4, 1, 0, -3, -7, 2, 5, -1,
                -2, 0, 5, 2, -3, 6, 4, 6, 2, -12, 6, 3, 3, 1, 0, 9, 3, 4, 0, 12, 8, -8, 5, 10,
                4, 0, 6, 12, 7, -1, 3, 12, 7, 5, -2, -1, 13, 0, 9, 34, -7, -11, 7, -4, 0, 3, 3,
                -1, -1, 1, 9, 2, 3, 6, -7, -3, 6, 4, 5, 5, -5, 0, -1, 1, 5, -1, 11, 6, -7, -1,
                -6, -2, 7, 2, -5, -8, 3, 7, 0, -3, -10, -9, 2, 8, -1, -13, -4, 4, 0, -3, -1, 7,
                -5, -2, 9, -4, -4, -4, -10, -6, -5, -5, 2, 5, -4, 2, 9, -10, -16, -12, -3, 6,
                -1, -11, -5, -4, 2, -8, -21, 5, -7, -13, -1, -7, 4, -3, -10, -3, -5, -3, -8,
                -14, -15, -13, -2, -8, -4, -8, -4, -3, -16, -1, 0, -6, -17, -13, -4, -10, -13,
                -9, -7, -14, -7, -4, -5, -16, -14, -4, -16, -1, 10, -7, -4, 6, -10, -12, -1,
                -11, -8, 3, -2, -6, 0, -2, -1, -4, -7, 6, 4, -10, -4, 0, 0, 9, -13, -20, -2, 3,
                -4, -11, 6, 9, -15, -23, 1, 16, 2, -3, 11, -7, -19, -5, -14, 3, 5, -19, 5, 4,
                -1, -2, -13, 6, 5, -4, -3, -11, -10, 5, -1, -5, -9, -4, 4, -13, -11, -11, 3, 11,
                -12, -14, -2, -1, -9, -11, -15, -5, 8, 0, -4, -7, -2, 2, -10, -6, -8, -8, -7,
                -4, -1, -16, -8, -14, -14, -14, -16, -4, -12, -6, -10, -6, 6, -10, -1, 3, -7,
                -6, -13, -7, -5, -8, -8, -1, -3, -6, -11, 1, 11, -13, -4, -11, -18, -2, -7, -11,
                -11, -2, 4, -4, -6, -6, -14, -7, -4, -10, -9, 4, 5, -1, -2, -1, -14, -3, 8, -8,
                11, 5, 1, 6, 0, 7, 5, -7, -6, -4, 6, 0, -12, 14, 7, -3, -10, -9, 13, 8, 3, 8,
                -1, -5, 5, -11, -8, 6, 6, 7, 5, -7, 6, 17, -20, -10, 2, -8, 5, 10, 1, 0, 2, -8,
                -8, 5, 3, -16, -7, -5, -5, 11, -2, -5, -3, -2, 2, 0, 7, 0, -7, -2, 7, -11, -17,
                -5, -5, -2, -8, -4, -5, 0, -1, -15, -1, 11, -4, -5, -3, -5, 0, -4, -4, 0, 6, -9,
                -1, -15, -20, 20, 11, 14, 16, -25, -40, -2, 5, -13, -3, -1, 6, 5, -6, -7, -1,
                -4, -18, 1, 4, -14, -3, 9, 0, 5, -2, -6, -1, -10, -6, -9, -8, -6, -6, -9, -10,
                -1, 6, -1, -13, -10, -2, -4, -11, -6, -2, -1, -9, -2, -4, -12, -7, -8, -6, -6,
                2, -3, 0, -7, 19, 32, -21, -6, 5, -7, -7, -8, -5, -7, 7, -3, -10, 3, 14, 4, -11,
                8, 7, 0, 5, 0, 5, 23, 3, -10, 14, -2, -3, -5, -5, 11, 3, -1, -3, 11, 7, -4, 4,
                -2, 0, 10, 4, -3, -2, -9, 1, 8, -1, -3, -3, 0, -3, 9, 7, -2, 0, -1, 3, 4, -1, 3,
                5, 5, 8, -1, 0, 5, -9, 4, 12, -3, 9, 6, 2, 10, 5, 0, 5, 7, 7, 9, 8, 1, -2, 4,
                -4, 3, 1, 2, 10, -10, 1, 5, 0, 7, -3, 10, 14, -6, 3, 10, 9, 10, 1, 11, 9, 0, 14,
                14, 3, 1, 7, 7, 0, 1, -1, 4, 12, -5, 3, 14, 4, 3, -1, 7, 9, 4, 1, 5, 10, -1, 3,
                10, 9, 3, 2, 5, 2, -1, -3, 7, 3, -2, 7, 7, 4, 2, 2, -3, 3, 11, -2, -3, -1, -3,
                -7, -8, 7, -1, -3, 4, 5, 6, -3, -11, -2, 12, -3, 2, 6, 2, -12, -8, 21, 2, 2, 6,
                -2, -8, -3, -7, -11, 15, -2, -9, 8, 5, -3, -3, -2, 0, 1, -1, -6, -24, -8, 0, -8,
                -5, 0, -8, 2, -6, -42, 17, 16, -19, 3, 1, -6, -16, 4, 2, -24, 5, 8, -13, -6, 3,
                10, -3, 3, -1, -18, -2, 3, -5, -2, 2, -1, -1, -6, -4, 9, 3, -4, 1, 1, -2, -6,
                -4, -5, 0, -6, -8, -7, -6, 0, -5, 1, -2, 6, 12, -7, -14, -8, -8, 1, 2, -9, -7,
                -3, -1, -7, 4, 14, -1, -11, -14, -5, 8, 0, -4, 4, -4, -2, -8, -18, -3, -11, -2,
                2, 0, 3, -1, -3, -6, -6, -2, -3, 1, 12, -11, -5, -4, -7, 12, -8, -8, 4, -4, -3,
                0, -6, -3, -4, -5, 4, -10, -16, -6, -4, -6, -10, -2, 0, -11, -6, 2, -8, -16, -6,
                -3, -12, -2, -3, -8, -5, -9, -6, -5, -3, 0, -3, -9, -8, -10, -6, -10, -12, -7,
                -18, -17, -11, -14, -9, -2, -3, -2, -11, -16, -14, -11, -1, -9, -12, -11, -11,
                5, -4, -14, 0, -5, -13, -3, -5, -7, -7, -1, 7, -10, -7, -3, -14, -14, -13, -6,
                -7, -26, 3, 11, 8, 34, -25, -24, -54, -128, -68, 2, 34, 29, 14, 4, -11, -2, -5,
                -7, 4, -9, -15, -10, -3, 1, -2, 1, -1, -14, -16, -6, -2, -9, -1, 3, -6, -11, -3,
                4, -12, -10, 1, -12, -12, 6, -2, -4, -1, -14, -1, 5, -9, -14, -9, -10, -2, -8,
                -7, 8, -7, -1, -2, -7, -4, -4, 3, -8, -3, 2, 0, -1, 0, 6, 0, -5, -7, -4, -4, 0,
                2, -2, 4, 7, -8, -3, 8, -3, 6, 8, -1, -6, -7, -2, 0, 4, 4, -8, -4, 2, -7, 5, 9,
                9, 1, -7, 3, -7, 0, 2, -8, 2, 5, 0, 7, 5, -4, 1, -2, -3, 0, 0, -6, -10, -4, 3,
                13, 7, -7, -10, -4, 4, 8, -3, -16, -1, -5, -15, -6, -5, -5, 3, 6, -1, 5, 4, 4,
                3, 2, 5, 2, 6, -9, -10, 1, 9, 14, -7, -10, 5, 4, -3, -1, 5, -3, 7, 9, -4, 4, 8,
                5, 5, -8, -5, 10, -8, -2, 5, 1, 4, -1, 6, -5, -11, 6, 1, 1, 9, -4, -12, -18, -9,
                3, -10, -8, -3, -9, -12, -2, 10, -2, -9, -5, -9, -1, 1, -5, -3, 1, 1, -5, 2, 8,
                -9, -9, -1, -7, 4, 1, -4, -1, -2, 7, -1, 2, 6, 15, 8, 4, 20, 5, 1, -2, 2, 4, 4,
                9, -1, -4, 8, 11, 8, -1, -3, 9, -2, -3, 8, 2, 4, 0, 2, 7, 9, 9, -4, 5, 11, 7, 1,
                0, 11, 3, 6, 9, 4, 14, 4, 8, 15, 5, 8, 2, 5, -4, 5, 6, -2, 13, 5, 18, 4, -5, 6,
                -2, 7, 19, 12, -3, 5, 8, 2, 18, 10, -20, 4, 16, 7, 10, 2, 14, 17, 11, 13, 9, 2,
                6, 4, -2, 16, 8, 13, 17, 0, 9, 9, 5, 0, 4, -11, 7, 20, -1, 6, 10, 12, 0, 5, 15,
                0, 0, 6, 3, -4, 0, 4, 13, -2, -7, 17, 3, 6, 10, 8, 9, 0, 4, -5, -7, 9, 3, 5, 8,
                -2, 2, 16, 11, -4, -1, 4, -1, -1, 4, 1, 5, 12, 3, 5, 5, -3, -3, -6, 1, 10, 14,
                9, 8, 16, 6, -4, 0, 3, 6, 4, 1, 5, 11, 4, 4, 4, -2, 3, -5, -1, 0, -1, 4, -4, 10,
                2, -18, -1, -1, -13, -6, 6, 21, 1, -11, -1, -3, 4, -7, -16, 2, -7, -7, 8, -4,
                -11, -10, -1, -5, 2, -12, -6, 22, -8, -6, 0, -11, -8, 1, -7, -14, -1, 2, 8, -2,
                -5, 8, 6, -1, -3, 12, 5, -10, -2, 48, 66, -5, -39, -19, -8, -15, -1, 13, 8, 3,
                -5, -5, -7, -5, -1, 3, 1, 5, 0, -4, -6, -12, -1, 5, 5, -10, -3, 11, -4, -7, -13,
                -7, 7, -4, -1, 10, -6, 1, 0, -10, 2, 0, 3, 0, 3, 4, -5, 0, 4, -10, -11, 4, -4,
                -5, 5, -9, -3, 2, -15, 7, -1, -17, 2, -1, -5, -7, -4, -2, -12, -13, -6, -5, -6,
                -7, -6, -14, -13, -6, -9, -4, 1, -9, -20, -6, -6, -11, -15, -26, 1, 4, -11, -7,
                -11, -8, -13, -9, -12, -24, -14, -12, -11, -15, -17, -13, -13, -20, -23, -15,
                -18, -17, -2, -10, -5, 4, -9, 3, 0, -9, -2, 4, -18, -26, 1, 6, -4, -7, -3, -1,
                -5, -15, -18, -5, -4, -24, -10, -7, -17, 9, 1, -10, 2, -4, -8, 6, 12, -4, -6,
                -2, -9, -9, -3, -5, -8, 10, -1, -17, -2, -4, 6, -1, -21, -23, -18, 6, 4, 5, 3,
                -11, -3, -4, -9, -2, 3, 0, -2, 1, -3, -1, -2, -2, -4, -10, 3, -4, -14, -2, -5,
                -1, 9, -4, -2, 5, 8, 10, -2, 10, -37, -36, 27, -1, -7, 8, 5, -6, 1, 14, -1, 2,
                -2, -15, -3, 8, -4, -13, 5, -1, -9, 3, -5, -13, 3, 16, 5, 7, 6, -6, -16, -10, 3,
                1, 9, -6, -11, -10, 1, 10, -2, 2, 0, -2, -3, -5, -4, 4, 5, -7, 8, 5, -8, 4, -3,
                -4, 5, 30, 8, -15, 12, 7, 6, 2, 3, 8, 13, 15, 18, 21, -1, -3, 12, 6, -1, -2, -1,
                4, 9, 18, 13, -1, -10, -4, -7, 2, 4, 1, 11, 10, -4, -2, 11, -16, 2, 0, -3, 26,
                -1, 2, 14, 1, 4, 9, 0, 4, 3, 5, 12, 4, -6, -2, 2, -1, 13, 7, 7, 7, 3, 0, 29, 28,
                -24, 5, -12, -18, 25, 6, 5, 5, 7, 11, 3, 7, 5, 1, 8, 26, 6, -6, 7, -2, 0, 0, 3,
                13, 13, 4, 3, -2, -2, 7, 2, 5, 8, 3, -1, 5, 13, 2, 1, 4, -1, 11, -1, -1, 8, 0,
                14, 15, 8, -7, 5, 8, -6, 10, 10, 4, 5, 2, 0, 1, 7, 1, 3, 8, 3, 13, 9, 12, 1,
                -24, 13, 24, 5, -5, 13, 24, 5, 24, 20, 10, 18, 4, 4, 6, 1, 7, 15, 9, 8, 20, 19,
                13, 7, 5, 13, 9, 16, 33, 10, 6, 15, 8, 15, 16, 7, 22, 20, -1, 7, 7, 10, 22, 11,
                4, 13, 14, 9, 10, 15, 10, -7, 9, 12, 9, 21, 5, 12, 8, 6, 23, 5, 15, 27, 13, 12,
                11, 7, 9, 13, 9, 19, 15, -2, -1, 11, 9, 11, 9, -3, 20, 21, 13, 4, 3, 17, -2, -6,
                17, 15, 12, 8, 11, 5, 2, 11, 6, 15, 8, 11, 16, 12, 16, 4, 13, 18, 15, 9, 4, 12,
                10, 14, 15, 12, 26, 17, -6, 15, 17, 7, 21, 14, 9, 16, 11, 2, 5, 9, 6, 8, 28, 11,
                8, 21, -9, 8, 13, 0, 19, 7, 4, 10, 8, -13, 0, 23, 5, 14, 10, 5, 5, 3, 13, 7, 15,
                8, -6, 8, 11, 0, -7, 16, 21, 5, -3, 10, 14, 1, 11, 14, 14, -3, 7, -2, -19, 20,
                21, 12, 6, 19, 9, 1, 6, -8, 9, 9, 6, -10, 0, 14, 5, 11, 10, 0, 0, -1, 1, 14, -4,
                -4, 4, 6, 4, -3, 2, 6, 6, 4, 11, -4, 0, 11, 1, 2, -8, -2, 7, -4, 4, 7, 10, 7,
                -9, 10, 6, -4, 13, 12, 8, 9, 10, 10, 10, 5, -4, 4, 17, 19, 13, 4, -1, 12, 9, -3,
                0, -5, -2, 6, 3, -3, -2, -1, 4, 4, 0, 2, 10, 11, 4, 2, -1, -3, 2, 0, -4, 5, 4,
                -24, -9, 14, 11, 14, 1, 4, 5, 2, 5, 2, 7, 0, -1, 13, 1, 4, -2, -18, 7, 1, -7, 2,
                6, -1, 2, -5, 3, 13, -5, 6, -4, -2, -10, -12, -1, -8, 7, 16, 13, -19, -2, 2,
                -13, 1, 5, 8, -19, 3, 19, -3, 2, 10, -3, -4, 8, -36, -4, 23, -4, 0, -13, -9, -7,
                -17, -12, 3, -11, -3, 3, -15, -2, 6, 1, -3, -2, -3, -2, -5, -7, -1, -2, -10,
                -17, -2, 0, -7, -10, -19, -12, 0, -16, -16, 4, -13, -4, -1, -13, -6, -14, 2, 0,
                -4, -3, -15, -19, -22, -7, -7, -4, 4, -10, -11, -4, -2, -13, -13, -4, -10, -8,
                -11, -11, -19, -3, -21, -29, 4, -17, -8, 4, -9, -6, -3, -24, -24, 3, -4, -8,
                -16, -15, -16, -23, -4, -5, -6, -8, -16, -1, -4, -24, -14, -8, -4, -14, -8, 5,
                -25, -3, 0, -4, 5, -14, -13, -7, -10, -74, -34, 51, 2, -10, 3, -2, 41, 24, -20,
                -7, -9, -7, 2, 1, -9, -5, -6, -10, 3, 5, 2, -2, -5, -3, -9, -7, 4, 5, -10, -7,
                -9, -7, -4, -28, -9, 4, -3, -4, -14, -6, 4, 3, -12, 4, 20, 1, -1, -1, -13, -3,
                4, -16, -11, -4, 1, 5, -8, -4, 5, -5, -3, -5, -10, 1, -5, -10, 7, 5, -16, 3, 5,
                -16, -8, -2, 2, -1, -5, -2, -6, -7, -2, -5, -7, -7, -11, 6, 0, -10, 15, -3, -9,
                7, -8, -4, 4, -4, -2, 3, -1, 8, 4, -8, 2, 7, -1, -12, -2, 5, -3, -1, 5, 0, -7,
                -2, 0, 1, 7, -10, -5, 9, -9, 2, 3, 0, 1, -3, 0, -1, 1, -6, -2, -2, -8, -12, -8,
                0, -7, -2, 12, 1, -7, -3, -4, -2, -2, -6, 2, 0, -8, 3, -3, -3, 2, -16, -5, 4,
                -2, 0, -7, 4, -6, -15, 5, 3, -1, -3, -11, -12, -9, -10, -16, -6, 8, -15, -23, 5,
                4, -2, -5, -11, -7, -11, -7, -2, 0, -8, -20, 8, 14, -14, -10, 0, -11, -8, 6,
                -17, 0, 13, -4, 16, 3, -2, -2, -7, 10, -1, 10, 7, -7, 2, -6, 0, -6, -7, -2, -2,
                -2, 3, 4, -3, -9, 2, 14, -14, 1, 10, -6, -2, -5, 15, -2, 11, -33, -70, 21, 12,
                8, 11, -2, 3, -7, 10, 3, 9, 3, 6, 17, -6, 2, 11, -2, 2, 5, 5, 10, 0, 3, 13, 12,
                0, 0, 10, 10, 1, 1, 12, 3, 5, 15, 13, -4, 3, 15, 5, 17, 16, 8, 14, 9, 4, -1, 5,
                1, 6, 12, -2, 2, 2, 1, 9, 14, 12, 0, -3, 15, 6, -14, 7, -5, -10, 22, -1, 4, 11,
                3, 15, -7, -10, 0, 4, -4, 6, 7, 2, 7, -15, 0, 5, -4, 2, 2, 6, -6, 2, 12, 4, 1,
                -8, 2, 10, 9, 15, 5, -8, -1, -1, -2, 5, 12, 8, -7, 5, 3, 5, 13, 0, -2, 4, 2, 5,
                8, -5, 2, 11, 13, 4, 6, 6, -10, 7, 6, 1, 10, 0, 0, 8, 9, 16, 9, -19, 12, 28, 5,
                9, 11, 16, 5, 6, 9, 5, 9, 3, -1, 15, 14, -7, 9, 19, 10, 7, 7, 17, 7, 7, 6, 8,
                26, 11, 0, 8, 5, 1, 16, 14, 9, 5, -2, 19, 23, 4, -4, 5, 7, 9, 10, 11, 5, 16, 19,
                10, 17, 2, 18, 25, 4, 14, 12, 8, 12, 10, 13, 8, 3, 12, 17, -15, -4, 22, 16, 9,
                3, 21, 16, 24, 22, 8, 19, -4, 14, 9, -18, 23, 26, 9, 4, 10, 2, 5, 19, 18, 33,
                13, 3, 4, 2, 13, -3, 10, 13, -3, 9, 13, 10, 6, 6, 2, 2, -12, -7, 10, 0, 2, 7, 0,
                -2, 5, 13, 5, -3, 3, -6, 2, 6, -2, 1, -1, 2, 7, -2, 2, 11, -8, 13, 17, 4, 21, 4,
                8, 17, 27, 33, 13, 25, 21, 6, 21, 31, 15, -7, 5, 20, 16, 14, 11, 11, 6, 13, 15,
                12, 20, -5, 0, 21, 2, 3, 4, 5, 11, 8, 3, 2, 14, -3, -4, -6, -1, 7, 3, 3, -10,
                -5, -6, 7, 9, -11, 1, -3, -9, 7, -6, -10, -10, -10, -11, -18, -5, -8, -11, -16,
                -21, 0, -11, -19, -4, -10, -18, -34, -27, -24, -23, -15, -23, -2, -6, -26, -4,
                3, 8, 16, 11, 23, 9, -2, 4, 12, 1, -19, -11, 11, 11, 0, 18, 23, 19, 23, 7, 1, 4,
                4, 10, -3, -10, 3, 0, -5, -1, -3, 5, -2, -12, 0, -11, -10, 7, -19, -18, 2, 0, 1,
                -11, -9, -3, -10, -13, -5, -4, 2, -6, -7, -3, -9, -2, -8, -12, -10, -4, -9, -15,
                -6, -13, -16, -18, -18, -11, -1, -4, -27, -22, -11, -18, -13, -9, -8, -12, -12,
                -4, -31, -21, 2, -12, -8, -14, -24, -29, -24, -17, -20, -17, -25, -23, -17, -21,
                -19, -17, -24, -23, -13, -21, -12, -13, -27, -19, -23, -24, -19, -4, -5, -16, 1,
                -7, -20, -10, -24, -23, -3, -19, -21, -20, -20, -3, -19, -25, -8, -18, -16, -12,
                -8, 7, -18, -37, -10, -26, -31, -26, -30, -12, -24, -26, -39, -20, 7, -23, -46,
                -24, -1, -17, -24, -13, -12, -10, -16, -21, -17, -12, -15, -20, -11, -16, -13,
                -19, -23, -13, -23, -19, -10, -10, -27, -30, -25, -21, -14, -23, -23, -18, -18,
                -20, -22, -24, -25, -33, -27, -9, -21, -25, -20, -15, -17, -24, -31, -33, -21,
                -30, -30, -15, -17, -18, -14, -16, -9, -20, -27, -17, -29, -25, -18, -29, -22,
                -19, -15, -17, -26, -24, -21, -23, -26, -17, -21, -25, -15, -30, -19, -18, -31,
                -20, -23, -9, -15, -20, -18, -26, -14, -29, -30, -9, -3, -23, -40, -16, -11,
                -31, -33, -28, -25, -20, -4, -19, -22, -18, -28, -8, -24, -18, -22, -14, -1,
                -38, -10, -12, -16, -6, -23, -17, -21, -20, -16, -13, -6, -14, -15, -13, -10,
                -11, -18, -16, -5, -13, -14, -8, -21, -8, -9, -25, -14, 3, -9, -16, 6, -2, -11,
                -8, -10, -19, -19, -10, -21, -12, -1, -4, -13, -15, -9, -7, -17, -24, -18, -10,
                -4, -12, -17, -22, -10, -26, -30, -6, -21, -16, -16, -21, -5, -12, -15, -3, -13,
                -15, -2, -15, -11, -12, -23, -11, -4, -5, -8, -17, -19, -12, -7, -4, -9, -15,
                -19, -20, -17, -9, -22, -13, -1, -13, -8, -19, 2, -20, -26, 7, -16, -5, -3, -7,
                -12, -13, -3, -13, -14, -11, -2, -8, -18, -2, -6, -7, -2, -5, 9, 1, 7, 12, -18,
                -15, 4, -8, -6, 6, -5, -4, -4, -5, -1, -3, -4, 5, 5, -5, 3, 8, 0, -9, 0, 14, -4,
                -3, 6, 2, 9, 3, 0, -5, 5, 13, 0, 5, 17, 10, -8, -1, 5, -3, 14, 9, -4, 7, -1, 5,
                31, 8, -9, 13, 16, 3, 0, -5, 4, 8, 2, 13, 6, 2, 5, 6, 5, 0, 5, 22, 34, 5, -6, 1,
                7, -5, -8, 26, 4, 0, 1, -4, 14, -2, 5, 7, 8, 0, -4, -2, -3, 8, -2, 10, 1, -9, 9,
                5, -5, 3, 13, 11, 4, 1, 16, 6, 7, 17, 5, 8, 13, 7, 8, 14, 3, -4, 0, 9, -2, -1,
                6, 6, 16, 2, 10, 4, -2, 11, -3, 7, 16, 7, 4, -2, -1, 10, 7, 23, 15, -5, 6, 10,
                12, 2, 4, -4, -5, 6, -5, 1, 5, 5, 12, 4, 7, 15, 12, 9, 18, 22, 4, 5, -7, -1, 25,
                10, 7, 19, 9, -4, 2, 11, 9, -2, 1, 9, 1, 3, 0, 2, 11, 17, 14, 3, 10, 17, 15, 7,
                7, 4, 8, 12, 4, 5, 8, 13, 10, 11, -1, 7, 23, -1, 6, 10, 7, 13, 3, 27, 26, -3, 2,
                4, 7, -5, -9, 3, 5, 12, 10, 9, 8, 2, 5, 8, 6, 4, 3, 12, 8, 1, 12, 19, -1, -6,
                14, 10, 9, 1, 10, 15, -5, 0, 3, 10, 15, -3, 0, 20, 16, 0, -3, 2, 13, 14, 5, 13,
                13, 13, 2, -5, 12, -4, 23, -10, -52, 33, 13, -3, 23, 9, 16, 13, -1, 3, 3, 4, 21,
                3, 4, 13, -3, 8, 4, 1, 11, 8, 17, 10, 10, 11, 0, 16, 11, -2, 8, 12, 8, 12, 5,
                -5, 5, 8, 1, 14, 5, 1, 16, 13, 16, 9, 13, 8, 0, 7, 16, 21, 12, 9, 5, 8, 10, -2,
                2, 5, 10, 18, 4, 10, 23, 1, -4, 17, -5, -1, 5, 1, -3, 6, -3, -19, 25, -8, -1, 9,
                -10, 8, 2, 4, -2, -2, 2, 0, -2, 2, -3, -2, 7, 4, 8, -12, -14, 15, 1, -10, -2,
                -1, -2, 1, -5, -10, 0, 1, 8, -2, -14, 0, -2, -2, 2, -6, 3, 1, -9, -9, -9, 6, -9,
                3, 14, -24, -9, 0, 4, 3, -8, -7, -1, 17, 9, -12, -6, -5, -7, 5, -15, -25, -3, 5,
                -5, -9, 8, -5, -9, -4, -8, -1, -10, -11, -8, -9, -10, -2, -9, -8, -5, -3, 3, -8,
                -9, -20, -6, -4, -12, -5, -14, -3, -2, -2, -11, -16, 0, -10, -6, -7, -22, -11,
                -9, -3, 4, -19, -10, -11, -15, -2, -10, -9, -14, -11, -8, -6, -6, -15, -16, -13,
                -7, -14, 4, 7, -5, -4, -15, -6, 4, 4, -13, -10, -4, -20, -22, -8, 1, -14, -13,
                8, -18, -26, -1, -7, 1, 5, -4, -27, -10, -8, -25, 0, -9, 11, 1, -14, 10, 2, 10,
                -5, -9, -12, -5, 8, -23, -6, -2, -10, -2, -9, 3, -1, -9, -5, -7, -11, -8, 0, 2,
                6, 0, 1, -1, -8, 1, -9, -4, -13, -32, -2, 4, -7, 3, 8, -5, -13, -8, 5, 1, -16,
                -11, -7, 0, -8, -10, 6, -2, -18, -6, 3, -2, -1, -7, -6, -11, -5, -8, -7, -15,
                -25, 7, 1, -12, -13, -6, -3, -5, 51, 63, -20, -44, -30, -18, -8, -16, -12, -10,
                -16, -17, -2, -8, -18, -11, -11, -6, -5, -10, -9, -6, 1, -10, -28, -10, -11, -2,
                -6, -30, 16, -15, -24, 5, -10, 2, -14, -10, 6, 7, 4, -9, -11, -6, -11, 1, -4,
                -8, -2, 1, 13, -1, -4, -7, -7, 0, -2, -1, -11, -9, 3, 3, 3, -3, -6, 7, 2, -10,
                -10, 4, -1, -13, 7, 7, -14, 0, 0, -15, -2, 2, 11, 9, -2, 8, -4, -8, 4, -6, -8,
                8, 10, -2, 6, 10, 12, 3, 2, 12, -1, 1, 6, 4, 5, 1, 12, 8, -7, 4, -3, -10, 6, 14,
                1, -7, -2, 4, 0, -6, 6, 3, -1, 9, 0, -9, -1, -19, 1, 8, -12, -13, -7, 10, 1, 6,
                -5, -5, 6, -12, 5, 6, 5, 24, 9, -13, -13, -6, 0, 9, 4, -1, 0, -3, -12, 0, 4, 10,
                7, -3, 3, -1, 11, 0, -3, -4, -3, 10, -11, -12, 8, 10, -4, 0, 11, -5, -12, -17,
                -19, -7, 5, 3, 8, 2, -12, 7, 7, 3, -13, -27, 13, 17, -11, -1, 8, -7, -5, -8, -7,
                -2, -5, 2, -23, -32, -15, -9, 0, 11, 11, -3, -9, -18, -7, -5, -10, 13, 10, -4,
                -7, 5, 9, -13, -4, 8, -16, -2, 5, 3, 4, -20, -14, -7, 2, 11, -16, -14, 2, -8,
                -15, -6, -6, -12, -9, -7, -3, -12, -13, -1, -5, 1, 8, -4, 1, 13, 5, -5, 1, -14,
                -12, 0, -13, -14, -27, -8, 9, -1, -3, -7, -4, -2, -10, -14, 7, -6, -15, 5, 0,
                -4, -9, -10, 0, 2, 6, 3, 1, 3, -15, 0, 7, -1, 1, -12, -1, -5, 2, 9, -4, 2, -5,
                8, -3, -14, 9, 5, 8, -16, 6, 32, -3, -1, -2, -8, 4, 12, -12, -9, 3, -2, 2, -1,
                0, 1, 3, 2, -3, -12, -3, 18, 4, 1, 9, -3, -1, 2, 2, -5, -8, -2, 4, 0, 4, 11, -5,
                -2, 3, 0, 11, 4, -8, 5, 3, 1, 3, -11, -9, 1, 11, 0, -25, -6, 8, 1, -7, -8, 0,
                -7, 1, 0, -3, -1, -8, -4, 9, 19, -4, -1, -2, -17, -1, -4, 11, 8, -15, -4, 3, -6,
                -7, 1, -2, -1, -16, 11, 21, -19, -3, -10, -25, -17, -4, 4, -10, -3, -7, -4, -2,
                -11, -9, -8, -4, -8, -5, -5, 2, -1, -16, -11, -2, -1, -5, 1, -15, -8, -2, -16,
                -9, 5, -6, -22, -11, -10, -2, -6, -16, -7, 5, 2, -5, -9, -5, -11, -23, 1, 4, -8,
                -6, -9, -7, 0, 6, -2, -6, -7, 6, -5, -32, -8, -11, -11, 8, 2, 0, -4, -7, -8,
                -17, -7, 5, 3, -2, -1, 1, -22, -11, -4, -7, 0, -2, -1, -2, 0, -12, 3, 2, -4, 9,
                -5, -1, 3, -4, 5, -8, -10, -1, -8, -7, 0, 8, 5, -6, -6, 4, -4, -17, -6, 21, 9,
                13, 24, -23, -1, 4, -1, 13, 6, 5, -18, -1, 8, 3, 2, -1, 4, 0, 6, 4, -1, -4, 5,
                15, -1, -1, 0, 1, 13, 5, 4, -4, -4, 0, 7, 14, -9, 1, 15, 4, 4, 7, 5, 2, 7, 3,
                -12, 2, 5, 4, 11, -2, 3, 13, 8, -13, 9, 11, -3, 11, 3, 7, 8, 2, -2, -4, 6, 13,
                12, 10, 18, 8, 7, 5, -8, 19, 28, 9, 10, 23, 11, 0, 12, 11, 12, 11, 13, 17, 14,
                21, 15, 2, -1, 5, 12, 5, 7, 8, 2, 2, 10, 8, 3, 17, 8, -2, 12, 11, 7, 12, 18, 12,
                3, 9, 11, 25, 13, -14, 4, 7, 7, 6, -3, 22, 9, -6, 9, -7, 10, 8, 0, 9, 3, 18, 3,
                10, 14, 1, 18, 17, 13, 11, -1, 3, 8, 9, 14, 10, 6, 8, -3, 1, 10, 9, 25, 15, 9,
                6, 8, 18, 9, 13, 7, 9, 12, 11, 16, 14, 17, 13, 11, 14, 8, 6, 7, 10, 6, 10, -2,
                -4, 25, 13, 3, 1, 3, 16, 5, 2, 14, 9, 9, 9, 4, 14, 6, 3, 15, 5, -3, 10, 14, 12,
                8, 12, 4, 4, 10, 6, 13, -5, 1, 11, 9, 13, 3, 6, 11, 14, 22, 6, -6, 3, 6, 12, 3,
                6, 16, -5, 4, 11, 7, 13, 4, 14, 20, 5, 1, 7, 5, 9, 17, 7, 11, 14, 3, 4, 4, 7,
                15, 11, 13, 4, -6, 11, 9, 1, 6, 13, 12, 14, 6, -8, 5, 11, 17, 8, -3, 16, 7, 7,
                14, 6, 22, 19, 4, 11, 12, 7, 6, 16, 15, 6, 15, 8, 14, 14, 4, 11, 2, 1, 10, 13,
                6, 5, 15, 9, 0, 12, 9, -5, 10, 14, 10, 12, 5, 6, 1, 4, 7, -2, -1, 17, 17, -11,
                7, 17, 7, 1, -20, -5, 10, 3, -1, 7, 10, 9, 17, 6, 5, -6, -15, 2, 11, 11, -4, 3,
                4, 2, 12, -6, 1, 4, -3, 16, -2, 1, 10, 2, 4, 6, 9, -1, 10, 3, -3, 10, 7, 12, 7,
                6, 12, 10, 5, 0, -2, 11, 17, 6, 5, 4, 7, -1, -5, 14, 9, 9, 4, 11, 27, 3, 1, 7,
                1, 0, -6, -5, 7, -1, -4, 0, -14, 2, 9, 8, -5, -13, 9, 12, 10, 0, 6, 13, -1, 3,
                11, 4, 6, 3, 3, 17, 0, -17, -5, 2, -2, -7, -8, -10, -5, 5, -2, 3, 6, -5, -2, -1,
                -8, -1, -1, 3, 11, -8, -5, 1, 3, 6, -3, -2, -2, 9, -1, -33, -3, 7, -1, 6, -19,
                3, 21, 1, -8, -12, 10, 16, -4, 3, 4, -12, -5, 10, 11, 1, -5, -3, -2, 0, -7, 1,
                3, -7, -1, -14, -12, 12, 1, -5, -3, 3, 14, -3, 3, 3, -12, -4, -4, -8, 3, 4, -12,
                6, -19, -28, 11, -8, -2, 2, -9, -3, -7, -1, -9, -14, 6, -3, -7, -3, -16, -12,
                -10, -13, -14, -12, -4, -19, -6, 6, -16, -6, -10, -3, -1, -10, -3, -8, -11, -12,
                1, -5, -7, -1, -8, -3, -1, -5, -11, -8, -5, 1, -19, -20, 3, 4, -1, -16, -9, -2,
                3, -2, -15, -11, -8, 7, 5, -4, 4, 0, -3, -11, -19, -7, -12, -16, -6, -8, -9,
                -13, -13, -6, -6, -17, -21, -10, -7, -7, -11, -12, -5, -16, -17, -8, -15, -10,
                -11, -6, -10, -6, 1, -10, -9, -15, -7, -10, -12, 2, 1, -6, -5, 17, -8, -25, -4,
                -16, -12, -3, -5, -2, -3, -11, -7, -1, -7, -8, -12, -6, -7, -10, -5, -4, 0, -8,
                -13, -10, -9, 0, -2, -9, -3, -6, -8, -3, -4, -5, -14, -12, -4, -1, -4, -4, -5,
                -12, -5, 0, -6, -1, 0, -15, -1, 2, -6, 6, -8, -6, -7, -17, -7, 3, 1, -10, -11,
                -21, -9, -4, -14, -5, -6, -4, -5, -1, -9, -4, 3, -7, 4, 0, -13, -11, 1, -7, -8,
                -3, -8, 22, 17, -12, -4, -10, -3, 6, -2, 0, -5, 2, 0, 1, 8, 1, 4, -1, -3, -11,
                -5, -12, -10, 5, -2, -6, -10, -3, 0, 13, -1, -14, -1, 0, -3, -2, 3, 0, 6, 3, 2,
                -1, -5, 10, 3, 3, 1, -5, 3, -8, 8, 9, 4, 15, -13, -9, 2, -5, -4, -1, 5, 8, 10,
                -4, 1, 8, -1, 1, -9, -1, 8, -1, -1, -3, 3, 4, 13, 8, -1, -1, -7, 4, -8, -9, -3,
                -6, 7, 5, -5, -7, -7, -1, 3, 2, 2, 0, -5, -5, -6, -7, -4, -6, -2, 4, -1, -5, -3,
                -2, -4, -5, 4, -6, -10, 4, -6, -3, -8, -7, 0, -11, 0, -2, -6, -5, 1, 10, -10,
                -11, 7, 2, 0, 0, -3, 0, -7, -6, 3, 7, 3, -16, -7, 19, -3, -8, 0, -10, -3, -5,
                -9, 2, 4, -4, -2, -3, -9, 1, 14, -2, -3, 12, -4, -1, 4, -1, 5, -5, 4, 9, 7, -1,
                -1, 10, 8, 11, 0, -6, 2, 9, 15, 4, 4, 11, 1, 0, 7, 9, -2, 4, 14, -1, 5, 8, -4,
                0, -1, 5, 10, -3, 5, 11, 3, 4, 9, 10, 10, 9, 9, 0, 2, 8, -2, 5, 8, 3, -3, -5, 1,
                5, 9, 7, 10, 7, 1, 9, 4, -5, 7, 10, 9, 14, 5, 7, 7, 12, 8, 3, 6, 0, 6, 8, -2,
                -22, 8, 19, 5, 9, 12, 9, 7, 10, 0, 12, 1, -1, 14, 0, 1, 5, 5, 4, 4, 11, -2, 10,
                14, 6, 2, 2, 1, -6, 19, 7, -6, 6, 0, 7, 1, 0, 13, 2, -5, -3, -1, 5, 2, 7, 0, -1,
                2, -6, -1, -4, 3, 13, 7, -1, 13, 12, 3, 11, 5, 4, 5, 0, 7, 10, 2, 5, 0, -7, -2,
                -1, 12, -2, -1, 14, 1, 3, 5, -4, 7, 18, 8, 3, -5, 3, 13, 7, 7, 1, -1, 15, 11, 3,
                9, 3, 7, 5, 14, 10, -11, 4, 12, 6, 4, 9, 9, 8, -4, -4, 11, 3, 9, 10, 9, 2, -3,
                12, 26, 10, -11, 2, 12, 16, 11, 6, 5, 14, 13, 0, 4, 7, 14, 25, 15, 2, 9, 4, 13,
                23, 3, 4, 11, 8, 9, 6, 10, 10, 11, 14, 5, 13, 15, 16, 15, 2, 2, 14, 18, 8, 5, 9,
                17, 13, -1, 9, 0, 9, 11, -6, 15, 16, 14, 10, -1, 3, 12, 7, 16, 13, 5, 16, 16, 8,
                2, 7, 10, 18, 15, 9, 14, 14, 16, 20, 18, 18, 18, 11, 10, 13, 13, 13, 9, 12, 15,
                11, 13, 7, 8, 13, 16, 12, 9, 17, 10, 4, 8, 13, 14, 14, 12, 17, 5, 4, 12, 13, 15,
                5, 7, 7, 11, 24, 13, 15, 18, 7, 11, 26, 28, -1, 5, 6, 4, 11, 9, 20, 8, 6, 8, 11,
                14, 3, 3, 3, 2, 22, 14, 8, 21, 10, 0, 3, 8, 4, 3, 6, 7, 11, 16, 13, 15, 4, 2, 8,
                3, 8, 9, 5, 9, 5, 8, 9, 12, 16, 9, 9, 11, 7, 6, 11, 13, 9, 8, 6, 1, 11, 16, 9,
                21, -8, -18, 23, 16, 7, 5, -1, 13, 8, 0, 20, 20, 11, 5, 14, 14, 2, 11, 5, 7, 13,
                7, 7, 7, 10, 5, 9, 1, -5, 9, 8, 6, 1, 1, 9, 16, 11, -3, 5, 7, -2, 1, 5, 3, 12,
                3, -3, 5, 3, 8, 0, 8, 6, -3, 6, 9, 12, 7, 8, 10, 2, 10, 9, 3, 11, 7, 6, -1, 8,
                19, 11, 6, 16, 13, -3, 6, 9, 13, 12, 12, 0, 1, 17, 5, 11, 11, 6, -1, 6, 20, -2,
                0, 13, -3, 7, 4, -8, 1, -3, 8, 7, -4, 3, 7, 4, 5, 2, -1, 3, -17, -18, 18, 9, 2,
                5, 2, 12, 6, 9, -1, -7, 3, 8, 5, 14, 8, -4, 35, -6, -25, -1, 0, 5, -2, 12, 2, 4,
                -11, -9, 5, -5, 1, -5, 6, 8, 9, 8, -3, -5, -7, 4, 11, -3, 0, -2, -3, 0, 0, 7, 6,
                5, -1, 2, -13, -15, 2, -9, 7, 1, -10, 4, -2, 8, 6, -8, -7, -4, -2, -3, 1, -7,
                -2, 5, -11, 3, 7, -6, 0, -2, -1, -9, -8, 3, -6, 0, 0, -11, -8, -3, 1, -2, 3, 0,
                -4, 1, -7, -2, -2, -1, -23, -20, 8, -1, -3, -5, -2, -1, 2, 2, -4, -7, -1, 0,
                -14, -17, -7, -14, -15, -4, -11, -3, -9, -16, 0, 0, -3, 2, 0, -9, -17, -8, -2,
                1, -19, -19, 16, -6, -16, -1, 0, 1, -10, -8, -7, -17, -8, -5, -11, -5, -4, 4,
                -7, -16, 3, 0, -9, -10, -7, -2, -1, -11, -5, -9, -5, 1, -14, 1, -5, -10, -5,
                -11, 9, 3, -25, -9, 2, -8, -1, 3, -3, -7, -8, -3, -5, -3, 6, -7, -7, 2, -16,
                -22, -9, 12, 3, -19, -2, -7, -12, -5, -6, -4, -9, -4, -6, -22, -18, -8, -11, -7,
                4, -1, -8, 3, -4, -4, 1, -14, -14, -14, -14, -9, -18, -20, -2, -9, -11, 8, -13,
                -8, 11, -15, -24, -19, -9, -10, -1, 10, -6, -1, -1, -12, -12, -2, -6, -10, -14,
                -9, 4, -8, -7, -8, -5, 0, -8, -17, -19, 0, -6, -9, -2, -11, -3, -4, -13, -6, -8,
                -14, -15, -13, -5, -5, -10, -6, -8, -8, -16, -17, -3, 1, -17, -27, -6, -11, -5,
                -8, -17, -8, -14, -8, -11, -19, -14, -6, -5, -11, -12, -13, -13, -11, -7, -9,
                -16, -13, -6, -5, -16, -24, -12, -7, -11, -5, -4, -10, -8, -5, -4, -14, -14,
                -12, -15, 0, -1, -9, -11, -2, 4, -20, -11, -2, -12, -12, 10, 4, -19, -1, -7,
                -12, -10, -6, -10, -15, -8, -11, -10, -2, -8, -14, -14, -17, -3, -2, -11, -10,
                -12, -11, -6, -11, -17, -9, -7, -6, -5, -3, -1, -1, -5, -7, 16, -7, -20, -4,
                -10, -5, -15, -6, -4, -10, 1, -2, -2, 1, -8, -10, 0, 6, 2, -5, -12, -7, 0, -2,
                -9, -7, -2, -10, -1, -2, -6, -7, -8, -1, -4, -12, -8, -6, -14, -2, -3, 0, 4, -9,
                -10, -13, -16, -2, -7, -14, -3, -8, -9, -1, -18, -17, -11, 0, 10, -22, -7, -13,
                -24, -1, -7, -12, -9, 0, -17, -18, -3, -19, -8, 11, -11, -16, -2, -3, -3, -14,
                -11, -1, -11, 0, -3, -21, -11, -14, -9, -3, -8, -11, -12, 0, 1, -5, -6, -7, -11,
                -8, 9, -4, -15, -8, -4, -1, -16, -6, -1, -13, -20, -11, -4, -17, -8, -4, -6, -6,
                -11, -15, -8, -4, -8, -23, -19, -12, -11, -2, -5, -22, -20, -15, -15, -1, -14,
                -13, -8, -12, -7, -4, -11, -16, 3
        };

#endif /* NOISE_STATIC_1_16384_H_ */
