/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Vector;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;

public abstract class AbstractTcpServer
implements Runnable,
TcpPacketListener {
    protected ServerSocket _myServerSocket;
    protected static int _myPort;
    protected TcpPacketListener _myTcpPacketListener = null;
    protected Vector _myTcpClients;
    protected Thread _myThread;
    public static final int MODE_READLINE = 0;
    public static final int MODE_TERMINATED = 1;
    public static final int MODE_NEWLINE = 2;
    public static final int MODE_STREAM = 3;
    protected final int _myMode;
    protected Vector _myBanList;

    public AbstractTcpServer(int n, int n2) {
        _myPort = n;
        this._myMode = n2;
        this._myTcpPacketListener = this;
        this.init();
    }

    public AbstractTcpServer(TcpPacketListener tcpPacketListener, int n, int n2) {
        _myPort = n;
        this._myMode = n2;
        this._myTcpPacketListener = tcpPacketListener;
        this.init();
    }

    protected void init() {
        this._myBanList = new Vector();
        this._myServerSocket = null;
        this._myTcpClients = new Vector();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.printError("TcpServer.start()", "TcpServer sleep interuption " + interruptedException);
            return;
        }
        try {
            this._myServerSocket = new ServerSocket(_myPort);
        }
        catch (IOException iOException) {
            Logger.printError("TcpServer.start()", "TcpServer io Exception " + iOException);
            return;
        }
        this._myThread = new Thread(this);
        this._myThread.start();
        Logger.printProcess("TcpServer", "ServerSocket started @ " + _myPort);
    }

    public void ban(String string) {
        this._myBanList.add(string);
        for (int i = this._myTcpClients.size() - 1; i >= 0; --i) {
            if (!((TcpClient)this._myTcpClients.get(i)).netAddress().address().equals(string)) continue;
            ((TcpClient)this._myTcpClients.get(i)).dispose();
        }
    }

    public void unBan(String string) {
        this._myBanList.remove(string);
    }

    private boolean checkBanList(ServerSocket serverSocket) {
        try {
            String string = serverSocket.getInetAddress().getHostAddress();
            String string2 = serverSocket.getInetAddress().getHostName();
            for (int i = this._myBanList.size() - 1; i >= 0; --i) {
                if (!string.equals(this._myBanList.get(i)) && !string2.equals(this._myBanList.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServerSocket socket() {
        return this._myServerSocket;
    }

    public void run() {
        while (Thread.currentThread() == this._myThread) {
            try {
                if (!this.checkBanList(this._myServerSocket)) continue;
                TcpClient tcpClient = new TcpClient(this, this._myServerSocket.accept(), this._myTcpPacketListener, _myPort, this._myMode);
                System.out.println("### new Client @ " + tcpClient);
                this._myTcpClients.addElement(tcpClient);
                Logger.printProcess("TcpServer.run", this._myTcpClients.size() + " currently running.");
            }
            catch (IOException iOException) {
                Logger.printError("TcpServer", "IOException. Stopping server.");
                break;
            }
        }
        this.dispose();
    }

    public synchronized void send(String string) {
        try {
            Enumeration enumeration = this._myTcpClients.elements();
            while (enumeration.hasMoreElements()) {
                ((TcpClient)enumeration.nextElement()).send(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized void send(byte[] byArray) {
        try {
            Enumeration enumeration = this._myTcpClients.elements();
            while (enumeration.hasMoreElements()) {
                ((TcpClient)enumeration.nextElement()).send(byArray);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this._myThread = null;
            if (this._myTcpClients != null) {
                Enumeration enumeration = this._myTcpClients.elements();
                while (enumeration.hasMoreElements()) {
                    this.remove((TcpClient)enumeration.nextElement());
                }
                this._myTcpClients = null;
            }
            if (this._myServerSocket != null) {
                this._myServerSocket.close();
                this._myServerSocket = null;
            }
        }
        catch (IOException iOException) {
            Logger.printError("TcpServer.dispose", "IOException " + iOException);
        }
    }

    public int size() {
        return this._myTcpClients.size();
    }

    public TcpClient[] getClients() {
        TcpClient[] tcpClientArray = new TcpClient[this._myTcpClients.size()];
        this._myTcpClients.toArray(tcpClientArray);
        return tcpClientArray;
    }

    public TcpClient getClient(int n) {
        return (TcpClient)this._myTcpClients.elementAt(n);
    }

    public void process(TcpPacket tcpPacket, int n) {
        this.handleInput(tcpPacket, n);
    }

    public abstract void handleInput(TcpPacket var1, int var2);

    public void remove(AbstractTcpClient abstractTcpClient) {
        if (this._myTcpPacketListener != null && !this._myTcpPacketListener.equals(this)) {
            this._myTcpPacketListener.remove(abstractTcpClient);
        }
        abstractTcpClient.dispose();
        this._myTcpClients.removeElement(abstractTcpClient);
        Logger.printProcess("TcpServer", "removing TcpClient.");
    }
}

