/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import netP5.Logger;
import netP5.UdpPacketListener;

public abstract class AbstractUdpServer
implements Runnable {
    private DatagramSocket _myDatagramSocket = null;
    protected UdpPacketListener _myListener;
    private Thread _myThread = null;
    private int _myPort;
    private String _myAddress;
    private InetAddress _myInetAddress;
    protected int _myDatagramSize = 1536;
    private boolean isRunning = true;
    private boolean isSocket = false;

    public AbstractUdpServer(UdpPacketListener udpPacketListener, int n, int n2) {
        this._myDatagramSize = n2;
        this._myPort = n;
        this._myListener = udpPacketListener;
        if (this._myListener != null) {
            this.start();
        }
    }

    protected AbstractUdpServer(UdpPacketListener udpPacketListener, String string, int n, int n2) {
        this._myDatagramSize = n2;
        this._myAddress = string;
        this._myPort = n;
        this._myListener = udpPacketListener;
        if (this._myListener != null) {
            this.start();
        }
    }

    public DatagramSocket socket() {
        return this._myDatagramSocket;
    }

    public void start() {
        this._myThread = null;
        this._myDatagramSocket = null;
        this._myThread = new Thread(this);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.printError("UdpServer.start()", "oscServer sleep interruption " + interruptedException);
        }
        try {
            this._myDatagramSocket = new DatagramSocket(this._myPort);
            this._myInetAddress = InetAddress.getByName(this._myAddress);
            Logger.printProcess("UdpServer.start()", "new Unicast DatagramSocket created @ port " + this._myPort);
        }
        catch (IOException iOException) {
            Logger.printError("UdpServer.start()", " IOException, couldnt create new DatagramSocket @ port " + this._myPort + " " + iOException);
        }
        if (this._myDatagramSocket != null) {
            this._myThread.start();
            this.isRunning = this._myThread.isAlive();
            this.isSocket = true;
        } else {
            this.isRunning = false;
        }
    }

    public void run() {
        if (this._myDatagramSocket != null) {
            if (this.isRunning) {
                Logger.printProcess("UdpServer.run()", "UdpServer is running @ " + this._myPort);
            }
        } else {
            Logger.printError("UdpServer.run()", "Socket is null. closing UdpServer.");
            return;
        }
        while (this.isRunning) {
            try {
                byte[] byArray = new byte[this._myDatagramSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, this._myDatagramSize);
                this._myDatagramSocket.receive(datagramPacket);
                this._myListener.process(datagramPacket, this._myPort);
            }
            catch (IOException iOException) {
                Logger.printProcess("UdpServer.run()", " socket closed.");
                break;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Logger.printError("UdpServer.run()", "ArrayIndexOutOfBoundsException:  " + arrayIndexOutOfBoundsException);
            }
        }
        this.dispose();
    }

    public void dispose() {
        this.isRunning = false;
        this._myThread = null;
        if (this._myDatagramSocket != null) {
            if (this._myDatagramSocket.isConnected()) {
                Logger.printDebug("UdpServer.dispose()", "disconnect()");
                this._myDatagramSocket.disconnect();
            }
            Logger.printDebug("UdpServer.dispose()", "close()");
            this._myDatagramSocket.close();
            this._myDatagramSocket = null;
            Logger.printDebug("UdpServer.dispose()", "Closing unicast datagram socket.");
        }
    }

    public void send(byte[] byArray) {
        if (this.isSocket) {
            this.send(byArray, this._myInetAddress, this._myPort);
        } else {
            Logger.printWarning("UdpClient.send", "no InetAddress and port has been set. Packet has not been sent.");
        }
    }

    public void send(byte[] byArray, String string, int n) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.send(byArray, inetAddress, n);
        }
        catch (UnknownHostException unknownHostException) {
            Logger.printError("UdpClient.send", "while sending to " + string + " " + unknownHostException);
        }
    }

    public void send(DatagramPacket datagramPacket) {
        if (this.isSocket) {
            try {
                this._myDatagramSocket.send(datagramPacket);
            }
            catch (IOException iOException) {
                Logger.printError("UdpClient.send", "ioexception while sending packet.");
            }
        }
    }

    public void send(byte[] byArray, InetAddress inetAddress, int n) {
        if (this.isSocket) {
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
                this.send(datagramPacket);
            }
            catch (NullPointerException nullPointerException) {
                Logger.printError("UdpServer.send", "a nullpointer exception occured." + nullPointerException);
            }
        } else {
            Logger.printWarning("UdpServer.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

