import com.cycling74.max.*;
import java.io.*;
import java.util.*;

public class syscommand extends MaxObject
{
	//enable verbose mode
	boolean verbose 	 = false;

	//execute process asynchronously
	boolean asynch		 = true;

	//directory which you wish the command to be executed in
	String  dir          = "";



	//hashtable containing references to processes being exectued
	//asynchronously mapped by thread name
	private Hashtable _process_hash = new Hashtable();
	private int    _current_asynch_key     = 1;
	//current synchronous process
	private Process _current_process = null;

	//current environment for 
	private HashMap _env = new HashMap();

	private static final int OUTLET_EXIT_CODE 	= 0;
	private static final int OUTLET_STDOUT 		= 1;
	private static final int OUTLET_STDERR		= 2;
	private static final int OUTLET_PROCESS_ID	= 3;
	private static final String[] INLET_ASSIST = new String[]{
		"messages in"
	};
	private static final String[] OUTLET_ASSIST = new String[]{
		"proc id & return code(int int)","stdout output","stderr output","process id (used by kill)"
	};
	
	public syscommand()
	{
		declareInlets(new int[]{DataTypes.ALL});
		declareOutlets(new int[]{DataTypes.ALL,DataTypes.ALL,DataTypes.ALL,DataTypes.ALL});

		declareAttribute("verbose");
		declareAttribute("asynch");
		declareAttribute("dir");

		setInletAssist(INLET_ASSIST);
		setOutletAssist(OUTLET_ASSIST);
		_init_default_env();
	}
	

	public void setenv(String name,String value)
	{
		_env.put(name,value);

	}
   
	public void getenv(String name)
	{
		outlet(getInfoIdx(),new String[]{name,(String)_env.get(name)});
		if(verbose)
		{
			post("(mxj syscommand) env var"+ name+"="+(String)_env.get(name));
		}
	} 

	public void unsetenv(String name)
	{
		_env.remove(name);
	}

	public void clearenv()
	{
		_env.clear();
		_init_default_env();
	}

	public void dumpenv()
	{
		String[] sa = _flatten_env();
		for(int i = 0; i < sa.length;i++)
		{
			outlet(getInfoIdx(),sa[i]);
			if(verbose)
			{
				post(sa[i]);
			}
		}
	}

	private void _init_default_env()
	{
		setenv("PATHSEP",System.getProperty("path.separator"));
		setenv("HOME",System.getProperty("user.home"));
		setenv("USERCOUNTRY",System.getProperty("user.country"));
		setenv("TMP",System.getProperty("java.io.tmpdir"));
		setenv("OSNAME",System.getProperty("os.name"));
		setenv("OSVERSION",System.getProperty("os.version"));
		setenv("USERTIMEZONE",System.getProperty("user.timezone"));
		setenv("USERLANG",System.getProperty("user.language"));
		setenv("USERNAME",System.getProperty("user.name"));
		setenv("SEP",System.getProperty("file.separator"));
	}

	private String[] _flatten_env()
	{
		Set s = _env.keySet();
		Iterator it = s.iterator();

		String[] flat = new String[s.size()];
		String str;
		for(int i = 0; i < s.size();i++)
		{
			str = (String)it.next();
			flat[i] = str+"="+(String)_env.get(str);
		}

		return flat;
	}

	private String expandvars(String in)
	{
		if(in.indexOf("$") == -1)
			return in;
		else
		{
			Set s = _env.keySet();
			Iterator it = s.iterator();
			String str;
			for(int i = 0; i < s.size();i++)
			{
				str = (String)it.next();
				post("str is "+str);
				in = in.replaceAll("\\$"+str,(String)_env.get(str));
			} 

			return in;
		}
	}

	public void kill(int id)
	{
		if(id == 0)
		{
			if(_current_process != null)
			{
				_current_process.destroy();
			}
			else
			{
				if(verbose)
					post("(mxj syscommand) no active synchronous process to kill.");
			}
		}
		else
		{
			Process p = (Process)_process_hash.get(String.valueOf(id));
			if(p != null)
				p.destroy();
			else
				post("(mxj syscommand) unable to find asynchronous process with id "+id);
		}
		
	}	
   
	public void killall()
	{
		if(_current_process != null)	
			_current_process.destroy();

		Enumeration e = _process_hash.elements();
		while(e.hasMoreElements())
			((Process)e.nextElement()).destroy();	

		_process_hash.clear();
	}

	public void exec(String[] command)
	{
		if(asynch)
		{
			final String[] f_command = command;
			final String f_dir = dir;
			Thread t = new Thread(String.valueOf(_current_asynch_key++))
			{
				public void run()
				{
					cmd(f_command,f_dir,true);
				}
			};
			t.start();

		}
		else
		{
			cmd(command,dir,false);
		}
	}
    
	public void getproperty(String prop)
	{
		String res = (String)System.getProperty(prop);
		if(res == null)
			res = "undefined";
		
		outlet(getInfoIdx(),new String[]{prop,res});
			
	}
	public void dumpproperties()
	{
		Properties p = System.getProperties();
		Enumeration e = p.propertyNames();
		while(e.hasMoreElements())
		{
			String key = (String)e.nextElement();
			outlet(getInfoIdx(),key+"="+System.getProperty(key));
		}
	}

	private void cmd( String[] cmd, String dirname,boolean asyn)
    {
        int exit_val = 0;
	 	String scmd	 = null;		
		File dir 	 = null;
		StreamReader r_out = null;
		StreamReader r_err = null;
	
		String[] env = _flatten_env();

  		if(dirname == null || dirname.equals(""))
			dir = null;	
        else
		{
			dirname = expandvars(dirname);
          	dir = new File(dirname);
			if(!dir.exists() || !dir.isDirectory())
			{
                error("(mxj syscommand) Cannot exec command in "
						+dirname+".Directory does not exist");
				return;
			}
		}

        	StringBuffer sb = new StringBuffer();
        	for(int i = 0; i < cmd.length;i++)
			{
				cmd[i] = expandvars(cmd[i]);
           		sb.append(cmd[i]+" ");
			}
        	scmd = sb.toString();


		try{
			Process p = Runtime.getRuntime().exec(cmd, env, dir);

			if(asyn){
				_process_hash.put(Thread.currentThread().getName(),p);
				outlet(OUTLET_PROCESS_ID,Integer.parseInt(Thread.currentThread().getName()));
			}
			else
			{
				_current_process = p;
				outlet(OUTLET_PROCESS_ID,0);
			}		
			r_out = new StreamReader(p.getInputStream(),OUTLET_STDOUT);//STDOUT                                                            
			r_err = new StreamReader(p.getErrorStream(),OUTLET_STDERR);//STDERR                                                            

			r_err.start();
			r_out.start();
			exit_val = p.waitFor();

			if(asyn)
			{
				
				_process_hash.remove(Thread.currentThread().getName());
				_current_asynch_key--;
				outlet(OUTLET_EXIT_CODE,
					new int[]{Integer.parseInt(Thread.currentThread().getName()),exit_val});	
			}
			else
			{
				_current_process = null;
				outlet(OUTLET_EXIT_CODE,new int[]{0,exit_val});	
			}


			}catch(Exception e)
			{
				e.printStackTrace();
				return;
			}

		if(verbose)
		{
			post("\n........................................................");
        	if(exit_val != 0)
            {
                post("(mxj syscommand) "+scmd+" FAILED"+" exit code:"+exit_val);			
			}
			else
			{
				post("(mxj syscommand) "+scmd+" OK"+" exit code:"+exit_val);						
			}
			post("........................................................");
			post("<STDOUT>");
			post(r_out.getBuf()+"</STDOUT>");
			post("<STDERR>");
			post(r_err.getBuf()+"</STDERR>");
			post("........................................................\n");
		}

    }

    class StreamReader extends Thread
    {
        InputStream is;
		int outlet = 0;
		StringBuffer buf;

        StreamReader(InputStream is,int outlet)
        {
            this.is = is;
			this.outlet = outlet;
			this.buf = new StringBuffer();
        }

        public void run()
        {

            try{
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while((line = br.readLine()) != null)
				{
					outlet(outlet,line);
					buf.append("\t"+line+"\n");	
				}
            }catch(IOException ioe)
                {
                    ioe.printStackTrace();
                }
        }
		public String getBuf()
		{
			return buf.toString();
		}

    }

}





