/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import thingm.blink1.Blink1;

public class Blink1ColorPicker
extends PApplet {
    Blink1 blink1;
    int sketchWidth = 400;
    int sketchHeight = 240;
    int colorPickerX = 10;
    int colorPickerY = 20;
    int colorPickerWidth = 255;
    int colorPickerHeight = 207;
    int previewWidth = 40;
    int previewHeight = 40;
    int pickX;
    int pickY;
    int previewX;
    int previewY;
    int backColor = this.color(226);
    int previewColor = this.color(255, 0, 255);
    PGraphics colorPickerImage;
    PFont font;
    String statusText = "";

    public void setup() {
        this.size(this.sketchWidth, this.sketchHeight);
        this.frameRate(20.0f);
        this.smooth();
        this.font = this.loadFont("LucidaSans-12.vlw");
        this.blink1 = new Blink1();
        int n = this.blink1.open();
        if (n != 0) {
            Blink1ColorPicker.println((String)"oops no blink1");
            this.statusText = "no Blink1 found";
        } else {
            this.statusText = "Blink1";
        }
        this.pickX = this.colorPickerX + this.colorPickerWidth / 8 * 7;
        this.pickY = this.colorPickerY + this.colorPickerHeight / 2;
        this.previewX = this.colorPickerX + this.colorPickerWidth + 30;
        this.previewY = this.colorPickerY - 5;
        this.colorPickerImage = this.createColorPickerImage();
        this.updateBlink1();
    }

    public void updateBlink1() {
        int n = PApplet.parseInt((float)this.red(this.previewColor));
        int n2 = PApplet.parseInt((float)this.green(this.previewColor));
        int n3 = PApplet.parseInt((float)this.blue(this.previewColor));
        int n4 = this.log2lin(n);
        int n5 = this.log2lin(n2);
        int n6 = this.log2lin(n3);
        Blink1ColorPicker.println((String)("r,g,b: (lin)" + n + "," + n2 + "," + n3 + " ==> (log)" + n4 + "," + n5 + "," + n6));
        this.blink1.setRGB(n, n2, n3);
    }

    public void draw() {
        this.background(this.backColor);
        this.drawColorPicker();
        this.drawPreview(this.previewX, this.previewY, this.previewWidth, this.previewHeight);
        this.drawStatus();
    }

    public void mousePressed() {
        if (this.mouseX > this.colorPickerX && this.mouseX < this.colorPickerX + this.colorPickerWidth && this.mouseY > this.colorPickerY && this.mouseY < this.colorPickerY + this.colorPickerHeight) {
            this.previewColor = this.colorPickerImage.get(this.mouseX - this.colorPickerX, this.mouseY - this.colorPickerY);
            this.pickX = this.mouseX;
            this.pickY = this.mouseY;
            this.updateBlink1();
        }
    }

    public void mouseDragged() {
        this.mousePressed();
    }

    public void drawStatus() {
        this.textFont(this.font, 12.0f);
        this.text(this.statusText, this.colorPickerX + this.colorPickerWidth + 5, this.height - 13);
    }

    public void drawPreview(int n, int n2, int n3, int n4) {
        int n5 = this.previewColor;
        this.pushMatrix();
        this.translate(n, n2);
        this.textFont(this.font, 12.0f);
        this.text("color", 0.0f, 0.0f);
        this.text("selected", 0.0f, 12.0f);
        this.strokeWeight(1.0f);
        this.stroke(180);
        this.fill(n5);
        this.rect(0.0f, 15.0f, n3, n4);
        this.fill(10);
        this.textFont(this.font, 8.0f);
        this.text(PApplet.parseInt((float)this.red(n5)), n3 + 2, 25.0f);
        this.text(PApplet.parseInt((float)this.green(n5)), n3 + 2, 35.0f);
        this.text(PApplet.parseInt((float)this.blue(n5)), n3 + 2, 45.0f);
        this.popMatrix();
    }

    public void drawColorPicker() {
        this.fill(10);
        this.textFont(this.font, 12.0f);
        this.text("pick a color", this.colorPickerX, this.colorPickerY - 5);
        this.image((PImage)this.colorPickerImage, this.colorPickerX, this.colorPickerY);
        this.noFill();
        this.stroke(200);
        this.rect(this.pickX - 4, this.pickY - 4, 8.0f, 8.0f);
        this.stroke(40);
        this.rect(this.pickX - 3, this.pickY - 3, 8.0f, 8.0f);
    }

    public PGraphics createColorPickerImage() {
        PGraphics pGraphics = this.createGraphics(255, 208, "processing.core.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.colorMode(3, 255.0f, 100.0f, 100.0f);
        pGraphics.stroke(255.0f, 0.0f, 100.0f);
        pGraphics.fill(255.0f, 0.0f, 100.0f);
        pGraphics.rect(0.0f, 0.0f, 255.0f, 4.0f);
        int n = 0;
        while (n < 255) {
            int n2 = 0;
            while (n2 < 100) {
                pGraphics.stroke((float)n, (float)n2, 100.0f);
                pGraphics.point((float)n, (float)(4 + n2));
                pGraphics.stroke((float)n, 100.0f, (float)(100 - n2));
                pGraphics.point((float)n, (float)(4 + n2 + 100));
                ++n2;
            }
            ++n;
        }
        pGraphics.stroke(255.0f, 0.0f, 0.0f);
        pGraphics.fill(255.0f, 0.0f, 0.0f);
        pGraphics.rect(0.0f, 204.0f, 255.0f, 4.0f);
        pGraphics.endDraw();
        return pGraphics;
    }

    public int log2lin(int n) {
        return (1 << n / 32) - 1 + ((1 << n / 32) * (n % 32 + 1) + 15) / 32;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "Blink1ColorPicker"});
    }
}

