/*
 * Decompiled with CFR 0.152.
 */
package thingm.blink1;

import java.awt.Color;
import java.util.Random;

public class Blink1 {
    public static void usage() {
        Blink1.println("Usage: Blink1 <cmd> [options]\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Blink1.usage();
        }
        Blink1 blink1 = new Blink1();
        int n = blink1.getCount();
        System.out.println("found " + n + " devices");
        System.out.println("device paths:");
        blink1.open();
        int n2 = blink1.getFirmwareVersion();
        blink1.close();
        System.out.println("firmware version: " + n2);
        String[] stringArray2 = blink1.getDevicePaths();
        String[] stringArray3 = blink1.getDeviceSerials();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(i + ": " + stringArray3[i] + " : " + stringArray2[i]);
        }
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            int n3 = random.nextInt() & 0xFF;
            int n4 = random.nextInt() & 0xFF;
            int n5 = random.nextInt() & 0xFF;
            int n6 = n == 0 ? 0 : random.nextInt() & n - 1;
            System.out.print("setting id: " + n6 + " to color " + n3 + "," + n4 + "," + n5 + "   ");
            int n7 = blink1.openById(n6);
            if (n7 == -1) {
                System.out.print("couldn't open " + n6 + " ");
            }
            Color color = new Color(n3, n4, n5);
            n7 = blink1.setRGB(color);
            blink1.close();
            if (n7 == -1) {
                System.out.println("error detected");
            } else {
                System.out.println();
            }
            Blink1.pause(250);
        }
        System.out.println("Done.");
    }

    public Blink1() {
        this.enumerate();
    }

    public native int enumerate();

    public native int getCount();

    public native String[] getDevicePaths();

    public native String[] getDeviceSerials();

    public native int open();

    public native void close();

    public native int openByPath(String var1);

    public native int openBySerial(String var1);

    public native int openById(int var1);

    public synchronized native int command(int var1, byte[] var2, byte[] var3);

    public synchronized native int setRGB(int var1, int var2, int var3);

    public int setRGB(Color color) {
        return this.setRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public synchronized native int fadeToRGB(int var1, int var2, int var3, int var4);

    public int fadeToRGB(int n, Color color) {
        return this.fadeToRGB(n, color.getRed(), color.getGreen(), color.getBlue());
    }

    public synchronized native int writePatternLine(int var1, int var2, int var3, int var4, int var5);

    public synchronized native int play(boolean var1, int var2);

    public synchronized native int serverdown(boolean var1, int var2);

    public synchronized native int getFirmwareVersion();

    public static final int log2lin(int n) {
        return (1 << n / 32) - 1 + ((1 << n / 32) * (n % 32 + 1) + 15) / 32;
    }

    public static final void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void println(String string) {
        System.out.println(string);
    }

    public static final void print(String string) {
        System.out.print(string);
    }

    static {
        System.loadLibrary("Blink1");
    }
}

