/**
 *
 *
 *
 */

import thingm.blink1.*;

import ddf.minim.analysis.*;
import ddf.minim.*;
 
Minim minim;
AudioInput in;
FFT fft;
// buffer size (= FFT size, must be power of 2)
int bufferSize = 1024;
float sampleRate = 22050;

BeatDetect beat;
BeatListener bl;

Blink1 blink1;

float kickSize, snareSize, hatSize;

color backColor = color(226);

void setup() {

  size(512, 200);
  smooth();
 
  minim = new Minim(this);
  
  // setup audio input
  in = minim.getLineIn(Minim.MONO, bufferSize, sampleRate);
 
  //fft = new FFT(in.bufferSize(), in.sampleRate());
  
  // suppress windowing inside FFT - we'll do it ourselves
  //fft.window(FFT.NONE);

  // a beat detection object that is FREQ_ENERGY mode that 
  // expects buffers the length of song's buffer size
  // and samples captured at songs's sample rate
  beat = new BeatDetect(in.bufferSize(), in.sampleRate());
  // set the sensitivity to 300 milliseconds
  // After a beat has been detected, the algorithm will wait for 300 millisecs 
  // before allowing another beat to be reported. You can use this to dampen the 
  // algorithm if it is giving too many false-positives. The default value is 10, 
  // which is essentially no damping. If you try to set the sensitivity to a negative value, 
  // an error will be reported and it will be set to 10 instead. 
  beat.setSensitivity(300);  
  kickSize = snareSize = hatSize = 16;
  // make a new beat listener, so we won't miss any buffers for the analysis
  bl = new BeatListener( beat,in );

  blink1 = new Blink1();

  int rc = blink1.open();

}

void draw() {
  backColor = 0;
  if ( beat.isKick() ) backColor = backColor + color(255,0,0); //kickSize = 32;
  if ( beat.isSnare() ) backColor = backColor + color(255,0,100); // snareSize = 32;
  if ( beat.isHat() ) backColor = backColor + color(0,255,0); //hatSize = 32;

  background( backColor );
  fill(255);

  textSize(kickSize);
  text("KICK", width/4, height/2);
  textSize(snareSize);
  text("SNARE", width/2, height/2);
  textSize(hatSize);
  text("HAT", 3*width/4, height/2);
  kickSize = constrain(kickSize * 0.95, 16, 32);
  snareSize = constrain(snareSize * 0.95, 16, 32);
  hatSize = constrain(hatSize * 0.95, 16, 32);

  textFont(createFont("SanSerif", 16));
  textAlign(CENTER);

}

void updateBlink1() {

    //blink1.fadeToRGB( 100, rn, gn, bn );

}

void stop()
{
  // always close Minim audio classes when you are finished with them
  in.close();
  // always stop Minim before exiting
  minim.stop();
  // this closes the sketch
  super.stop();
}


