CON
  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

OBJ
  pwmOut       : "PwmPortOut03"
  midiIn       : "MidiIn03"
  sensorIn     : "MidiIn03"

PUB start | i, dummy, phase, mode, value
  pwmOut.start
  pwmOut.speed_set(0)
  midiIn.start(24)
  sensorIn.start(25)
  LED_all_off
  phase := 0
  repeat
    dummy := sensorIn.event
    if dummy <> -1
      if phase == 0
        if (dummy & $F00000) == $D00000
          mode := (dummy & $0F0000) >> 16 + 100
          value := dummy & $7F
          if value < 26
            value := 0
          elseif value < 35
            value := 1
          elseif value < 44
            value := 2
          elseif value < 53
            value := 4
          elseif value < 62
            value := 8
          elseif value < 71
            value := 16
          elseif value < 80
            value := 32
          elseif value < 89
            value := 64
          else
            value := 127
          LED_control(mode, value)
    dummy := midiIn.event
    if dummy <> -1
      if (dummy & $FF0000) == $AF0000
        phase := 1
        mode := (dummy & $7F00) >> 8
        value := dummy & $7F
        if mode == 26           ' AF 26 dd ---> stand-alone mode
          phase := 0
        else
          LED_control(mode, value)

PUB LED_control(mode,value) | i
  if mode < 24                  ' AF nn dd ---> each LED (nn=0-23) value(0-127)
    LED_data_set(mode, value)
    return
  elseif mode > 99
    if mode < 106
      mode := (mode-100) << 2
      repeat i from 0 to 3
        LED_data_set(mode+i, value)
      return
    case mode
      106:
      107:
      108:
      109:
        return
  case mode
    24:                         ' AF 24 dd ---> all LED value(0-127)
      repeat i from 0 to 23
        LED_data_set(i, value)
      return
    25:
      pwmOut.speed_set(value)   ' AF 25 dd ---> PWM speed (0-6)
      return

PUB LED_all_off | i
  repeat i from 0 to 23
    LED_data_set(i, 0)

PUB LED_data_set(address, data)
  pwmOut.buffer_set(address<<8 + data)

PUB pause1ms(period)
  waitcnt(80_000 * period + cnt)

