VAR
  long rx_Head, rx_Tail, rx_Buff[64]

PUB start(_midiPin) : status
  midiPin := _midiPin
  rx_top := @rx_Head
  rx_end := @rx_Tail
  rx_fifo := @rx_Buff
  bitticks := clkfreq / 31_250
  halfticks := bitticks / 2  
  longfill(@rx_Head,0,66)
  status := cognew(@asm_entry, 0)

PUB event : status
  status := -1
  if rx_Tail <> rx_Head
    status := rx_Buff[rx_Tail]
    rx_Tail := (rx_Tail + 1) & $3F
    
DAT
                        org
asm_entry
                        mov     midiMask,#1
                        shl     midiMask,midiPin
getMidiByte
                        waitpeq midiMask,midiMask
                        mov     bitClk,cnt
                        add     bitClk,halfticks       
                        add     bitClk,bitticks
                        mov     testBits,#9                         
:check_loop
                        waitcnt bitClk,bitticks
                        test    midiMask,ina            wc
                        rcr     rx_data,#1
                        djnz    testBits,#:check_loop
                        shr     rx_data,#32-9
                        xor     rx_data,#$FF
                        and     rx_data,#$FF
                        test    rx_data,#%10000000      wz
              if_z      jmp     #:running
                        mov     t1,rx_data
                        and     t1,#%11110000
                        cmp     t1,#%11110000           wz
              if_z      jmp     #getMidiByte
                        mov     rsb,rx_data
                        mov     dcb,#0
                        jmp     #getMidiByte
:running
                        mov     t1,rsb
                        and     t1,#%11100000
                        cmp     t1,#%11000000           wz
              if_z      jmp     #:byte_2
                        tjnz    dcb,#:byte_3
                        add     dcb,#1
                        mov     keyno,rx_data
                        jmp     #getMidiByte
:byte_2 
                        mov     event_data,rsb
                        shl     event_data,#16                                      
                        or      event_data,rx_data
                        jmp     #:write_event
:byte_3 
                        mov     dcb,#0
                        mov     event_data,rsb
                        shl     event_data,#16                                      
                        mov     t1,keyno
                        shl     t1,#8
                        or      event_data,t1
                        or      event_data,rx_data
:write_event
                        rdlong  t1,rx_top
                        mov     rx_pointer,t1
                        shl     rx_pointer,#2
                        add     rx_pointer,rx_fifo
                        wrlong  event_data,rx_pointer
                        add     t1,#1
                        and     t1,#$3F
                        wrlong  t1,rx_top
                        jmp     #getMidiByte

t1                      long    0
midiMask                long    0
testBits                long    0
bitClk                  long    0
bitticks                long    0
halfticks               long    0
midiPin                 long    0
rx_top                  long    0
rx_end                  long    0
rx_fifo                 long    0
rx_data                 long    0
rx_pointer              long    0
event_data              long    0
rsb                     long    0
dcb                     long    0
keyno                   long    0

                        fit
