CON
  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

OBJ
  midiOut       : "MidiOut01"
  serialOut     : "SRF02_Out01"
  serialIn      : "SRF02_In01"

PUB start | i, num_max, rx_data, old_data[10]
  midiOut.start(26)
  serialIn.start(14)
  serialOut.start(15)
  num_max := 6
  repeat
    repeat i from 1 to num_max
      pause1ms(1)
      rx_data := rx_SF02(i)
      if rx_data < 3700
        rx_data := 127 - ((rx_data>>5) & %01111111)
        if rx_data > 105
          rx_data := 0
        if rx_data <> old_data[i-1]
          old_data[i-1] := rx_data
          midiOut.fifoset(($D0+i-1)<<16 + rx_data)

PUB rx_SF02(channel) | mode, dummy, rx_data
  serialOut.fifoset(channel)
  serialOut.fifoset($55)
  mode := 0
  repeat
    if mode == 1
      dummy := serialIn.event
      if dummy <> -1
        rx_data := rx_data + dummy
        return(rx_data)
    elseif mode == 0
      dummy := serialIn.event
      if dummy <> -1
        rx_data := dummy << 8
        mode := 1

PUB pause1ms(period)
  waitcnt(80_000 * period + cnt)

