#include "MIDIUSB.h"

int timer0;
int timer1[5] = { 0, 7, 14, 21, 28 };
int timer2[5], motor_phase[5], motor_speed[5], motor_mode[5], motor_direction[5];
int motor_bit[5][4] = { {0,1,2,3},{4,5,6,7},{8,9,10,11},{12,13,A0,A1},{A2,A3,A4,A5} };
int LED_speed = 500;

void setup() {
  int i,j;
  Serial.begin(115200);
  pinMode(LED_BUILTIN, OUTPUT);
  for(i=0; i<5; i++){
    for(j=0; j<4; j++){
      pinMode(motor_bit[i][j], OUTPUT);
    }
    timer1[0] = 0;
    motor_mode[i] = 0;
    motor_speed[i] = 50;
  }
  timer0 = 0;
  motor_go(i);
}

void loop() {
  int i;
  midiEventPacket_t rx;
  rx = MidiUSB.read();
  if (rx.header != 0) {
    if (rx.byte1 == 0xB0){
      switch(rx.byte2){
        case 10:
          LED_speed = 100 + 10 * rx.byte3;
          break;
        case 0:
          motor_speed[0] = 10 + 2 * rx.byte3;
          break;
        case 1:
          motor_mode[0] = rx.byte3;
          break;
        case 2:
          motor_speed[1] = 10 + 2 * rx.byte3;
          break;
        case 3:
          motor_mode[1] = rx.byte3;
          break;
        case 4:
          motor_speed[2] = 10 + 2 * rx.byte3;
          break;
        case 5:
          motor_mode[2] = rx.byte3;
          break;
        case 6:
          motor_speed[3] = 10 + 2 * rx.byte3;
          break;
        case 7:
          motor_mode[3] = rx.byte3;
          break;
        case 8:
          motor_speed[4] = 10 + 2 * rx.byte3;
          break;
        case 9:
          motor_mode[4] = rx.byte3;
          break;
      }
    }
  }
  if (++timer0 > 101){
    timer0 = 0;
    builtin_led();
  }
  for(i=0; i<5; i++){
    if (++timer1[i] > 37){
      timer1[i] = 0;
      motor_go(i);
    }
  }
}

void motor_go(int i){
  timer2[i]++;
  if (timer2[i] < motor_speed[i]) return;
  timer2[i] = 0;
  switch(motor_mode[i]){
    case 0:
      motor_off(i);
      return;
    case 1:
      return;
    case 2:
      motor_direction[i] = 1;
      motor_mode_2phase(i);
      break;
    case 3:
      motor_direction[i] = 3;
      motor_mode_2phase(i);
      break;
  }
  motor_phase[i] = (motor_phase[i] + motor_direction[i]) & 3;
  return;
}

void motor_off(int i){
  digitalWrite(motor_bit[i][0], LOW);
  digitalWrite(motor_bit[i][1], LOW);
  digitalWrite(motor_bit[i][2], LOW);
  digitalWrite(motor_bit[i][3], LOW);
}

void motor_mode_2phase(int i){
  switch(motor_phase[i]){
    case 0:
      digitalWrite(motor_bit[i][0], LOW);
      digitalWrite(motor_bit[i][1], HIGH);
      digitalWrite(motor_bit[i][2], LOW);
      digitalWrite(motor_bit[i][3], HIGH);
      break;
    case 1:
      digitalWrite(motor_bit[i][0], LOW);
      digitalWrite(motor_bit[i][1], HIGH);
      digitalWrite(motor_bit[i][2], HIGH);
      digitalWrite(motor_bit[i][3], LOW);
      break;
    case 2:
      digitalWrite(motor_bit[i][0], HIGH);
      digitalWrite(motor_bit[i][1], LOW);
      digitalWrite(motor_bit[i][2], HIGH);
      digitalWrite(motor_bit[i][3], LOW);
      break;
    case 3:
      digitalWrite(motor_bit[i][0], HIGH);
      digitalWrite(motor_bit[i][1], LOW);
      digitalWrite(motor_bit[i][2], LOW);
      digitalWrite(motor_bit[i][3], HIGH);
      break;   
  }
  return;
}

void builtin_led(){
  static int timer, flag;
  timer++;
  if (timer > LED_speed){
    timer = 0;
    flag = ++flag & 1;
    digitalWrite(LED_BUILTIN, flag);
  }
}

