import de.voidplus.myo.*;
import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myBroadcastLocation;
Myo myo;
ArrayList<ArrayList<Integer>> sensors;

int received_0 = 0;
int received_1 = 0;
int xx;

void setup() {
  size(100, 100);
  background(255);
  noFill();    
  oscP5 = new OscP5(this,8000);
  myBroadcastLocation = new NetAddress("127.0.0.1",7000);
  myo = new Myo(this);
  myo.withEmg();
  sensors = new ArrayList<ArrayList<Integer>>();
  for(int i=0; i<8; i++){
    sensors.add(new ArrayList<Integer>()); 
  }
}

void draw() {
  background(255);  
  OscMessage myOscMessage = new OscMessage("Myo");
  synchronized (this){
    for(int i=0; i<8; i++){
      if(!sensors.get(i).isEmpty()){
        for(int j=0; j<sensors.get(i).size(); j++){
          xx = sensors.get(i).get(j)+(i*50);
        }
      } 
      myOscMessage.add(xx);
    }
  }
  oscP5.send(myOscMessage, myBroadcastLocation);
}

void oscEvent(OscMessage theOscMessage) {
  received_0 = theOscMessage.get(0).intValue();
  received_1 = theOscMessage.get(1).intValue();
}

void myoOnEmg(Myo myo, long timestamp, int[] data) {  
  synchronized (this){
    for(int i = 0; i<data.length; i++){
      sensors.get(i).add((int) map(data[i], -128, 127, 0, 50)); // [-128 - 127]
    }
    while(sensors.get(0).size() > width){
      for(ArrayList<Integer> sensor : sensors){
        sensor.remove(0);
      }
    }
  }
}

