import de.voidplus.myo.*;
import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myBroadcastLocation;
Myo myo;
int received_0 = 0;
int received_1 = 0;

void setup() {
  myo = new Myo(this);
  myo.withEmg();
  oscP5 = new OscP5(this,8000);
  myBroadcastLocation = new NetAddress("127.0.0.1",7000);
}

void draw() {
}

void oscEvent(OscMessage theOscMessage) {
  received_0 = theOscMessage.get(0).intValue();
  received_1 = theOscMessage.get(1).intValue();
  if (received_0 == 1) {
    myo.vibrate(1);
  }
}

void myoOn(Myo.Event event, Myo myo, long timestamp) {
  switch(event) {
    case EMG:
      OscMessage myOscMessage = new OscMessage("Myo");
      int[] data = myo.getEmg();
      for(int i = 0; i<data.length; i++){
        myOscMessage.add(data[i]);
      }
      oscP5.send(myOscMessage, myBroadcastLocation);
      break;
  }
}

