import de.voidplus.myo.*;
import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myBroadcastLocation;
Myo myo;
int received_0 = 0;
int received_1 = 0;

void setup() {
  myo = new Myo(this);
  myo.withEmg();
  oscP5 = new OscP5(this,8000);
  myBroadcastLocation = new NetAddress("127.0.0.1",7000);
}

void draw() {
}

void oscEvent(OscMessage theOscMessage) {
  received_0 = theOscMessage.get(0).intValue();
  received_1 = theOscMessage.get(1).intValue();
  if (received_0 == 1) {
    myo.vibrate(1);
  }
}

void myoOn(Myo.Event event, Myo myo, long timestamp) {
  switch(event) {
    case EMG:
      OscMessage myOscMessage1 = new OscMessage("EMG");
      int[] data1 = myo.getEmg();
      for(int i = 0; i<data1.length; i++){
        myOscMessage1.add(data1[i]);
      }
      oscP5.send(myOscMessage1, myBroadcastLocation);
      break;
    case GYROSCOPE:
      OscMessage myOscMessage2 = new OscMessage("Gyro");
      PVector data2 = myo.getGyroscope();
      myOscMessage2.add(data2.x/8.0);
      myOscMessage2.add(data2.y/8.0);
      myOscMessage2.add(data2.z/8.0);
      oscP5.send(myOscMessage2, myBroadcastLocation);
      break;
    case ACCELEROMETER:
      OscMessage myOscMessage3 = new OscMessage("Accel");
      PVector data3 = myo.getAccelerometer();
      myOscMessage3.add(data3.x*40);
      myOscMessage3.add(data3.y*40);
      myOscMessage3.add(data3.z*40);
      oscP5.send(myOscMessage3, myBroadcastLocation);
      break;
    case ORIENTATION:
      OscMessage myOscMessage4 = new OscMessage("Orient");
      PVector data4 = myo.getOrientation();
      myOscMessage4.add(data4.x*14);
      myOscMessage4.add(data4.y*14);
      myOscMessage4.add(data4.z*14);
      oscP5.send(myOscMessage4, myBroadcastLocation);
      break;
  }
}

