/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.myo;

import com.thalmic.myo.DeviceListener;
import com.thalmic.myo.FirmwareVersion;
import com.thalmic.myo.Pose;
import com.thalmic.myo.Quaternion;
import com.thalmic.myo.Vector3;
import com.thalmic.myo.enums.PoseType;
import com.thalmic.myo.enums.XDirection;
import de.voidplus.myo.Arm;
import de.voidplus.myo.Myo;
import de.voidplus.myo.Pose;
import processing.core.PVector;

public class Collector
implements DeviceListener {
    private Myo myo;
    private static final int SCALE = 18;

    public Collector(Myo myo) {
        this.myo = myo;
    }

    private void dispatchGlobalEvent(Myo.Event event, Myo myo, long timestamp, int logLevel) {
        this.myo.dispatch(new Class[]{((Object)((Object)event)).getClass(), myo.getClass(), Long.TYPE}, new Object[]{event, this.myo, timestamp}, logLevel);
    }

    private void dispatchGlobalEvent(Myo.Event event, Myo myo, long timestamp) {
        this.dispatchGlobalEvent(event, myo, timestamp, 1);
    }

    private void dispatchLocalEvent(String method, Class[] classes, Object[] objects, int logLevel) {
        this.myo.dispatch(method, classes, objects, logLevel);
    }

    private void dispatchLocalEvent(String method, Class[] classes, Object[] objects) {
        this.dispatchLocalEvent(method, classes, objects, 1);
    }

    public void onPair(com.thalmic.myo.Myo myo, long timestamp, FirmwareVersion firmwareVersion) {
        this.myo.setFirmware(firmwareVersion);
        if (this.myo.withEmg) {
            if (this.myo.emg != null) {
                int i = 0;
                while (i < this.myo.emg.length) {
                    this.myo.emg[i] = 0;
                    ++i;
                }
            } else {
                this.myo.emg = new int[8];
            }
        }
        this.dispatchLocalEvent("myoOnPair", new Class[]{Myo.class, this.myo.getClass(), Long.TYPE, String.class}, new Object[]{this.myo, timestamp, this.myo.getFirmware()});
        this.dispatchGlobalEvent(Myo.Event.PAIR, this.myo, timestamp);
    }

    public void onUnpair(com.thalmic.myo.Myo myo, long timestamp) {
        this.dispatchLocalEvent("myoOnUnpair", new Class[]{this.myo.getClass(), Long.TYPE}, new Object[]{this.myo, timestamp});
        this.dispatchGlobalEvent(Myo.Event.UNPAIR, this.myo, timestamp);
    }

    public void onConnect(com.thalmic.myo.Myo myo, long timestamp, FirmwareVersion firmwareVersion) {
        this.myo.setFirmware(firmwareVersion);
        this.dispatchLocalEvent("myoOnConnect", new Class[]{this.myo.getClass(), Long.TYPE, String.class}, new Object[]{this.myo, timestamp, this.myo.getFirmware()});
        this.dispatchGlobalEvent(Myo.Event.CONNECT, this.myo, timestamp);
    }

    public void onDisconnect(com.thalmic.myo.Myo myo, long timestamp) {
        this.myo.setFirmware(null);
        this.dispatchLocalEvent("myoOnDisconnect", new Class[]{this.myo.getClass(), Long.TYPE}, new Object[]{this.myo, timestamp});
        this.dispatchGlobalEvent(Myo.Event.DISCONNECT, this.myo, timestamp);
    }

    public void onArmSync(com.thalmic.myo.Myo myo, long timestamp, com.thalmic.myo.enums.Arm arm, XDirection xDirection) {
        if (arm != com.thalmic.myo.enums.Arm.ARM_UNKNOWN && this.myo.arm.type.asRaw() != arm) {
            switch (arm) {
                case ARM_LEFT: {
                    this.myo.arm.type = Arm.Type.LEFT;
                    break;
                }
                case ARM_RIGHT: {
                    this.myo.arm.type = Arm.Type.RIGHT;
                    break;
                }
                case ARM_UNKNOWN: {
                    this.myo.arm.type = Arm.Type.UNKNOWN;
                }
            }
            this.dispatchLocalEvent("myoOnArmSync", new Class[]{this.myo.getClass(), Long.TYPE, Arm.class}, new Object[]{this.myo, timestamp, this.myo.arm}, 2);
            this.dispatchGlobalEvent(Myo.Event.ARM_SYNC, this.myo, timestamp);
        }
    }

    public void onArmUnsync(com.thalmic.myo.Myo myo, long timestamp) {
        this.myo.arm.type = Arm.Type.UNKNOWN;
        this.myo.pose.type = Pose.Type.UNKNOWN;
        this.dispatchLocalEvent("myoOnArmUnsync", new Class[]{this.myo.getClass(), Long.TYPE}, new Object[]{this.myo, timestamp});
        this.dispatchGlobalEvent(Myo.Event.ARM_UNSYNC, this.myo, timestamp);
    }

    public void onPose(com.thalmic.myo.Myo myo, long timestamp, Pose pose) {
        if (pose.getType() != PoseType.UNKNOWN) {
            boolean newPoseChanged;
            boolean bl = newPoseChanged = this.myo.pose.type.asRaw() != pose.getType();
            if (newPoseChanged) {
                switch (pose.getType()) {
                    case REST: {
                        this.myo.pose.type = Pose.Type.REST;
                        break;
                    }
                    case FIST: {
                        this.myo.pose.type = Pose.Type.FIST;
                        break;
                    }
                    case WAVE_IN: {
                        this.myo.pose.type = Pose.Type.WAVE_IN;
                        break;
                    }
                    case WAVE_OUT: {
                        this.myo.pose.type = Pose.Type.WAVE_OUT;
                        break;
                    }
                    case FINGERS_SPREAD: {
                        this.myo.pose.type = Pose.Type.FINGERS_SPREAD;
                        break;
                    }
                    case DOUBLE_TAP: {
                        this.myo.pose.type = Pose.Type.DOUBLE_TAP;
                    }
                }
                this.dispatchLocalEvent("myoOnPose", new Class[]{this.myo.getClass(), Long.TYPE, this.myo.pose.getClass()}, new Object[]{this.myo, timestamp, this.myo.pose}, 2);
            }
            this.dispatchGlobalEvent(Myo.Event.POSE, this.myo, timestamp, 2);
        }
    }

    public void onOrientationData(com.thalmic.myo.Myo myo, long timestamp, Quaternion rotation) {
        Quaternion normalized = rotation.normalized();
        double roll = Math.atan2(2.0 * (normalized.getW() * normalized.getX() + normalized.getY() * normalized.getZ()), 1.0 - 2.0 * (normalized.getX() * normalized.getX() + normalized.getY() * normalized.getY()));
        double pitch = Math.asin(2.0 * (normalized.getW() * normalized.getY() - normalized.getZ() * normalized.getX()));
        double yaw = Math.atan2(2.0 * (normalized.getW() * normalized.getZ() + normalized.getX() * normalized.getY()), 1.0 - 2.0 * (normalized.getY() * normalized.getY() + normalized.getZ() * normalized.getZ()));
        this.myo.orientation = new PVector((float)((roll + Math.PI) / (Math.PI * 2) * 18.0), (float)((pitch + 1.5707963267948966) / Math.PI * 18.0), (float)((yaw + Math.PI) / (Math.PI * 2) * 18.0));
        this.dispatchLocalEvent("myoOnOrientation", new Class[]{this.myo.getClass(), Long.TYPE, PVector.class}, new Object[]{this.myo, timestamp, this.myo.orientation}, 4);
        this.dispatchGlobalEvent(Myo.Event.ORIENTATION, this.myo, timestamp, 4);
    }

    public void onAccelerometerData(com.thalmic.myo.Myo myo, long timestamp, Vector3 accelerometer) {
        this.myo.accelerometer = new PVector((float)accelerometer.getX(), (float)accelerometer.getY(), (float)accelerometer.getZ());
        this.dispatchLocalEvent("myoOnAccelerometer", new Class[]{this.myo.getClass(), Long.TYPE, PVector.class}, new Object[]{this.myo, timestamp, this.myo.accelerometer}, 4);
        this.dispatchGlobalEvent(Myo.Event.ACCELEROMETER, this.myo, timestamp, 4);
    }

    public void onGyroscopeData(com.thalmic.myo.Myo myo, long timestamp, Vector3 gyroscope) {
        this.myo.gyroscope = new PVector((float)gyroscope.getX(), (float)gyroscope.getY(), (float)gyroscope.getZ());
        this.dispatchLocalEvent("myoOnGyroscope", new Class[]{this.myo.getClass(), Long.TYPE, PVector.class}, new Object[]{this.myo, timestamp, this.myo.gyroscope}, 4);
        this.dispatchGlobalEvent(Myo.Event.GYROSCOPE, this.myo, timestamp, 4);
    }

    public void onRssi(com.thalmic.myo.Myo myo, long timestamp, int rssi) {
        this.myo.rssi = rssi;
        this.dispatchLocalEvent("myoOnRssi", new Class[]{this.myo.getClass(), Long.TYPE, Integer.TYPE}, new Object[]{this.myo, timestamp, rssi}, 3);
        this.dispatchGlobalEvent(Myo.Event.RSSI, this.myo, timestamp, 3);
    }

    public void onLock(com.thalmic.myo.Myo myo, long timestamp) {
        this.dispatchLocalEvent("myoOnLock", new Class[]{this.myo.getClass(), Long.TYPE}, new Object[]{this.myo, timestamp}, 3);
        this.dispatchGlobalEvent(Myo.Event.LOCK, this.myo, timestamp, 3);
    }

    public void onUnlock(com.thalmic.myo.Myo arg0, long timestamp) {
        this.dispatchLocalEvent("myoOnUnLock", new Class[]{this.myo.getClass(), Long.TYPE}, new Object[]{this.myo, timestamp}, 3);
        this.dispatchGlobalEvent(Myo.Event.UNLOCK, this.myo, timestamp, 3);
    }

    public void onEmgData(com.thalmic.myo.Myo myo, long timestamp, byte[] data) {
        if (this.myo.withEmg && data != null) {
            int i = 0;
            while (i < 8) {
                this.myo.emg[i] = data[i];
                ++i;
            }
            this.dispatchLocalEvent("myoOnEmg", new Class[]{this.myo.getClass(), Long.TYPE, int[].class}, new Object[]{this.myo, timestamp, this.myo.emg}, 4);
            this.dispatchGlobalEvent(Myo.Event.EMG, this.myo, timestamp, 4);
        }
    }
}

