/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.myo;

import com.thalmic.myo.DeviceListener;
import com.thalmic.myo.FirmwareVersion;
import com.thalmic.myo.Hub;
import com.thalmic.myo.enums.StreamEmgType;
import com.thalmic.myo.enums.UnlockType;
import com.thalmic.myo.enums.VibrationType;
import de.voidplus.myo.Arm;
import de.voidplus.myo.Collector;
import de.voidplus.myo.Pose;
import java.io.File;
import processing.core.PApplet;
import processing.core.PVector;

public class Myo {
    private PApplet parent;
    private boolean verbose;
    private int verboseLevel;
    private com.thalmic.myo.Myo myo;
    private Hub hub;
    private Collector collector;
    private int frequency;
    private String firmware;
    protected Arm arm;
    protected Pose pose;
    protected LockingPolicy lockingPolicy;
    protected PVector orientation;
    protected PVector accelerometer;
    protected PVector gyroscope;
    protected int rssi;
    protected int[] emg;
    protected boolean withEmg;
    private static final String NAME = "Myo";
    private static final String VERSION = "0.8.2.1";
    private static final String MYO_SDK_VERSION = "0.8.1";
    private static final String MYO_FIRMWARE_VERSION = "1.1.755";
    private static final String MYO_FIRMWARE_VERSION_ALPHA = "1.1.5";
    private static final String REPOSITORY = "https://github.com/nok/myo-processing";

    public Myo(PApplet parent) {
        PApplet.println((String)"# Myo v0.8.2.1 - Support: Myo SDK v0.8.1, Firmware v1.1.755, Alpha Firmware v1.1.5 - https://github.com/nok/myo-processing");
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            try {
                String framework = String.valueOf(new File(Myo.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().toString()) + File.separator + "macosx" + File.separator + "myo.framework";
                System.setProperty("java.library.path", framework);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        parent.registerMethod("pre", (Object)this);
        parent.registerMethod("dispose", (Object)this);
        this.parent = parent;
        this.setVerbose(false).setVerboseLevel(1).setFrequency(30);
        this.hub = new Hub();
        this.myo = this.hub.waitForMyo(10000);
        if (this.myo == null) {
            throw new RuntimeException("Unable to find a Myo!");
        }
        this.log("Connected to a Myo armband.");
        if (this.myo != null) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        Myo.this.hub.run(Myo.this.frequency);
                    }
                }
            }.start();
        }
        this.collector = new Collector(this);
        this.hub.addListener((DeviceListener)this.collector);
        this.withEmg = false;
        this.arm = new Arm();
        this.pose = new Pose();
        this.setLockingPolicy(LockingPolicy.STANDARD);
        this.orientation = new PVector();
        this.accelerometer = new PVector();
        this.gyroscope = new PVector();
    }

    public void pre() {
        if (this.myo != null) {
            this.hub.runOnce(this.frequency);
        }
    }

    public void dispose() {
        if (this.myo != null) {
            this.hub.removeListener((DeviceListener)this.collector);
        }
    }

    public com.thalmic.myo.Myo getRawMyo() {
        return this.myo;
    }

    public Hub getRawHub() {
        return this.hub;
    }

    protected void dispatch(Object object, String method, Class[] classes, Object[] objects, int logLevel) {
        boolean success = false;
        if (method == null) {
            method = "myoOn";
        }
        if (classes.length == objects.length) {
            try {
                try {
                    object.getClass().getMethod(method, classes).invoke((Object)this.parent, objects);
                    success = true;
                }
                catch (Exception exception) {
                    if (success) {
                        this.log("Method: " + method + "(...); has been called.", logLevel);
                    }
                }
            }
            finally {
                if (success) {
                    this.log("Method: " + method + "(...); has been called.", logLevel);
                }
            }
        }
    }

    protected void dispatch(String method, Class[] classes, Object[] objects, int logLevel) {
        this.dispatch(this.parent, method, classes, objects, logLevel);
    }

    protected void dispatch(String method, Class[] classes, Object[] objects) {
        this.dispatch(this.parent, method, classes, objects, 1);
    }

    protected void dispatch(Class[] classes, Object[] objects, int logLevel) {
        this.dispatch(this.parent, null, classes, objects, logLevel);
    }

    protected void dispatch(Class[] classes, Object[] objects) {
        this.dispatch(this.parent, null, classes, objects, 1);
    }

    public Myo vibrate(int level) {
        switch (level) {
            case 1: {
                this.log("Vibrating short ...");
                this.myo.vibrate(VibrationType.VIBRATION_SHORT);
            }
            case 2: {
                this.log("Vibrating medium ...");
                this.myo.vibrate(VibrationType.VIBRATION_MEDIUM);
            }
            case 3: {
                this.log("Vibrating long ...");
                this.myo.vibrate(VibrationType.VIBRATION_LONG);
            }
        }
        return this;
    }

    public Myo vibrate() {
        return this.vibrate(2);
    }

    public Myo lock() {
        this.myo.lock();
        return this;
    }

    public Myo unlock(Unlock mode) {
        switch (mode) {
            case HOLD: {
                this.myo.unlock(UnlockType.UNLOCK_HOLD);
                break;
            }
            default: {
                this.myo.unlock(UnlockType.UNLOCK_TIMED);
            }
        }
        return this;
    }

    public Myo setLockingPolicy(LockingPolicy policy) {
        switch (policy) {
            case NONE: {
                this.hub.setLockingPolicy(com.thalmic.myo.enums.LockingPolicy.LOCKING_POLICY_NONE);
                break;
            }
            default: {
                this.hub.setLockingPolicy(com.thalmic.myo.enums.LockingPolicy.LOCKING_POLICY_STANDARD);
            }
        }
        return this;
    }

    public Myo withEmg() {
        this.emg = new int[8];
        this.myo.setStreamEmg(StreamEmgType.STREAM_EMG_ENABLED);
        this.withEmg = true;
        return this;
    }

    public Myo withoutEmg() {
        this.myo.setStreamEmg(StreamEmgType.STREAM_EMG_DISABLED);
        this.withEmg = false;
        return this;
    }

    public int[] getEmg() {
        return this.emg;
    }

    public Myo setFrequency(int frequency) {
        this.frequency = frequency;
        return this;
    }

    protected Myo setFirmware(FirmwareVersion firmwareVersion) {
        this.firmware = firmwareVersion == null ? "" : String.valueOf(firmwareVersion.getFirmwareVersionMajor()) + "." + firmwareVersion.getFirmwareVersionMinor() + "." + firmwareVersion.getFirmwareVersionPath();
        return this;
    }

    public String getFirmware() {
        if (this.firmware == null) {
            return "";
        }
        return this.firmware;
    }

    public String getPose() {
        return this.pose.getType().toString().toUpperCase();
    }

    public String getArm() {
        return this.arm.getType().toString().toUpperCase();
    }

    public boolean hasArm() {
        return this.arm.hasArm();
    }

    public Boolean isArmLeft() {
        return this.arm.isLeft();
    }

    public Boolean isArmRight() {
        return this.isArmLeft() == false;
    }

    public PVector getOrientation() {
        return this.orientation;
    }

    public PVector getAccelerometer() {
        return this.accelerometer;
    }

    public PVector getGyroscope() {
        return this.gyroscope;
    }

    public Myo setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Myo setVerboseLevel(int level) {
        this.verboseLevel = level > 0 && level < 4 ? level : 1;
        return this;
    }

    protected Myo log(String message, int verboseLevel) {
        if (this.verbose && verboseLevel <= this.verboseLevel) {
            PApplet.println((String)("# Myo: LOG (" + verboseLevel + "): " + message));
        }
        return this;
    }

    protected Myo log(String message) {
        return this.log(message, 1);
    }

    public static enum Event {
        PAIR,
        UNPAIR,
        CONNECT,
        DISCONNECT,
        ARM_SYNC,
        ARM_UNSYNC,
        POSE,
        ORIENTATION,
        ACCELEROMETER,
        GYROSCOPE,
        RSSI,
        EMG,
        LOCK,
        UNLOCK;

    }

    public static enum LockingPolicy {
        NONE,
        STANDARD;

    }

    public static enum Unlock {
        HOLD,
        TIMED;

    }
}

