/*
 * Decompiled with CFR 0.152.
 */
package development;

import de.voidplus.myo.Arm;
import de.voidplus.myo.Myo;
import de.voidplus.myo.Pose;
import processing.core.PApplet;

public class Sketch
extends PApplet {
    private static final long serialVersionUID = 6021680985562939964L;
    Myo myo;

    public void setup() {
        this.size(100, 100, "processing.opengl.PGraphics3D");
        this.background(250);
        this.myo = new Myo(this);
        this.myo.setVerbose(true);
        this.myo.setVerboseLevel(4);
        this.myo.setLockingPolicy(Myo.LockingPolicy.STANDARD);
        this.myo.unlock(Myo.Unlock.TIMED);
    }

    public void draw() {
        this.background(250);
    }

    public void myoOn(Myo.Event EVENT, Myo myo, long timestamp) {
        switch (EVENT) {
            case PAIR: {
                break;
            }
            case UNPAIR: {
                break;
            }
            case CONNECT: {
                break;
            }
            case DISCONNECT: {
                break;
            }
            case ARM_SYNC: {
                break;
            }
            case ARM_UNSYNC: {
                break;
            }
            case POSE: {
                break;
            }
            case ORIENTATION: {
                break;
            }
            case ACCELEROMETER: {
                break;
            }
            case GYROSCOPE: {
                break;
            }
        }
    }

    public void myoOnPair(Myo myo, long timestamp, String firmware) {
        PApplet.println((String)"Sketch: myoOnPair");
    }

    public void myoOnUnpair(Myo myo, long timestamp) {
        PApplet.println((String)"Sketch: myoOnUnpair");
    }

    public void myoOnConnect(Myo myo, long timestamp, String firmware) {
        PApplet.println((String)"Sketch: myoOnConnect");
    }

    public void myoOnDisconnect(Myo myo, long timestamp) {
        PApplet.println((String)"Sketch: myoOnDisconnect");
    }

    public void myoOnArmSync(Myo myo, long timestamp, Arm arm) {
        PApplet.println((String)"Sketch: myoOnArmSync");
        switch (arm.getType()) {
            case LEFT: {
                PApplet.println((String)"Left arm.");
                break;
            }
            case RIGHT: {
                PApplet.println((String)"Right arm.");
            }
        }
        if (myo.hasArm()) {
            if (myo.isArmLeft().booleanValue()) {
                PApplet.println((String)"Left arm.");
            } else {
                PApplet.println((String)"Right arm.");
            }
        }
    }

    public void myoOnLock(Myo myo, long timestamp) {
        PApplet.println((String)"Sketch: myoOnLock");
    }

    public void myoOnUnLock(Myo myo, long timestamp) {
        PApplet.println((String)"Sketch: myoOnUnLock");
    }

    public void myoOnArmUnsync(Myo myo, long timestamp) {
        PApplet.println((String)"Sketch: myoOnArmUnsync");
    }

    public void myoOnPose(Myo myo, long timestamp, Pose pose) {
        switch (pose.getType()) {
            case REST: {
                break;
            }
            case FIST: {
                myo.vibrate();
                break;
            }
            case FINGERS_SPREAD: {
                break;
            }
            case DOUBLE_TAP: {
                break;
            }
            case WAVE_IN: {
                break;
            }
            case WAVE_OUT: {
                break;
            }
        }
    }

    public void myoOnRssi(Myo myo, long timestamp, int rssi) {
        PApplet.println((String)"Sketch: myoOnRssi");
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"development.Sketch"});
    }
}

