/*
 * Decompiled with CFR 0.152.
 */
package com.thalmic.myo;

import com.thalmic.myo.Vector3;

public final class Quaternion {
    private final double x;
    private final double y;
    private final double z;
    private final double w;

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion(Quaternion quaternion) {
        this(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    private Quaternion(float x, float y, float z, float w) {
        this((double)x, (double)y, (double)z, (double)w);
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public final Quaternion multiply(Quaternion rhs) {
        return new Quaternion(this.getW() * rhs.getX() + this.getX() * rhs.getW() + this.getY() * rhs.getZ() - this.getZ() * rhs.getY(), this.getW() * rhs.getY() - this.getX() * rhs.getZ() + this.getY() * rhs.getW() + this.getZ() * rhs.getX(), this.getW() * rhs.getZ() + this.getX() * rhs.getY() - this.getY() * rhs.getX() + this.getZ() * rhs.getW(), this.getW() * rhs.getW() - this.getX() * rhs.getX() - this.getY() * rhs.getY() - this.getZ() * rhs.getZ());
    }

    public final Quaternion normalized() {
        double norm = Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0) + Math.pow(this.w, 2.0));
        return new Quaternion(this.x / norm, this.y / norm, this.z / norm, this.w / norm);
    }

    public final Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    public static Quaternion fromAxisAngle(Vector3 axis, double angle) {
        return new Quaternion(axis.getX() * Math.sin(angle / 2.0), axis.getY() * Math.sin(angle / 2.0), axis.getZ() * Math.sin(angle / 2.0), Math.cos(angle / 2.0));
    }

    public static Quaternion rotate(Vector3 from, Vector3 to) {
        double cosTheta = from.dot(to);
        if (cosTheta >= 1.0) {
            return new Quaternion();
        }
        double k = Math.sqrt(from.dot(from) * to.dot(to));
        if (k <= 0.0) {
            return new Quaternion();
        }
        Vector3 cross = from.cross(to);
        if (cosTheta / k <= -1.0) {
            Vector3 xAxis = new Vector3(1.0, 0.0, 0.0);
            Vector3 yAxis = new Vector3(0.0, 1.0, 0.0);
            cross = from.cross(Math.abs(from.dot(xAxis)) < 1.0 ? xAxis : yAxis);
            cosTheta = 0.0;
            k = 0.0;
        }
        return new Quaternion(cross.getX(), cross.getY(), cross.getZ(), k + cosTheta);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quaternion other = (Quaternion)obj;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Quaternion [x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + "]";
    }
}

