/*
 * Decompiled with CFR 0.152.
 */
package com.thalmic.myo;

import com.thalmic.myo.Quaternion;

public class Vector3 {
    private final double x;
    private final double y;
    private final double z;

    public Vector3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3(Vector3 vector) {
        this(vector.x, vector.y, vector.z);
    }

    private Vector3(float x, float y, float z) {
        this((double)x, (double)y, (double)z);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3 normalized() {
        double normal = this.magnitude();
        return new Vector3(this.x / normal, this.y / normal, this.z / normal);
    }

    public double dot(Vector3 rightHandSide) {
        return this.x * rightHandSide.x + this.y * rightHandSide.y + this.z * rightHandSide.z;
    }

    public Vector3 cross(Vector3 rightHandSide) {
        return new Vector3(this.x * rightHandSide.z - this.z * rightHandSide.y, this.z * rightHandSide.x - this.x * rightHandSide.z, this.x * rightHandSide.y - this.y * rightHandSide.x);
    }

    public double angleTo(Vector3 rightHandSide) {
        return Math.acos(this.dot(rightHandSide) / (this.magnitude() * rightHandSide.magnitude()));
    }

    public static Vector3 rotate(Quaternion quat, Vector3 vec) {
        Quaternion qvec = new Quaternion(vec.getX(), vec.getY(), vec.getZ(), 0.0);
        Quaternion result = quat.multiply(qvec).multiply(quat.conjugate());
        return new Vector3(result.getX(), result.getY(), result.getZ());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Vector3 [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

