/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.TcpClient;
import netP5.TcpPacket;

public class NetMessage {
    private InetAddress _myInetAddress;
    private int _myPort;
    private String _myString = "";
    private byte[] _myData = new byte[0];
    private TcpClient _myTcpClient;
    private boolean isDatagramPacket = false;
    private int _myProtocol;
    private DatagramPacket _myDatagramPacket;
    private TcpPacket _myTcpPacket;

    protected NetMessage(DatagramPacket datagramPacket) {
        this._myDatagramPacket = datagramPacket;
        this._myInetAddress = datagramPacket.getAddress();
        this._myPort = datagramPacket.getPort();
        this._myData = datagramPacket.getData();
        this._myProtocol = 0;
        this.isDatagramPacket = true;
    }

    protected NetMessage(TcpPacket tcpPacket) {
        this._myTcpPacket = tcpPacket;
        this._myInetAddress = tcpPacket.getTcpConnection().socket().getInetAddress();
        this._myPort = tcpPacket.getTcpConnection().socket().getPort();
        this._myString = tcpPacket.getTcpConnection().getString();
        this._myData = tcpPacket.getData();
        this._myProtocol = 2;
        this._myTcpClient = tcpPacket.getTcpConnection();
    }

    public TcpPacket getTcpPacket() {
        return this._myTcpPacket;
    }

    public DatagramPacket getDatagramPacket() {
        return this._myDatagramPacket;
    }

    protected void setProtocol(int n) {
        this._myProtocol = n;
    }

    public byte[] getData() {
        return this._myData;
    }

    public String getString() {
        if (this.isDatagramPacket) {
            return new String(this._myData);
        }
        return this._myString;
    }

    public int protocol() {
        return this._myProtocol;
    }

    public int port() {
        return this._myPort;
    }

    public TcpClient tcpConnection() {
        return this._myTcpClient;
    }

    public String address() {
        return this._myInetAddress.getHostAddress();
    }

    public InetAddress inetAddress() {
        return this._myInetAddress;
    }
}

