long previousMillis = 0;
int interval = 500;
int mode = 0;

void setup() {
   for (int i=0; i <= 13; i++){
      pinMode(i, OUTPUT);    
   }
   digitalWrite(0, HIGH);
   digitalWrite(13, HIGH);
   port_initial();
}

void loop() {
  unsigned long currentMillis = millis(); 
  if(currentMillis - previousMillis > interval) {
    previousMillis = currentMillis;  
    mode = (mode+1) & 7;
    switch(mode){
      case 0:
        port_initial();
        break;
      case 1:
        for (int i=0; i < 8; i++){
          port_data_out(i, 255);    
        }
        break;
      case 2:
        port_initial();
        break;
      case 3:
        for (int i=0; i < 8; i++){
          port_data_out(i, B01010101);    
        }
        break;
      case 4:
        for (int i=0; i < 8; i++){
          port_data_out(i, B10101010);    
        }
        break;
      case 5:
        port_initial();
        break;
      case 6:
        for (int i=0; i < 4; i++){
          port_data_out(i*2, B01010101);    
          port_data_out(i*2+1, B10101010);    
        }
        break;
      case 7:
        for (int i=0; i < 8; i++){
          port_data_out(i, 1 << i);    
        }
        break;
    }
  }
}

void port_initial() {
  for (int i=0; i < 8; i++){
    port_data_out(i, 0);    
  }
}

void port_data_out(int port, int data){
  for (int i=0; i < 8; i++){
    digitalWrite(i+2, (data >> i) & 1);
  }
  for (int i=0; i < 3; i++){
    digitalWrite(i+10, (port >> i) & 1);
  }
   digitalWrite(13, LOW);
   digitalWrite(13, HIGH);
}

