long previousMillis = 0;
int interval = 10;
int phase = 0;

void setup() {
  Serial.begin(31250);
  for (int i=0; i <= 13; i++){
    pinMode(i, OUTPUT);    
  }
  digitalWrite(0, HIGH);
  digitalWrite(13, HIGH);
}

void loop() {
  unsigned long currentMillis = millis();
  int dd;
  if(currentMillis - previousMillis > interval) {
    previousMillis = currentMillis;  
    phase = (++phase) & 7;
    switch (phase) {
      case 0:
        dd = analogRead(A0);
        port_data_out(0, dd/4);
        pgmOut(0xc0, dd/8);
        break;
      case 1:
        dd = analogRead(A1);
        port_data_out(1, dd/4);
        pgmOut(0xc1, dd/8);
        break;
      case 2:
        dd = analogRead(A2);
        port_data_out(2, dd/4);
        pgmOut(0xc2, dd/8);
        break;
      case 3:
        dd = analogRead(A3);
        port_data_out(3, dd/4);
        pgmOut(0xc3, dd/8);
        break;
      case 4:
        dd = analogRead(A4);
        port_data_out(4, dd/4);
        pgmOut(0xc4, dd/8);
        break;
      case 5:
        dd = analogRead(A5);
        port_data_out(5, dd/4);
        pgmOut(0xc5, dd/8);
        break;
      case 6:
        dd = analogRead(A6);
        port_data_out(6, dd/4);
        pgmOut(0xc6, dd/8);
        break;
      case 7:
        dd = analogRead(A7);
        port_data_out(7, dd/4);
        pgmOut(0xc7, dd/8);
        break;
    }
  }
}

void pgmOut(char cmd, char data) {
  Serial.write(cmd);
  Serial.write(data);
}

void port_data_out(int port, int data){
  for (int i=0; i < 8; i++){
    digitalWrite(i+2, (data >> i) & 1);
  }
  for (int i=0; i < 3; i++){
    digitalWrite(i+10, (port >> i) & 1);
  }
  digitalWrite(13, LOW);
  digitalWrite(13, HIGH);
}

