long previousMillis = 0;
int interval = 1000;
int phase = 0;

void setup() {
  Serial.begin(38400);
  for (int i=2; i <= 13; i++){
    pinMode(i, OUTPUT);    
  }
  digitalWrite(13, HIGH);
  for (int i=0; i < 8; i++){
    port_data_out(i, 0);    
  }
}

void loop() {
  unsigned long currentMillis = millis();
  int dd;
  if(currentMillis - previousMillis > interval) {
    previousMillis = currentMillis;  
    phase = (++phase) & 7;
    Serial.write(0xc0);
    port_data_out(0, phase);
    Serial.write(phase+0x30);
  }
  if(Serial.available() > 0) {
    dd = Serial.read();
    if(dd<128){
      port_data_out(1, dd);
    }
  }
}

void port_data_out(int port, int data){
  for (int i=0; i < 8; i++){
    digitalWrite(i+2, (data >> i) & 1);
  }
  for (int i=0; i < 3; i++){
    digitalWrite(i+10, (port >> i) & 1);
  }
  digitalWrite(13, LOW);
  digitalWrite(13, HIGH);
}
