
#define         ctc_0           0x10
#define         ctc_1           0x11
#define         ctc_2           0x12
#define         ctc_3           0x13
#define         sio_a           0x18
#define         sio_b           0x1a
#define         pio_a           0x1c
#define         pio_b           0x1e

#define         rx_fifo         0x8000          /* MIDI Receive */
#define         tx_fifo         0x8800          /* MIDI Transmit */
#define         lcd_fifo        0x9000          /* LCD Display */
#define         rx_top          0x9100 + 2 * 0
#define         rx_end          0x9100 + 2 * 1
#define         tx_top          0x9100 + 2 * 2
#define         tx_end          0x9100 + 2 * 3
#define         timer_flag      0x9100 + 2 * 4
#define         lcd_top         0x9100 + 2 * 5
#define         lcd_end         0x9100 + 2 * 6
#define         lcd             0x9100 + 2 * 7
#define         work            0x9200          /* unversal use */

int     i,j,k,l,m,n;                    /* universal for local use */
int     midi,rsb,dcb,channel,keyno;     /* universal MIDI parameter */

/*****  Common Functions  **********************************/

void port_out( int port, int data ){
#asm
        ld      hl,4
        add     hl,sp
        ld      c,(hl)
        ld      hl,2
        add     hl,sp
        ld      a,(hl)
        out     (c),a
        nop
        ret
#endasm
}

int port_in( int port ){
#asm
        ld      hl,2
        add     hl,sp
        ld      c,(hl)
        in      a,(c)
        ld      l,a
        ld      h,0
        ret
#endasm
}

void ram_put( int address, int data ){
#asm
        ld      hl,4
        add     hl,sp
        ld      c,(hl)
        inc     hl
        ld      b,(hl)
        ld      hl,2
        add     hl,sp
        ld      a,(hl)
        ld      (bc),a
#endasm
}

int ram_get( int address ){
#asm
        ld      hl,2
        add     hl,sp
        ld      c,(hl)
        inc     hl
        ld      b,(hl)
        ld      a,(bc)
        ld      l,a
        ld      h,0
        ret
#endasm
}

void enable_interrupt(){
#asm
        ei
#endasm
}

void disable_interrupt(){
#asm
        di
#endasm
}

/*****  I/O Setting Functions  *****************************/

void pio_a_setting( int bitmap ){
        port_out( pio_a+1, 0xcf );              /* Mode 3 */
        port_out( pio_a+1, bitmap );
}

void pio_b_setting( int bitmap ){ 
        port_out( pio_b+1, 0xcf );              /* Mode 3 */
        port_out( pio_b+1, bitmap );
}

void timer_0_setting(){
        port_out( ctc_0, 0x70 );                /* Interrupt Address */
        port_out( ctc_0, 0xa5 );                /* Timer Mode */
        port_out( ctc_0, 158);                  /* about 10msec */
}

void sio_dummy_read(){
#asm
        in      a,(sio_a+0)
#endasm
}

void midi_port_setting(){
        port_out( sio_b+1, 0x18 );
        port_out( sio_b+1, 0x04 );
        port_out( sio_b+1, 0xc4 );
        port_out( sio_b+1, 0x01 );
        port_out( sio_b+1, 0x00 );
        port_out( sio_b+1, 0x05 );
        port_out( sio_b+1, 0x60 );
        port_out( sio_b+1, 0x02 );
        port_out( sio_b+1, 0x20 );
        port_out( sio_a+1, 0x18 );
        port_out( sio_a+1, 0x04 );
        port_out( sio_a+1, 0xc4 );
        port_out( sio_a+1, 0x01 );
        port_out( sio_a+1, 0x10 );
        port_out( sio_a+1, 0x05 );
        port_out( sio_a+1, 0x68 );
        port_out( sio_a+1, 0x03 );
        port_out( sio_a+1, 0xc1 );
}

/*****  MIDI Functions  ************************************/

void tx_midi_check(){
#asm
        ld      de,(tx_end)
        ld      hl,(tx_top)
        and     a
        sbc     hl,de
        ret     z
        xor     a
        out     (sio_a+1),a
        in      a,(sio_a+1)
        bit     2,a
        ret     z
        ld      a,10001000b
        or      d
        ld      h,a
        ld      l,e
        ld      a,(hl)
        out     (sio_a),a
        inc     de
        res     3,d
        ld      (tx_end),de
        ret
#endasm
}

void tx_midi_set(int data){
#asm
        ld      hl,2
        add     hl,sp
        ld      b,(hl)
        ld      de,(tx_top)
        ld      a,10001000b
        or      d
        ld      h,a
        ld      l,e
        ld      (hl),b
        inc     de
        res     3,d
        ld      (tx_top),de
        ret
#endasm
}

