#include	"library.c"		/* Common Tools for AKI-80 */

initial(){
	lcd_module_setting();		/* using Port[A] */
	timer_0_setting();		/* about 10msec */
	midi_port_setting();		/* sio_a */
	enable_interrupt();		/* EI */
	sio_dummy_read();		/* omajinai */
}

line_disp( int tt ){
	int t;
	t = 15-(tt%16);
	switch(t){
		case  0: disp_string( 0x40, "Hello SIGMUS    "); break;
		case  1: disp_string( 0x40, " Hello SIGMUS   "); break;
		case  2: disp_string( 0x40, "  Hello JMACS!  "); break;
		case  3: disp_string( 0x40, "   Hello SIGMUS "); break;
		case  4: disp_string( 0x40, "    Hello SIGMUS"); break;
		case  5: disp_string( 0x40, "S    Hello SIGMU"); break;
		case  6: disp_string( 0x40, "US    Hello SIGM"); break;
		case  7: disp_string( 0x40, "MUS    Hello SIG"); break;
		case  8: disp_string( 0x40, "GMUS    Hello SI"); break;
		case  9: disp_string( 0x40, "IGMUS    Hello S"); break;
		case 10: disp_string( 0x40, "(^_^;)    Hello "); break;
		case 11: disp_string( 0x40, " SIGMUS    Hello"); break;
		case 12: disp_string( 0x40, "o SIGMUS    Hell"); break;
		case 13: disp_string( 0x40, "lo SIGMUS    Hel"); break;
		case 14: disp_string( 0x40, "llo SIGMUS    He"); break;
		case 15: disp_string( 0x40, "ello SIGMUS    H"); break;
	}
}

midi_display(){
	if( midi > 127 ){
		if( midi > 0xef ) rsb = 0;
		else{
			rsb = midi & 0xf0;
			channel = midi & 0x0f;
			dcb = 0;
		}
	}
	else{
		if( rsb == 0 ){}
		else if( (rsb == 0xc0) || (rsb == 0xd0) ){
			disp_hex( 7, rsb+channel );
			disp_hex( 10, midi );
			disp_string( 13, "  ");
		}
		else{
			if( dcb == 0 ){
				keyno = midi;
				dcb = 1;
			}
			else{
				dcb = 0;
				if( (rsb==0x90) && (midi!=0) ){
					disp_hex( 7, rsb+channel );
					disp_hex( 10, keyno );
					disp_hex( 13, midi );
				}
			}
		}
	}
}

main(){
	int timer,t;
	t = 0;
	initial();
	disp_string( 0, "MIDI =          ");
	while(1){
		tx_midi_check();
		lcd_disp_check();
		midi = rx_midi_check();
		if( midi < 256 ){
			tx_midi_set( midi );
			midi_display( midi );
		}
		if( ram_get(timer_flag) != 0){
			ram_put( timer_flag, 0 );
			timer++;
			if( timer > 50 ){
				timer = 0;
				line_disp(t++);
			}
		}
	}
}
