
ctc_0		equ		010h
ctc_1		equ		011h
ctc_2		equ		012h
ctc_3		equ		013h
sio_a		equ		018h
sio_b		equ		01ah
pio_a		equ		01ch
pio_b		equ		01eh

rx_fifo		equ		08000h			; MIDI Receive
tx_fifo		equ		08800h			; MIDI Transmit
lcd_fifo	equ		09000h
rx_top		equ		09100h + 2 * 0
rx_end		equ		09100h + 2 * 1
tx_top		equ		09100h + 2 * 2
tx_end		equ		09100h + 2 * 3
timer_flag	equ		09100h + 2 * 4
lcd_top		equ		09100h + 2 * 5
lcd_end		equ		09100h + 2 * 6
lcd		equ		09100h + 2 * 7
work		equ		09200h			; universal use
ram_top		equ		09300h			; [C] constant

	org	0000h
	ld	sp,9fffh
	di
	ld      hl,08000h
	ld      a,09fh
__ram_clear__:
	ld      (hl),0
	inc     hl
	cp      h
	jr	nc,__ram_clear__
	im	2
	call	__main
__st_loop__:
	di
	nop
	jr	__st_loop__

	org     0020h
	dw	__midi__
__midi__:
	ex	af,af'
	exx
	ld	de,(rx_top)
	ld	a,10000000b
	or	d
	ld	h,a
	ld	l,e
	in	a,(sio_a+0)
	ld	(hl),a
	inc	de
	res	3,d
	ld	(rx_top),de
	exx
	ex	af,af'
	ei
	reti

	org	0066h
	retn

	org     0070h
	dw	_timer_
_timer_:
	ex	af,af'
	ld	a,1
	ld	(timer_flag),a
	ex	af,af'
	ei
	reti

