;System Load Compiler [mini-'C' V1.0] for Z80/KC80 1995.3
;By System Load CO.,LTD. & K.Kino Copyright (C) All rights reserved
;
 include	"startup.h"

MC_GCHAR:
	LD	A,(HL)
MC_SXT:
	LD	L,A
	RLCA
	SBC	A,A
	LD	H,A
	RET
MC_CDR:
	INC	HL
	INC	HL
MC_GINT:
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	RET
MC_PINT:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	LD	(DE),A
	INC	DE
	LD	A,H
	LD	(DE),A
	RET
MC_OROR:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	OR	H
	JP	NZ,__OR2R
	LD	A,E
	OR	D
	JP	NZ,__OR2R
	LD	HL,0
	RET
__OR2R:
	LD	HL,1
	RET
MC_OR:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	OR	E
	LD	L,A
	LD	A,H
	OR	D
	LD	H,A
	RET
MC_XOR:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	XOR	E
	LD	L,A
	LD	A,H
	XOR	D
	LD	H,A
	RET
MC_ANDAND:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	OR	H
	JP	Z,__AND2R
	LD	A,E
	OR	D
	JP	Z,__AND2R
	LD	HL,1
	RET
__AND2R:
	LD	HL,0
	RET
MC_AND:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,L
	AND	E
	LD	L,A
	LD	A,H
	AND	D
	LD	H,A
	RET
MC_EQ:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_CMP
	RET	Z
	DEC	HL
	RET
MC_NE:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_CMP
	RET	NZ
	DEC	HL
	RET
MC_GT:
	POP	BC
	POP	DE
	PUSH	BC
	EX	DE,HL
	CALL	MC_CMP
	RET	C
	DEC	HL
	RET
MC_LE:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_CMP
	RET	Z
	RET	C
	DEC	HL
	RET
MC_GE:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_CMP
	RET	NC
	DEC	HL
	RET
MC_LT:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_CMP
	RET	C
	DEC	HL
	RET
MC_CMP:
	LD	A,E
	SUB	L
	LD	E,A
	LD	A,D
	SBC	A,H
	LD	HL,00001H
	JP	M,MC_CMP1
	OR	E
	RET
MC_CMP1:
	OR	E
	SCF
	RET
MC_LNEG:
	LD	A,H
	OR	L
	LD	HL,0
	JR	Z,MC_LNEG1
	RET
MC_LNEG1:
	INC	L
	RET
MC_UGE:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_UCMP
	RET	NC
	DEC	HL
	RET
MC_ULT:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_UCMP
	RET	C
	DEC	HL
	RET
MC_UGT:
	POP	BC
	POP	DE
	PUSH	BC
	EX	DE,HL
	CALL	MC_UCMP
	RET	C
	DEC	HL
	RET
MC_ULE:
	POP	BC
	POP	DE
	PUSH	BC
	CALL	MC_UCMP
	RET	Z
	RET	C
	DEC	HL
	RET
MC_UCMP:
	LD	A,D
	CP	H
	JR	NZ,CUCMP1
	LD	A,E
	CP	L
CUCMP1:
	LD	HL,00001H
	RET
MC_ASR:
	EX	DE,HL
	DEC	E
	RET	M
	LD	A,H
	RLA
	LD	A,H
	RRA
	LD	H,A
	LD	A,L
	RRA
	LD	L,A
	JR	MC_ASR+1
MC_ASL:
	POP	BC
	POP	DE
	PUSH	BC
	EX	DE,HL
MC_ASL4:
	DEC	E
	RET	M
	ADD	HL,HL
	JR	MC_ASL4
MC_SUB:
	POP	BC
	POP	DE
	PUSH	BC
	LD	A,E
	SUB	L
	LD	L,A
	LD	A,D
	SBC	A,H
	LD	H,A
	RET
MC_NEG:
	CALL	MC_COM
	INC	HL
	RET
MC_COM:
	LD	A,H
	CPL
	LD	H,A
	LD	A,L
	CPL
	LD	L,A
	RET
MC_MULT:
	POP	BC
	POP	DE
	PUSH	BC
	LD	B,H
	LD	C,L
	LD	HL,00000H
MC_MLT1:
	LD	A,C
	RRCA
	JR	NC,CMLT2
	ADD	HL,DE
CMLT2:
	XOR	A
	LD	A,B
	RRA
	LD	B,A
	LD	A,C
	RRA
	LD	C,A
	OR	B
	RET	Z
	XOR	A
	LD	A,E
	RLA
	LD	E,A
	LD	A,D
	RLA
	LD	D,A
	OR	E
	RET	Z
	JR	MC_MLT1
MC_DIV:
	LD	B,H
	LD	C,L
	LD	A,D
	XOR	B
	PUSH	AF
	LD	A,D
	OR	A
	CALL	M,MC_DENEG
	LD	A,B
	OR	A
	CALL	M,MC_BCNEG
	LD	A,010H
	PUSH	AF
	EX	DE,HL
	LD	DE,00000H
MC_DIV1:
	ADD	HL,HL
	CALL	MC_RDEL
	JR	Z,MC_DIV2
	CALL	MC_PBCDE
	JP	M,MC_DIV2
	LD	A,L
	OR	001H
	LD	L,A
	LD	A,E
	SUB	C
	LD	E,A
	LD	A,D
	SBC	A,B
	LD	D,A
MC_DIV2:
	POP	AF
	DEC	A
	JR	Z,MC_DIV3
	PUSH	AF
	JR	MC_DIV1
MC_DIV3:
	POP	AF
	RET	P
	CALL	MC_DENEG
	EX	DE,HL
	CALL	MC_DENEG
	EX	DE,HL
	RET
MC_DENEG:
	LD	A,D
	CPL
	LD	D,A
	LD	A,E
	CPL
	LD	E,A
	INC	DE
	RET
MC_BCNEG:
	LD	A,B
	CPL
	LD	B,A
	LD	A,C
	CPL
	LD	C,A
	INC	BC
	RET
MC_RDEL:
	LD	A,E
	RLA
	LD	E,A
	LD	A,D
	RLA
	LD	D,A
	OR	E
	RET
MC_PBCDE:
	LD	A,E
	SUB	C
	LD	A,D
	SBC	A,B
	RET
MC_SWITCH:
	EX	DE,HL
	POP	HL
SWLOOP:
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	A,B
	OR	C
	JR	Z,SWEND
	LD	A,(HL)
	INC	HL
	CP	E
	LD	A,(HL)
	INC	HL
	JR	NZ,SWLOOP
	CP	D
	JR	NZ,SWLOOP
	LD	H,B
	LD	L,C
SWEND:
	JP	(HL)
DEBUGSP:
	LD	HL,2
DEBUGSP2:
	ADD	HL,SP
	PUSH	HL
	POP	IY
	RET

;#include	"library.c"		/* Common Tools for AKI-80 */
;#define		ctc_0		0x10
;#define		ctc_1		0x11
;#define		ctc_2		0x12
;#define		ctc_3		0x13
;#define		sio_a		0x18
;#define		sio_b		0x1a
;#define		pio_a		0x1c
;#define		pio_b		0x1e
;#define		rx_fifo		0x8000		/* MIDI Receive */
;#define		tx_fifo		0x8800		/* MIDI Transmit */
;#define		lcd_fifo	0x9000		/* LCD Display */
;#define		rx_top		0x9100 + 2 * 0
;#define		rx_end		0x9100 + 2 * 1
;#define		tx_top		0x9100 + 2 * 2
;#define		tx_end		0x9100 + 2 * 3
;#define		timer_flag	0x9100 + 2 * 4
;#define		lcd_top		0x9100 + 2 * 5
;#define		lcd_end		0x9100 + 2 * 6
;#define		lcd		0x9100 + 2 * 7
;#define		work		0x9200		/* unversal use */
;int	i,j,k,l,m,n;			/* universal for local use */
;int	midi,rsb,dcb,channel,keyno;	/* universal MIDI parameter */
;/*****  Common Functions  **********************************/
;void port_out( int port, int data ){
__port_out:
;#asm

	ld	hl,4
	add	hl,sp
	ld	c,(hl)
	ld	hl,2
	add	hl,sp
	ld	a,(hl)
	out	(c),a
	nop
	ret

;#endasm
;}
	RET
;int port_in( int port ){
__port_in:
;#asm

	ld	hl,2
	add	hl,sp
	ld	c,(hl)
	in	a,(c)
	ld	l,a
	ld	h,0
	ret

;#endasm
;}
	RET
;void ram_put( int address, int data ){
__ram_put:
;#asm

	ld	hl,4
	add	hl,sp
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	ld	hl,2
	add	hl,sp
	ld	a,(hl)
	ld	(bc),a

;#endasm
;}
	RET
;int ram_get( int address ){
__ram_get:
;#asm

	ld	hl,2
	add	hl,sp
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	ld	a,(bc)
	ld	l,a
	ld	h,0
	ret

;#endasm
;}
	RET
;void enable_interrupt(){
__enable_interrupt:
;#asm

	ei

;#endasm
;}
	RET
;void disable_interrupt(){
__disable_interrupt:
;#asm

	di

;#endasm
;}
	RET
;char hex_conv( int data ){
__hex_conv:
;	switch(data){
	LD HL,02H
	ADD HL,SP
	CALL mc_gint
	JP mc_10
;		case 0:	 return('0');
mc_11:
	LD HL,30H
	RET
;		case 1:	 return('1');
mc_12:
	LD HL,31H
	RET
;		case 2:	 return('2');
mc_13:
	LD HL,32H
	RET
;		case 3:	 return('3');
mc_14:
	LD HL,33H
	RET
;		case 4:	 return('4');
mc_15:
	LD HL,34H
	RET
;		case 5:	 return('5');
mc_16:
	LD HL,35H
	RET
;		case 6:	 return('6');
mc_17:
	LD HL,36H
	RET
;		case 7:	 return('7');
mc_18:
	LD HL,37H
	RET
;		case 8:	 return('8');
mc_19:
	LD HL,38H
	RET
;		case 9:	 return('9');
mc_20:
	LD HL,39H
	RET
;		case 10: return('A');
mc_21:
	LD HL,41H
	RET
;		case 11: return('B');
mc_22:
	LD HL,42H
	RET
;		case 12: return('C');
mc_23:
	LD HL,43H
	RET
;		case 13: return('D');
mc_24:
	LD HL,44H
	RET
;		case 14: return('E');
mc_25:
	LD HL,45H
	RET
;		case 15: return('F');
mc_26:
	LD HL,46H
	RET
;	}
	JP mc_9
mc_10:
	CALL MC_SWITCH
	DEFW mc_11,00H
	DEFW mc_12,01H
	DEFW mc_13,02H
	DEFW mc_14,03H
	DEFW mc_15,04H
	DEFW mc_16,05H
	DEFW mc_17,06H
	DEFW mc_18,07H
	DEFW mc_19,08H
	DEFW mc_20,09H
	DEFW mc_21,0AH
	DEFW mc_22,0BH
	DEFW mc_23,0CH
	DEFW mc_24,0DH
	DEFW mc_25,0EH
	DEFW mc_26,0FH
	DEFW 0
mc_9:
;}
	RET
;/*****  I/O Setting Functions  *****************************/
;void pio_a_setting( int bitmap ){
__pio_a_setting:
;	port_out( pio_a+1, 0xcf );		/* Mode 3 */
	LD HL,1CH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,0CFH
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a+1, bitmap );
	LD HL,1CH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,04H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;}
	RET
;void pio_b_setting( int bitmap ){ 
__pio_b_setting:
;	port_out( pio_b+1, 0xcf );		/* Mode 3 */
	LD HL,1EH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,0CFH
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_b+1, bitmap );
	LD HL,1EH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,04H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;}
	RET
;void timer_0_setting(){
__timer_0_setting:
;	port_out( ctc_0, 0x70 );		/* Interrupt Address */
	LD HL,10H
	PUSH HL
	LD HL,70H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( ctc_0, 0xa5 );		/* Timer Mode */
	LD HL,10H
	PUSH HL
	LD HL,0A5H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( ctc_0, 158);			/* about 10msec */
	LD HL,10H
	PUSH HL
	LD HL,9EH
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;}
	RET
;void sio_dummy_read(){
__sio_dummy_read:
;#asm

	in	a,(sio_a+0)

;#endasm
;}
	RET
;void midi_port_setting(){
__midi_port_setting:
;	port_out( sio_b+1, 0x18 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,18H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x04 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,04H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0xc4 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,0C4H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x01 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,01H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x00 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,00H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x05 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,05H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x60 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,60H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x02 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,02H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_b+1, 0x20 );
	LD HL,1AH
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,20H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x18 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,18H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x04 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,04H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0xc4 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,0C4H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x01 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,01H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x10 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,10H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x05 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,05H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x68 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,68H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0x03 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,03H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( sio_a+1, 0xc1 );
	LD HL,18H
	PUSH HL
	LD HL,01H
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,0C1H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;}
	RET
;/*****  MIDI Functions  ************************************/
;void tx_midi_check(){
__tx_midi_check:
;#asm

	ld	de,(tx_end)
	ld	hl,(tx_top)
	and	a
	sbc	hl,de
	ret	z
	xor	a
	out	(sio_a+1),a
	in	a,(sio_a+1)
	bit	2,a
	ret	z
	ld	a,10001000b
	or	d
	ld	h,a
	ld	l,e
	ld	a,(hl)
	out	(sio_a),a
	inc	de
	res	3,d
	ld	(tx_end),de
	ret

;#endasm
;}
	RET
;void tx_midi_set(int data){
__tx_midi_set:
;#asm

	ld	hl,2
	add	hl,sp
	ld	b,(hl)
	ld	de,(tx_top)
	ld	a,10001000b
	or	d
	ld	h,a
	ld	l,e
	ld	(hl),b
	inc	de
	res	3,d
	ld	(tx_top),de
	ret

;#endasm
;}
	RET
;int rx_midi_check(){
__rx_midi_check:
;#asm

	ld	de,(rx_end)
	ld	hl,(rx_top)
	and	a
	sbc	hl,de
	jr	nz,___non_event
	ld	h,10
	ret
___non_event:
	ld	a,10000000b
	or	d
	ld	h,a
	ld	l,e
	ld	b,(hl)
	inc	de
	res	3,d
	ld	(rx_end),de
	ld	l,b
	ld	h,0
	ret

;#endasm
;}
	RET
;/*****  LCD Functions  *************************************/
;//      This Library uses [PA0-PA7] port for LCD !
;//
;//	Connection Mapping :
;//         ===== AKI-80 ===== LCD Module =====
;//		  PA 7  ---------------------(LED on AKI-80)
;//		     6  --  No. 9  E
;//		     5  --     10  R/W
;//		     4  --     11  RS
;//		     3  --      1  DB7
;//		     2  --      2  DB6
;//		     1  --      3  DB5
;//		  PA 0  --      4  DB4
;//                 +5V  --     14  Vdd
;//                 GND  --     13  Vss
;//         contrast VR  --     12  Vo
;//                (nc)  --      5  DB3
;//                (nc)  --      6  DB2
;//                (nc)  --      7  DB1
;//                (nc)  --      8  DB0
;//
;//	Work Memory Assignment :
;//		(lcd + 0) -- 8 bit data buffer to be transfered
;//		(lcd + 1) -- bit 7 (MSB) only for LED
;void wait_37usec(){
__wait_37usec:
;#asm

	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;#endasm
;}
	RET
;void wait_500usec(){
__wait_500usec:
;	for(j=0;j<15;j++) wait_37usec();
	LD HL,00H
	LD (__j),HL
mc_39:
	LD HL,(__j)
	PUSH HL
	LD HL,0FH
	CALL mc_lt
	LD A,H
	OR L
	JP Z,mc_38
	JP mc_40
mc_37:
	LD HL,(__j)
	INC HL
	LD (__j),HL
	DEC HL
	JP mc_39
mc_40:
	CALL __wait_37usec
	JP mc_37
mc_38:
;}
	RET
;void lcd_command_set( int rs, int data ){
__lcd_command_set:
;#asm

	ld	a,(lcd+1)
	ld	b,a
	ld	hl,4
	add	hl,sp
	ld	a,(hl)
	and	00000001b
	sla	a
	sla	a
	sla	a
	sla	a
	or	b
	ld	b,a
	ld	hl,2
	add	hl,sp
	ld	a,(hl)
	ld	(lcd+0),a
	srl	a
	srl	a
	srl	a
	srl	a
	or	b
	out	(pio_a),a
	set	6,a
	out	(pio_a),a
	nop
	res	6,a
	out	(pio_a),a
	ld	a,(lcd+0)
	and	00001111b
	or	b
	out	(pio_a),a
	set	6,a
	out	(pio_a),a
	nop
	res	6,a
	out	(pio_a),a

;#endasm
;	wait_37usec();
	CALL __wait_37usec
;}
	RET
;void lcd_module_setting(){
__lcd_module_setting:
;	pio_a_setting( 0x00 );			/* bit0-7 output */
	LD HL,00H
	PUSH HL
	CALL __pio_a_setting
	POP BC
;	for(i=0;i<10;i++) wait_500usec();
	LD HL,00H
	LD (__i),HL
mc_45:
	LD HL,(__i)
	PUSH HL
	LD HL,0AH
	CALL mc_lt
	LD A,H
	OR L
	JP Z,mc_44
	JP mc_46
mc_43:
	LD HL,(__i)
	INC HL
	LD (__i),HL
	DEC HL
	JP mc_45
mc_46:
	CALL __wait_500usec
	JP mc_43
mc_44:
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0xc3 );		/* 11000011 */
	LD HL,1CH
	PUSH HL
	LD HL,0C3H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	for(i=0;i<10;i++) wait_500usec();
	LD HL,00H
	LD (__i),HL
mc_49:
	LD HL,(__i)
	PUSH HL
	LD HL,0AH
	CALL mc_lt
	LD A,H
	OR L
	JP Z,mc_48
	JP mc_50
mc_47:
	LD HL,(__i)
	INC HL
	LD (__i),HL
	DEC HL
	JP mc_49
mc_50:
	CALL __wait_500usec
	JP mc_47
mc_48:
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0xc3 );		/* 11000011 */
	LD HL,1CH
	PUSH HL
	LD HL,0C3H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	wait_500usec();
	CALL __wait_500usec
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0xc3 );		/* 11000011 */
	LD HL,1CH
	PUSH HL
	LD HL,0C3H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0x83 );		/* 10000011 */
	LD HL,1CH
	PUSH HL
	LD HL,83H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	wait_37usec();
	CALL __wait_37usec
;	port_out( pio_a, 0x82 );		/* 10000010 */
	LD HL,1CH
	PUSH HL
	LD HL,82H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0xc2 );		/* 11000010 */
	LD HL,1CH
	PUSH HL
	LD HL,0C2H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	port_out( pio_a, 0x82 );		/* 10000010 */
	LD HL,1CH
	PUSH HL
	LD HL,82H
	PUSH HL
	CALL __port_out
	POP BC
	POP BC
;	wait_37usec();
	CALL __wait_37usec
;	lcd_command_set( 0, 0x28 );		/* function reset */
	LD HL,00H
	PUSH HL
	LD HL,28H
	PUSH HL
	CALL __lcd_command_set
	POP BC
	POP BC
;	lcd_command_set( 0, 0x08 );		/* display off */
	LD HL,00H
	PUSH HL
	LD HL,08H
	PUSH HL
	CALL __lcd_command_set
	POP BC
	POP BC
;	lcd_command_set( 0, 0x01 );		/* all clear */
	LD HL,00H
	PUSH HL
	LD HL,01H
	PUSH HL
	CALL __lcd_command_set
	POP BC
	POP BC
;	for(i=0;i<5;i++) wait_500usec();
	LD HL,00H
	LD (__i),HL
mc_53:
	LD HL,(__i)
	PUSH HL
	LD HL,05H
	CALL mc_lt
	LD A,H
	OR L
	JP Z,mc_52
	JP mc_54
mc_51:
	LD HL,(__i)
	INC HL
	LD (__i),HL
	DEC HL
	JP mc_53
mc_54:
	CALL __wait_500usec
	JP mc_51
mc_52:
;	lcd_command_set( 0, 0x06 );		/* entry mode */
	LD HL,00H
	PUSH HL
	LD HL,06H
	PUSH HL
	CALL __lcd_command_set
	POP BC
	POP BC
;	lcd_command_set( 0, 0x0c );		/* display ON */
	LD HL,00H
	PUSH HL
	LD HL,0CH
	PUSH HL
	CALL __lcd_command_set
	POP BC
	POP BC
;}
	RET
;void lcd_fifo_set( int data ){
__lcd_fifo_set:
;#asm

	ld	hl,2
	add	hl,sp
	ld	c,(hl)			; [C] = raw data
	ld	a,(lcd_top)
	ld	l,a
	ld	h,090h
	ld	(hl),c
	inc	l
	ld	a,l
	ld	(lcd_top),a
	ret

;#endasm
;}
	RET
;void lcd_display( int address, int data ){
__lcd_display:
;#asm

	ld	hl,4
	add	hl,sp
	ld	a,(hl)
	or	10000000b
	ld	b,a			; [B] = address
	ld	hl,2
	add	hl,sp
	ld	a,(hl)
	and	07fh
	ld	c,a			; [C] = data
	ld	a,(lcd_top)
	ld	l,a
	ld	h,090h
	ld	(hl),b
	inc	l
	ld	(hl),c
	inc	l
	ld	a,l
	ld	(lcd_top),a
	ret

;#endasm
;}
	RET
;void disp_string( int address, char *s ){
__disp_string:
;	char a;
	DEC SP
;	lcd_fifo_set( 0x80+address );
	LD HL,80H
	PUSH HL
	LD HL,07H
	ADD HL,SP
	CALL mc_gint
	POP DE
	ADD HL,DE
	PUSH HL
	CALL __lcd_fifo_set
	POP BC
;	i = 0;
	LD HL,00H
	LD (__i),HL
;	while(1){
mc_58:
	LD HL,01H
	LD A,H
	OR L
	JP Z,mc_59
;		a = s[i++];
	LD HL,00H
	ADD HL,SP
	PUSH HL
	LD HL,05H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	LD HL,(__i)
	INC HL
	LD (__i),HL
	DEC HL
	POP DE
	ADD HL,DE
	CALL  mc_gchar
	POP DE
	LD A,L
	LD (DE),A
;		if( a==0 ) break;
	LD HL,00H
	ADD HL,SP
	CALL  mc_gchar
	PUSH HL
	LD HL,00H
	CALL mc_eq
	LD A,H
	OR L
	JP Z,mc_60
	JP mc_59
;		lcd_fifo_set( a & 0x7f );
mc_60:
	LD HL,00H
	ADD HL,SP
	CALL  mc_gchar
	PUSH HL
	LD HL,7FH
	CALL mc_and
	PUSH HL
	CALL __lcd_fifo_set
	POP BC
;	}
	JP mc_58
mc_59:
;}
	INC SP
	RET
;void disp_hex( int address, int data ){
__disp_hex:
;	lcd_fifo_set( 0x80+address );
	LD HL,80H
	PUSH HL
	LD HL,06H
	ADD HL,SP
	CALL mc_gint
	POP DE
	ADD HL,DE
	PUSH HL
	CALL __lcd_fifo_set
	POP BC
;	lcd_fifo_set( hex_conv(data/16) );
	LD HL,02H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	LD HL,10H
	POP DE
	CALL mc_div
	PUSH HL
	CALL __hex_conv
	POP BC
	PUSH HL
	CALL __lcd_fifo_set
	POP BC
;	lcd_fifo_set( hex_conv(data%16) );
	LD HL,02H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	LD HL,10H
	POP DE
	CALL mc_div
	EX DE,HL
	PUSH HL
	CALL __hex_conv
	POP BC
	PUSH HL
	CALL __lcd_fifo_set
	POP BC
;}
	RET
;void lcd_disp_check(){
__lcd_disp_check:
;#asm

	ld	a,(lcd_end)
	ld	l,a
	ld	a,(lcd_top)
	cp	l
	ret	z
	ld	h,090h
	ld	a,(lcd+1)
	ld	b,a
	ld	a,(hl)
	xor	10000000b
	and	10000000b
	srl	a
	srl	a
	srl	a
	or	b
	ld	b,a
	ld	a,(hl)
	ld	(lcd+0),a
	srl	a
	srl	a
	srl	a
	srl	a
	or	b
	out	(pio_a),a
	set	6,a
	out	(pio_a),a
	nop
	res	6,a
	out	(pio_a),a
	ld	a,(lcd+0)
	and	00001111b
	or	b
	out	(pio_a),a
	set	6,a
	out	(pio_a),a
	nop
	res	6,a
	out	(pio_a),a
	inc	l
	ld	a,l
	ld	(lcd_end),a
	ret

;#endasm
;}
	RET
;initial(){
__initial:
;	lcd_module_setting();		/* using Port[A] */
	CALL __lcd_module_setting
;	timer_0_setting();		/* about 10msec */
	CALL __timer_0_setting
;	midi_port_setting();		/* sio_a */
	CALL __midi_port_setting
;	enable_interrupt();		/* EI */
	CALL __enable_interrupt
;	sio_dummy_read();		/* omajinai */
	CALL __sio_dummy_read
;}
	RET
;line_disp( int tt ){
__line_disp:
;	int t;
	PUSH BC
;	t = 15-(tt%16);
	LD HL,00H
	ADD HL,SP
	PUSH HL
	LD HL,0FH
	PUSH HL
	LD HL,08H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	LD HL,10H
	POP DE
	CALL mc_div
	EX DE,HL
	CALL mc_sub
	CALL mc_pint
;	switch(t){
	LD HL,00H
	ADD HL,SP
	CALL mc_gint
	JP mc_67
;		case  0: disp_string( 0x40, "Hello SIGMUS    "); break;
mc_68:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+00H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  1: disp_string( 0x40, " Hello SIGMUS   "); break;
mc_69:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+11H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  2: disp_string( 0x40, "  Hello JMACS!  "); break;
mc_70:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+22H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  3: disp_string( 0x40, "   Hello SIGMUS "); break;
mc_71:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+33H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  4: disp_string( 0x40, "    Hello SIGMUS"); break;
mc_72:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+44H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  5: disp_string( 0x40, "S    Hello SIGMU"); break;
mc_73:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+55H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  6: disp_string( 0x40, "US    Hello SIGM"); break;
mc_74:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+66H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  7: disp_string( 0x40, "MUS    Hello SIG"); break;
mc_75:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+77H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  8: disp_string( 0x40, "GMUS    Hello SI"); break;
mc_76:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+88H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case  9: disp_string( 0x40, "IGMUS    Hello S"); break;
mc_77:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+99H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 10: disp_string( 0x40, "(^_^;)    Hello "); break;
mc_78:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0AAH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 11: disp_string( 0x40, " SIGMUS    Hello"); break;
mc_79:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0BBH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 12: disp_string( 0x40, "o SIGMUS    Hell"); break;
mc_80:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0CCH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 13: disp_string( 0x40, "lo SIGMUS    Hel"); break;
mc_81:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0DDH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 14: disp_string( 0x40, "llo SIGMUS    He"); break;
mc_82:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0EEH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;		case 15: disp_string( 0x40, "ello SIGMUS    H"); break;
mc_83:
	LD HL,40H
	PUSH HL
	LD HL,mc_64+0FFH
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
	JP mc_66
;	}
	JP mc_66
mc_67:
	CALL MC_SWITCH
	DEFW mc_68,00H
	DEFW mc_69,01H
	DEFW mc_70,02H
	DEFW mc_71,03H
	DEFW mc_72,04H
	DEFW mc_73,05H
	DEFW mc_74,06H
	DEFW mc_75,07H
	DEFW mc_76,08H
	DEFW mc_77,09H
	DEFW mc_78,0AH
	DEFW mc_79,0BH
	DEFW mc_80,0CH
	DEFW mc_81,0DH
	DEFW mc_82,0EH
	DEFW mc_83,0FH
	DEFW 0
mc_66:
;}
	POP BC
	RET
mc_64:	DEFB 48H,65H,6CH,6CH,6FH,20H,53H,49H,47H,4DH
	DEFB 55H,53H,20H,20H,20H,20H,00H,20H,48H,65H
	DEFB 6CH,6CH,6FH,20H,53H,49H,47H,4DH,55H,53H
	DEFB 20H,20H,20H,00H,20H,20H,48H,65H,6CH,6CH
	DEFB 6FH,20H,4AH,4DH,41H,43H,53H,21H,20H,20H
	DEFB 00H,20H,20H,20H,48H,65H,6CH,6CH,6FH,20H
	DEFB 53H,49H,47H,4DH,55H,53H,20H,00H,20H,20H
	DEFB 20H,20H,48H,65H,6CH,6CH,6FH,20H,53H,49H
	DEFB 47H,4DH,55H,53H,00H,53H,20H,20H,20H,20H
	DEFB 48H,65H,6CH,6CH,6FH,20H,53H,49H,47H,4DH
	DEFB 55H,00H,55H,53H,20H,20H,20H,20H,48H,65H
	DEFB 6CH,6CH,6FH,20H,53H,49H,47H,4DH,00H,4DH
	DEFB 55H,53H,20H,20H,20H,20H,48H,65H,6CH,6CH
	DEFB 6FH,20H,53H,49H,47H,00H,47H,4DH,55H,53H
	DEFB 20H,20H,20H,20H,48H,65H,6CH,6CH,6FH,20H
	DEFB 53H,49H,00H,49H,47H,4DH,55H,53H,20H,20H
	DEFB 20H,20H,48H,65H,6CH,6CH,6FH,20H,53H,00H
	DEFB 28H,5EH,5FH,5EH,3BH,29H,20H,20H,20H,20H
	DEFB 48H,65H,6CH,6CH,6FH,20H,00H,20H,53H,49H
	DEFB 47H,4DH,55H,53H,20H,20H,20H,20H,48H,65H
	DEFB 6CH,6CH,6FH,00H,6FH,20H,53H,49H,47H,4DH
	DEFB 55H,53H,20H,20H,20H,20H,48H,65H,6CH,6CH
	DEFB 00H,6CH,6FH,20H,53H,49H,47H,4DH,55H,53H
	DEFB 20H,20H,20H,20H,48H,65H,6CH,00H,6CH,6CH
	DEFB 6FH,20H,53H,49H,47H,4DH,55H,53H,20H,20H
	DEFB 20H,20H,48H,65H,00H,65H,6CH,6CH,6FH,20H
	DEFB 53H,49H,47H,4DH,55H,53H,20H,20H,20H,20H
	DEFB 48H,00H
;midi_display(){
__midi_display:
;	if( midi > 127 ){
	LD HL,(__midi)
	PUSH HL
	LD HL,7FH
	CALL mc_gt
	LD A,H
	OR L
	JP Z,mc_85
;		if( midi > 0xef ) rsb = 0;
	LD HL,(__midi)
	PUSH HL
	LD HL,0EFH
	CALL mc_gt
	LD A,H
	OR L
	JP Z,mc_86
	LD HL,00H
	LD (__rsb),HL
;		else{
	JP mc_87
mc_86:
;			rsb = midi & 0xf0;
	LD HL,(__midi)
	PUSH HL
	LD HL,0F0H
	CALL mc_and
	LD (__rsb),HL
;			channel = midi & 0x0f;
	LD HL,(__midi)
	PUSH HL
	LD HL,0FH
	CALL mc_and
	LD (__channel),HL
;			dcb = 0;
	LD HL,00H
	LD (__dcb),HL
;		}
mc_87:
;	}
;	else{
	JP mc_88
mc_85:
;		if( rsb == 0 ){}
	LD HL,(__rsb)
	PUSH HL
	LD HL,00H
	CALL mc_eq
	LD A,H
	OR L
	JP Z,mc_89
;		else if( (rsb == 0xc0) || (rsb == 0xd0) ){
	JP mc_90
mc_89:
	LD HL,(__rsb)
	PUSH HL
	LD HL,0C0H
	CALL mc_eq
	PUSH HL
	LD HL,(__rsb)
	PUSH HL
	LD HL,0D0H
	CALL mc_eq
	CALL mc_oror
	LD A,H
	OR L
	JP Z,mc_91
;			disp_hex( 7, rsb+channel );
	LD HL,07H
	PUSH HL
	LD HL,(__rsb)
	PUSH HL
	LD HL,(__channel)
	POP DE
	ADD HL,DE
	PUSH HL
	CALL __disp_hex
	POP BC
	POP BC
;			disp_hex( 10, midi );
	LD HL,0AH
	PUSH HL
	LD HL,(__midi)
	PUSH HL
	CALL __disp_hex
	POP BC
	POP BC
;			disp_string( 13, "  ");
	LD HL,0DH
	PUSH HL
	LD HL,mc_84+00H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
;		}
;		else{
	JP mc_92
mc_91:
;			if( dcb == 0 ){
	LD HL,(__dcb)
	PUSH HL
	LD HL,00H
	CALL mc_eq
	LD A,H
	OR L
	JP Z,mc_93
;				keyno = midi;
	LD HL,(__midi)
	LD (__keyno),HL
;				dcb = 1;
	LD HL,01H
	LD (__dcb),HL
;			}
;			else{
	JP mc_94
mc_93:
;				dcb = 0;
	LD HL,00H
	LD (__dcb),HL
;				if( (rsb==0x90) && (midi!=0) ){
	LD HL,(__rsb)
	PUSH HL
	LD HL,90H
	CALL mc_eq
	PUSH HL
	LD HL,(__midi)
	PUSH HL
	LD HL,00H
	CALL mc_ne
	CALL mc_andand
	LD A,H
	OR L
	JP Z,mc_95
;					disp_hex( 7, rsb+channel );
	LD HL,07H
	PUSH HL
	LD HL,(__rsb)
	PUSH HL
	LD HL,(__channel)
	POP DE
	ADD HL,DE
	PUSH HL
	CALL __disp_hex
	POP BC
	POP BC
;					disp_hex( 10, keyno );
	LD HL,0AH
	PUSH HL
	LD HL,(__keyno)
	PUSH HL
	CALL __disp_hex
	POP BC
	POP BC
;					disp_hex( 13, midi );
	LD HL,0DH
	PUSH HL
	LD HL,(__midi)
	PUSH HL
	CALL __disp_hex
	POP BC
	POP BC
;				}
;			}
mc_95:
mc_94:
;		}
mc_92:
mc_90:
;	}
mc_88:
;}
	RET
mc_84:	DEFB 20H,20H,00H
;main(){
__main:
;	int timer,t;
	PUSH BC
	PUSH BC
;	t = 0;
	LD HL,00H
	ADD HL,SP
	PUSH HL
	LD HL,00H
	CALL mc_pint
;	initial();
	CALL __initial
;	disp_string( 0, "MIDI =          ");
	LD HL,00H
	PUSH HL
	LD HL,mc_96+00H
	PUSH HL
	CALL __disp_string
	POP BC
	POP BC
;	while(1){
mc_97:
	LD HL,01H
	LD A,H
	OR L
	JP Z,mc_98
;		tx_midi_check();
	CALL __tx_midi_check
;		lcd_disp_check();
	CALL __lcd_disp_check
;		midi = rx_midi_check();
	CALL __rx_midi_check
	LD (__midi),HL
;		if( midi < 256 ){
	LD HL,(__midi)
	PUSH HL
	LD HL,0100H
	CALL mc_lt
	LD A,H
	OR L
	JP Z,mc_99
;			tx_midi_set( midi );
	LD HL,(__midi)
	PUSH HL
	CALL __tx_midi_set
	POP BC
;			midi_display( midi );
	LD HL,(__midi)
	PUSH HL
	CALL __midi_display
	POP BC
;		}
;		if( ram_get(timer_flag) != 0){
mc_99:
	LD HL,9100H
	PUSH HL
	LD HL,02H
	PUSH HL
	LD HL,04H
	CALL mc_mult
	POP DE
	ADD HL,DE
	PUSH HL
	CALL __ram_get
	POP BC
	PUSH HL
	LD HL,00H
	CALL mc_ne
	LD A,H
	OR L
	JP Z,mc_100
;			ram_put( timer_flag, 0 );
	LD HL,9100H
	PUSH HL
	LD HL,02H
	PUSH HL
	LD HL,04H
	CALL mc_mult
	POP DE
	ADD HL,DE
	PUSH HL
	LD HL,00H
	PUSH HL
	CALL __ram_put
	POP BC
	POP BC
;			timer++;
	LD HL,02H
	ADD HL,SP
	PUSH HL
	CALL mc_gint
	INC HL
	CALL mc_pint
	DEC HL
;			if( timer > 50 ){
	LD HL,02H
	ADD HL,SP
	CALL mc_gint
	PUSH HL
	LD HL,32H
	CALL mc_gt
	LD A,H
	OR L
	JP Z,mc_101
;				timer = 0;
	LD HL,02H
	ADD HL,SP
	PUSH HL
	LD HL,00H
	CALL mc_pint
;				line_disp(t++);
	LD HL,00H
	ADD HL,SP
	PUSH HL
	CALL mc_gint
	INC HL
	CALL mc_pint
	DEC HL
	PUSH HL
	CALL __line_disp
	POP BC
;			}
;		}
mc_101:
;	}
mc_100:
	JP mc_97
mc_98:
;}
	POP BC
	POP BC
	RET
mc_96:	DEFB 4DH,49H,44H,49H,20H,3DH,20H,20H,20H,20H
	DEFB 20H,20H,20H,20H,20H,20H,00H
	ORG	RAM_TOP
__channel:	DEFS 02H
__midi:	DEFS 02H
__i:	DEFS 02H
__j:	DEFS 02H
__k:	DEFS 02H
__l:	DEFS 02H
__m:	DEFS 02H
__n:	DEFS 02H
__dcb:	DEFS 02H
__keyno:	DEFS 02H
__rsb:	DEFS 02H

	END
;; --- End of Compilation ---
