CON
  _clkmode = xtal1 + pll8x      'Use the PLL to multiple the external clock by 8
  _xinfreq = 8_000_000          'An external clock of 8MHz. is used (64MHz. operation)
  _OUTPUT       = 1             'Sets pin to output in DIRA register
  _INPUT        = 0             'Sets pin to input in DIRA register  
  _HIGH         = 1             'High=ON=1=3.3v DC
  _ON           = 1
  _LOW          = 0             'Low=OFF=0=0v DC
  _OFF          = 0
  _ENABLE       = 1             'Enable (turn on) function/mode
  _DISABLE      = 0             'Disable (turn off) function/mode
  _xpixels      = 96                                    'Screen width
  _ypixels      = 64                                    'Screen height          
  _pixelperlong = 4                                     'Each tile requires 4 longs
  _xtiles       = _xpixels/_pixelperlong                'Each tile is 4 pixels x 4 pixels
  _ytiles       = _ypixels/_pixelperlong                                        
  _screensize   = (_xtiles * _ytiles * _pixelperlong)   'Size needed for arrays
  _red          = %11100000
  _green        = %00011100
  _blue         = %00000011
  _yellow       = %11111100
  _purple       = %11100011
  _turq         = %00011111
  _white        = %11111111
  _black        = %00000000

VAR
  long MemDisp[_screensize]     'OLED display driver variables 
  long MemWork[_screensize]     'graphics driver variables  

OBJ
  OLED          : "OLED-Driver1"
  Graphics      : "OLED-Driver2"
  midiIn        : "XBee_In2"
  midiOut       : "XBee_Out"

PUB main | dummy, i[3], num, d, x, y, color, x0, y0, x1, y1, x_0, y_0, x_1, y_1, c_x, c_y, r
  OLED.start(@MemDisp)
  Graphics.setup(_xtiles, _ytiles, @MemWork)
  midiIn.start(21)
  midiOut.start(20)
  num := 0
  repeat
    i[0] := cnt & $8000000
    if i[0] <> i[1]
      i[1] := i[0]
      num := ++num & 127
      dummy := $C00000 + num
      midiOut.fifoset(dummy)
    dummy := midiIn.event
    if dummy <> -1
      d := (dummy & $FF0000) >> 16
      if d == $FF
        Graphics.clear
        Graphics.copy(@MemDisp)
      elseif d < $E0
        x := d & $7F
        d := (dummy & $007F00) >> 8
        y := d & $3F
        color := d & $40
        d := dummy & $00007F
        color := color + d
        Graphics.plotPixel(x, y, color)
        Graphics.copy(@MemDisp)
      elseif d == $E0
        color := dummy & $00007F
        d := (dummy & $000100) >> 1
        color := color + d
      elseif d == $E1
        x0 := (dummy & $007F00) >> 8
        y0 := dummy & $00003F
      elseif d == $E2
        x1 := (dummy & $007F00) >> 8
        y1 := dummy & $00003F
        Graphics.plotLine(x0, y0, x1, y1, color)
        Graphics.copy(@MemDisp)
        x0 := x1
        y0 := y1
      elseif d == $E3
        x1 := (dummy & $007F00) >> 8
        y1 := dummy & $00003F
        Graphics.plotLine(x0, y0, x1, y1, color)
        Graphics.copy(@MemDisp)
      elseif d == $E4
        x_0 := (dummy & $007F00) >> 8
        y_0 := dummy & $00003F
      elseif d == $E5
        x_1 := (dummy & $007F00) >> 8
        y_1 := dummy & $00003F
        Graphics.plotLine(x_0, y_0, x_1, y_0, color)
        Graphics.plotLine(x_0, y_0, x_0, y_1, color)
        Graphics.plotLine(x_1, y_0, x_1, y_1, color)
        Graphics.plotLine(x_0, y_1, x_1, y_1, color)
        Graphics.copy(@MemDisp)
      elseif d == $E6
        x_1 := (dummy & $007F00) >> 8
        y_1 := dummy & $00003F
        y := y_1 - y_0
        repeat while y > 0
          Graphics.plotLine(x_0, y_0+y, x_1, y_0+y, color)
          y--
        Graphics.copy(@MemDisp)
      elseif (d == $E7) OR (d == $EF)
        c_x := (dummy & $007F00) >> 8
        c_y := dummy & $00003F
      elseif d == $E8
        r := (dummy & $007F00) >> 8
        Graphics.plotCircle(c_x, c_y, r, color)
        Graphics.copy(@MemDisp)
      elseif (d == $E9) OR (d == $F1)
        r := (dummy & $007F00) >> 8
      elseif d == $EA
        c_x := (dummy & $007F00) >> 8
        c_y := dummy & $00003F
        Graphics.plotCircle(c_x, c_y, r, color)
        Graphics.copy(@MemDisp)
      elseif d == $F0
        r := (dummy & $007F00) >> 8
        repeat while r > 0
          Graphics.plotCircle(c_x, c_y, r, color)
          r--
        Graphics.copy(@MemDisp)
      elseif d == $F2
        c_x := (dummy & $007F00) >> 8
        c_y := dummy & $00003F
        repeat while r > 0
          Graphics.plotCircle(c_x, c_y, r, color)
          r--
        Graphics.copy(@MemDisp)
PRI pauseMSec(Duration)
  waitcnt(((clkfreq / 1_000 * Duration - 3932) #> 381) + cnt)

