#include <stdio.h>
#include <stdlib.h>
#include <bcm2835.h>

int assign[15] = {17,18,27,22,23,24,25,4,2,3,10,9,11,8,7};
FILE *fp;
char s[134];

void GPIO_out(int data, int mode){
	int i;
	mode = mode & 1;	// mode=0 : active high / mode=1 : active low
	data = data & 255;
	for (i=0; i<8; i++) {
		bcm2835_gpio_write( assign[i], ( ( (data >>i) & 1) ^ mode ) );
	}
}

void Select_out(int data){
	int i;
	data = data & 7;
	for (i=0; i<3; i++) {
		bcm2835_gpio_write( assign[i+10], ( (data >>i) & 1)  );
	}
	bcm2835_gpio_write( assign[13], 0 );
	bcm2835_gpio_write( assign[13], 1 );
}

void data_file_read(){
	int i;
	if ((fp = fopen("/media/ramdisk/test.txt", "rb")) == NULL) {
		printf("\nread error!!\n");
	}
	else{
		for(i=0; i<132; i++){
			s[i] = fgetc(fp);
		}
		s[132] = 0;	
		fclose(fp);
	}
}

int asc_2_int(char s){
	char c;
	if ('0' <= s && s <= '9')
		return(s - '0');
	else if ('a' <= (c = tolower(s)) && c <= 'f')
		return(c - 'a' + 10);
}

int main(void)
{
	int i, j, get_data, bit_data, put_data;

	if (!bcm2835_init()){
		printf("GPIO is not found.\n");
		return 1;
	}
	for (i=0; i<15; i++){
		bcm2835_gpio_fsel(assign[i], BCM2835_GPIO_FSEL_OUTP);
	}
	while(1){
		data_file_read();
		for (j=0; j<8; j++) {
			put_data = 0;
			for (i=0; i<8; i++) {
				get_data =16*asc_2_int(s[2*(8*j+i)+2]);
				get_data = get_data + asc_2_int(s[2*(8*j+i)+3]);
				if(get_data<128)
					bit_data = 0;
				else
					bit_data = 1;
				put_data = put_data + (bit_data<<i);
			}
			GPIO_out(put_data, 0);
			Select_out(j);
		}
	}
	bcm2835_close();
	printf("...normally finished.(^_^) \n");
	return 0;
}
