#include <stdio.h>
#include <stdlib.h>
#include <bcm2835.h>

int assign[15] = {17,18,27,22,23,24,25,4,2,3,10,9,11,8,7};
FILE *fp;
char s[134];
int PWM_data[64];

void GPIO_out(int data, int mode){
	int i;
	mode = mode & 1;	// mode=0 : active high / mode=1 : active low
	data = data & 255;
	for (i=0; i<8; i++) {
		bcm2835_gpio_write( assign[i], ( ( (data >>i) & 1) ^ mode ) );
	}
}

void Select_out(int data){
	int i;
	data = data & 7;
	for (i=0; i<3; i++) {
		bcm2835_gpio_write( assign[i+10], ( (data >>i) & 1)  );
	}
	bcm2835_gpio_write( assign[13], 0 );
	bcm2835_gpio_write( assign[13], 1 );
}

int asc_2_int(char s){
	char c;
	if ('0' <= s && s <= '9'){
		return(s - '0');
	}
	else if ('a' <= (c = tolower(s)) && c <= 'f'){
		return(c - 'a' + 10);
	}
}

void data_file_read(){
	int i, j;
	if ((fp = fopen("/media/ramdisk/test.txt", "rb")) == NULL) {
		for(i=0; i<64; i++){
			PWM_data[i] = 0;
		}
	}
	else{
		for(i=0; i<132; i++){
			s[i] = fgetc(fp);
		}
		s[132] = 0;	
		fclose(fp);
		for (j=0; j<8; j++) {
			for (i=0; i<8; i++) {
				PWM_data[8*j+i]  = 16*asc_2_int(s[2*(8*j+i)+2])  + asc_2_int(s[2*(8*j+i)+3]);
			}
		}
	}
}

int main(int argc, char *argv[])
{
	int i, j, bit_data, put_data;
	int interval = 0;
	int current_value = 0;
	int RADdisk_access = 200;

	if (!bcm2835_init()){
		printf("GPIO is not found.\n");
		return 1;
	}
	if(argc > 1){
		RADdisk_access = atoi(argv[1]);
	}
	for (i=0; i<15; i++){
		bcm2835_gpio_fsel(assign[i], BCM2835_GPIO_FSEL_OUTP);
	}
	while(1){
		if(++interval > RADdisk_access){
			interval = 0;
			data_file_read();
		}
		if (++current_value > 255){
			current_value = 0;
		}
		for (j=0; j<8; j++) {
			put_data = 0;
			for (i=0; i<8; i++) {
				if(PWM_data[8*j+i] < current_value){
					bit_data = 0;
				}
				else{
					bit_data = 1;
				}
				put_data = put_data + (bit_data<<i);
			}
			GPIO_out(put_data, 0);
			Select_out(j);
		}
	}
	bcm2835_close();
	printf("...normally finished.(^_^) \n");
	return 0;
}
