autowatch = 1;

var buf_win_pr = new Buffer("buf_win_pr");

// wavetable sample number
var len = 1024;
// total wave number
var chan = 128;

function bang(){

    // set buffer size
    buf_win_pr.send("sizeinsamps", len);

    // square ⇆ hann
    for(var i=0; i<chan; i++){
        var check_1 = i*len/(2*chan);
        var check_2 = len - check_1;
        var rate = 1 - 0.6*Math.pow(i/(chan - 1), 0.2);
        for(var j=0; j<len; j++){
            if(j < check_1){
                var val = 0.5 - 0.5*Math.cos(Math.PI*j/check_1);
            }
            else if(j >= check_1 && j < check_2){
                var val = 1;
            }
            else{
                var val = 0.5 - 0.5*Math.cos(2*Math.PI*((j-check_2)/(2*check_1) + 0.5));
            }
            buf_win_pr.poke(chan-i, j, val*rate);
        }
    }


}

function wrap(x, l, u){
    return ((Math.abs(x)+l)%(u-l+1) + l);
}

//log function
function log(message) {
    for(var i=0, len=arguments.length; i<len; i++) {
        var message = arguments[i];
        if(message && message.toString) {
            var s = message.toString();
            if(s.indexOf("[object ") >= 0) {
                s = JSON.stringify(message);
            }
            post(s);
        }
        else if(message===null) {
            post("<null>");
        }
        
        else {
            post(message);
        }
    }
    post("\n");
}


