include("utility-function.js");
autowatch = 1;
outlets = 1;

// jsui init
mgraphics.init();
mgraphics.relative_coords = 0;
mgraphics.autofill = 0;

// jsui
var w = this.box.rect[2] - this.box.rect[0];
var h = w;

// color
var borderC = [0.652, 0.666, 0.663, 1];
var yellow = [0.96, 0.83, 0.15, 1];
var grayC = [0.325, 0.345, 0.372, 1];
var blue = [0.318, 0.654, 0.976, 1];
var offwhite = [0.831373, 0.835294, 0.890196, 0.9];

// mouse state 
var mPos = [0, 0];
var sPos = [0, 0];
var posX = [];
var posY = [];
var dragState = 0;

// xyRange 
var val_x = 50;
var val_y = 50;
var val_xRange = 0;
var val_yRange = 0;
var initVal = [0, 0];
var scaleFactor = 0.92;

function paint(){

    var pointerR = 5;
    var coordPointerX = w*((scaleFactor-0.01)*val_x/100 + (1 - scaleFactor)/2);
    var coordPointerY = w*(1 - (scaleFactor*val_y/100 + (1 - (scaleFactor+0.005))/2));
    var coordRangeX = w*val_xRange/100;
    var coordRangeY = h*val_yRange/100;

     
    //draw range rectangle
    mgraphics.set_source_rgba(grayC[0], grayC[1], grayC[2], 0.3);
    mgraphics.rectangle_rounded(coordPointerX - coordRangeX/2, coordPointerY - coordRangeY/2, coordRangeX, coordRangeY, 10, 10);
    mgraphics.fill();

    //draw circular pointer
    mgraphics.set_line_width(1.);
    mgraphics.set_source_rgba(grayC[0], grayC[1], grayC[2], grayC[3]);
    mgraphics.arc(coordPointerX, coordPointerY, pointerR, 0, 2*Math.PI);
    if(dragState == 0) {
        mgraphics.stroke();
    } else {
        mgraphics.fill();
    }
    
    //draw xy range line
    mgraphics.set_line_width(1);
    mgraphics.set_source_rgba(yellow[0],yellow[1],yellow[2],yellow[3]);
    mgraphics.move_to(coordPointerX, coordPointerY - coordRangeY/2);
    mgraphics.line_to(coordPointerX, coordPointerY + coordRangeY/2);
    mgraphics.stroke();
    //mgraphics.set_line_width(1);
    mgraphics.set_source_rgba(blue[0], blue[1], blue[2], blue[3]);
    mgraphics.move_to(coordPointerX - coordRangeX/2, coordPointerY);
    mgraphics.line_to(coordPointerX + coordRangeX/2, coordPointerY);
    mgraphics.stroke();

}

function onclick(x, y, click, cmd, shift, caps, opt){

	if(click == 1){
		max.message("hidecursor");
		sPos = [mPos[0], mPos[1]];
        initVal = [val_x, val_y];
        dragState = 1;
	}

    posX.unshift(x);
    posY.unshift(y);

    mgraphics.redraw()
}


function ondrag(x, y, click, cmd, shift, caps, opt){

    // show cursor
    if(click == 0){
        max.message("showcursor");
        max.message("pupdate", sPos[0] + (val_x - initVal[0])/100*w*scaleFactor, sPos[1] - (val_y - initVal[1])/100*h*scaleFactor);
        dragState = 0;
        mgraphics.redraw();
        return;
    }

    // fill pointer while dragging
    dragState = click;

    posX.unshift(x);
    posY.unshift(y);
    posX = posX.slice(0, 2);
    posY = posY.slice(0, 2);
    var diffY = (sPos[1] - mPos[1]);
    var diffX = (sPos[0] - mPos[0]);

    if(cmd == 0) {

        val_x -= diffX;
        val_x = clip(val_x, 0, 100);

        val_y += diffY;
        val_y = clip(val_y, 0, 100);

    } else {

        val_xRange -= diffX/1.5;
        val_xRange = clip(val_xRange, 0, 100);

        val_yRange += diffY/1.5;
        val_yRange = clip(val_yRange, 0, 100);

    }

    outlet(0, "x", val_x);
    outlet(0, "y", val_y);
    outlet(0, "xRange", val_xRange);
    outlet(0, "yRange", val_yRange);
    max.message("pupdate",sPos[0],sPos[1]);
	mgraphics.redraw();
}

function ondblclick(x, y, click, cmd, shift, caps, opt, cnt){

    val_x = 50;
    val_y = 50;

    val_xRange = 0;
    val_yRange = 0;
    

    outlet(0, "x", val_x);
    outlet(0, "y", val_y);
    outlet(0, "xRange", val_xRange);
    outlet(0, "yRange", val_yRange);

    mgraphics.redraw();
}

function set_mPos(){
	mPos[0] = arrayfromargs(arguments)[0];
	mPos[1] = arrayfromargs(arguments)[1];
}

function set_x(val){
    val_x = val;
}

function set_y(val){
    val_y = val;
}

function set_xRange(val){
    val_xRange = val;
}

function set_yRange(val){
    val_yRange = val;
}

function draw(){
    mgraphics.redraw();
}
