
const ndegrees = 300;
const magicmath = 0.01745329251994;

// color setting from live.dial attr
var activedialcolor = box.getattr("activedialcolor");
var dialcolor = box.getattr("dialcolor");
var activeneedlecolor = box.getattr("activeneedlecolor");
var needlecolor = box.getattr("needlecolor");
var activefgdialcolor = box.getattr("activefgdialcolor");
var fgdialcolor = box.getattr("fgdialcolor");

var displayMode = box.getattr("appearance"); //0:vertical 1:tiny 2:panel 3:large
var displayName = box.getattr("showname");
var displayParam = box.getattr("shownumber")
var triangle = box.getattr("triangle");
var exponent = 1 / box.getattr("_parameter_exponent"); //exponential
var type = box.getattr("_parameter_type");

// my dial
var yellow = [0.96, 0.83, 0.15, 1];
var gray = [0.325, 0.345, 0.372, 1];
var blue = [0.318, 0.654, 0.976, 1];
var offwhite = [0.831373, 0.835294, 0.890196, 0.9];
var offblack = [0.12, 0.12, 0.12, 1];
var white = [1, 1, 1, 1];
var startDeg = 1/3.8*Math.PI;
var endDeg = Math.PI - startDeg;
var degRange = 2*Math.PI - (endDeg - startDeg);
var scaleFactor = 0.8;
var initialVal = box.getattr("_parameter_initial");


function paint() {

    //PARAM
    var w = mgraphics.size[0];
    var h = mgraphics.size[1];
	var range = box.getattr("_parameter_range");
    var valRange = (type != null && type != 2) ? range[1] - range[0] : range.length - 1;
    var val = (type != null && type != 2) ? box.getvalueof() - range[0] : parseFloat(box.getvalueof());
    var valExp = Math.pow(val / valRange, exponent) * valRange;

    //COLOR
    var color = (box.getattr("active")) ? activedialcolor : dialcolor;
    var nColor = (box.getattr("active")) ? activeneedlecolor : needlecolor;

    //DISPLAY MODE
    switch (displayMode) {

        case 0: //vertical
            var arcR = 12;
            var arcLineWidth = 1.5;
            var needleLineWidth = 3.5;
            var needleLenFric = 1.08;
            var triangleOffset = triangle*(2 - (5*displayName + 8*displayParam));
            var arcCenterX = w/2;
            var arcCenterY = 15 + 15*displayName + 10*displayParam + triangleOffset;
            break;

        case 1: //tiny
            var arcR = 10;
            var arcLineWidth = 1.5;
            var needleLineWidth = 2.5;
            var needleLenFric = 1.06;5
            var triangleOffset = 0;
            var arcCenterX = 13;
            var arcCenterY = 13 + 7*displayName + 3*displayParam + triangleOffset;
            break;

        case 2: //panel
            var arcR = 17;
            var arcLineWidth = 2.5;
            var needleLineWidth = 5;
            var arcCenterX = w/2;
            var arcCenterY = 56;
            var needleLenFric = 1.06;
            break;

        case 3: //large
            var arcR = 22;
            var arcLineWidth = 2.5;
            var needleLineWidth = 5;
            var needleLenFric = 1.07;
            var triangleOffset = 5 -5*(displayName + displayParam);
            var arcCenterX = w/2;
            var arcCenterY = 15 + 9*(displayName + displayParam) + triangleOffset;
            break;
    }
    

    //DRAW BG PANEL
    mgraphics.set_source_rgba(activefgdialcolor);
    mgraphics.arc(arcCenterX, arcCenterY, arcR - arcLineWidth*0.5, 0, 2*Math.PI);
    mgraphics.fill();

    /*
    //DRAW BG DIAL
    mgraphics.set_line_width(arcLineWidth);
    mgraphics.set_source_rgba(activefgdialcolor);
    mgraphics.arc_negative(arcCenterX, arcCenterY, arcR, startDeg, endDeg);
    mgraphics.stroke();
    */

    //DRAW FRONT DIAL
    var ratio = valExp/valRange;
    var startDegScaled = startDeg - degRange*(1 - ratio);
    var endDegScaled = endDeg;
    mgraphics.set_line_width(arcLineWidth);
    mgraphics.set_source_rgba(color);
    if(triangle == 0) {

        mgraphics.arc_negative(arcCenterX, arcCenterY, arcR, startDegScaled, endDegScaled);

    } else {

        if(startDegScaled > -Math.PI/2) {

            mgraphics.arc(arcCenterX, arcCenterY, arcR, -Math.PI/2, startDegScaled);

        } else {

            mgraphics.arc_negative(arcCenterX, arcCenterY, arcR, -Math.PI/2, startDegScaled);

        }
    }
    mgraphics.stroke();

    if(triangle) {

        // triangle color
        if(initialVal == val) {
            //mgraphics.set_source_rgba(activefgdialcolor);
        } else {
            mgraphics.set_source_rgba(color);
            switch(displayMode) {

                case 0: //vertical
                    var triW = 1.5;
                    var triStartY = arcCenterY - arcR;
                    /*
                    mgraphics.move_to(arcCenterX, triStartY);
                    mgraphics.line_to(arcCenterX + triW, triStartY - triW/1.2);
                    mgraphics.line_to(arcCenterX - triW, triStartY - triW/1.2);
                    mgraphics.line_to(arcCenterX, triStartY);
                    */
                    //mgraphics.rectangle(arcCenterX -triW/2, triStartY, triW, triW);
                    mgraphics.arc(arcCenterX, triStartY, triW, 0, Math.PI*2);
                    mgraphics.fill();
                    break;
    
            }
        }
    }

    //DRAW NEEDLE
    var needleX = arcR*Math.cos(startDegScaled, endDegScaled)*needleLenFric;
    var needleY = arcR*Math.sin(startDegScaled, endDegScaled)*needleLenFric;
    mgraphics.set_source_rgba(nColor);
    mgraphics.set_line_width(needleLineWidth);
    mgraphics.move_to(arcCenterX, arcCenterY);
    mgraphics.line_to(arcCenterX + needleX, arcCenterY + needleY);
    mgraphics.stroke();

    //DRAW dial circle
    mgraphics.arc(arcCenterX, arcCenterY, arcR*0.7, 0, 2*Math.PI);
    mgraphics.fill();

}
