#ifndef BLAHBLAH4B_H_
#define BLAHBLAH4B_H_
 
#if ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif
#include "mozzi_pgmspace.h"
 
#define BLAHBLAH4B_NUM_CELLS 22569
#define BLAHBLAH4B_SAMPLERATE 16384
 
CONSTTABLE_STORAGE(int8_t) BLAHBLAH4B_DATA [] = {   -1, 2, 6, 9, 12, 15, 17, 20, 22, 25, 28, 30,
32, 34, 37, 38, 40, 42, 44, 46, 47, 49, 50, 52, 53, 53, 54, 55, 55, 55, 54, 54,
53, 51, 48, 46, 42, 38, 34, 29, 25, 20, 15, 10, 5, -1, -6, -11, -16, -21, -25,
-29, -33, -37, -40, -43, -47, -50, -52, -55, -57, -58, -59, -59, -59, -59, -58,
-57, -56, -55, -54, -53, -51, -50, -48, -45, -42, -39, -35, -32, -27, -23, -18,
-14, -9, -5, -1, 3, 7, 10, 13, 16, 19, 22, 25, 28, 30, 33, 36, 38, 40, 43, 45,
47, 49, 51, 53, 54, 56, 57, 57, 58, 58, 58, 58, 58, 57, 56, 55, 52, 49, 46, 41,
37, 33, 28, 23, 17, 12, 7, 1, -5, -10, -15, -20, -25, -30, -34, -38, -42, -46,
-49, -52, -55, -57, -59, -61, -62, -63, -62, -62, -61, -60, -59, -58, -57, -56,
-54, -52, -51, -48, -45, -42, -38, -34, -31, -26, -22, -18, -13, -9, -5, -1, 3,
6, 9, 12, 15, 18, 21, 24, 27, 29, 32, 34, 37, 39, 41, 43, 45, 47, 49, 51, 53,
55, 56, 57, 59, 59, 59, 59, 58, 58, 57, 55, 53, 50, 47, 43, 38, 34, 29, 24, 19,
15, 9, 4, -2, -8, -13, -18, -24, -28, -32, -37, -40, -44, -47, -50, -54, -56,
-59, -61, -62, -64, -64, -64, -63, -62, -61, -60, -58, -58, -57, -55, -53, -50,
-48, -45, -42, -39, -35, -31, -27, -22, -22, -17, -8, -2, 4, 8, 12, 14, 17, 21,
23, 25, 28, 30, 32, 36, 39, 42, 44, 45, 46, 48, 50, 51, 53, 54, 56, 58, 58, 60,
60, 59, 59, 57, 55, 53, 51, 49, 46, 42, 39, 35, 29, 24, 19, 13, 8, 2, -4, -10,
-15, -20, -27, -31, -33, -39, -41, -45, -49, -50, -55, -56, -59, -61, -62, -64,
-64, -63, -62, -61, -59, -58, -54, -52, -50, -47, -44, -42, -42, -41, -39, -37,
-35, -34, -33, -30, -23, -15, -8, -2, 4, 6, 8, 11, 13, 16, 22, 26, 27, 27, 27,
28, 29, 29, 30, 33, 36, 40, 44, 47, 49, 49, 48, 48, 47, 46, 47, 48, 51, 53, 55,
56, 57, 56, 53, 49, 43, 39, 34, 30, 26, 22, 19, 17, 14, 9, 3, -2, -8, -14, -22,
-28, -32, -36, -38, -39, -41, -41, -43, -46, -49, -52, -55, -58, -60, -61, -59,
-58, -57, -55, -52, -50, -51, -51, -50, -49, -48, -47, -46, -42, -37, -34, -29,
-24, -20, -16, -12, -10, -7, -3, 0, 3, 6, 10, 14, 17, 20, 23, 26, 28, 29, 31,
33, 35, 36, 39, 42, 44, 47, 48, 50, 52, 53, 53, 54, 54, 55, 56, 56, 56, 56, 56,
54, 51, 47, 42, 37, 33, 29, 24, 19, 15, 10, 6, 0, -5, -10, -15, -21, -27, -33,
-37, -40, -42, -45, -48, -48, -50, -53, -55, -56, -57, -59, -60, -60, -58, -57,
-56, -55, -53, -52, -54, -53, -49, -48, -46, -48, -48, -48, -52, -43, -28, -21,
-14, -17, -20, -9, 0, 7, 14, 14, 13, 15, 21, 29, 34, 33, 32, 32, 32, 37, 44, 46,
46, 46, 45, 46, 49, 55, 56, 55, 55, 51, 49, 52, 54, 57, 58, 56, 55, 54, 52, 50,
48, 44, 35, 28, 23, 17, 13, 10, 5, -2, -11, -20, -26, -27, -33, -41, -44, -51,
-59, -62, -64, -65, -65, -66, -68, -70, -68, -67, -66, -63, -65, -59, -54, -57,
-52, -41, -38, -41, -43, -38, -32, -32, -31, -27, -23, -20, -23, -24, -12, -3,
0, 7, 11, 11, 14, 13, 17, 22, 16, 15, 20, 23, 28, 34, 38, 43, 40, 37, 37, 38,
44, 47, 47, 48, 47, 48, 51, 53, 57, 56, 54, 55, 56, 55, 55, 54, 54, 50, 43, 40,
39, 36, 32, 26, 16, 7, 0, -7, -14, -19, -23, -29, -38, -47, -52, -60, -65, -72,
-80, -84, -86, -87, -85, -86, -83, -84, -86, -82, -79, -73, -64, -57, -41, -30,
-32, -27, -15, -5, -6, -10, 0, 12, 16, 15, 19, 30, 33, 28, 29, 31, 31, 31, 21,
17, 17, 15, 18, 19, 22, 20, 17, 19, 19, 17, 14, 8, 8, 11, 11, 10, 8, 15, 21, 16,
10, 15, 24, 23, 18, 24, 30, 29, 30, 35, 37, 36, 37, 38, 40, 40, 37, 40, 43, 40,
34, 30, 27, 26, 19, 13, 9, 4, -1, -9, -15, -18, -28, -34, -37, -48, -54, -58,
-61, -60, -67, -71, -72, -72, -70, -77, -76, -70, -69, -68, -66, -60, -52, -42,
-33, -35, -32, -20, -14, -14, -15, -6, 6, 8, 7, 13, 22, 28, 26, 29, 36, 32, 32,
37, 40, 41, 39, 42, 48, 46, 42, 36, 33, 34, 30, 26, 23, 22, 26, 25, 19, 14, 16,
21, 13, 9, 16, 19, 16, 13, 18, 21, 14, 17, 21, 20, 20, 21, 27, 31, 26, 26, 26,
25, 24, 20, 18, 16, 14, 11, 5, 3, 0, -7, -10, -16, -20, -28, -33, -33, -39, -43,
-50, -53, -51, -58, -61, -60, -61, -61, -62, -63, -60, -60, -58, -53, -53, -52,
-48, -37, -25, -25, -24, -11, -1, -1, -3, 2, 13, 17, 18, 19, 24, 33, 36, 37, 38,
38, 37, 38, 39, 39, 39, 41, 41, 39, 38, 33, 29, 28, 25, 23, 18, 16, 18, 18, 14,
8, 4, 9, 14, 6, 1, 10, 18, 14, 8, 11, 16, 15, 15, 18, 19, 21, 25, 28, 31, 28,
23, 25, 28, 23, 15, 12, 19, 20, 10, 3, 1, -2, -7, -16, -22, -27, -30, -31, -37,
-46, -51, -52, -53, -57, -63, -66, -64, -62, -63, -65, -65, -61, -57, -56, -57,
-54, -51, -46, -40, -35, -24, -17, -15, -5, 4, 7, 2, 5, 20, 27, 24, 25, 31, 43,
46, 39, 39, 44, 44, 41, 38, 40, 42, 42, 43, 39, 35, 31, 26, 24, 23, 18, 14, 12,
13, 13, 8, 2, 4, 11, 8, -2, 1, 10, 10, 6, 6, 11, 11, 10, 12, 14, 17, 18, 20, 26,
26, 21, 20, 24, 24, 15, 10, 13, 15, 9, 3, 3, 0, -7, -13, -18, -21, -29, -34,
-32, -37, -46, -49, -49, -50, -56, -59, -59, -61, -59, -58, -59, -57, -54, -51,
-50, -49, -47, -42, -38, -36, -34, -24, -10, -11, -9, 3, 12, 13, 7, 14, 28, 30,
29, 30, 39, 48, 44, 44, 50, 49, 45, 43, 43, 44, 41, 39, 41, 38, 35, 29, 23, 23,
20, 14, 8, 4, 4, 6, 1, -2, 0, 5, 1, -5, -2, 2, 2, 1, 4, 8, 8, 8, 13, 16, 18, 17,
20, 26, 25, 21, 21, 23, 22, 17, 13, 14, 12, 9, 6, 3, -1, -8, -13, -14, -20, -29,
-32, -30, -36, -47, -45, -46, -51, -52, -55, -54, -55, -56, -53, -54, -52, -49,
-49, -44, -43, -42, -35, -34, -32, -27, -25, -15, -1, -3, -3, 8, 18, 17, 10, 18,
30, 30, 31, 29, 35, 45, 42, 40, 44, 43, 39, 37, 38, 38, 33, 34, 33, 30, 29, 22,
17, 17, 15, 11, 4, 0, 1, 4, 3, -4, -4, 5, 4, -4, -3, 4, 6, 5, 5, 11, 13, 13, 16,
19, 22, 19, 19, 27, 26, 20, 18, 21, 22, 16, 11, 8, 8, 7, -1, -6, -9, -16, -19,
-21, -27, -36, -38, -35, -43, -50, -47, -50, -53, -51, -52, -54, -54, -51, -47,
-48, -48, -44, -41, -36, -36, -36, -29, -27, -23, -19, -19, -13, 1, 8, 2, 4, 16,
22, 17, 15, 24, 32, 32, 28, 30, 38, 39, 34, 36, 41, 35, 29, 31, 32, 30, 25, 22,
23, 22, 18, 12, 10, 11, 8, 3, -1, -4, -2, 3, 0, -2, 3, 6, 3, 2, 6, 8, 7, 8, 13,
17, 17, 16, 22, 25, 23, 19, 21, 24, 19, 15, 16, 17, 12, 6, 5, 5, 0, -10, -11,
-9, -17, -26, -29, -28, -32, -40, -41, -41, -45, -46, -47, -50, -50, -50, -49,
-48, -49, -45, -42, -41, -37, -36, -34, -32, -30, -25, -22, -20, -17, -14, -5,
9, 6, 0, 11, 21, 22, 12, 13, 28, 32, 28, 24, 26, 35, 34, 30, 33, 34, 30, 29, 30,
29, 25, 21, 23, 22, 20, 16, 10, 13, 14, 9, 3, -3, -2, 3, 2, -4, -4, 7, 9, 0, -1,
5, 7, 4, 5, 10, 13, 13, 14, 18, 21, 18, 15, 21, 24, 16, 13, 14, 18, 14, 6, 3, 6,
5, -6, -7, -4, -14, -20, -17, -21, -31, -35, -29, -33, -39, -37, -40, -43, -39,
-43, -46, -42, -42, -41, -36, -36, -35, -32, -28, -29, -31, -25, -22, -23, -18,
-16, -16, -4, 6, -1, -2, 8, 13, 11, 6, 10, 20, 22, 19, 14, 20, 27, 22, 21, 28,
26, 22, 25, 24, 22, 21, 16, 16, 17, 15, 11, 9, 12, 11, 7, 2, -2, -1, 4, 3, -2,
3, 9, 8, 6, 4, 8, 12, 11, 9, 14, 19, 18, 19, 24, 26, 22, 22, 28, 27, 21, 19, 21,
22, 17, 9, 9, 11, 5, -3, -2, -2, -11, -18, -15, -20, -32, -32, -30, -35, -38,
-38, -40, -42, -42, -43, -46, -44, -41, -41, -38, -37, -37, -33, -31, -31, -30,
-27, -25, -25, -20, -19, -20, -16, -3, 2, -6, -4, 5, 12, 7, 0, 9, 19, 18, 13,
11, 19, 22, 19, 20, 23, 22, 22, 23, 22, 23, 18, 16, 18, 16, 15, 12, 11, 14, 13,
11, 5, 2, 5, 9, 7, 8, 12, 13, 14, 14, 13, 14, 15, 19, 21, 23, 24, 23, 28, 31,
30, 27, 29, 32, 29, 24, 23, 24, 20, 14, 11, 8, 6, 1, 0, -2, -8, -13, -20, -21,
-28, -33, -33, -38, -37, -41, -45, -44, -48, -47, -48, -50, -50, -49, -46, -45,
-45, -41, -37, -38, -37, -35, -34, -29, -29, -27, -24, -25, -20, -6, -1, -10,
-7, 7, 12, 3, -2, 12, 22, 18, 14, 13, 23, 29, 23, 26, 31, 28, 28, 30, 29, 28,
26, 27, 27, 23, 24, 22, 21, 23, 21, 17, 13, 8, 11, 15, 12, 12, 20, 19, 16, 17,
19, 18, 16, 21, 23, 20, 23, 24, 25, 29, 27, 24, 26, 28, 22, 18, 18, 18, 15, 8,
3, 5, 4, -6, -8, -7, -13, -24, -28, -25, -36, -44, -39, -42, -44, -49, -51, -49,
-52, -56, -56, -57, -57, -54, -52, -50, -49, -46, -40, -43, -42, -35, -34, -32,
-30, -28, -24, -22, -22, -19, -3, 6, -3, -4, 10, 18, 10, 4, 15, 26, 29, 24, 22,
31, 39, 36, 32, 37, 36, 35, 39, 37, 36, 37, 37, 36, 32, 31, 29, 25, 25, 24, 18,
14, 9, 8, 14, 12, 9, 11, 11, 11, 10, 6, 5, 6, 11, 11, 8, 10, 14, 16, 19, 18, 14,
16, 20, 16, 11, 10, 12, 12, 6, 2, 1, -1, -6, -9, -12, -19, -24, -28, -31, -35,
-40, -41, -44, -45, -47, -53, -51, -52, -54, -53, -55, -56, -53, -48, -45, -44,
-41, -38, -35, -32, -30, -29, -24, -18, -18, -16, -12, -10, -7, -4, 1, 13, 14,
9, 14, 24, 29, 21, 20, 33, 39, 37, 33, 32, 41, 47, 40, 38, 40, 41, 43, 39, 36,
35, 33, 34, 28, 21, 23, 20, 16, 14, 8, 3, 0, -5, -6, -3, -3, -4, -7, -5, 0, -6,
-10, -7, -1, 2, -2, -1, 6, 11, 11, 12, 14, 16, 17, 19, 15, 12, 14, 16, 13, 9, 8,
7, 5, 2, -4, -8, -11, -19, -21, -22, -29, -33, -31, -32, -37, -41, -41, -44,
-45, -43, -47, -48, -43, -41, -41, -38, -35, -33, -31, -27, -25, -25, -19, -16,
-15, -11, -9, -7, -3, 0, 1, 1, 1, 9, 21, 17, 11, 19, 29, 30, 20, 21, 33, 36, 33,
28, 27, 33, 34, 29, 31, 31, 27, 27, 24, 20, 17, 13, 14, 10, 4, 4, 1, -3, -4, -8,
-11, -14, -17, -12, -7, -10, -12, -8, -4, -5, -8, -4, 3, 7, 9, 10, 13, 19, 24,
26, 29, 30, 31, 33, 32, 27, 26, 26, 27, 26, 20, 16, 17, 13, 6, 1, -4, -8, -14,
-20, -19, -26, -32, -29, -34, -38, -41, -45, -44, -46, -48, -48, -49, -46, -41,
-42, -41, -37, -35, -31, -31, -31, -25, -23, -22, -18, -16, -13, -12, -10, -6,
-6, -5, -6, 2, 13, 9, 6, 13, 22, 22, 13, 15, 23, 25, 25, 20, 18, 26, 28, 25, 26,
23, 22, 23, 18, 14, 11, 11, 14, 8, 4, 6, 2, 0, -2, -4, -2, -5, -9, -2, 4, 1, -1,
3, 10, 10, 7, 10, 14, 20, 23, 22, 25, 32, 37, 37, 37, 40, 40, 39, 36, 32, 31,
29, 27, 26, 23, 17, 13, 11, 5, -4, -8, -11, -20, -24, -25, -32, -38, -36, -38,
-47, -50, -49, -52, -55, -56, -57, -56, -54, -53, -52, -47, -45, -43, -39, -39,
-38, -33, -30, -27, -24, -18, -14, -14, -10, -8, -5, -2, -2, -1, 9, 17, 11, 13,
23, 29, 27, 20, 24, 30, 32, 30, 24, 28, 35, 34, 30, 30, 30, 29, 27, 21, 17, 17,
18, 16, 10, 10, 10, 7, 7, 3, 3, 5, 3, 3, 5, 7, 7, 7, 11, 13, 13, 14, 16, 19, 24,
25, 24, 30, 33, 35, 35, 35, 36, 34, 32, 27, 23, 23, 21, 17, 11, 8, 6, -2, -7,
-13, -17, -20, -27, -35, -38, -39, -45, -50, -50, -50, -57, -63, -58, -59, -64,
-61, -60, -56, -55, -54, -49, -47, -43, -40, -38, -34, -30, -26, -20, -16, -14,
-9, -5, -3, 1, 2, 6, 8, 8, 20, 25, 24, 26, 32, 39, 36, 29, 33, 39, 39, 36, 33,
36, 41, 38, 36, 35, 32, 31, 28, 23, 21, 17, 19, 19, 13, 10, 8, 6, 4, -1, -4, -6,
-9, -7, -5, -7, -6, -4, -2, 0, -3, -2, 0, 4, 7, 6, 8, 14, 18, 21, 22, 23, 25,
24, 22, 22, 20, 18, 17, 18, 17, 10, 8, 9, 4, -3, -8, -9, -14, -20, -24, -27,
-30, -33, -35, -37, -41, -44, -44, -46, -51, -50, -47, -46, -45, -44, -40, -39,
-37, -34, -32, -29, -27, -22, -17, -15, -12, -7, -3, 0, 0, 2, 5, 7, 7, 7, 9, 13,
16, 21, 22, 22, 25, 27, 26, 23, 23, 25, 26, 25, 23, 23, 25, 25, 23, 22, 21, 18,
16, 14, 11, 10, 9, 8, 5, 1, -2, -5, -7, -9, -12, -12, -10, -11, -11, -8, -6, -6,
-6, -3, -1, -1, 2, 5, 9, 13, 16, 21, 26, 29, 32, 34, 37, 38, 38, 39, 38, 37, 38,
36, 33, 31, 26, 24, 19, 13, 8, 3, 0, -9, -14, -16, -23, -28, -32, -35, -39, -44,
-46, -49, -51, -52, -53, -54, -54, -51, -51, -49, -46, -44, -38, -38, -36, -28,
-27, -24, -18, -15, -13, -10, -5, -1, -1, 2, 5, 5, 6, 7, 7, 8, 8, 7, 12, 13, 12,
12, 15, 17, 14, 9, 12, 11, 9, 8, 5, 6, 8, 7, 6, 5, 4, 5, 4, 1, 0, -2, 2, 4, 1,
5, 9, 10, 13, 13, 17, 22, 22, 24, 28, 30, 32, 32, 37, 42, 41, 43, 47, 49, 51,
51, 50, 52, 51, 49, 44, 40, 37, 32, 25, 20, 13, 8, 2, -6, -9, -17, -27, -29,
-32, -40, -50, -52, -54, -61, -65, -67, -71, -71, -67, -71, -73, -69, -66, -62,
-63, -58, -54, -51, -43, -42, -34, -27, -26, -18, -11, -8, -5, 0, 6, 8, 9, 9,
13, 14, 16, 14, 16, 26, 27, 24, 28, 30, 30, 27, 23, 23, 22, 21, 18, 14, 15, 18,
16, 15, 14, 10, 11, 10, 4, 2, 3, 5, 1, -1, 2, 2, 2, 2, 2, 4, 4, 4, 8, 13, 14,
17, 21, 25, 27, 28, 32, 34, 37, 39, 39, 41, 46, 47, 47, 48, 49, 48, 45, 42, 38,
31, 28, 22, 15, 9, 2, 0, -5, -15, -19, -22, -30, -37, -42, -47, -54, -61, -59,
-64, -70, -67, -69, -68, -69, -70, -64, -64, -62, -56, -55, -49, -45, -41, -31,
-30, -24, -14, -13, -6, -1, 1, 7, 9, 14, 16, 16, 21, 20, 20, 23, 20, 21, 26, 26,
24, 26, 28, 28, 24, 23, 22, 18, 19, 17, 12, 14, 14, 13, 14, 13, 11, 11, 10, 8,
5, 4, 4, 1, -1, 1, -3, -3, -3, -3, -2, -1, 3, 4, 5, 11, 13, 14, 16, 19, 23, 25,
27, 30, 34, 38, 40, 42, 47, 48, 48, 50, 50, 47, 45, 42, 38, 33, 28, 23, 17, 12,
6, -2, -8, -14, -21, -28, -34, -42, -47, -51, -58, -64, -64, -65, -71, -71, -68,
-70, -71, -67, -66, -64, -58, -57, -52, -45, -39, -36, -30, -20, -17, -13, -5,
-2, 2, 6, 9, 12, 15, 19, 19, 20, 24, 24, 21, 22, 20, 16, 16, 13, 13, 12, 10, 11,
10, 11, 8, 4, 4, 3, -2, -5, -5, -6, -6, -5, -5, -4, -2, 0, 0, -1, 4, 5, 6, 9,
11, 15, 19, 21, 26, 31, 36, 39, 40, 43, 46, 46, 47, 46, 48, 51, 50, 49, 51, 52,
52, 48, 46, 44, 38, 32, 26, 19, 12, 4, -4, -8, -16, -26, -28, -34, -42, -48,
-50, -57, -63, -65, -69, -71, -73, -76, -75, -71, -69, -76, -68, -60, -62, -61,
-52, -44, -43, -35, -27, -24, -18, -11, -5, 0, 5, 7, 12, 18, 18, 20, 23, 25, 23,
22, 22, 19, 17, 15, 12, 14, 16, 12, 9, 13, 15, 9, 3, 3, 2, -1, -5, -9, -9, -5,
-4, -5, -3, -1, 1, 2, 2, -2, -3, 1, 2, -1, -1, 3, 8, 14, 18, 21, 31, 38, 38, 39,
44, 46, 42, 44, 48, 48, 49, 53, 55, 59, 61, 59, 59, 60, 57, 51, 45, 42, 36, 29,
21, 11, 6, 1, -8, -16, -19, -25, -38, -47, -47, -55, -65, -67, -68, -73, -76,
-76, -77, -78, -77, -73, -71, -71, -68, -62, -57, -52, -49, -40, -32, -29, -20,
-12, -8, -3, 6, 13, 13, 16, 20, 24, 25, 26, 27, 29, 29, 29, 27, 25, 22, 19, 20,
20, 14, 13, 16, 16, 12, 9, 9, 9, 7, 5, 2, 0, 2, 3, 4, 4, 4, 6, 9, 9, 8, 8, 10,
10, 8, 8, 6, 5, 7, 8, 8, 8, 10, 15, 16, 16, 18, 20, 21, 20, 21, 22, 22, 24, 28,
29, 30, 33, 36, 38, 38, 38, 39, 37, 35, 33, 30, 25, 22, 20, 15, 11, 6, 3, -1,
-8, -14, -21, -27, -33, -40, -43, -50, -52, -53, -55, -57, -62, -59, -57, -62,
-61, -59, -58, -58, -52, -48, -46, -40, -31, -26, -24, -18, -13, -10, -5, -4, 1,
3, 5, 9, 11, 14, 15, 17, 18, 17, 14, 12, 9, 4, 2, 0, -1, -1, -3, 0, 3, 5, 3, 0,
2, 2, -2, -4, -5, -4, 0, 2, 3, 7, 12, 17, 18, 17, 19, 22, 25, 24, 23, 29, 35,
37, 40, 45, 50, 54, 54, 53, 53, 53, 50, 47, 47, 46, 45, 45, 46, 46, 46, 44, 40,
37, 32, 25, 17, 10, 2, -5, -12, -19, -22, -28, -34, -36, -43, -49, -52, -58,
-62, -68, -71, -70, -74, -75, -72, -69, -67, -67, -60, -56, -55, -51, -46, -39,
-36, -34, -25, -19, -15, -9, -2, 5, 10, 14, 17, 19, 19, 23, 23, 20, 21, 19, 18,
13, 8, 9, 4, 5, 8, 5, 5, 6, 6, 6, 2, -1, -1, -3, -5, -8, -10, -4, -2, -1, 5, 8,
10, 12, 13, 13, 10, 11, 12, 10, 11, 12, 13, 18, 24, 27, 29, 35, 42, 41, 39, 42,
43, 41, 40, 39, 42, 43, 44, 46, 48, 50, 50, 49, 48, 46, 41, 39, 33, 28, 23, 15,
7, 0, -3, -10, -22, -25, -28, -37, -45, -51, -53, -58, -64, -67, -70, -71, -74,
-74, -73, -73, -72, -69, -64, -62, -59, -52, -47, -42, -35, -28, -24, -19, -8,
-4, -3, 5, 11, 14, 17, 20, 25, 25, 27, 29, 26, 26, 25, 20, 18, 16, 11, 8, 10,
10, 8, 8, 10, 8, 5, 5, 3, -1, 0, -2, -4, -3, -2, 1, 4, 7, 9, 10, 13, 12, 10, 10,
8, 6, 6, 5, 4, 5, 8, 9, 9, 12, 14, 15, 17, 17, 16, 19, 19, 19, 21, 24, 27, 29,
33, 36, 37, 40, 42, 42, 43, 43, 43, 42, 40, 38, 34, 31, 26, 21, 16, 11, 3, -3,
-8, -16, -22, -29, -36, -40, -47, -51, -56, -59, -63, -68, -67, -69, -70, -68,
-67, -65, -63, -58, -55, -52, -45, -41, -35, -29, -25, -19, -12, -7, -3, 1, 7,
9, 10, 13, 15, 14, 16, 18, 15, 14, 13, 9, 6, 1, -2, -2, -1, -2, -4, 0, 2, 0, 0,
1, 0, -2, -3, -4, -5, -3, 0, 2, 6, 10, 13, 16, 19, 19, 21, 27, 26, 24, 28, 33,
35, 36, 42, 46, 49, 51, 50, 49, 51, 49, 46, 45, 45, 43, 42, 43, 43, 43, 44, 42,
38, 36, 32, 25, 21, 17, 9, 2, -4, -10, -17, -22, -26, -33, -35, -39, -48, -51,
-53, -57, -61, -63, -64, -67, -66, -65, -68, -62, -59, -56, -56, -53, -45, -44,
-40, -34, -28, -22, -20, -14, -6, -3, -1, 4, 11, 12, 13, 13, 16, 18, 18, 17, 13,
15, 14, 6, 2, 1, -2, -6, -7, -6, -7, -6, -4, -4, -3, -2, -4, -4, -3, -4, -5, -3,
1, 3, 7, 12, 14, 19, 23, 24, 25, 25, 25, 23, 23, 21, 19, 19, 22, 22, 20, 25, 31,
32, 33, 35, 38, 35, 32, 32, 30, 30, 29, 28, 30, 34, 36, 38, 40, 42, 42, 41, 39,
35, 31, 27, 20, 13, 9, 3, -4, -8, -13, -19, -24, -29, -37, -42, -48, -55, -60,
-65, -68, -70, -72, -74, -71, -69, -68, -67, -63, -59, -59, -55, -48, -46, -42,
-32, -28, -23, -14, -8, -3, 4, 8, 9, 13, 16, 15, 16, 20, 20, 16, 18, 19, 12, 10,
7, 2, -1, -1, -2, -2, 0, 1, 2, 5, 6, 4, 5, 8, 6, 4, 7, 10, 12, 18, 22, 24, 30,
36, 37, 38, 40, 39, 37, 37, 35, 31, 30, 31, 29, 27, 27, 24, 21, 20, 16, 12, 9,
6, 3, 1, 1, -1, -1, 3, 5, 4, 6, 8, 9, 10, 10, 12, 12, 13, 14, 12, 12, 10, 8, 8,
6, 1, 0, -2, -7, -10, -13, -17, -22, -25, -29, -34, -37, -41, -46, -44, -49,
-51, -48, -49, -48, -48, -45, -41, -40, -35, -33, -30, -24, -23, -20, -14, -10,
-7, -4, 2, 6, 6, 11, 10, 9, 13, 8, 4, 4, 1, -5, -7, -11, -14, -17, -19, -16,
-17, -15, -11, -10, -5, -5, -7, -2, 0, -1, 0, 4, 8, 11, 17, 23, 28, 35, 40, 43,
46, 47, 47, 47, 46, 44, 42, 42, 42, 40, 42, 42, 40, 39, 36, 33, 28, 21, 19, 13,
9, 7, 4, 4, 6, 6, 8, 9, 10, 11, 10, 9, 7, 4, 2, -1, -6, -9, -12, -13, -12, -17,
-20, -20, -19, -24, -30, -30, -31, -38, -40, -43, -47, -46, -45, -46, -48, -43,
-41, -45, -41, -40, -38, -37, -36, -30, -28, -23, -21, -17, -7, -6, -3, 1, 2, 2,
5, 4, 1, 2, 2, 0, -2, 0, -2, -7, -6, -5, -12, -15, -16, -17, -16, -14, -14, -14,
-7, -3, -3, -2, 1, 3, 4, 6, 5, 5, 10, 14, 17, 19, 22, 26, 30, 32, 30, 29, 29,
28, 24, 21, 24, 24, 27, 36, 37, 40, 46, 48, 48, 46, 46, 42, 37, 37, 34, 32, 35,
37, 40, 45, 47, 46, 46, 45, 38, 30, 23, 12, 1, -7, -15, -24, -28, -31, -35, -40,
-43, -47, -53, -57, -64, -71, -73, -77, -81, -78, -74, -74, -70, -61, -55, -54,
-47, -40, -39, -34, -29, -26, -21, -14, -8, -2, 5, 11, 15, 21, 24, 21, 23, 20,
14, 12, 11, 6, -1, -2, -2, -7, -10, -12, -12, -10, -8, -9, -11, -7, -4, -4, -2,
-1, 3, 9, 14, 15, 19, 28, 34, 38, 40, 44, 47, 49, 50, 48, 47, 47, 45, 43, 38,
35, 32, 29, 25, 20, 15, 11, 5, 1, -2, -6, -10, -11, -11, -11, -12, -11, -8, -4,
-2, 1, 2, 7, 11, 13, 17, 20, 22, 26, 27, 26, 24, 23, 22, 19, 15, 11, 5, 2, -2,
-7, -11, -17, -20, -25, -32, -38, -43, -45, -51, -55, -55, -57, -59, -56, -53,
-53, -50, -43, -42, -39, -33, -30, -27, -22, -17, -12, -7, -3, 1, 7, 11, 12, 12,
15, 15, 11, 8, 4, 2, -2, -8, -12, -14, -17, -21, -21, -17, -18, -18, -13, -8,
-9, -8, -4, -3, 0, 1, 2, 6, 13, 17, 22, 30, 37, 42, 48, 52, 52, 52, 53, 52, 49,
46, 44, 43, 42, 40, 38, 37, 35, 31, 27, 24, 18, 12, 7, 3, -2, -5, -5, -5, -4, 0,
1, 3, 7, 9, 9, 9, 9, 7, 6, 4, 1, -3, -5, -6, -8, -9, -10, -11, -14, -16, -16,
-21, -24, -28, -32, -34, -39, -45, -45, -44, -47, -48, -46, -46, -42, -37, -36,
-36, -30, -22, -23, -25, -16, -9, -11, -11, -2, 1, 0, 3, 7, 8, 8, 9, 6, 4, 4,
-3, -7, -7, -11, -16, -17, -18, -22, -21, -16, -12, -11, -9, -4, -3, -1, -1, -2,
2, 4, 4, 4, 6, 12, 18, 21, 25, 28, 31, 33, 31, 29, 28, 25, 22, 21, 16, 15, 20,
25, 27, 30, 38, 42, 40, 39, 41, 38, 34, 31, 28, 28, 28, 28, 33, 39, 43, 46, 48,
48, 45, 40, 35, 25, 14, 5, -7, -18, -23, -29, -34, -37, -40, -44, -47, -51, -55,
-60, -65, -70, -74, -76, -76, -77, -72, -65, -61, -53, -46, -38, -31, -26, -21,
-16, -10, -9, -5, 2, 3, 9, 15, 19, 22, 25, 27, 25, 23, 19, 13, 9, 3, -5, -13,
-17, -18, -23, -26, -25, -26, -23, -19, -18, -16, -11, -7, -6, -3, -1, 3, 9, 14,
18, 22, 31, 37, 41, 45, 48, 48, 47, 46, 42, 37, 32, 27, 23, 18, 13, 8, 6, 5, 0,
-4, -6, -8, -10, -12, -13, -13, -12, -8, -4, -1, 4, 11, 18, 25, 30, 34, 41, 45,
48, 50, 51, 52, 53, 50, 46, 40, 35, 28, 20, 11, 1, -7, -17, -26, -34, -43, -52,
-57, -60, -69, -74, -73, -77, -82, -79, -76, -78, -74, -66, -62, -58, -49, -39,
-33, -23, -12, -8, -1, 11, 16, 18, 24, 27, 28, 30, 30, 26, 25, 26, 19, 14, 11,
6, -1, -9, -14, -23, -30, -35, -39, -38, -37, -35, -30, -23, -18, -13, -6, 0, 3,
8, 12, 16, 20, 27, 35, 42, 51, 57, 63, 70, 72, 72, 70, 67, 61, 53, 45, 36, 30,
24, 17, 12, 6, 1, -4, -8, -14, -21, -26, -30, -33, -36, -36, -34, -30, -23, -16,
-8, 1, 9, 16, 23, 28, 32, 35, 37, 37, 35, 33, 31, 26, 21, 19, 17, 11, 4, 0, -6,
-18, -24, -29, -40, -48, -52, -62, -69, -68, -72, -73, -68, -69, -67, -59, -53,
-51, -46, -33, -28, -29, -15, -6, -6, 5, 15, 17, 23, 32, 31, 30, 35, 33, 27, 24,
21, 12, 7, 4, -8, -13, -11, -20, -26, -19, -16, -22, -20, -12, -12, -14, -12,
-11, -10, -5, -4, -5, 3, 12, 16, 23, 31, 36, 41, 47, 46, 42, 43, 42, 34, 28, 25,
20, 16, 16, 14, 11, 15, 16, 14, 13, 12, 11, 8, 6, 4, 1, 3, 4, 5, 12, 17, 20, 27,
33, 34, 36, 36, 32, 26, 20, 11, 2, -5, -10, -17, -23, -24, -28, -34, -35, -36,
-42, -48, -54, -57, -64, -71, -70, -68, -70, -64, -53, -48, -41, -30, -21, -13,
-10, -5, 0, 4, 6, 4, 10, 17, 18, 20, 25, 27, 27, 28, 23, 17, 11, 3, -5, -19,
-27, -32, -43, -44, -46, -48, -39, -33, -29, -19, -12, -6, 0, 3, 7, 12, 15, 20,
23, 29, 40, 45, 52, 61, 65, 68, 69, 65, 60, 52, 42, 32, 21, 11, 1, -8, -13, -17,
-21, -22, -23, -25, -24, -25, -26, -25, -24, -21, -18, -13, -5, 5, 15, 26, 37,
47, 56, 62, 67, 70, 70, 66, 61, 56, 45, 34, 25, 14, 3, -5, -16, -29, -35, -43,
-57, -64, -71, -81, -86, -86, -94, -100, -90, -83, -83, -75, -62, -52, -42, -27,
-19, -9, 5, 14, 19, 26, 35, 38, 44, 49, 49, 52, 53, 50, 46, 42, 33, 21, 12, 3,
-13, -26, -35, -45, -54, -62, -68, -66, -61, -58, -51, -41, -32, -23, -13, -4,
4, 12, 22, 29, 35, 43, 53, 62, 70, 76, 81, 84, 84, 82, 75, 67, 57, 45, 31, 17,
3, -9, -19, -29, -37, -42, -48, -51, -52, -53, -53, -51, -45, -40, -35, -24,
-13, -2, 11, 25, 38, 50, 60, 70, 79, 83, 84, 84, 81, 76, 67, 56, 43, 30, 17, 2,
-11, -26, -38, -51, -64, -71, -79, -93, -99, -96, -101, -108, -105, -95, -86,
-81, -70, -55, -39, -24, -15, -2, 16, 27, 32, 45, 52, 53, 59, 63, 63, 62, 60,
54, 47, 41, 31, 16, 5, -4, -21, -36, -47, -60, -68, -76, -87, -88, -79, -76,
-73, -58, -42, -31, -19, -4, 7, 19, 31, 38, 44, 55, 64, 70, 77, 83, 87, 92, 92,
86, 81, 75, 62, 46, 32, 16, -1, -14, -26, -39, -46, -49, -52, -53, -50, -48,
-43, -38, -35, -32, -24, -12, -1, 10, 18, 26, 41, 59, 72, 80, 82, 79, 79, 79,
73, 60, 42, 21, 5, -6, -22, -39, -45, -55, -70, -74, -73, -81, -91, -91, -92,
-97, -97, -92, -89, -81, -69, -55, -36, -18, -6, 13, 32, 43, 55, 64, 68, 68, 71,
69, 61, 57, 55, 47, 38, 32, 21, 10, 1, -13, -27, -41, -57, -72, -85, -95, -96,
-88, -83, -79, -63, -41, -25, -13, 4, 21, 33, 40, 43, 47, 56, 62, 64, 68, 74,
78, 83, 84, 81, 77, 71, 58, 41, 25, 9, -9, -23, -35, -45, -48, -46, -42, -36,
-28, -19, -10, -3, 3, 8, 11, 14, 19, 24, 30, 33, 40, 49, 52, 53, 53, 50, 42, 29,
15, 1, -14, -34, -48, -57, -68, -78, -83, -81, -80, -82, -83, -79, -71, -71,
-70, -61, -51, -44, -34, -20, -7, 10, 25, 37, 50, 62, 68, 69, 73, 72, 64, 57,
49, 40, 28, 17, 5, -5, -13, -26, -39, -47, -56, -64, -68, -69, -70, -68, -59,
-51, -44, -32, -17, -4, 7, 17, 28, 39, 48, 54, 58, 65, 67, 67, 68, 66, 61, 57,
52, 43, 33, 23, 12, 1, -8, -20, -29, -34, -37, -40, -38, -32, -26, -17, -6, 1,
10, 21, 28, 35, 40, 42, 44, 47, 47, 43, 38, 35, 30, 20, 9, 1, -5, -20, -32, -37,
-50, -62, -65, -72, -82, -84, -84, -86, -83, -79, -70, -61, -51, -40, -27, -13,
-3, 9, 24, 31, 36, 46, 51, 51, 55, 53, 51, 48, 42, 34, 24, 16, 4, -9, -21, -35,
-47, -55, -64, -68, -62, -61, -58, -45, -33, -24, -13, 0, 11, 19, 25, 32, 38,
44, 49, 52, 58, 60, 62, 66, 65, 61, 56, 51, 42, 29, 16, 4, -8, -18, -29, -37,
-41, -41, -41, -38, -32, -25, -16, -6, 3, 9, 18, 28, 34, 39, 43, 47, 50, 49, 43,
39, 35, 27, 16, 4, -7, -18, -29, -41, -53, -59, -67, -76, -77, -79, -83, -80,
-74, -71, -64, -55, -45, -32, -19, -8, 4, 19, 31, 40, 50, 56, 59, 63, 64, 58,
53, 48, 39, 28, 16, 3, -9, -20, -32, -45, -56, -64, -68, -69, -71, -70, -61,
-52, -45, -33, -18, -6, 8, 21, 31, 41, 52, 61, 67, 70, 72, 75, 76, 72, 65, 61,
56, 46, 35, 24, 13, 1, -10, -22, -32, -39, -43, -46, -47, -44, -39, -32, -22,
-12, -2, 9, 18, 28, 37, 41, 42, 45, 45, 42, 38, 30, 23, 18, 9, -5, -14, -20,
-29, -39, -47, -56, -60, -64, -71, -73, -69, -68, -66, -58, -49, -42, -30, -15,
-6, 3, 17, 27, 34, 42, 46, 47, 49, 48, 43, 37, 32, 24, 15, 6, -4, -13, -20, -27,
-34, -38, -41, -43, -42, -41, -42, -38, -31, -27, -23, -15, -6, 3, 12, 21, 30,
39, 47, 52, 55, 58, 58, 57, 53, 48, 42, 37, 31, 24, 18, 12, 7, 4, 1, -3, -6, -6,
-7, -8, -8, -8, -6, -6, -7, -8, -10, -11, -13, -18, -21, -25, -29, -33, -35,
-37, -37, -37, -37, -33, -30, -30, -26, -20, -18, -17, -12, -8, -4, 0, 3, 8, 13,
17, 21, 24, 26, 27, 25, 22, 17, 11, 4, -3, -11, -20, -23, -25, -28, -29, -27,
-25, -20, -15, -12, -9, -6, -4, -2, 1, 3, 6, 9, 11, 17, 24, 28, 30, 34, 35, 34,
33, 29, 23, 17, 10, 4, -1, -5, -9, -10, -11, -10, -7, -5, -2, 1, 2, 4, 5, 5, 5,
4, 1, 1, -1, -3, -6, -8, -11, -14, -17, -19, -24, -26, -27, -30, -34, -32, -30,
-30, -30, -27, -22, -18, -15, -9, -5, -1, 3, 7, 11, 15, 15, 16, 17, 16, 15, 12,
9, 7, 8, 6, 5, 6, 8, 8, 8, 9, 10, 8, 5, 3, 0, -3, -5, -7, -8, -8, -6, -3, -1, 1,
4, 6, 6, 6, 6, 4, 1, 0, -2, -4, -3, -3, -2, 1, 5, 8, 10, 13, 14, 16, 16, 15, 12,
8, 5, 2, -1, -5, -9, -14, -18, -22, -27, -31, -34, -39, -42, -43, -44, -44, -42,
-38, -32, -26, -21, -13, -6, 2, 8, 13, 18, 22, 23, 25, 25, 24, 22, 19, 15, 11,
6, 1, -4, -9, -14, -16, -17, -18, -19, -17, -15, -11, -8, -6, -2, 2, 4, 6, 10,
13, 15, 16, 19, 21, 21, 21, 20, 18, 16, 12, 8, 4, -1, -6, -10, -13, -14, -15,
-16, -15, -14, -11, -8, -5, -1, 2, 4, 7, 9, 10, 11, 10, 10, 8, 5, 2, -1, -8,
-13, -20, -28, -33, -39, -47, -50, -51, -54, -51, -45, -42, -36, -28, -18, -11,
-4, 4, 9, 14, 18, 20, 22, 23, 21, 20, 18, 15, 11, 6, -1, -7, -12, -17, -21, -25,
-28, -30, -29, -28, -26, -23, -19, -15, -10, -5, 1, 7, 12, 15, 21, 26, 29, 30,
31, 30, 29, 27, 23, 18, 14, 8, 2, -2, -6, -10, -14, -17, -19, -19, -19, -19,
-18, -16, -14, -11, -8, -4, -2, 0, 2, 5, 6, 5, 4, 5, 2, -4, -7, -9, -16, -23,
-27, -29, -33, -36, -35, -34, -32, -27, -24, -20, -14, -10, -7, -4, -1, 1, 1, 0,
0, 0, -1, -4, -6, -7, -10, -12, -13, -13, -13, -13, -12, -9, -7, -6, -4, -3, -1,
0, 0, 2, 3, 4, 4, 5, 7, 7, 7, 7, 7, 5, 3, 1, -1, -4, -8, -10, -12, -12, -12,
-12, -11, -8, -5, -1, 2, 6, 9, 12, 15, 17, 18, 19, 19, 17, 15, 14, 10, 5, -1,
-7, -13, -20, -28, -34, -39, -47, -52, -53, -52, -53, -51, -42, -34, -28, -18,
-5, 4, 12, 20, 27, 30, 32, 32, 30, 25, 21, 15, 7, 0, -6, -13, -18, -20, -22,
-25, -25, -24, -24, -22, -22, -21, -20, -20, -18, -16, -13, -11, -6, -2, 2, 6,
10, 13, 14, 14, 14, 12, 9, 5, 1, -3, -6, -9, -10, -11, -10, -9, -7, -5, -3, -1,
0, 1, 2, 3, 3, 4, 4, 4, 4, 4, 4, 1, -1, -4, -8, -13, -19, -23, -28, -35, -38,
-39, -42, -45, -41, -37, -35, -29, -19, -14, -7, 3, 9, 14, 21, 24, 24, 24, 23,
20, 14, 8, 2, -6, -13, -18, -22, -26, -29, -28, -25, -24, -21, -15, -13, -10,
-5, -2, 0, 3, 5, 5, 8, 10, 11, 12, 13, 13, 13, 12, 9, 7, 2, -3, -7, -11, -16,
-20, -23, -25, -25, -24, -22, -19, -15, -10, -6, -1, 3, 6, 9, 10, 12, 12, 12,
11, 10, 9, 6, 4, 1, -2, -6, -9, -13, -18, -22, -26, -32, -36, -37, -42, -46,
-44, -42, -41, -35, -28, -22, -14, -4, 4, 10, 16, 20, 19, 19, 17, 11, 4, -2, -9,
-15, -18, -21, -23, -19, -16, -14, -7, -1, 1, 3, 7, 7, 6, 7, 5, 3, 3, 4, 4, 4,
7, 9, 9, 10, 11, 9, 5, 2, -2, -7, -11, -16, -19, -20, -20, -19, -16, -12, -7,
-1, 4, 9, 13, 16, 17, 18, 17, 14, 11, 8, 4, 1, -2, -5, -8, -10, -11, -15, -16,
-18, -23, -24, -27, -31, -34, -36, -36, -37, -37, -33, -30, -25, -17, -10, -3,
4, 11, 15, 19, 21, 19, 17, 13, 6, -1, -7, -15, -20, -22, -26, -27, -24, -21,
-17, -12, -6, -3, 0, 4, 5, 5, 6, 4, 3, 4, 4, 4, 5, 7, 9, 10, 12, 12, 11, 9, 7,
3, 0, -5, -9, -12, -14, -14, -13, -11, -7, -3, 2, 7, 10, 14, 17, 17, 17, 16, 14,
11, 7, 5, 2, 0, -2, -4, -4, -5, -6, -7, -8, -11, -14, -16, -21, -26, -29, -34,
-35, -36, -38, -35, -30, -24, -17, -9, -2, 6, 14, 19, 20, 22, 21, 15, 11, 5, -3,
-9, -14, -19, -22, -21, -19, -17, -13, -8, -5, 0, 3, 4, 6, 5, 4, 4, 2, 1, 0, 0,
2, 3, 4, 6, 7, 8, 9, 8, 5, 3, 0, -4, -7, -10, -12, -13, -13, -11, -9, -5, -1, 4,
8, 12, 15, 17, 18, 18, 16, 14, 11, 7, 5, 2, 0, 0, 0, 0, 2, 4, 5, 6, 6, 5, 3, 2,
-2, -6, -11, -16, -21, -26, -27, -32, -35, -32, -33, -29, -23, -21, -14, -7, -1,
6, 10, 14, 17, 18, 18, 17, 14, 11, 7, 4, 2, 0, -2, -3, -3, -3, -2, -1, -2, -2,
-1, -3, -3, -4, -6, -7, -6, -6, -5, -3, -1, 2, 5, 9, 11, 12, 14, 13, 12, 11, 8,
5, 2, -1, -3, -4, -4, -4, -2, 0, 3, 6, 9, 11, 13, 14, 15, 14, 12, 10, 8, 5, 2,
1, 0, -1, 1, 1, 3, 5, 5, 6, 6, 5, 2, 0, -3, -6, -9, -13, -15, -18, -20, -21,
-24, -22, -22, -21, -18, -14, -11, -7, -2, 1, 5, 8, 10, 12, 12, 11, 10, 8, 6, 4,
2, -1, -1, -3, -4, -3, -4, -3, -2, -2, -1, 0, 0, 1, 3, 4, 6, 8, 10, 12, 13, 14,
14, 13, 12, 9, 7, 4, 0, -3, -7, -9, -11, -13, -13, -13, -11, -8, -5, -2, 2, 6,
10, 13, 15, 17, 18, 18, 17, 16, 14, 12, 10, 7, 5, 3, 2, 1, 1, 1, 2, 2, 3, 4, 4,
4, 4, 4, 3, 1, 0, -1, -3, -5, -6, -10, -12, -16, -21, -24, -29, -33, -36, -38,
-36, -34, -28, -20, -11, 1, 12, 24, 33, 41, 45, 45, 44, 36, 29, 19, 6, -4, -15,
-24, -30, -34, -35, -33, -28, -22, -15, -7, 1, 7, 13, 17, 20, 21, 21, 20, 18,
16, 15, 12, 11, 9, 7, 6, 4, 2, -1, -4, -7, -10, -13, -15, -16, -16, -14, -11,
-7, -2, 4, 9, 15, 19, 22, 24, 23, 21, 17, 12, 6, -1, -7, -13, -17, -20, -21,
-20, -18, -14, -9, -3, 2, 7, 12, 15, 17, 18, 17, 15, 13, 11, 9, 8, 8, 9, 11, 14,
17, 20, 23, 24, 23, 21, 18, 11, 4, -3, -12, -20, -27, -33, -37, -38, -38, -35,
-32, -28, -23, -18, -10, -3, 2, 11, 16, 22, 28, 31, 34, 34, 32, 28, 24, 17, 9,
1, -7, -14, -20, -25, -27, -28, -26, -22, -17, -10, -2, 5, 12, 19, 24, 28, 30,
30, 30, 27, 24, 19, 14, 9, 4, 0, -5, -8, -10, -12, -13, -13, -12, -10, -8, -5,
-3, 1, 4, 7, 10, 13, 15, 16, 17, 17, 17, 16, 14, 11, 8, 4, 1, -3, -5, -8, -10,
-11, -11, -11, -9, -7, -4, -1, 3, 6, 9, 12, 14, 16, 17, 17, 17, 15, 13, 12, 9,
7, 4, 2, 1, -1, 0, 1, 4, 8, 12, 18, 23, 27, 31, 32, 31, 27, 21, 13, 4, -6, -16,
-24, -31, -35, -37, -36, -32, -27, -19, -11, -4, 4, 10, 15, 18, 19, 19, 18, 15,
12, 9, 5, 2, -1, -3, -6, -7, -8, -11, -12, -13, -14, -15, -14, -13, -10, -6, -2,
4, 9, 16, 21, 26, 30, 31, 32, 30, 26, 20, 14, 7, -1, -7, -14, -19, -22, -24,
-23, -22, -18, -14, -9, -3, 2, 7, 12, 16, 19, 21, 22, 22, 21, 20, 19, 16, 14,
11, 8, 5, 2, -2, -5, -8, -11, -13, -15, -15, -15, -14, -11, -8, -3, 1, 7, 13,
21, 30, 34, 41, 43, 42, 42, 35, 26, 15, 3, -10, -22, -32, -40, -46, -48, -47,
-43, -37, -29, -20, -11, 0, 9, 17, 24, 28, 32, 33, 33, 31, 26, 23, 17, 12, 7, 1,
-3, -7, -9, -11, -11, -11, -9, -7, -4, -1, 3, 6, 8, 11, 11, 12, 12, 10, 9, 5, 2,
-2, -6, -8, -10, -12, -12, -12, -10, -7, -5, -2, 1, 3, 6, 7, 8, 8, 8, 7, 7, 6,
6, 6, 5, 6, 6, 6, 7, 6, 6, 6, 4, 3, 1, 0, -2, -4, -5, -6, -6, -6, -4, -3, 2, 5,
9, 16, 18, 23, 27, 28, 29, 27, 25, 20, 15, 8, 1, -6, -12, -16, -20, -20, -20,
-18, -14, -11, -6, -2, 1, 3, 4, 3, 3, 0, -3, -5, -7, -9, -8, -7, -5, -1, 2, 8,
12, 16, 18, 19, 19, 17, 13, 8, 2, -4, -10, -14, -17, -18, -18, -16, -11, -6, 1,
8, 14, 20, 24, 26, 27, 26, 22, 18, 13, 8, 3, -2, -5, -7, -9, -8, -7, -6, -4, -2,
0, 3, 3, 4, 4, 3, 2, 1, 1, 0, 1, 1, 2, 4, 6, 9, 11, 13, 14, 14, 14, 13, 11, 8,
5, 2, -2, -5, -8, -4, -4, 1, 7, 9, 18, 22, 26, 29, 28, 25, 20, 14, 6, -2, -11,
-19, -25, -30, -31, -31, -29, -23, -17, -10, -2, 5, 12, 17, 22, 24, 24, 23, 21,
18, 14, 11, 8, 5, 4, 3, 3, 4, 5, 6, 7, 8, 8, 7, 6, 4, 2, 0, -1, -3, -3, -4, -3,
-3, -2, -1, -1, -1, 0, 0, -1, -1, -3, -2, -2, -2, -2, -2, -1, 0, 1, 3, 4, 5, 7,
9, 9, 11, 11, 11, 12, 11, 11, 10, 9, 8, 7, 7, 7, 6, 6, 7, 8, 9, 10, 11, 12, 13,
13, 13, 13, 12, 11, 9, 8, 7, 5, 4, 3, 2, 1, 1, 1, 1, 0, 0, 0, 0, -1, -1, -3, -3,
-5, -6, -7, -9, -9, -10, -10, -10, -10, -10, -9, -8, -6, -5, -4, -2, 1, 4, 5, 8,
9, 11, 13, 13, 13, 12, 11, 9, 7, 6, 4, 2, 1, 1, 0, 0, 0, 0, 1, 1, 2, 2, 2, 3, 3,
3, 2, 2, 2, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10, 9, 8, 6, 5, 3, 2, 0,
-1, -1, -2, -2, -1, 0, 1, 3, 4, 6, 7, 8, 9, 9, 9, 9, 8, 7, 6, 4, 3, 2, 1, 0, 1,
2, 5, 9, 12, 17, 19, 21, 22, 20, 17, 12, 6, 0, -7, -13, -18, -22, -23, -23, -21,
-18, -13, -8, -2, 4, 9, 12, 14, 16, 16, 14, 12, 9, 6, 3, 1, 0, -1, 0, 1, 3, 6,
8, 11, 13, 13, 14, 13, 11, 8, 4, -1, -6, -11, -16, -22, -24, -26, -26, -24, -22,
-17, -12, -5, 2, 7, 12, 17, 20, 22, 23, 21, 20, 17, 14, 12, 8, 5, 3, 1, 1, 0, 0,
2, 2, 3, 4, 4, 4, 5, 4, 3, 3, 2, 2, 2, 2, 3, 4, 6, 8, 10, 12, 14, 15, 16, 15,
14, 13, 11, 8, 5, 2, -1, -4, -6, -8, -9, -10, -10, -10, -9, -8, -8, -7, -7, -7,
-6, -7, -6, -7, -8, -8, -8, -7, -6, -5, -4, -2, 0, 1, 4, 5, 6, 9, 9, 10, 10, 9,
10, 9, 8, 7, 5, 4, 3, 2, 1, 1, 1, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4,
5, 6, 7, 8, 9, 9, 9, 10, 9, 8, 7, 6, 4, 2, 1, -1, -2, -3, -3, -3, -3, -2, -1, 1,
2, 4, 5, 6, 7, 7, 7, 7, 7, 6, 5, 5, 3, 7, 9, 10, 17, 15, 19, 22, 19, 20, 16, 10,
5, -3, -9, -15, -22, -25, -27, -28, -24, -21, -16, -9, -3, 4, 10, 15, 19, 21,
22, 22, 21, 18, 15, 12, 9, 7, 5, 4, 3, 4, 5, 6, 7, 9, 9, 9, 8, 6, 5, 0, -3, -8,
-13, -18, -24, -26, -28, -27, -24, -22, -16, -9, 0, 8, 16, 22, 28, 31, 33, 33,
30, 25, 19, 12, 5, -2, -9, -13, -17, -19, -19, -18, -15, -11, -7, -2, 3, 7, 11,
14, 16, 17, 18, 17, 17, 16, 14, 14, 12, 11, 10, 9, 9, 8, 7, 7, 5, 4, 2, 0, -2,
-4, -7, -9, -12, -14, -15, -17, -17, -17, -16, -14, -13, -9, -7, -5, 0, 2, 5, 8,
9, 10, 11, 10, 8, 6, 3, 0, -1, -5, -5, -6, -6, -3, -2, 0, 3, 5, 7, 8, 9, 8, 8,
5, 3, 2, -2, -3, -4, -5, -5, -4, -3, -1, 1, 3, 5, 6, 7, 8, 7, 7, 5, 3, 2, 0, -2,
-3, -4, -4, -3, -2, -1, 1, 2, 4, 6, 6, 7, 7, 6, 6, 4, 3, 1, -1, -1, -2, -2, -2,
1, 5, 6, 15, 17, 21, 29, 28, 31, 32, 25, 22, 16, 5, -1, -12, -22, -27, -35, -37,
-37, -38, -32, -27, -20, -11, -3, 5, 13, 18, 23, 25, 26, 26, 23, 20, 16, 12, 9,
5, 2, 1, -1, -1, 0, 0, 2, 3, 3, 4, 3, 1, -1, -5, -9, -15, -23, -29, -32, -34,
-35, -33, -30, -23, -12, -3, 9, 19, 27, 35, 41, 45, 44, 41, 34, 27, 18, 7, -2,
-12, -19, -24, -27, -27, -25, -21, -16, -9, -2, 4, 10, 14, 17, 19, 18, 17, 15,
13, 11, 9, 8, 7, 7, 8, 9, 10, 12, 12, 13, 12, 11, 8, 4, 0, -5, -10, -16, -20,
-24, -27, -28, -28, -26, -23, -17, -12, -6, 1, 6, 12, 16, 19, 21, 21, 20, 18,
15, 11, 7, 3, -1, -5, -10, -13, -16, -18, -17, -18, -18, -15, -13, -10, -5, -2,
1, 4, 6, 8, 10, 11, 11, 11, 10, 10, 9, 8, 7, 5, 5, 3, 2, 2, 0, -1, -1, -2, -3,
-3, -4, -4, -4, -4, -4, -4, -3, -2, -1, 0, 1, 3, 4, 5, 6, 6, 6, 6, 6, 5, 4, 2,
2, 1, 0, 1, 2, 3, 6, 8, 10, 13, 14, 16, 17, 16, 15, 12, 8, 4, -2, -7, -13, -18,
-22, -26, -28, -29, -29, -27, -23, -19, -14, -8, -2, 4, 9, 13, 17, 20, 21, 22,
21, 21, 19, 17, 15, 12, 10, 8, 6, 4, 3, 2, 1, -1, -2, -3, -4, -6, -8, -10, -13,
-16, -20, -26, -29, -28, -29, -28, -26, -23, -14, -5, 3, 13, 20, 27, 32, 37, 40,
38, 35, 30, 24, 17, 10, 2, -5, -11, -16, -19, -20, -20, -19, -17, -14, -10, -6,
-4, -1, 0, 1, 2, 2, 1, 0, 0, 1, 2, 4, 8, 10, 15, 21, 25, 29, 31, 32, 31, 28, 24,
18, 10, 1, -7, -16, -23, -30, -35, -38, -39, -37, -33, -29, -22, -16, -9, -1, 5,
10, 15, 17, 19, 20, 19, 19, 17, 16, 14, 13, 11, 10, 10, 9, 9, 8, 8, 7, 6, 4, 1,
-1, -5, -10, -14, -21, -28, -32, -34, -36, -37, -36, -31, -24, -15, -5, 5, 14,
23, 31, 38, 42, 42, 40, 36, 31, 24, 16, 7, -1, -9, -15, -20, -22, -24, -25, -23,
-20, -17, -13, -9, -6, -4, -1, 0, 2, 2, 1, 1, 1, 1, 2, 3, 4, 5, 8, 12, 14, 17,
20, 21, 24, 25, 25, 24, 20, 17, 12, 7, 1, -5, -11, -17, -21, -24, -27, -28, -27,
-26, -23, -19, -15, -10, -7, -3, 0, 3, 6, 8, 8, 9, 10, 11, 11, 11, 12, 12, 12,
13, 14, 14, 13, 12, 11, 9, 7, 5, 2, -1, -4, -7, -9, -11, -13, -15, -15, -16,
-18, -21, -23, -22, -21, -22, -20, -18, -13, -8, -3, 4, 8, 14, 19, 23, 27, 27,
26, 26, 22, 20, 15, 10, 6, -1, -5, -8, -12, -14, -16, -16, -16, -15, -12, -10,
-9, -7, -4, -2, 0, 1, 2, 4, 7, 8, 12, 14, 16, 20, 23, 26, 28, 27, 28, 25, 22,
19, 13, 7, 0, -7, -13, -20, -25, -29, -32, -33, -33, -30, -27, -23, -17, -11,
-5, 2, 7, 12, 15, 18, 20, 20, 20, 19, 17, 15, 13, 11, 9, 7, 6, 5, 4, 3, 2, 1,
-1, -3, -5, -10, -14, -18, -21, -24, -27, -28, -28, -25, -22, -16, -10, -4, 3,
11, 17, 23, 27, 30, 31, 31, 29, 26, 21, 16, 10, 5, 1, -4, -8, -11, -12, -13,
-12, -11, -9, -9, -7, -5, -4, -3, -3, -3, -3, -4, -4, -4, -4, -3, -1, 1, 4, 7,
9, 13, 17, 19, 22, 24, 25, 25, 25, 24, 21, 17, 13, 8, 2, -3, -8, -13, -17, -21,
-23, -24, -25, -24, -23, -21, -18, -15, -11, -9, -6, -2, 0, 2, 4, 5, 6, 7, 8, 9,
9, 10, 11, 12, 13, 13, 13, 13, 12, 12, 10, 9, 7, 4, 2, -1, -3, -5, -8, -9, -11,
-12, -12, -13, -14, -16, -18, -19, -19, -18, -19, -19, -18, -14, -11, -7, -3, 1,
6, 10, 15, 19, 21, 22, 23, 23, 22, 19, 16, 12, 7, 3, 0, -3, -7, -11, -13, -13,
-13, -13, -13, -11, -10, -9, -7, -4, -4, -4, -3, -2, 2, 4, 4, 8, 11, 14, 17, 20,
22, 19, 20, 20, 17, 15, 10, 5, 2, -5, -9, -12, -17, -20, -23, -22, -21, -21,
-19, -17, -14, -10, -7, -3, 0, 2, 4, 6, 8, 8, 7, 7, 7, 6, 7, 5, 5, 5, 4, 4, 4,
3, 2, -1, -3, -4, -6, -8, -12, -13, -14, -15, -14, -13, -12, -11, -8, -4, -1, 2,
5, 8, 11, 13, 14, 16, 15, 14, 12, 11, 10, 7, 4, 2, 0, -1, -3, -4, -4, -5, -5,
-4, -3, -3, -3, -2, -2, -2, -2, -2, -3, -3, -4, -3, -3, -3, -2, -1, 0, 2, 3, 5,
7, 8, 11, 14, 15, 17, 18, 20, 20, 20, 20, 17, 13, 12, 8, 4, 1, -5, -8, -11, -15,
-16, -18, -19, -20, -20, -18, -17, -16, -14, -13, -11, -8, -6, -4, -2, -1, 1, 3,
5, 7, 8, 10, 11, 13, 14, 15, 15, 16, 16, 16, 15, 14, 13, 11, 10, 8, 6, 3, 0, -3,
-6, -9, -12, -15, -17, -20, -23, -25, -27, -27, -26, -26, -25, -22, -18, -14,
-9, -3, 2, 6, 11, 16, 20, 22, 22, 23, 23, 23, 20, 17, 15, 12, 8, 5, 2, 0, -4,
-6, -8, -8, -10, -12, -12, -12, -13, -13, -12, -10, -8, -7, -4, 1, 5, 8, 11, 16,
18, 19, 20, 21, 20, 18, 15, 12, 9, 4, 0, -4, -7, -11, -13, -15, -17, -17, -17,
-17, -16, -15, -13, -12, -10, -9, -7, -5, -4, -4, -2, -2, -1, 0, 0, 1, 1, 1, 0,
-1, -2, -1, -2, -4, -5, -4, -4, -4, -3, -3, -3, -2, -1, 0, 1, 0, 0, 1, 1, 1, 0,
0, -1, -2, -2, -1, -1, -2, -2, -1, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, -1, -2,
-2, -3, -3, -4, -4, -3, -3, -3, -2, -1, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 3,
3, 5, 7, 9, 11, 13, 15, 16, 16, 15, 14, 13, 10, 6, 2, -2, -7, -11, -14, -19,
-22, -24, -25, -26, -26, -25, -24, -21, -18, -15, -12, -9, -5, -2, 1, 4, 6, 8,
9, 11, 12, 13, 14, 14, 14, 15, 15, 15, 14, 14, 13, 12, 11, 9, 7, 5, 2, -1, -5,
-9, -13, -17, -22, -26, -30, -31, -32, -34, -34, -31, -28, -24, -19, -13, -6,
-1, 5, 12, 18, 21, 24, 27, 29, 29, 27, 25, 23, 19, 15, 11, 8, 4, 0, -4, -5, -7,
-9, -11, -11, -11, -11, -11, -11, -11, -11, -11, -9, -7, -6, -5, -2, 2, 4, 7,
11, 13, 15, 17, 19, 20, 19, 19, 17, 15, 12, 9, 5, 1, -4, -8, -11, -15, -19, -21,
-23, -24, -24, -23, -22, -21, -19, -16, -13, -10, -7, -5, -2, 0, 2, 3, 3, 3, 3,
2, 1, 1, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 7, 7, 6, 4, 4, 2, -1, -3, -4, -6,
-8, -9, -9, -9, -9, -9, -7, -5, -4, -2, 0, 3, 4, 6, 7, 8, 9, 8, 8, 8, 6, 5, 3,
2, 0, -1, -2, -2, -3, -3, -2, -2, -1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2,
4, 6, 8, 10, 11, 13, 14, 15, 15, 14, 12, 10, 8, 4, 0, -4, -8, -12, -16, -20,
-22, -24, -26, -26, -25, -24, -22, -20, -16, -13, -9, -5, -1, 3, 6, 9, 11, 14,
16, 16, 17, 17, 17, 17, 16, 15, 14, 13, 12, 10, 9, 7, 4, 2, -1, -5, -9, -13,
-17, -20, -24, -28, -30, -31, -32, -32, -30, -27, -23, -19, -14, -7, -1, 5, 10,
15, 21, 24, 26, 28, 29, 28, 26, 24, 21, 18, 13, 9, 5, 2, -1, -4, -7, -8, -9,
-10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -9, -7, -8, -5, 0, 1, 4, 10,
13, 14, 18, 22, 23, 23, 24, 22, 20, 19, 14, 9, 5, -2, -7, -11, -16, -21, -24,
-26, -29, -29, -28, -27, -26, -23, -21, -18, -14, -12, -9, -7, -6, -4, -2, -2,
-3, -2, 0, 0, 0, 2, 3, 5, 7, 8, 11, 13, 13, 13, 14, 15, 13, 11, 9, 7, 4, 1, -3,
-6, -9, -12, -15, -16, -17, -18, -18, -17, -16, -14, -12, -10, -7, -4, -2, 1, 3,
5, 7, 8, 8, 9, 9, 8, 7, 7, 6, 5, 3, 2, 1, 0, -1, -2, -2, -3, -4, -4, -4, -5, -5,
-5, -4, -4, -4, -2, -1, 0, 2, 4, 5, 6, 8, 9, 10, 10, 10, 9, 8, 7, 5, 2, -1, -4,
-7, -10, -14, -17, -19, -22, -24, -24, -24, -24, -23, -21, -19, -16, -13, -10,
-7, -3, 0, 3, 6, 8, 10, 12, 13, 14, 14, 14, 13, 13, 11, 9, 7, 4, 0, -3, -6, -9,
-12, -15, -17, -18, -19, -19, -20, -19, -17, -16, -13, -11, -8, -5, -3, 0, 3, 6,
7, 9, 11, 12, 12, 12, 12, 12, 11, 10, 9, 9, 7, 6, 4, 4, 2, 1, 0, -1, -2, -3, -4,
-5, -6, -7, -8, -9, -9, -10, -10, -10, -10, -9, -8, -7, -4, -1, 2, 4, 9, 13, 15,
19, 22, 24, 24, 25, 25, 23, 21, 17, 13, 10, 5, -1, -5, -10, -15, -19, -22, -25,
-27, -28, -29, -28, -26, -24, -22, -19, -15, -13, -9, -6, -4, -1, 1, 1, 3, 4, 3,
3, 3, 2, 3, 3, 2, 3, 4, 5, 6, 8, 10, 11, 11, 12, 13, 13, 12, 10, 9, 7, 4, 1, -2,
-5, -9, -11, -14, -15, -16, -17, -16, -15, -13, -11, -8, -5, -2, 1, 4, 7, 9, 11,
12, 12, 12, 12, 11, 9, 7, 5, 3, 1, -1, -2, -3, -5, -5, -6, -6, -6, -5, -5, -3,
-1, 0, 2, 4, 7, 7, 9, 11, 11, 11, 12, 12, 11, 10, 8, 6, 4, 2, -1, -4, -7, -10,
-12, -14, -16, -18, -19, -20, -20, -19, -19, -18, -17, -15, -13, -11, -9, -7,
-4, -2, 0, 3, 6, 7, 9, 11, 12, 13, 14, 14, 13, 13, 12, 10, 8, 5, 1, -2, -5, -8,
-12, -14, -17, -19, -19, -20, -21, -20, -19, -17, -15, -12, -10, -7, -4, -1, 2,
4, 6, 7, 9, 10, 11, 11, 11, 11, 10, 10, 9, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, -1, -3,
-4, -5, -6, -8, -8, -9, -10, -10, -9, -8, -7, -5, -3, 0, 2, 6, 9, 11, 14, 16,
18, 19, 19, 19, 18, 16, 14, 11, 8, 4, -1, -5, -9, -14, -18, -22, -25, -27, -29,
-30, -30, -30, -28, -26, -23, -20, -16, -12, -9, -5, -1, 1, 4, 6, 7, 8, 8, 9, 9,
8, 8, 8, 8, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 8, 8, 7, 5, 4, 2, -1, -3, -6, -8, -10,
-12, -14, -14, -15, -14, -14, -12, -10, -8, -6, -3, 0, 3, 5, 8, 10, 11, 13, 13,
13, 13, 13, 12, 10, 9, 7, 6, 4, 2, 0, -1, -2, -2, -2, -3, -1, 1, 2, 4, 7, 9, 10,
12, 14, 14, 15, 14, 13, 12, 10, 6, 3, 0, -6, -10, -14, -18, -22, -25, -27, -29,
-29, -29, -28, -26, -23, -20, -16, -11, -7, -2, 3, 6, 10, 14, 16, 18, 20, 20,
19, 19, 16, 14, 11, 7, 4, 1, -2, -6, -9, -11, -12, -13, -14, -14, -13, -11, -11,
-9, -7, -5, -4, -3, -1, 0, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 3, 3, 4, 5, 6, 7,
7, 8, 9, 9, 9, 8, 8, 6, 5, 3, 1, -1, -3, -5, -7, -9, -10, -11, -13, -13, -10,
-9, -9, -4, 0, 2, 6, 11, 14, 18, 20, 23, 25, 25, 25, 23, 21, 19, 13, 8, 5, -2,
-8, -13, -19, -25, -28, -32, -35, -36, -36, -36, -35, -31, -28, -24, -20, -15,
-10, -5, -2, 3, 7, 10, 11, 13, 14, 14, 13, 13, 12, 10, 10, 9, 7, 7, 7, 6, 6, 7,
7, 8, 8, 8, 8, 8, 7, 6, 5, 3, 0, -2, -4, -7, -10, -12, -15, -16, -17, -18, -19,
-18, -17, -15, -13, -9, -6, -3, 1, 5, 9, 12, 15, 17, 19, 20, 20, 20, 19, 18, 16,
13, 10, 8, 5, 2, 1, -2, -3, -2, -2, -2, 0, 2, 3, 5, 7, 9, 10, 11, 11, 10, 9, 8,
4, 1, -2, -7, -11, -14, -19, -22, -24, -28, -29, -29, -29, -28, -25, -23, -19,
-15, -10, -5, 0, 5, 9, 13, 16, 19, 20, 21, 21, 19, 18, 15, 12, 9, 6, 2, 0, -2,
-4, -6, -7, -7, -6, -6, -4, -3, -1, 0, 2, 3, 5, 5, 5, 5, 4, 3, 2, 0, -2, -3, -5,
-7, -8, -8, -9, -9, -8, -7, -5, -2, 0, 2, 5, 8, 10, 12, 14, 15, 15, 16, 15, 14,
13, 10, 8, 6, 3, 0, -2, -3, -3, -6, -6, -3, -3, -1, 3, 5, 8, 10, 13, 16, 17, 17,
18, 15, 15, 13, 8, 5, 1, -6, -9, -14, -21, -24, -27, -31, -33, -33, -33, -32,
-31, -28, -25, -21, -17, -12, -8, -3, 1, 4, 8, 10, 12, 14, 16, 15, 15, 15, 14,
13, 13, 11, 11, 10, 9, 9, 9, 9, 8, 7, 8, 7, 7, 6, 5, 4, 3, 1, -2, -3, -5, -8,
-11, -13, -14, -16, -17, -18, -18, -17, -16, -15, -12, -9, -7, -4, 0, 4, 7, 10,
13, 16, 18, 19, 20, 21, 21, 20, 19, 17, 15, 14, 12, 10, 8, 8, 7, 5, 6, 6, 6, 6,
6, 7, 7, 6, 5, 3, 1, 0, -4, -7, -9, -14, -17, -20, -24, -25, -27, -29, -30, -28,
-28, -26, -24, -21, -16, -13, -10, -5, -1, 3, 6, 9, 12, 15, 16, 17, 18, 18, 18,
18, 17, 16, 15, 13, 11, 10, 9, 8, 6, 5, 4, 3, 3, 3, 2, 1, 1, 0, -1, -1, -2, -3,
-4, -6, -6, -7, -8, -9, -10, -10, -10, -10, -10, -8, -7, -6, -4, -2, 1, 4, 6, 9,
11, 13, 15, 16, 17, 18, 18, 17, 17, 16, 14, 13, 14, 12, 9, 11, 11, 9, 11, 11,
10, 11, 10, 10, 11, 9, 8, 6, 2, 2, -2, -7, -9, -14, -18, -20, -26, -27, -28,
-32, -33, -32, -32, -30, -29, -27, -23, -19, -16, -11, -6, -1, 3, 7, 11, 16, 18,
20, 22, 24, 25, 25, 24, 24, 23, 20, 18, 16, 15, 12, 9, 7, 6, 4, 2, 0, -1, -2,
-3, -5, -5, -5, -7, -8, -9, -9, -10, -11, -12, -12, -12, -12, -12, -11, -10, -9,
-8, -6, -3, -1, 1, 3, 6, 8, 10, 12, 13, 15, 16, 16, 16, 16, 16, 15, 16, 16, 13,
14, 15, 13, 14, 14, 13, 13, 13, 12, 12, 10, 9, 6, 2, 1, -1, -7, -10, -13, -18,
-21, -26, -29, -30, -34, -36, -37, -37, -36, -36, -35, -31, -28, -26, -20, -15,
-10, -5, -1, 5, 10, 15, 18, 23, 26, 28, 29, 31, 32, 31, 30, 29, 27, 25, 22, 18,
15, 13, 8, 5, 2, -1, -4, -7, -9, -11, -13, -15, -16, -17, -17, -18, -18, -18,
-17, -17, -16, -15, -14, -12, -11, -9, -7, -5, -3, 0, 2, 5, 7, 9, 12, 14, 16,
17, 18, 20, 21, 21, 21, 22, 23, 22, 22, 22, 22, 22, 21, 19, 18, 17, 15, 12, 10,
6, 3, -1, -5, -9, -14, -18, -23, -27, -31, -34, -38, -40, -41, -42, -42, -42,
-40, -37, -35, -31, -26, -21, -16, -10, -4, 2, 7, 12, 18, 23, 27, 30, 33, 36,
38, 39, 39, 40, 39, 37, 35, 33, 30, 27, 22, 19, 15, 10, 6, 1, -3, -7, -11, -14,
-17, -19, -22, -24, -25, -25, -26, -26, -25, -24, -23, -21, -19, -16, -14, -11,
-8, -4, -1, 3, 6, 10, 13, 16, 19, 22, 25, 27, 29, 31, 33, 34, 36, 36, 36, 36,
35, 34, 32, 29, 26, 22, 18, 13, 8, 3, -3, -9, -14, -20, -26, -30, -35, -39, -43,
-45, -47, -48, -49, -48, -46, -44, -41, -37, -32, -27, -22, -16, -9, -3, 2, 7,
14, 18, 22, 26, 30, 34, 36, 37, 39, 40, 40, 39, 38, 37, 35, 33, 30, 27, 24, 20,
16, 12, 9, 4, 0, -4, -7, -11, -15, -18, -21, -23, -25, -27, -28, -28, -29, -29,
-28, -26, -25, -23, -20, -17, -14, -11, -7, -3, 1, 4, 9, 13, 17, 21, 26, 30, 34,
37, 41, 44, 45, 46, 47, 46, 45, 42, 39, 34, 29, 22, 15, 8, 1, -7, -15, -22, -29,
-35, -41, -46, -50, -53, -55, -55, -55, -54, -51, -47, -43, -38, -32, -26, -20,
-14, -9, -2, 4, 9, 13, 18, 22, 25, 28, 31, 33, 35, 35, 36, 37, 38, 37, 37, 36,
35, 33, 31, 29, 27, 24, 20, 17, 13, 9, 5, 0, -4, -8, -12, -16, -19, -22, -25,
-28, -29, -30, -30, -30, -29, -28, -26, -23, -20, -17, -13, -9, -6, -2, 4, 8,
11, 17, 21, 24, 29, 32, 35, 37, 38, 38, 38, 37, 35, 32, 27, 25, 19, 13, 8, 2,
-3, -10, -16, -20, -24, -29, -33, -36, -38, -40, -41, -40, -39, -38, -36, -33,
-29, -26, -23, -19, -14, -11, -8, -3, 0, 3, 6, 9, 13, 16, 18, 21, 23, 26, 27,
29, 31, 32, 33, 33, 34, 33, 32, 31, 29, 27, 24, 20, 17, 13, 9, 4, 0, -4, -8,
-12, -15, -18, -21, -23, -24, -25, -25, -25, -24, -23, -21, -19, -17, -15, -10,
-7, -3, 2, 7, 11, 16, 20, 24, 27, 29, 30, 31, 30, 29, 27, 23, 20, 16, 10, 5, 0,
-5, -10, -16, -20, -23, -26, -29, -31, -31, -30, -30, -29, -26, -24, -22, -20,
-17, -13, -10, -8, -6, -4, -2, 0, 1, 3, 5, 6, 7, 8, 10, 12, 13, 14, 16, 18, 19,
20, 21, 22, 22, 21, 21, 21, 20, 18, 15, 13, 11, 9, 6, 4, 1, -1, -4, -6, -7, -8,
-9, -11, -11, -11, -11, -11, -10, -10, -9, -7, -6, -3, 0, 2, 5, 8, 11, 14, 15,
17, 18, 19, 18, 17, 16, 14, 12, 9, 5, 2, -2, -6, -10, -13, -17, -19, -22, -23,
-25, -26, -26, -26, -25, -24, -23, -21, -19, -18, -16, -14, -11, -10, -8, -6,
-4, -2, 0, 3, 5, 7, 9, 11, 14, 16, 17, 18, 21, 22, 22, 23, 23, 23, 22, 21, 20,
19, 17, 14, 12, 9, 7, 4, 2, 0, -2, -4, -6, -7, -8, -8, -8, -9, -8, -8, -7, -6,
-5, -3, 0, 1, 3, 7, 10, 12, 14, 17, 18, 19, 18, 18, 18, 17, 13, 10, 8, 5, 1, -3,
-7, -10, -14, -18, -20, -23, -24, -26, -28, -28, -28, -28, -27, -26, -24, -23,
-22, -20, -17, -15, -13, -12, -9, -6, -5, -2, 0, 3, 5, 6, 9, 11, 13, 15, 17, 18,
19, 20, 21, 21, 21, 21, 20, 18, 17, 16, 14, 11, 9, 7, 5, 3, 1, -1, -2, -3, -4,
-5, -5, -5, -5, -5, -4, -3, -2, -1, 2, 4, 5, 8, 10, 11, 13, 13, 13, 13, 12, 10,
9, 7, 4, 1, -2, -4, -7, -10, -13, -15, -17, -20, -22, -22, -23, -24, -24, -24,
-24, -23, -22, -21, -20, -19, -18, -16, -14, -12, -11, -10, -8, -7, -6, -4, -3,
-1, -1, 0, 2, 3, 5, 7, 8, 9, 10, 10, 12, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7,
7, 7, 7, 7, 7, 6, 6, 7, 7, 7, 8, 8, 8, 9, 10, 10, 11, 11, 11, 11, 11, 9, 8, 7,
5, 2, 0, -2, -5, -7, -10, -13, -15, -18, -20, -21, -22, -24, -25, -24, -25, -25,
-24, -24, -23, -21, -21, -19, -17, -15, -13, -12, -9, -7, -6, -4, -2, -1, 0, 0,
1, 1, 2, 2, 3, 4, 4, 4, 5, 5, 5, 5, 4, 4, 3, 3, 3, 3, 3, 2, 3, 3, 3, 4, 5, 6, 6,
7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 16, 17, 18, 18, 18, 18, 16, 16, 15, 12, 10,
8, 5, 2, -1, -4, -7, -10, -13, -16, -18, -21, -23, -25, -26, -27, -29, -29, -29,
-29, -29, -29, -28, -26, -25, -24, -22, -19, -16, -14, -11, -9, -6, -4, -3, -2,
0, 1, 2, 4, 6, 7, 8, 9, 10, 11, 11, 11, 11, 10, 10, 9, 9, 8, 8, 8, 7, 7, 7, 7,
6, 7, 7, 7, 7, 8, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 15, 14, 12,
11, 9, 6, 4, 1, -1, -3, -6, -8, -11, -13, -15, -17, -19, -20, -22, -23, -24,
-25, -26, -27, -27, -27, -26, -26, -25, -22, -20, -18, -16, -14, -12, -10, -10,
-10, -9, -8, -7, -6, -4, -3, -2, -1, -1, 0, 0, 1, 1, 1, 2, 3, 4, 4, 5, 7, 8, 9,
10, 12, 13, 13, 14, 15, 16, 17, 17, 18, 19, 19, 19, 20, 20, 21, 20, 20, 19, 18,
17, 15, 13, 11, 8, 5, 2, -1, -3, -7, -10, -12, -15, -17, -20, -22, -24, -25,
-27, -28, -29, -29, -30, -30, -29, -28, -27, -25, -23, -20, -16, -14, -11, -9,
-8, -8, -7, -7, -7, -5, -4, -4, -4, -3, -3, -3, -3, -4, -4, -4, -5, -5, -4, -4,
-4, -3, -2, -1, 1, 2, 3, 5, 7, 8, 10, 11, 13, 14, 15, 17, 19, 20, 21, 22, 24,
24, 25, 25, 24, 24, 22, 21, 19, 17, 15, 13, 10, 8, 5, 2, 0, -2, -5, -8, -11,
-14, -16, -18, -20, -23, -25, -27, -29, -30, -30, -31, -30, -29, -28, -26, -23,
-21, -18, -16, -17, -16, -18, -16, -11, -11, -12, -13, -10, -6, -5, -5, -7, -6,
-4, -2, -2, -2, -2, 0, 2, 3, 4, 5, 7, 8, 10, 10, 11, 12, 13, 14, 15, 16, 16, 17,
19, 20, 20, 21, 21, 21, 21, 20, 20, 19, 17, 16, 14, 12, 11, 9, 7, 5, 3, 1, -1,
-3, -5, -7, -9, -11, -13, -15, -17, -19, -21, -22, -23, -24, -25, -25, -24, -23,
-22, -20, -19, -17, -16, -16, -16, -16, -16, -16, -15, -14, -13, -13, -13, -12,
-11, -10, -10, -9, -8, -7, -6, -5, -4, -2, -1, 0, 2, 4, 5, 6, 8, 10, 11, 13, 14,
16, 18, 20, 21, 23, 24, 25, 26, 26, 26, 26, 25, 24, 23, 22, 20, 17, 15, 13, 11,
8, 6, 4, 1, -1, -4, -6, -9, -11, -13, -16, -18, -20, -22, -24, -25, -26, -27,
-26, -26, -24, -23, -21, -20, -19, -19, -19, -19, -18, -18, -18, -17, -16, -15,
-14, -13, -12, -11, -10, -9, -7, -6, -5, -3, -1, 0, 2, 4, 5, 7, 8, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 22, 22, 22, 21, 20, 20, 19, 17, 16, 15,
13, 12, 10, 8, 6, 4, 2, 0, -2, -4, -5, -8, -10, -12, -14, -16, -18, -19, -21,
-22, -23, -23, -22, -21, -21, -20, -19, -18, -18, -19, -20, -21, -21, -21, -20,
-19, -18, -18, -17, -16, -14, -12, -11, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10,
12, 14, 15, 17, 19, 20, 22, 23, 25, 26, 26, 27, 28, 28, 27, 27, 26, 25, 23, 21,
19, 17, 15, 12, 10, 8, 5, 2, 0, -3, -5, -8, -11, -13, -16, -18, -20, -22, -24,
-26, -27, -27, -28, -28, -27, -25, -23, -21, -20, -19, -18, -18, -20, -19, -18,
-18, -17, -16, -15, -14, -13, -11, -9, -8, -6, -5, -3, -1, 0, 2, 4, 6, 8, 9, 11,
13, 14, 15, 16, 18, 19, 20, 21, 21, 22, 22, 23, 23, 22, 22, 22, 21, 19, 18, 17,
16, 14, 12, 11, 9, 7, 5, 3, 1, -2, -5, -7, -10, -13, -15, -18, -20, -23, -25,
-26, -27, -28, -27, -26, -25, -23, -22, -20, -20, -21, -22, -24, -24, -24, -24,
-23, -22, -21, -20, -18, -15, -13, -11, -9, -7, -5, -3, -1, 2, 4, 6, 8, 10, 12,
14, 16, 18, 19, 20, 22, 23, 25, 26, 26, 27, 27, 27, 27, 27, 25, 24, 23, 21, 19,
17, 14, 12, 10, 7, 4, 2, 0, -3, -5, -8, -10, -13, -16, -18, -20, -23, -25, -27,
-28, -30, -31, -31, -30, -29, -27, -25, -23, -21, -21, -21, -22, -22, -22, -22,
-21, -20, -18, -17, -15, -13, -10, -9, -7, -5, -3, -1, 1, 3, 5, 7, 9, 11, 13,
15, 17, 18, 20, 21, 22, 24, 25, 26, 27, 27, 27, 27, 27, 26, 25, 23, 22, 20, 18,
16, 14, 12, 9, 6, 4, 1, -1, -4, -7, -9, -13, -15, -18, -20, -22, -26, -27, -29,
-30, -31, -31, -30, -29, -27, -25, -23, -20, -19, -19, -18, -18, -18, -19, -20,
-19, -19, -18, -17, -15, -13, -11, -9, -7, -5, -3, -1, 1, 4, 5, 7, 9, 11, 13,
16, 17, 19, 21, 23, 25, 26, 28, 29, 30, 30, 30, 30, 30, 28, 27, 26, 23, 22, 19,
16, 15, 12, 8, 5, 3, 0, -3, -6, -9, -12, -15, -19, -22, -24, -27, -30, -32, -33,
-34, -35, -35, -34, -33, -31, -29, -26, -23, -21, -20, -20, -19, -19, -19, -18,
-17, -17, -16, -15, -12, -10, -7, -5, -3, 0, 2, 4, 7, 9, 10, 12, 14, 15, 17, 19,
21, 22, 24, 25, 26, 28, 28, 29, 29, 28, 28, 27, 26, 25, 22, 20, 18, 16, 13, 10,
8, 5, 3, -1, -3, -5, -7, -10, -12, -15, -17, -20, -22, -24, -26, -29, -31, -33,
-34, -35, -35, -34, -33, -32, -30, -27, -23, -21, -20, -20, -19, -19, -19, -19,
-18, -17, -16, -15, -13, -10, -8, -5, -4, -1, 1, 3, 5, 7, 9, 11, 12, 14, 16, 18,
20, 21, 23, 24, 26, 28, 29, 30, 30, 30, 30, 29, 29, 27, 26, 23, 21, 18, 15, 12,
9, 5, 2, -1, -4, -7, -10, -13, -16, -19, -22, -25, -26, -28, -31, -33, -35, -36,
-37, -38, -37, -37, -36, -34, -32, -28, -25, -23, -21, -20, -19, -18, -17, -17,
-16, -16, -15, -14, -11, -9, -6, -4, -2, 1, 3, 5, 8, 10, 12, 14, 15, 17, 19, 21,
23, 25, 26, 27, 29, 30, 31, 32, 32, 32, 31, 30, 29, 28, 25, 22, 19, 16, 13, 10,
7, 4, 0, -3, -6, -8, -11, -14, -16, -19, -21, -23, -26, -27, -29, -31, -34, -35,
-35, -36, -36, -36, -36, -34, -32, -29, -26, -23, -22, -20, -19, -18, -17, -17,
-16, -16, -15, -14, -13, -11, -8, -6, -3, -1, 1, 4, 6, 9, 11, 12, 14, 15, 17,
19, 21, 23, 24, 26, 27, 29, 31, 32, 33, 33, 34, 32, 32, 30, 28, 27, 24, 20, 18,
15, 11, 9, 4, 1, -2, -6, -9, -11, -15, -18, -20, -23, -26, -28, -31, -33, -35,
-38, -39, -39, -40, -40, -40, -40, -37, -34, -32, -28, -25, -23, -21, -21, -19,
-18, -17, -17, -16, -14, -14, -12, -9, -7, -4, -2, 1, 4, 6, 9, 11, 12, 14, 15,
17, 19, 20, 22, 23, 24, 26, 27, 29, 30, 31, 32, 32, 32, 31, 30, 29, 27, 24, 21,
18, 15, 12, 9, 6, 2, -1, -4, -6, -9, -12, -13, -16, -19, -21, -23, -25, -28,
-30, -33, -35, -36, -38, -39, -39, -38, -38, -37, -35, -32, -29, -27, -24, -23,
-21, -20, -20, -19, -18, -18, -17, -16, -15, -12, -10, -8, -5, -2, 1, 3, 6, 8,
10, 12, 14, 15, 17, 19, 21, 22, 24, 26, 27, 29, 31, 32, 32, 33, 33, 32, 32, 30,
28, 27, 23, 20, 17, 13, 10, 7, 3, 0, -4, -6, -8, -11, -13, -15, -17, -19, -22,
-24, -27, -29, -32, -34, -36, -37, -38, -39, -39, -39, -38, -37, -34, -32, -29,
-26, -25, -22, -21, -20, -19, -19, -18, -17, -16, -14, -12, -9, -7, -4, -1, 2,
4, 7, 9, 11, 13, 14, 16, 18, 20, 22, 24, 25, 27, 28, 29, 31, 32, 33, 33, 34, 32,
31, 30, 28, 25, 23, 20, 16, 14, 10, 6, 4, 0, -3, -5, -8, -10, -12, -14, -16,
-19, -21, -23, -25, -27, -30, -32, -34, -35, -36, -37, -37, -37, -36, -35, -34,
-31, -28, -27, -25, -23, -22, -20, -20, -19, -18, -17, -16, -15, -12, -9, -6,
-3, 0, 3, 6, 7, 10, 12, 14, 16, 17, 19, 21, 23, 24, 26, 28, 29, 31, 32, 32, 33,
33, 32, 32, 30, 29, 26, 23, 22, 17, 14, 12, 8, 6, 3, -1, -2, -6, -9, -10, -13,
-15, -17, -20, -22, -24, -26, -28, -30, -32, -33, -34, -35, -36, -36, -36, -35,
-34, -32, -30, -28, -27, -25, -24, -23, -22, -22, -22, -20, -19, -17, -15, -12,
-9, -7, -4, -1, 2, 5, 7, 9, 12, 14, 16, 18, 21, 23, 25, 27, 29, 31, 32, 34, 35,
36, 36, 35, 34, 33, 32, 30, 26, 24, 20, 16, 14, 11, 7, 6, 3, -1, -2, -5, -8, -9,
-12, -15, -16, -20, -22, -23, -26, -28, -28, -31, -32, -33, -35, -34, -34, -35,
-34, -33, -32, -30, -28, -27, -25, -23, -22, -21, -20, -20, -19, -18, -17, -15,
-12, -10, -6, -4, -1, 2, 4, 7, 9, 11, 14, 15, 17, 19, 22, 23, 26, 28, 30, 31,
33, 34, 35, 35, 35, 35, 34, 32, 31, 28, 25, 23, 19, 17, 15, 12, 9, 8, 5, 3, 1,
-2, -5, -7, -11, -14, -15, -19, -21, -22, -25, -27, -28, -31, -31, -32, -34,
-34, -34, -35, -34, -33, -32, -30, -29, -28, -27, -25, -25, -24, -23, -23, -21,
-20, -18, -15, -13, -11, -7, -5, -2, 1, 3, 6, 8, 10, 13, 15, 17, 20, 23, 24, 27,
30, 32, 34, 35, 36, 38, 38, 37, 37, 35, 35, 32, 29, 27, 24, 20, 19, 16, 13, 13,
10, 7, 6, 2, -1, -3, -7, -10, -12, -16, -18, -19, -22, -24, -25, -28, -29, -30,
-31, -32, -33, -34, -34, -34, -34, -33, -32, -31, -29, -28, -28, -26, -26, -26,
-24, -24, -22, -20, -18, -16, -13, -11, -8, -5, -3, 0, 2, 4, 6, 9, 10, 13, 15,
18, 21, 23, 26, 29, 31, 33, 35, 36, 37, 37, 37, 37, 35, 33, 31, 28, 25, 23, 19,
18, 17, 14, 13, 12, 8, 7, 4, 0, -3, -6, -9, -11, -14, -17, -19, -21, -24, -25,
-27, -29, -30, -31, -33, -34, -35, -36, -36, -36, -36, -35, -34, -34, -33, -32,
-31, -30, -29, -29, -27, -25, -23, -20, -18, -15, -12, -10, -7, -4, -2, 0, 3, 4,
7, 9, 11, 14, 17, 19, 22, 25, 26, 31, 32, 35, 36, 36, 37, 37, 36, 35, 34, 32,
29, 26, 23, 22, 20, 18, 17, 16, 14, 12, 10, 7, 4, 1, -3, -5, -8, -11, -14, -16,
-18, -20, -22, -23, -25, -26, -27, -28, -30, -31, -32, -33, -34, -34, -34, -34,
-34, -33, -32, -31, -30, -29, -28, -27, -25, -23, -21, -18, -16, -13, -10, -8,
-6, -3, -1, 1, 3, 5, 8, 10, 12, 15, 17, 20, 23, 26, 29, 31, 33, 35, 37, 37, 38,
38, 37, 36, 35, 33, 30, 28, 26, 23, 22, 21, 20, 19, 17, 15, 14, 10, 7, 4, 0, -3,
-6, -9, -12, -14, -17, -19, -20, -22, -24, -25, -26, -27, -28, -30, -31, -32,
-34, -35, -35, -35, -35, -34, -34, -32, -30, -29, -27, -25, -24, -22, -20, -18,
-16, -13, -11, -9, -7, -5, -3, -1, 1, 3, 5, 7, 10, 12, 14, 17, 20, 23, 25, 28,
31, 33, 35, 36, 37, 38, 37, 37, 35, 34, 32, 30, 27, 25, 24, 22, 21, 20, 20, 17,
16, 14, 10, 7, 3, -2, -5, -7, -11, -13, -15, -18, -20, -22, -24, -24, -26, -27,
-28, -29, -30, -31, -33, -34, -35, -36, -36, -36, -36, -35, -34, -32, -30, -28,
-26, -23, -21, -20, -18, -16, -14, -12, -11, -9, -7, -5, -3, -1, 1, 3, 5, 7, 10,
12, 15, 18, 21, 23, 26, 29, 31, 34, 35, 36, 37, 38, 36, 36, 35, 32, 30, 29, 26,
23, 22, 20, 20, 19, 18, 16, 14, 11, 8, 4, 0, -5, -8, -12, -16, -17, -20, -22,
-23, -25, -26, -27, -27, -28, -29, -29, -31, -31, -33, -34, -35, -37, -37, -38,
-38, -37, -35, -34, -31, -28, -25, -22, -19, -17, -15, -14, -13, -12, -10, -9,
-7, -6, -4, -1, 0, 3, 5, 7, 10, 12, 15, 18, 22, 25, 27, 31, 33, 34, 36, 37, 38,
38, 37, 36, 36, 33, 30, 29, 26, 23, 22, 21, 19, 19, 18, 16, 14, 11, 8, 3, -1,
-6, -10, -13, -16, -19, -20, -21, -23, -23, -24, -24, -24, -25, -26, -26, -27,
-29, -30, -32, -34, -35, -37, -37, -37, -37, -36, -34, -32, -29, -25, -21, -17,
-14, -13, -11, -10, -10, -10, -9, -8, -7, -5, -3, 0, 3, 6, 8, 11, 14, 17, 19,
23, 26, 28, 31, 34, 35, 37, 38, 38, 39, 39, 38, 37, 36, 34, 31, 29, 26, 24, 21,
19, 17, 16, 14, 12, 10, 7, 3, -1, -5, -9, -12, -16, -18, -19, -20, -20, -21,
-21, -21, -22, -22, -23, -24, -25, -26, -28, -29, -30, -33, -34, -35, -36, -36,
-36, -35, -34, -32, -30, -27, -24, -20, -17, -15, -12, -10, -10, -9, -8, -8, -7,
-6, -5, -2, 1, 4, 8, 12, 15, 18, 20, 23, 26, 28, 30, 32, 34, 36, 37, 38, 39, 40,
40, 39, 38, 37, 35, 33, 30, 28, 24, 20, 17, 14, 12, 10, 8, 7, 5, 2, -1, -5, -9,
-12, -16, -19, -19, -21, -21, -21, -22, -21, -23, -24, -24, -26, -26, -28, -29,
-31, -32, -34, -35, -36, -38, -38, -37, -37, -35, -32, -30, -28, -25, -23, -19,
-17, -14, -11, -10, -7, -6, -5, -3, -2, -1, 1, 4, 7, 11, 14, 18, 21, 23, 26, 28,
30, 32, 34, 36, 37, 38, 39, 41, 40, 41, 40, 39, 39, 37, 36, 33, 30, 27, 22, 17,
14, 9, 6, 4, 3, 2, 1, -2, -5, -7, -11, -16, -19, -22, -23, -25, -25, -25, -25,
-26, -27, -27, -28, -29, -31, -32, -32, -34, -35, -35, -37, -38, -39, -40, -39,
-37, -35, -33, -29, -27, -24, -21, -18, -16, -13, -11, -8, -5, -3, 0, 2, 4, 6,
8, 10, 14, 17, 20, 24, 27, 29, 32, 34, 36, 38, 39, 40, 42, 43, 44, 45, 45, 45,
44, 43, 42, 38, 39, 36, 28, 29, 21, 16, 14, 5, 0, -2, -6, -9, -7, -10, -12, -11,
-15, -19, -21, -26, -30, -30, -32, -33, -30, -30, -30, -29, -30, -32, -32, -34,
-35, -35, -36, -36, -35, -37, -38, -37, -38, -37, -35, -33, -29, -25, -22, -18,
-15, -13, -10, -8, -6, -3, -1, 2, 6, 8, 10, 13, 15, 18, 22, 24, 27, 31, 33, 37,
40, 41, 43, 45, 45, 46, 48, 49, 49, 50, 50, 49, 48, 46, 43, 40, 36, 32, 27, 22,
17, 11, 5, -1, -7, -11, -16, -19, -19, -21, -21, -22, -24, -27, -28, -32, -36,
-36, -38, -38, -36, -35, -34, -33, -34, -35, -35, -36, -38, -38, -38, -37, -37,
-37, -36, -36, -34, -34, -33, -29, -25, -22, -18, -14, -11, -7, -5, -3, 0, 2, 4,
7, 10, 13, 17, 21, 24, 27, 30, 32, 35, 38, 40, 43, 45, 47, 49, 50, 50, 51, 52,
52, 52, 52, 51, 50, 48, 44, 40, 37, 31, 26, 21, 14, 8, 2, -5, -11, -15, -23,
-25, -26, -28, -29, -29, -30, -31, -32, -38, -39, -41, -46, -45, -44, -43, -40,
-38, -39, -37, -37, -40, -38, -40, -40, -37, -38, -36, -34, -33, -33, -30, -29,
-27, -22, -20, -15, -10, -5, -1, 2, 4, 7, 9, 11, 14, 17, 20, 24, 27, 30, 34, 36,
38, 41, 43, 45, 48, 50, 51, 54, 55, 55, 55, 55, 54, 53, 52, 50, 49, 47, 43, 39,
36, 30, 24, 21, 14, 7, 3, -4, -11, -14, -21, -28, -29, -35, -41, -41, -44, -47,
-45, -48, -48, -46, -48, -48, -47, -47, -47, -46, -46, -44, -43, -43, -41, -39,
-39, -37, -36, -34, -32, -30, -28, -25, -23, -19, -15, -12, -7, -4, 0, 4, 8, 10,
14, 17, 19, 22, 25, 27, 31, 34, 35, 38, 41, 42, 45, 47, 48, 50, 51, 52, 52, 53,
54, 52, 52, 52, 50, 49, 48, 44, 42, 40, 34, 31, 27, 20, 15, 10, 4, -3, -8, -16,
-21, -27, -35, -39, -44, -48, -51, -54, -56, -56, -58, -59, -58, -57, -56, -54,
-54, -54, -51, -50, -48, -44, -42, -39, -36, -35, -32, -30, -29, -27, -24, -22,
-17, -14, -11, -4, 0, 2, 7, 9, 12, 16, 18, 20, 25, 27, 29, 33, 35, 36, 38, 40,
41, 43, 45, 47, 49, 50, 51, 52, 51, 51, 51, 50, 48, 47, 47, 45, 44, 42, 39, 37,
33, 27, 23, 19, 12, 7, 3, -5, -11, -15, -24, -28, -33, -43, -46, -49, -56, -58,
-59, -64, -62, -62, -66, -63, -61, -62, -59, -55, -55, -51, -47, -47, -41, -39,
-38, -33, -30, -29, -25, -21, -19, -14, -11, -8, -3, 1, 5, 8, 13, 17, 19, 23,
26, 28, 32, 33, 35, 38, 40, 41, 44, 46, 47, 49, 51, 51, 53, 53, 52, 53, 53, 51,
51, 50, 48, 46, 45, 43, 41, 39, 36, 33, 29, 25, 20, 15, 11, 4, -2, -7, -13, -22,
-26, -32, -40, -44, -50, -55, -56, -60, -65, -64, -66, -70, -68, -67, -68, -65,
-63, -61, -57, -53, -51, -47, -42, -40, -35, -32, -27, -23, -20, -16, -12, -8,
-4, 1, 6, 12, 17, 21, 26, 29, 32, 35, 37, 40, 42, 43, 46, 49, 49, 52, 54, 54,
55, 56, 55, 56, 56, 54, 54, 54, 51, 50, 49, 45, 43, 42, 38, 35, 34, 30, 26, 25,
19, 14, 10, 4, -2, -7, -14, -20, -24, -31, -37, -41, -47, -52, -58, -60, -64,
-68, -69, -71, -71, -73, -72, -72, -71, -69, -68, -64, -61, -57, -53, -48, -43,
-38, -33, -29, -23, -18, -15, -9, -4, 2, 6, 13, 19, 24, 29, 33, 38, 41, 44, 47,
49, 51, 53, 55, 56, 58, 59, 60, 60, 60, 60, 59, 59, 58, 56, 55, 53, 51, 49, 46,
43, 40, 37, 33, 30, 26, 22, 18, 14, 9, 4, -2, -8, -12, -19, -25, -30, -36, -43,
-46, -53, -57, -59, -66, -70, -70, -74, -78, -76, -77, -77, -75, -74, -73, -68,
-66, -65, -59, -54, -51, -46, -40, -36, -30, -25, -20, -13, -8, -2, 4, 10, 17,
23, 28, 34, 40, 43, 46, 51, 53, 54, 57, 59, 59, 62, 63, 63, 66, 65, 64, 65, 65,
62, 61, 60, 57, 54, 52, 49, 46, 43, 39, 35, 32, 28, 23, 19, 16, 10, 4, 0, -7,
-14, -19, -26, -33, -37, -44, -50, -54, -58, -63, -68, -70, -74, -77, -79, -80,
-81, -81, -80, -80, -78, -75, -72, -69, -64, -59, -56, -50, -44, -39, -34, -29,
-21, -15, -9, -2, 4, 11, 19, 25, 30, 37, 43, 47, 52, 56, 59, 62, 64, 65, 67, 68,
69, 70, 71, 71, 70, 71, 70, 68, 66, 64, 61, 58, 55, 51, 48, 45, 40, 36, 33, 28,
23, 18, 13, 9, 2, -3, -9, -16, -21, -29, -37, -41, -45, -55, -60, -62, -67, -73,
-76, -77, -80, -81, -84, -85, -83, -82, -84, -82, -76, -75, -73, -67, -62, -58,
-52, -47, -42, -34, -29, -23, -15, -8, 0, 6, 14, 23, 29, 35, 44, 49, 52, 59, 62,
65, 69, 71, 72, 75, 78, 77, 78, 81, 79, 78, 78, 77, 74, 72, 69, 64, 62, 57, 52,
49, 44, 38, 34, 30, 24, 19, 14, 9, 3, -4, -10, -17, -24, -30, -37, -46, -50,
-55, -66, -66, -72, -78, -80, -84, -88, -89, -89, -91, -91, -90, -88, -88, -86,
-78, -78, -73, -66, -64, -55, -50, -44, -38, -29, -23, -17, -9, -2, 7, 15, 22,
31, 37, 44, 52, 57, 61, 68, 70, 73, 77, 77, 79, 82, 82, 82, 82, 83, 82, 80, 79,
77, 73, 70, 67, 61, 58, 53, 47, 44, 38, 32, 28, 23, 17, 11, 5, -1, -8, -15, -21,
-27, -35, -39, -48, -54, -56, -65, -69, -72, -77, -81, -85, -88, -89, -90, -91,
-91, -93, -87, -87, -87, -79, -76, -73, -66, -62, -55, -48, -42, -36, -29, -21,
-15, -9, 1, 9, 16, 25, 32, 41, 47, 54, 61, 65, 70, 72, 74, 78, 79, 80, 82, 82,
82, 83, 82, 82, 80, 78, 76, 72, 69, 65, 59, 56, 51, 45, 41, 36, 32, 26, 22, 18,
12, 6, 0, -5, -11, -19, -24, -31, -38, -42, -49, -56, -58, -62, -70, -72, -73,
-80, -81, -83, -87, -86, -86, -88, -87, -84, -82, -80, -78, -69, -67, -65, -54,
-51, -46, -35, -33, -27, -18, -13, -6, 1, 10, 18, 24, 34, 41, 47, 56, 61, 65,
69, 72, 74, 75, 78, 78, 77, 80, 78, 77, 79, 77, 76, 74, 71, 68, 65, 61, 57, 52,
48, 42, 37, 34, 29, 24, 21, 17, 13, 7, 2, -2, -9, -15, -21, -28, -34, -39, -47,
-52, -54, -61, -66, -68, -72, -75, -79, -80, -82, -85, -83, -86, -87, -83, -82,
-82, -76, -72, -68, -63, -57, -51, -46, -38, -32, -29, -20, -15, -10, -1, 4, 12,
19, 27, 35, 41, 51, 57, 60, 67, 70, 72, 75, 76, 76, 76, 76, 76, 74, 75, 75, 72,
72, 70, 66, 65, 60, 56, 53, 47, 42, 37, 33, 30, 25, 21, 18, 14, 10, 5, 1, -3,
-9, -15, -21, -26, -32, -38, -43, -50, -53, -56, -64, -65, -69, -72, -74, -79,
-81, -79, -83, -85, -81, -83, -79, -79, -76, -70, -68, -62, -58, -51, -44, -40,
-33, -28, -20, -17, -11, -2, 3, 8, 17, 24, 30, 40, 45, 52, 59, 62, 66, 68, 72,
73, 71, 73, 73, 72, 71, 71, 70, 69, 67, 65, 62, 61, 58, 53, 51, 46, 41, 38, 33,
30, 27, 23, 21, 18, 15, 12, 8, 4, -2, -7, -12, -18, -24, -29, -33, -39, -44,
-48, -52, -56, -60, -65, -66, -72, -75, -77, -80, -80, -83, -83, -80, -79, -78,
-72, -69, -63, -58, -56, -47, -43, -38, -32, -27, -20, -16, -11, -4, 3, 10, 16,
24, 33, 39, 46, 53, 58, 65, 66, 68, 71, 70, 71, 70, 69, 70, 68, 67, 67, 66, 65,
64, 61, 58, 55, 51, 46, 42, 38, 32, 30, 26, 24, 21, 20, 19, 17, 16, 13, 10, 7,
1, -5, -9, -15, -21, -26, -30, -33, -39, -42, -42, -51, -53, -53, -62, -65, -67,
-72, -76, -78, -78, -80, -79, -77, -74, -71, -66, -61, -58, -51, -45, -43, -39,
-30, -27, -24, -17, -14, -8, 0, 3, 11, 20, 27, 35, 41, 49, 55, 58, 62, 64, 64,
64, 65, 64, 62, 63, 62, 61, 63, 61, 60, 61, 59, 55, 52, 48, 45, 39, 33, 30, 25,
22, 20, 18, 18, 19, 18, 16, 15, 13, 9, 5, -1, -8, -11, -18, -24, -27, -31, -35,
-38, -41, -43, -45, -51, -54, -56, -64, -68, -72, -77, -77, -82, -81, -79, -77,
-73, -70, -64, -58, -53, -49, -44, -38, -34, -30, -26, -21, -18, -12, -9, -2, 5,
11, 20, 25, 34, 42, 47, 53, 57, 59, 61, 61, 59, 59, 59, 58, 56, 56, 56, 56, 57,
56, 56, 55, 52, 49, 44, 40, 35, 29, 24, 20, 18, 17, 17, 17, 18, 19, 19, 18, 16,
14, 9, 3, -4, -8, -15, -21, -24, -28, -31, -33, -36, -38, -40, -41, -47, -53,
-55, -63, -70, -71, -77, -81, -79, -79, -79, -75, -67, -64, -59, -50, -48, -43,
-37, -35, -32, -28, -24, -22, -18, -13, -7, 0, 8, 15, 24, 33, 40, 47, 52, 57,
58, 58, 58, 56, 57, 56, 54, 54, 55, 55, 56, 57, 57, 57, 56, 53, 48, 44, 38, 31,
26, 20, 16, 14, 13, 14, 16, 17, 19, 21, 20, 19, 16, 13, 7, 0, -7, -12, -17, -22,
-24, -27, -28, -28, -29, -33, -33, -36, -44, -49, -57, -62, -68, -74, -77, -80,
-78, -76, -74, -69, -61, -56, -52, -47, -42, -38, -36, -33, -32, -29, -25, -22,
-19, -12, -4, 2, 10, 19, 27, 34, 41, 46, 49, 52, 53, 52, 50, 51, 50, 49, 50, 50,
51, 53, 55, 55, 55, 55, 52, 49, 44, 39, 33, 28, 24, 19, 17, 19, 20, 21, 24, 26,
28, 28, 28, 25, 20, 16, 9, 0, -5, -10, -15, -17, -19, -21, -22, -22, -26, -31,
-30, -38, -46, -53, -62, -66, -75, -81, -80, -81, -81, -76, -74, -67, -59, -58,
-52, -47, -44, -42, -41, -37, -34, -31, -29, -23, -15, -10, -2, 6, 15, 24, 29,
35, 42, 46, 48, 49, 50, 51, 50, 50, 49, 52, 54, 53, 55, 56, 57, 56, 54, 52, 49,
44, 39, 33, 28, 24, 20, 19, 18, 19, 21, 22, 25, 26, 26, 27, 24, 21, 16, 11, 6,
-1, -6, -9, -12, -15, -16, -16, -18, -20, -25, -28, -31, -40, -47, -54, -62,
-68, -74, -79, -78, -79, -78, -74, -70, -65, -61, -56, -53, -49, -46, -45, -41,
-38, -35, -31, -27, -20, -13, -8, 0, 9, 16, 22, 28, 34, 38, 42, 44, 45, 48, 48,
48, 49, 50, 52, 52, 53, 54, 54, 54, 53, 50, 48, 44, 41, 36, 32, 29, 23, 21, 20,
19, 19, 20, 22, 23, 24, 25, 24, 23, 21, 18, 14, 10, 6, 0, -4, -5, -9, -10, -11,
-13, -15, -19, -24, -27, -33, -41, -48, -56, -60, -67, -73, -73, -74, -75, -72,
-70, -67, -61, -59, -56, -52, -48, -46, -44, -40, -37, -33, -28, -23, -15, -10,
-3, 3, 9, 17, 20, 25, 32, 34, 37, 40, 42, 45, 46, 48, 50, 51, 52, 52, 53, 53,
52, 51, 49, 47, 44, 40, 38, 34, 31, 29, 25, 24, 22, 21, 21, 21, 23, 23, 23, 25,
23, 22, 21, 18, 15, 11, 8, 3, 0, -2, -6, -8, -10, -14, -17, -20, -25, -31, -36,
-42, -49, -56, -62, -65, -70, -74, -73, -74, -72, -70, -68, -63, -60, -56, -53,
-50, -45, -43, -39, -35, -30, -24, -20, -13, -7, -2, 5, 9, 15, 20, 25, 30, 32,
37, 40, 41, 46, 46, 48, 50, 49, 51, 50, 50, 50, 48, 48, 45, 42, 40, 37, 36, 33,
30, 28, 25, 24, 22, 20, 21, 20, 22, 22, 23, 23, 23, 23, 23, 21, 19, 16, 13, 8,
5, 2, -2, -4, -7, -10, -13, -16, -21, -28, -30, -36, -45, -48, -56, -62, -64,
-71, -71, -72, -73, -70, -70, -66, -61, -59, -55, -51, -47, -44, -39, -35, -32,
-25, -21, -17, -8, -5, 2, 8, 12, 18, 22, 28, 31, 34, 39, 40, 44, 46, 46, 49, 48,
49, 50, 47, 49, 47, 45, 44, 42, 40, 37, 35, 33, 30, 29, 26, 23, 21, 19, 19, 18,
18, 19, 19, 21, 22, 23, 24, 23, 23, 21, 19, 17, 13, 10, 6, 4, 0, -3, -4, -8,
-12, -15, -21, -25, -30, -38, -44, -50, -56, -60, -65, -68, -69, -70, -70, -67,
-65, -62, -59, -57, -53, -49, -46, -42, -38, -33, -28, -22, -17, -12, -6, -1, 4,
8, 13, 18, 21, 26, 29, 32, 36, 39, 42, 45, 46, 48, 48, 49, 48, 46, 46, 45, 43,
41, 39, 37, 35, 34, 32, 29, 28, 26, 23, 21, 20, 19, 18, 18, 19, 20, 21, 22, 23,
24, 25, 25, 24, 23, 20, 17, 14, 10, 7, 3, 0, -3, -8, -10, -14, -21, -24, -29,
-36, -42, -47, -55, -60, -63, -69, -71, -72, -72, -72, -69, -66, -63, -60, -54,
-52, -48, -43, -39, -35, -30, -24, -20, -15, -9, -4, 1, 6, 11, 15, 19, 25, 28,
32, 36, 38, 41, 44, 46, 47, 47, 47, 47, 45, 45, 44, 43, 40, 40, 37, 34, 33, 31,
28, 27, 24, 22, 20, 18, 17, 16, 17, 17, 19, 21, 22, 24, 25, 26, 27, 26, 25, 24,
21, 18, 14, 11, 9, 5, 2, -1, -5, -8, -14, -18, -24, -30, -35, -45, -50, -55,
-64, -68, -72, -75, -75, -76, -74, -72, -69, -65, -63, -57, -54, -49, -45, -42,
-36, -33, -27, -21, -17, -8, -3, 2, 10, 13, 19, 24, 28, 33, 35, 39, 42, 43, 48,
48, 50, 51, 52, 52, 50, 49, 48, 45, 44, 40, 38, 35, 31, 29, 25, 24, 21, 18, 18,
15, 14, 13, 13, 14, 14, 17, 19, 20, 23, 24, 25, 26, 26, 27, 25, 25, 22, 18, 17,
13, 11, 7, 4, 1, -5, -9, -14, -21, -28, -34, -43, -50, -55, -61, -68, -71, -73,
-76, -76, -74, -74, -71, -68, -65, -63, -59, -54, -52, -46, -40, -34, -28, -20,
-13, -7, 0, 7, 11, 17, 23, 26, 29, 34, 36, 38, 41, 45, 48, 50, 53, 53, 54, 53,
51, 48, 46, 43, 39, 35, 32, 29, 25, 23, 21, 20, 19, 18, 16, 14, 14, 11, 10, 11,
11, 12, 14, 17, 19, 21, 25, 27, 29, 31, 32, 31, 29, 27, 23, 19, 17, 13, 11, 7,
3, -1, -6, -11, -19, -25, -30, -41, -48, -56, -64, -70, -77, -78, -80, -82, -79,
-79, -77, -73, -69, -66, -62, -55, -51, -47, -40, -36, -28, -21, -14, -5, 1, 9,
14, 20, 27, 29, 34, 37, 39, 41, 41, 43, 44, 46, 48, 48, 49, 48, 47, 45, 42, 40,
36, 31, 28, 23, 20, 15, 12, 10, 8, 8, 6, 6, 5, 4, 3, 3, 3, 6, 8, 11, 14, 17, 20,
24, 28, 31, 34, 37, 38, 38, 36, 34, 32, 28, 26, 23, 19, 15, 9, 5, -3, -10, -16,
-25, -33, -41, -51, -59, -66, -74, -79, -81, -83, -84, -82, -81, -79, -75, -73,
-68, -64, -58, -53, -50, -42, -35, -30, -22, -13, -4, 4, 11, 17, 22, 27, 29, 32,
35, 35, 36, 37, 37, 40, 41, 44, 47, 48, 49, 47, 45, 41, 38, 33, 27, 23, 17, 12,
9, 5, 4, 3, 4, 4, 4, 5, 3, 2, 1, 0, 2, 4, 7, 11, 15, 20, 25, 31, 38, 44, 48, 51,
53, 52, 49, 47, 43, 39, 36, 32, 29, 24, 20, 14, 6, 2, -5, -16, -22, -34, -46,
-55, -66, -74, -80, -85, -88, -89, -88, -89, -86, -82, -79, -74, -70, -65, -61,
-58, -52, -47, -41, -32, -25, -15, -6, 2, 10, 15, 22, 28, 31, 36, 37, 37, 36,
36, 37, 38, 42, 45, 47, 50, 49, 48, 46, 43, 40, 35, 30, 24, 17, 12, 6, 2, 2, 1,
2, 4, 4, 5, 4, 3, 2, 2, 5, 8, 10, 14, 19, 23, 28, 35, 42, 48, 54, 57, 59, 59,
57, 54, 51, 50, 47, 42, 38, 33, 28, 21, 15, 7, -1, -9, -20, -32, -43, -54, -65,
-75, -82, -87, -91, -95, -97, -97, -97, -96, -93, -89, -85, -81, -76, -72, -66,
-60, -53, -44, -35, -25, -15, -6, 3, 11, 19, 24, 30, 36, 38, 41, 42, 41, 42, 41,
41, 44, 47, 50, 51, 52, 51, 49, 46, 41, 38, 32, 25, 18, 11, 6, 1, -3, -4, -3,
-3, -3, -3, -5, -7, -8, -8, -8, -6, -2, 4, 9, 16, 25, 31, 38, 46, 53, 59, 62,
61, 62, 63, 61, 59, 58, 59, 58, 54, 52, 48, 42, 35, 26, 15, 5, -8, -24, -38,
-49, -62, -73, -80, -87, -91, -96, -99, -100, -102, -102, -103, -102, -98, -99,
-96, -91, -86, -78, -71, -59, -49, -37, -24, -16, -4, 6, 14, 22, 28, 35, 39, 41,
44, 46, 48, 49, 51, 52, 52, 57, 56, 56, 58, 54, 52, 48, 43, 37, 30, 24, 16, 11,
6, 2, -1, -4, -4, -4, -5, -4, -6, -6, -6, -8, -9, -9, -9, -8, -5, 1, 7, 14, 22,
29, 36, 42, 47, 50, 52, 54, 54, 54, 54, 52, 52, 52, 51, 51, 48, 43, 37, 30, 19,
10, 1, -14, -23, -33, -47, -52, -60, -69, -72, -77, -81, -84, -88, -92, -94,
-95, -97, -97, -93, -89, -83, -78, -70, -60, -53, -43, -33, -24, -14, -7, 0, 7,
13, 20, 24, 30, 35, 38, 42, 45, 47, 48, 49, 50, 48, 48, 48, 46, 45, 43, 40, 38,
34, 30, 25, 21, 18, 12, 8, 5, 1, -2, -4, -6, -7, -8, -9, -11, -10, -10, -12,
-12, -11, -9, -7, -1, 4, 9, 16, 20, 24, 30, 33, 37, 39, 41, 43, 45, 46, 47, 49,
52, 53, 54, 53, 51, 46, 38, 31, 22, 14, 6, -4, -12, -20, -30, -37, -42, -50,
-56, -57, -65, -72, -75, -83, -89, -90, -92, -92, -88, -87, -84, -75, -70, -64,
-55, -49, -40, -34, -28, -21, -18, -12, -8, -2, 4, 11, 17, 20, 26, 30, 32, 35,
35, 35, 32, 28, 27, 24, 25, 25, 25, 27, 27, 25, 24, 22, 20, 16, 13, 9, 4, 1, -5,
-7, -8, -9, -6, -5, -1, 3, 5, 8, 10, 12, 14, 16, 17, 21, 24, 27, 31, 37, 41, 46,
52, 57, 61, 64, 66, 67, 68, 68, 66, 64, 62, 58, 54, 48, 40, 31, 24, 14, 4, -4,
-14, -26, -36, -45, -54, -62, -68, -75, -80, -83, -90, -95, -96, -100, -100,
-100, -99, -94, -91, -86, -80, -72, -63, -58, -49, -40, -33, -26, -20, -14, -8,
-2, 4, 8, 16, 19, 20, 23, 24, 26, 25, 24, 24, 29, 35, 36, 41, 44, 43, 43, 39,
38, 35, 30, 26, 21, 17, 12, 7, 5, 5, 7, 6, 6, 6, 1, -1, -5, -10, -14, -18, -22,
-24, -23, -20, -16, -5, 6, 17, 29, 39, 45, 48, 51, 53, 54, 57, 57, 60, 66, 69,
72, 78, 87, 93, 96, 98, 94, 86, 73, 54, 37, 22, 6, -9, -20, -27, -37, -44, -51,
-57, -61, -65, -72, -80, -89, -100, -110, -121, -125, -127, -128, -121, -115,
-106, -94, -87, -75, -64, -56, -46, -40, -36, -33, -31, -28, -22, -15, -8, 4,
15, 23, 33, 37, 41, 45, 41, 42, 48, 47, 48, 49, 47, 46, 46, 44, 46, 49, 48, 46,
43, 38, 32, 24, 17, 14, 9, 4, 0, -7, -11, -14, -20, -22, -23, -24, -27, -28,
-30, -33, -33, -32, -28, -21, -11, -2, 6, 16, 24, 31, 40, 47, 53, 61, 67, 70,
73, 77, 81, 85, 91, 96, 100, 101, 99, 92, 84, 73, 59, 46, 35, 21, 8, -6, -19,
-31, -42, -51, -58, -65, -73, -81, -90, -100, -107, -116, -122, -122, -124,
-123, -119, -116, -108, -101, -98, -84, -74, -69, -58, -50, -45, -38, -34, -31,
-22, -14, -9, 0, 7, 12, 18, 20, 24, 28, 28, 34, 39, 43, 48, 49, 49, 49, 49, 47,
45, 45, 41, 38, 34, 28, 25, 19, 17, 16, 13, 12, 7, 4, 1, -6, -9, -13, -13, -13,
-13, -9, -6, -2, 2, 7, 14, 20, 27, 30, 35, 40, 41, 45, 49, 52, 59, 64, 70, 75,
79, 82, 83, 84, 82, 79, 75, 67, 58, 47, 36, 24, 12, 2, -7, -14, -23, -32, -40,
-49, -57, -65, -74, -81, -88, -96, -103, -107, -112, -114, -112, -110, -103,
-97, -91, -83, -77, -69, -61, -53, -43, -37, -30, -23, -18, -12, -7, 0, 8, 15,
22, 23, 28, 31, 29, 29, 27, 25, 20, 13, 10, 10, 13, 15, 17, 23, 26, 26, 25, 23,
23, 19, 14, 11, 8, 4, 0, -2, 0, 3, 7, 9, 14, 16, 16, 15, 9, 5, 2, -4, -7, -8,
-8, -8, -5, 1, 9, 18, 27, 35, 41, 44, 46, 46, 44, 44, 43, 45, 49, 51, 55, 60,
65, 70, 73, 76, 76, 72, 64, 54, 42, 28, 14, 3, -5, -12, -20, -25, -30, -35, -41,
-47, -53, -60, -68, -75, -84, -92, -100, -105, -106, -104, -102, -96, -86, -80,
-73, -67, -61, -53, -50, -44, -37, -35, -31, -29, -27, -20, -15, -10, -1, 7, 11,
15, 16, 15, 16, 12, 6, 3, -2, -3, 0, 3, 8, 14, 19, 24, 28, 29, 31, 30, 26, 23,
19, 14, 13, 11, 12, 16, 20, 25, 30, 34, 37, 38, 35, 31, 27, 22, 17, 12, 9, 8, 7,
8, 12, 17, 23, 28, 30, 33, 34, 33, 31, 28, 27, 27, 27, 28, 32, 36, 41, 46, 50,
54, 55, 53, 48, 41, 33, 23, 13, 5, -1, -5, -8, -12, -15, -16, -20, -24, -28,
-35, -42, -50, -59, -68, -74, -80, -85, -83, -82, -79, -72, -68, -64, -58, -56,
-53, -51, -47, -47, -45, -41, -41, -37, -33, -29, -21, -17, -11, -7, -2, 2, -1,
0, -2, -5, -9, -17, -19, -19, -17, -7, 0, 10, 20, 24, 27, 29, 30, 27, 25, 22,
17, 16, 11, 8, 11, 15, 22, 29, 35, 41, 43, 41, 38, 31, 23, 16, 11, 7, 6, 7, 8,
14, 20, 28, 39, 46, 51, 52, 51, 49, 45, 40, 37, 37, 41, 43, 47, 54, 60, 65, 68,
71, 71, 67, 58, 45, 33, 19, 5, -7, -15, -18, -21, -23, -26, -29, -32, -38, -44,
-52, -60, -69, -79, -86, -94, -99, -101, -100, -93, -89, -82, -73, -70, -64,
-58, -56, -50, -47, -45, -39, -36, -35, -31, -25, -23, -16, -8, -4, 3, 6, 8, 9,
6, 5, 1, -3, -6, -14, -17, -15, -14, -6, 3, 11, 19, 23, 25, 24, 24, 20, 16, 12,
8, 7, 3, 3, 9, 13, 21, 30, 36, 44, 47, 46, 43, 38, 32, 26, 23, 21, 22, 24, 27,
34, 40, 48, 57, 61, 64, 64, 60, 56, 50, 44, 40, 40, 41, 42, 45, 49, 53, 55, 56,
54, 50, 43, 31, 18, 5, -9, -21, -30, -35, -37, -38, -39, -40, -42, -45, -49,
-55, -63, -69, -77, -85, -90, -96, -98, -96, -93, -88, -79, -70, -63, -55, -50,
-48, -42, -39, -37, -33, -31, -28, -23, -20, -13, -6, 1, 7, 14, 17, 19, 21, 16,
15, 13, 6, 2, -3, -10, -13, -14, -9, 0, 8, 18, 26, 28, 28, 25, 20, 19, 16, 9, 7,
8, 4, 4, 8, 14, 23, 32, 38, 43, 44, 41, 34, 25, 20, 14, 10, 11, 14, 17, 23, 30,
37, 47, 56, 60, 62, 60, 54, 47, 41, 36, 33, 36, 41, 46, 53, 59, 64, 67, 68, 66,
61, 52, 39, 23, 8, -6, -20, -29, -32, -33, -33, -33, -35, -40, -43, -48, -57,
-62, -70, -80, -86, -93, -97, -97, -95, -89, -81, -70, -64, -58, -50, -47, -42,
-39, -34, -29, -29, -25, -23, -19, -13, -8, 0, 9, 18, 19, 21, 24, 18, 16, 13, 7,
5, -2, -10, -18, -22, -21, -18, -8, 4, 13, 19, 20, 20, 16, 12, 10, 6, 4, 2, -1,
-2, 0, 5, 13, 24, 36, 44, 50, 51, 47, 41, 33, 26, 22, 19, 19, 19, 22, 27, 32,
41, 51, 60, 65, 65, 61, 53, 46, 38, 32, 31, 32, 36, 40, 46, 51, 56, 61, 63, 63,
60, 51, 39, 23, 9, -5, -17, -22, -26, -26, -25, -26, -28, -31, -34, -39, -47,
-55, -64, -75, -84, -90, -95, -95, -91, -86, -78, -71, -65, -58, -54, -50, -46,
-43, -40, -39, -37, -34, -31, -23, -16, -7, 4, 11, 15, 18, 18, 17, 14, 11, 7, 3,
-1, -5, -9, -13, -15, -18, -23, -22, -18, -17, -11, -4, -3, 0, 2, 0, 2, 6, 6, 8,
11, 14, 16, 20, 26, 35, 42, 48, 55, 56, 58, 58, 53, 49, 47, 42, 39, 40, 40, 40,
43, 44, 46, 50, 51, 51, 47, 42, 35, 28, 24, 20, 18, 20, 24, 27, 30, 35, 39, 41,
44, 42, 40, 36, 27, 17, 7, -2, -12, -18, -21, -24, -24, -26, -28, -31, -35, -39,
-44, -51, -57, -65, -74, -78, -84, -88, -85, -84, -81, -75, -69, -64, -58, -52,
-48, -40, -34, -31, -24, -21, -14, -11, -9, -1, 4, 7, 14, 18, 21, 25, 26, 25,
28, 27, 21, 20, 15, 12, 9, 3, -2, -7, -11, -16, -16, -11, -10, -8, -4, -4, -3,
-1, 3, 12, 19, 22, 24, 21, 19, 18, 17, 24, 34, 37, 40, 46, 47, 49, 51, 50, 56,
60, 57, 54, 49, 45, 40, 36, 37, 41, 41, 40, 36, 32, 28, 24, 20, 21, 23, 22, 19,
16, 14, 15, 17, 20, 23, 25, 21, 14, 5, -4, -13, -20, -24, -25, -27, -30, -31,
-34, -35, -34, -32, -31, -32, -39, -46, -54, -65, -71, -73, -73, -68, -64, -60,
-54, -50, -43, -32, -25, -19, -10, -8, -10, -9, -8, -9, -7, -4, 0, 6, 8, 11, 13,
13, 17, 15, 9, 8, 2, -12, -20, -30, -43, -46, -47, -46, -35, -26, -16, -4, 4,
12, 17, 18, 20, 19, 13, 13, 13, 11, 17, 28, 37, 51, 63, 70, 76, 78, 75, 69, 62,
54, 45, 36, 29, 25, 23, 24, 29, 34, 40, 43, 40, 37, 32, 23, 15, 10, 5, 3, 5, 7,
13, 21, 29, 35, 42, 45, 42, 35, 28, 15, 3, -6, -16, -22, -22, -22, -20, -13, -9,
-3, 1, 0, -5, -16, -30, -43, -56, -64, -65, -68, -66, -59, -53, -40, -35, -33,
-22, -22, -30, -36, -30, -25, -39, -40, -29, -26, -26, -21, -7, 1, 2, -5, -3, 3,
-5, -8, -15, -14, -12, -32, -35, -30, -36, -37, -42, -43, -31, -25, -20, -2, 15,
21, 28, 32, 41, 51, 44, 45, 52, 50, 51, 52, 56, 63, 66, 69, 72, 74, 69, 58, 49,
39, 27, 13, 1, -2, -4, -5, -3, 3, 11, 18, 22, 26, 29, 28, 23, 22, 23, 25, 29,
32, 41, 55, 67, 78, 87, 95, 98, 95, 90, 80, 66, 50, 35, 21, 9, -1, -11, -17,
-20, -25, -29, -33, -38, -43, -49, -57, -63, -68, -71, -71, -70, -68, -63, -58,
-52, -42, -35, -33, -28, -27, -23, -16, -9, -1, 5, 1, 8, 15, 4, 0, 2, -2, -8,
-13, -12, -17, -28, -31, -33, -34, -35, -41, -46, -45, -51, -65, -66, -72, -76,
-65, -58, -39, -13, 5, 27, 47, 60, 73, 78, 79, 84, 82, 70, 65, 60, 54, 61, 67,
70, 76, 72, 61, 55, 43, 25, 6, -14, -35, -52, -67, -75, -73, -67, -55, -38, -24,
-7, 3, 9, 18, 22, 23, 26, 29, 35, 43, 53, 65, 82, 98, 112, 120, 121, 115, 102,
84, 67, 47, 25, 3, -17, -32, -43, -51, -55, -57, -59, -63, -67, -73, -81, -88,
-93, -94, -94, -90, -82, -73, -60, -46, -33, -24, -16, -10, -12, -12, -13, -13,
-14, -16, -13, -16, -20, -16, -15, -12, -8, -15, -26, -34, -48, -61, -65, -68,
-69, -71, -73, -67, -64, -60, -49, -44, -43, -41, -50, -61, -59, -54, -41, -16,
11, 36, 54, 69, 83, 91, 99, 102, 95, 82, 66, 44, 27, 23, 24, 27, 32, 32, 27, 18,
9, -1, -14, -28, -47, -68, -85, -95, -96, -84, -62, -38, -12, 13, 31, 42, 54,
62, 66, 67, 65, 61, 58, 59, 65, 77, 93, 106, 113, 114, 107, 93, 74, 54, 30, 3,
-23, -49, -68, -80, -84, -81, -76, -70, -67, -68, -69, -73, -76, -77, -79, -78,
-73, -70, -64, -50, -34, -15, 6, 19, 22, 19, 8, 1, -4, -10, -12, -17, -26, -35,
-37, -37, -36, -30, -30, -33, -43, -56, -64, -70, -71, -72, -73, -71, -68, -67,
-60, -44, -27, -17, -16, -16, -29, -39, -37, -38, -22, 7, 23, 38, 56, 67, 75,
88, 95, 93, 82, 57, 33, 11, 1, 3, 0, 5, 10, 4, 3, 4, -1, -5, -13, -26, -47, -66,
-78, -86, -82, -67, -43, -16, 9, 37, 60, 77, 91, 97, 97, 94, 84, 71, 66, 65, 66,
78, 90, 99, 103, 100, 95, 85, 71, 52, 26, -1, -28, -52, -67, -71, -71, -68, -61,
-55, -50, -45, -43, -43, -45, -48, -52, -56, -54, -47, -35, -21, -8, 3, 9, 11,
8, 3, -3, -15, -24, -36, -48, -52, -56, -59, -55, -50, -49, -46, -46, -53, -55,
-56, -59, -62, -61, -58, -57, -51, -40, -32, -24, -15, -12, -10, -8, -12, -18,
-21, -27, -36, -37, -27, -12, 11, 35, 47, 56, 62, 61, 60, 59, 52, 40, 25, 11, 6,
6, 12, 23, 30, 35, 36, 28, 22, 17, 5, -10, -25, -41, -52, -53, -39, -16, 1, 19,
34, 42, 49, 54, 54, 54, 49, 39, 36, 41, 45, 55, 72, 89, 101, 106, 106, 102, 93,
80, 63, 44, 26, 7, -9, -14, -14, -14, -11, -8, -9, -12, -18, -27, -35, -41, -47,
-52, -52, -49, -41, -29, -15, -1, 5, 7, 6, 1, -8, -16, -25, -38, -44, -44, -42,
-36, -26, -19, -14, -11, -14, -21, -29, -40, -53, -63, -68, -71, -70, -59, -44,
-32, -21, -8, -1, 1, 1, -8, -19, -26, -37, -44, -44, -43, -43, -40, -30, -16, 3,
23, 42, 54, 53, 52, 46, 39, 40, 35, 27, 22, 18, 17, 26, 41, 50, 57, 56, 47, 38,
26, 15, 4, -10, -21, -31, -37, -31, -21, -6, 11, 25, 34, 41, 47, 49, 50, 49, 46,
46, 47, 52, 59, 68, 80, 89, 94, 97, 93, 85, 74, 62, 47, 34, 21, 9, -1, -7, -10,
-9, -9, -10, -15, -20, -27, -34, -38, -40, -42, -41, -38, -31, -22, -11, 1, 9,
14, 16, 10, 4, -4, -16, -26, -36, -46, -48, -46, -43, -35, -28, -26, -27, -32,
-37, -40, -48, -56, -65, -72, -76, -74, -63, -48, -33, -23, -13, -9, -7, -7,
-12, -17, -26, -37, -46, -52, -50, -47, -45, -43, -43, -34, -19, -3, 17, 29, 30,
28, 28, 29, 33, 37, 36, 32, 30, 29, 35, 43, 51, 55, 49, 41, 30, 18, 10, 1, -10,
-23, -36, -44, -46, -40, -30, -11, 4, 14, 27, 36, 41, 47, 49, 51, 53, 50, 48,
54, 61, 69, 79, 86, 91, 89, 81, 76, 68, 56, 43, 25, 7, -9, -22, -29, -31, -33,
-37, -40, -43, -45, -46, -47, -47, -49, -48, -45, -40, -31, -21, -11, -3, 0, 1,
0, -5, -13, -21, -33, -42, -48, -52, -47, -41, -36, -33, -35, -35, -38, -47,
-53, -62, -72, -78, -81, -79, -67, -55, -45, -27, -9, 1, 9, 16, 16, 9, 2, -6,
-16, -17, -16, -22, -16, -7, -11, -12, -13, -7, 2, 6, 11, 8, 1, -2, 1, 4, 12,
21, 14, 13, 18, 17, 25, 32, 34, 34, 30, 23, 15, 17, 19, 16, 12, 3, -2, -5, -1,
9, 11, 16, 19, 17, 23, 33, 38, 39, 42, 43, 43, 47, 51, 54, 59, 62, 64, 64, 67,
68, 65, 65, 63, 56, 49, 43, 34, 27, 22, 13, 5, 0, -6, -11, -15, -18, -20, -22,
-22, -25, -26, -25, -26, -24, -21, -21, -24, -25, -25, -27, -27, -27, -31, -33,
-34, -36, -40, -42, -44, -47, -46, -44, -43, -41, -36, -34, -31, -27, -28, -33,
-35, -34, -35, -36, -35, -37, -33, -30, -27, -21, -16, -14, -17, -18, -18, -22,
-30, -36, -41, -49, -55, -61, -58, -36, -14, 7, 24, 33, 40, 43, 47, 52, 50, 42,
30, 22, 21, 25, 34, 42, 52, 55, 52, 47, 39, 33, 20, 3, -15, -37, -51, -55, -52,
-42, -29, -14, -1, 14, 29, 38, 44, 44, 39, 36, 35, 35, 40, 48, 60, 72, 83, 91,
97, 97, 94, 87, 74, 59, 41, 23, 9, 0, -7, -11, -13, -15, -16, -17, -20, -23,
-29, -37, -46, -52, -53, -51, -45, -35, -24, -16, -9, -2, 2, 3, -1, -9, -17,
-25, -35, -41, -41, -41, -39, -35, -29, -24, -24, -24, -30, -37, -44, -57, -65,
-64, -65, -62, -52, -41, -29, -16, -7, 0, 6, 0, -6, -11, -21, -25, -30, -32,
-28, -26, -22, -17, -15, -13, -18, -21, -13, -7, 0, 4, 7, 12, 20, 31, 41, 49,
51, 48, 46, 44, 46, 46, 42, 41, 37, 33, 29, 24, 23, 19, 11, 1, -12, -19, -24,
-27, -25, -19, -13, -7, 3, 14, 24, 31, 35, 40, 45, 47, 50, 56, 62, 68, 76, 83,
88, 90, 89, 88, 84, 75, 63, 47, 31, 17, 4, -5, -12, -19, -25, -28, -30, -33,
-34, -36, -40, -44, -47, -49, -47, -40, -33, -25, -17, -9, -4, 3, 7, 7, 4, -4,
-10, -18, -25, -29, -32, -36, -40, -40, -36, -34, -32, -30, -33, -40, -48, -52,
-54, -53, -54, -54, -48, -45, -39, -27, -15, -6, -4, -3, -2, -7, -9, -11, -12,
-16, -19, -22, -27, -24, -24, -30, -24, -18, -10, 5, 12, 14, 21, 24, 26, 31, 35,
34, 31, 27, 28, 33, 36, 41, 46, 43, 42, 37, 29, 27, 21, 8, -2, -14, -24, -26,
-25, -22, -13, -4, 3, 11, 20, 26, 29, 31, 33, 35, 36, 39, 45, 53, 63, 71, 77,
82, 85, 81, 78, 72, 61, 50, 36, 23, 12, 3, -2, -7, -9, -13, -16, -19, -22, -25,
-29, -33, -38, -42, -41, -38, -31, -21, -14, -6, 0, 3, 7, 7, 4, -1, -9, -17,
-23, -30, -34, -37, -40, -40, -41, -43, -41, -41, -41, -40, -40, -43, -46, -45,
-46, -42, -37, -35, -31, -25, -22, -18, -9, -2, -1, 2, 1, -3, -7, -9, -10, -13,
-14, -19, -28, -31, -34, -41, -42, -31, -23, -13, 3, 8, 13, 25, 28, 34, 41, 39,
32, 29, 28, 30, 36, 40, 44, 45, 43, 43, 39, 34, 31, 19, 4, -7, -20, -27, -26,
-23, -15, -7, -1, 7, 16, 24, 29, 32, 32, 31, 30, 32, 39, 46, 54, 63, 69, 74, 77,
76, 74, 70, 60, 48, 36, 22, 12, 5, 0, -2, -5, -8, -10, -12, -14, -16, -19, -24,
-29, -32, -34, -31, -27, -22, -15, -10, -6, -2, -1, -1, -2, -9, -15, -19, -25,
-28, -29, -31, -32, -34, -33, -31, -31, -33, -36, -37, -37, -41, -42, -42, -41,
-42, -35, -30, -29, -22, -16, -14, -8, -7, -8, -11, -13, -15, -17, -18, -19,
-19, -20, -20, -23, -26, -27, -32, -39, -42, -38, -32, -20, -1, 9, 17, 26, 32,
40, 48, 49, 44, 37, 30, 26, 28, 32, 36, 36, 35, 35, 32, 28, 26, 17, 4, -9, -23,
-33, -35, -31, -23, -15, -8, -1, 7, 16, 24, 29, 29, 27, 25, 26, 32, 40, 47, 57,
65, 70, 74, 76, 75, 72, 65, 54, 42, 29, 19, 12, 8, 6, 2, -2, -4, -8, -11, -14,
-18, -25, -31, -35, -37, -35, -29, -25, -18, -11, -6, -1, 3, 3, 0, -5, -12, -21,
-26, -29, -28, -28, -26, -26, -30, -28, -26, -26, -27, -29, -36, -45, -50, -52,
-50, -48, -48, -42, -36, -31, -25, -17, -8, -5, -8, -7, -8, -12, -15, -13, -12,
-13, -16, -18, -18, -19, -22, -24, -29, -39, -44, -40, -32, -18, -4, 2, 11, 19,
25, 33, 39, 39, 33, 28, 22, 20, 24, 27, 33, 37, 35, 35, 31, 30, 28, 18, 8, -5,
-19, -25, -23, -16, -10, -3, 3, 8, 16, 22, 28, 31, 30, 27, 26, 30, 35, 43, 53,
64, 70, 73, 77, 78, 76, 72, 62, 50, 37, 24, 15, 9, 6, 2, -3, -7, -10, -14, -17,
-19, -24, -30, -35, -38, -38, -33, -27, -22, -17, -11, -6, -3, 0, 0, -4, -10,
-17, -21, -24, -26, -27, -28, -28, -29, -30, -31, -30, -29, -33, -37, -40, -44,
-46, -46, -43, -41, -38, -33, -29, -22, -16, -12, -7, -4, -3, -5, -7, -10, -11,
-12, -15, -15, -18, -21, -24, -27, -29, -34, -44, -47, -41, -35, -24, -7, 0, 7,
16, 22, 31, 38, 37, 34, 31, 26, 24, 28, 32, 36, 38, 35, 34, 31, 26, 24, 15, 2,
-12, -26, -32, -32, -27, -19, -12, -5, 2, 11, 19, 27, 31, 30, 30, 29, 32, 41,
49, 60, 70, 77, 81, 85, 86, 84, 79, 69, 55, 41, 27, 18, 10, 6, 3, -2, -5, -7,
-9, -11, -13, -18, -25, -30, -34, -35, -31, -27, -20, -13, -8, -3, 2, 5, 5, 3,
-2, -9, -16, -23, -27, -31, -33, -34, -36, -36, -36, -38, -41, -41, -43, -48,
-50, -51, -50, -48, -44, -35, -30, -27, -21, -15, -10, -8, -4, -3, -4, -4, -6,
-7, -7, -8, -8, -10, -13, -17, -24, -29, -34, -40, -51, -61, -56, -46, -35, -16,
0, 7, 16, 26, 34, 42, 42, 34, 30, 25, 21, 26, 33, 41, 47, 48, 49, 49, 45, 40,
32, 17, 1, -16, -29, -32, -27, -23, -16, -7, 0, 8, 16, 23, 27, 26, 23, 21, 22,
27, 35, 45, 57, 68, 73, 79, 84, 82, 79, 72, 59, 45, 32, 21, 15, 12, 10, 8, 6, 4,
1, -3, -6, -12, -22, -30, -37, -41, -40, -36, -30, -23, -17, -12, -7, -3, -2,
-3, -7, -12, -20, -28, -29, -29, -29, -28, -28, -28, -27, -23, -20, -19, -22,
-30, -35, -39, -40, -40, -39, -38, -37, -34, -30, -23, -18, -13, -10, -13, -15,
-15, -16, -16, -16, -17, -19, -22, -22, -22, -21, -20, -25, -29, -33, -42, -50,
-47, -34, -23, -6, 9, 16, 28, 38, 47, 57, 57, 51, 42, 34, 31, 30, 33, 38, 41,
39, 37, 38, 36, 35, 28, 13, -1, -16, -27, -29, -26, -24, -22, -17, -11, -4, 6,
13, 17, 17, 16, 17, 18, 26, 34, 43, 53, 61, 68, 73, 79, 80, 77, 71, 60, 48, 37,
28, 22, 16, 13, 9, 5, 3, 1, -1, -4, -9, -17, -24, -30, -34, -34, -32, -29, -26,
-22, -16, -11, -7, -5, -7, -11, -15, -19, -21, -22, -24, -25, -24, -23, -21,
-19, -22, -25, -28, -32, -33, -38, -41, -40, -42, -41, -38, -32, -27, -22, -18,
-15, -11, -14, -14, -11, -12, -12, -13, -12, -11, -14, -14, -12, -13, -16, -21,
-25, -31, -37, -48, -56, -58, -52, -42, -27, -4, 12, 22, 37, 47, 54, 57, 56, 51,
44, 38, 34, 38, 45, 49, 54, 56, 57, 56, 51, 45, 34, 19, 4, -11, -21, -25, -25,
-23, -17, -11, -7, 0, 5, 8, 9, 9, 9, 9, 13, 20, 31, 44, 56, 67, 74, 80, 82, 79,
76, 68, 56, 45, 33, 24, 17, 13, 9, 5, 1, -4, -8, -12, -18, -25, -32, -38, -43,
-45, -44, -39, -34, -28, -22, -18, -14, -10, -8, -7, -7, -8, -10, -11, -10, -9,
-8, -9, -10, -12, -16, -19, -23, -27, -32, -35, -36, -36, -35, -33, -30, -25,
-20, -16, -17, -19, -21, -20, -20, -20, -18, -17, -15, -12, -7, -3, -1, 1, -1,
-5, -8, -14, -23, -28, -30, -37, -43, -45, -47, -46, -37, -23, -9, 9, 18, 24,
33, 38, 40, 44, 43, 39, 34, 32, 34, 40, 46, 50, 53, 50, 47, 43, 36, 32, 21, 7,
-5, -15, -21, -21, -18, -15, -11, -7, -4, 2, 6, 10, 12, 13, 14, 17, 22, 31, 41,
52, 60, 67, 70, 72, 71, 67, 63, 54, 43, 33, 22, 16, 11, 7, 4, -2, -6, -10, -15,
-19, -23, -29, -36, -40, -42, -43, -38, -34, -29, -23, -19, -15, -12, -9, -9,
-12, -15, -16, -15, -14, -10, -8, -8, -9, -12, -13, -16, -22, -25, -30, -38,
-42, -41, -41, -42, -38, -35, -33, -30, -25, -19, -16, -13, -12, -12, -11, -10,
-9, -7, -8, -8, -8, -7, -5, -3, -2, -5, -8, -11, -18, -23, -27, -32, -41, -48,
-48, -43, -35, -25, -7, 7, 15, 24, 31, 35, 37, 36, 34, 31, 28, 26, 31, 40, 45,
50, 54, 54, 52, 47, 42, 36, 24, 13, 2, -4, -6, -6, -2, 3, 8, 9, 11, 14, 14, 14,
14, 13, 13, 15, 21, 30, 41, 50, 58, 62, 63, 63, 59, 54, 47, 37, 28, 20, 13, 10,
7, 5, 2, -2, -7, -14, -19, -25, -32, -38, -44, -46, -48, -46, -41, -35, -29,
-21, -17, -13, -10, -9, -11, -13, -15, -15, -11, -9, -7, -3, -2, -5, -4, -2, -5,
-10, -14, -19, -21, -22, -24, -25, -25, -27, -29, -24, -19, -19, -18, -17, -19,
-18, -16, -13, -9, -7, -8, -8, -4, -1, 1, -1, -2, -7, -15, -18, -17, -19, -23,
-25, -25, -29, -30, -27, -24, -23, -25, -23, -22, -22, -13, 0, 10, 17, 23, 29,
34, 40, 45, 49, 48, 42, 40, 37, 35, 38, 40, 39, 38, 36, 33, 32, 31, 26, 21, 14,
6, 1, -3, -2, 1, 2, 5, 8, 11, 15, 21, 26, 31, 35, 35, 36, 39, 41, 45, 47, 47,
45, 42, 39, 36, 32, 26, 18, 10, 2, -6, -12, -16, -21, -26, -31, -35, -38, -39,
-40, -41, -41, -41, -42, -37, -32, -29, -24, -17, -14, -11, -6, 0, 1, 0, 1, 0,
-3, -6, -6, -5, -7, -11, -12, -11, -12, -14, -13, -14, -17, -22, -27, -29, -30,
-33, -33, -29, -29, -29, -24, -20, -17, -14, -12, -12, -12, -12, -16, -15, -11,
-15, -17, -17, -17, -20, -22, -23, -26, -27, -31, -34, -31, -30, -27, -25, -20,
-15, -12, -1, 12, 20, 26, 33, 38, 38, 42, 46, 45, 46, 42, 39, 40, 39, 39, 40,
40, 36, 31, 29, 25, 22, 17, 13, 7, 1, -1, -3, -2, 1, 3, 5, 9, 13, 17, 22, 28,
32, 35, 37, 39, 43, 46, 48, 49, 48, 47, 43, 39, 35, 29, 22, 15, 6, -2, -8, -14,
-19, -23, -27, -32, -35, -37, -39, -40, -40, -40, -39, -38, -34, -29, -24, -18,
-13, -9, -6, -4, -3, -3, -4, -2, -3, -4, -5, -5, -3, -2, -3, -4, -6, -11, -17,
-19, -23, -28, -31, -34, -33, -32, -31, -24, -21, -19, -18, -16, -16, -14, -13,
-15, -12, -10, -12, -6, -1, 1, 2, 2, -2, -7, -10, -14, -18, -20, -22, -25, -26,
-25, -22, -21, -20, -21, -27, -30, -32, -30, -25, -17, -9, -4, 6, 14, 21, 31,
34, 33, 31, 28, 24, 21, 27, 31, 30, 37, 41, 44, 47, 50, 52, 47, 40, 30, 21, 18,
13, 13, 17, 19, 21, 26, 33, 35, 38, 38, 34, 29, 25, 24, 22, 25, 28, 28, 32, 34,
35, 35, 33, 28, 18, 9, 0, -10, -15, -20, -23, -24, -24, -22, -21, -19, -18, -19,
-22, -29, -34, -38, -39, -41, -40, -34, -30, -24, -17, -11, -7, -8, -11, -14,
-17, -19, -20, -20, -22, -22, -18, -16, -11, -10, -12, -13, -17, -21, -24, -24,
-26, -29, -27, -26, -22, -17, -13, -9, -9, -11, -11, -13, -14, -15, -14, -14,
-15, -14, -15, -12, -13, -15, -13, -17, -22, -23, -25, -26, -25, -22, -21, -22,
-22, -21, -16, -13, -7, 0, 4, 7, 10, 15, 20, 23, 25, 26, 27, 26, 26, 27, 28, 31,
31, 32, 34, 34, 36, 37, 37, 36, 31, 28, 25, 23, 21, 21, 23, 23, 25, 27, 30, 33,
35, 36, 34, 32, 32, 30, 29, 29, 29, 29, 28, 27, 26, 25, 23, 18, 14, 7, 0, -5,
-10, -14, -17, -20, -21, -21, -21, -22, -21, -22, -24, -27, -29, -31, -32, -32,
-32, -33, -31, -29, -27, -23, -20, -18, -20, -21, -21, -20, -19, -20, -17, -16,
-16, -15, -14, -11, -12, -13, -13, -14, -16, -17, -16, -15, -16, -15, -15, -15,
-16, -17, -15, -13, -15, -16, -16, -15, -15, -13, -12, -13, -14, -16, -16, -17,
-18, -17, -18, -19, -21, -20, -19, -19, -18, -18, -17, -18, -19, -16, -14, -12,
-8, -4, 2, 5, 10, 16, 20, 22, 23, 25, 25, 24, 25, 28, 32, 33, 36, 40, 41, 42,
44, 44, 43, 39, 36, 33, 30, 28, 27, 27, 26, 28, 27, 26, 27, 25, 24, 22, 19, 17,
16, 15, 16, 18, 19, 19, 21, 21, 19, 18, 15, 11, 6, 1, -3, -7, -10, -12, -13,
-14, -15, -16, -17, -18, -23, -27, -28, -31, -35, -37, -38, -37, -38, -37, -35,
-31, -30, -30, -27, -24, -23, -22, -20, -18, -15, -15, -15, -10, -8, -9, -8, -4,
-3, -6, -8, -7, -10, -13, -13, -14, -16, -19, -18, -16, -15, -15, -14, -13, -17,
-18, -18, -21, -21, -21, -22, -22, -24, -22, -22, -24, -22, -22, -22, -23, -23,
-20, -20, -20, -18, -20, -20, -15, -12, -11, -4, 1, 6, 10, 12, 18, 22, 23, 26,
27, 27, 28, 30, 32, 33, 37, 39, 40, 42, 42, 43, 43, 41, 40, 36, 32, 30, 28, 26,
26, 26, 26, 26, 25, 26, 26, 24, 24, 22, 21, 22, 20, 22, 23, 23, 24, 24, 24, 23,
20, 18, 15, 10, 6, 3, -1, -5, -7, -8, -9, -11, -13, -16, -17, -20, -23, -26,
-29, -32, -34, -37, -37, -36, -37, -36, -34, -32, -30, -27, -25, -22, -21, -20,
-18, -17, -15, -15, -15, -12, -12, -13, -10, -9, -10, -8, -5, -5, -5, -5, -5,
-7, -12, -11, -10, -14, -14, -13, -16, -17, -16, -18, -19, -19, -21, -22, -23,
-25, -25, -26, -25, -24, -27, -27, -26, -29, -30, -29, -27, -24, -24, -19, -12,
-8, -3, 7, 14, 15, 19, 26, 27, 26, 29, 35, 37, 39, 43, 46, 48, 49, 50, 52, 51,
48, 45, 42, 38, 34, 32, 30, 28, 25, 23, 22, 21, 19, 18, 17, 15, 11, 9, 9, 9, 10,
12, 15, 16, 18, 20, 22, 24, 25, 25, 24, 22, 20, 17, 15, 13, 10, 7, 4, 1, -3, -5,
-8, -10, -14, -19, -23, -28, -33, -36, -39, -41, -44, -46, -46, -46, -44, -43,
-41, -40, -38, -37, -36, -31, -26, -23, -20, -17, -13, -12, -12, -8, -4, -4, -3,
-1, 0, -2, -2, 0, 3, 0, -2, -2, -3, -7, -11, -12, -13, -19, -24, -24, -28, -33,
-33, -33, -36, -38, -39, -41, -44, -46, -46, -46, -45, -44, -44, -39, -33, -28,
-20, -11, -2, 4, 10, 17, 22, 25, 31, 35, 37, 39, 42, 46, 50, 54, 57, 61, 63, 62,
61, 60, 58, 53, 48, 44, 39, 34, 29, 27, 24, 22, 20, 17, 14, 10, 7, 6, 5, 3, 2,
2, 2, 3, 5, 8, 10, 12, 13, 15, 15, 15, 15, 15, 14, 13, 12, 11, 9, 9, 8, 6, 4, 1,
-3, -6, -10, -13, -16, -19, -22, -26, -28, -29, -31, -32, -32, -32, -33, -34,
-34, -34, -33, -33, -31, -30, -28, -27, -24, -21, -20, -17, -15, -13, -11, -9,
-10, -9, -6, -7, -7, -5, -4, -6, -6, -4, -4, -7, -7, -7, -10, -12, -14, -15,
-18, -20, -22, -23, -25, -27, -28, -29, -31, -34, -33, -31, -33, -34, -30, -27,
-25, -21, -17, -13, -9, -6, -3, 0, 2, 4, 7, 11, 13, 15, 20, 23, 25, 29, 34, 35,
37, 40, 41, 41, 43, 44, 42, 42, 43, 42, 41, 41, 40, 38, 37, 35, 32, 30, 29, 27,
25, 25, 23, 23, 22, 22, 21, 22, 21, 19, 19, 18, 17, 16, 15, 13, 12, 11, 10, 8,
7, 5, 3, 2, 0, -3, -4, -5, -8, -11, -12, -14, -17, -20, -22, -25, -29, -32, -33,
-35, -37, -38, -38, -38, -39, -40, -38, -37, -38, -37, -36, -36, -36, -35, -33,
-31, -31, -28, -25, -23, -22, -20, -16, -14, -13, -11, -8, -9, -10, -8, -7, -7,
-8, -7, -6, -7, -8, -7, -7, -9, -10, -11, -12, -15, -17, -16, -15, -17, -16,
-10, -7, -8, -5, 1, 2, 2, 3, 6, 6, 6, 8, 11, 14, 17, 21, 25, 29, 31, 34, 37, 39,
38, 40, 41, 41, 40, 40, 41, 42, 42, 42, 42, 40, 38, 35, 32, 31, 27, 24, 23, 22,
22, 23, 23, 24, 24, 24, 23, 21, 19, 18, 16, 16, 14, 13, 13, 13, 12, 13, 13, 12,
10, 7, 4, 1, -2, -5, -8, -11, -13, -15, -17, -19, -20, -22, -26, -30, -33, -36,
-40, -43, -44, -44, -45, -43, -40, -38, -37, -34, -30, -29, -28, -27, -26, -25,
-23, -20, -18, -15, -13, -12, -9, -7, -7, -4, -3, -3, -4, -4, -5, -7, -7, -8,
-9, -12, -16, -19, -24, -27, -31, -36, -39, -41, -41, -39, -35, -30, -24, -13,
-4, 1, 8, 14, 19, 25, 29, 33, 36, 40, 45, 49, 55, 60, 64, 67, 67, 66, 63, 60,
55, 47, 42, 35, 27, 20, 15, 12, 8, 5, 2, -2, -5, -8, -10, -12, -11, -9, -6, -1,
5, 12, 21, 29, 38, 44, 49, 52, 53, 54, 54, 54, 53, 51, 48, 44, 40, 35, 28, 22,
13, 5, -5, -16, -25, -33, -40, -47, -51, -54, -57, -59, -58, -55, -52, -49, -48,
-47, -44, -42, -37, -30, -24, -19, -13, -9, -5, 1, 4, 8, 12, 10, 9, 6, 1, -4,
-9, -14, -18, -25, -31, -36, -39, -41, -41, -42, -42, -42, -44, -44, -44, -42,
-37, -37, -35, -34, -34, -31, -28, -24, -19, -19, -22, -22, -14, -7, 1, 15, 31,
39, 42, 52, 54, 50, 53, 49, 43, 37, 29, 27, 24, 27, 29, 28, 29, 24, 19, 14, 11,
6, 0, -3, -8, -9, -7, -6, 2, 10, 16, 17, 17, 19, 17, 19, 24, 28, 35, 37, 43, 51,
57, 64, 67, 67, 61, 54, 45, 37, 32, 27, 23, 20, 14, 10, 5, 1, -3, -8, -14, -20,
-26, -30, -32, -29, -25, -21, -19, -17, -14, -14, -15, -14, -15, -18, -21, -22,
-23, -21, -18, -16, -14, -17, -20, -23, -27, -30, -32, -34, -37, -37, -37, -36,
-33, -29, -28, -30, -29, -29, -28, -26, -27, -23, -21, -24, -18, -11, -10, -6,
-1, -3, -8, -13, -17, -20, -27, -27, -26, -33, -35, -35, -38, -42, -43, -35,
-30, -26, -14, -1, 14, 27, 40, 54, 55, 56, 58, 55, 54, 51, 50, 50, 47, 47, 46,
44, 41, 36, 32, 22, 12, 1, -8, -16, -19, -18, -21, -18, -14, -11, -4, -1, 4, 9,
11, 16, 22, 28, 36, 45, 55, 62, 68, 72, 72, 70, 66, 60, 52, 43, 34, 27, 20, 14,
9, 3, -4, -9, -16, -21, -25, -28, -29, -30, -29, -27, -23, -21, -16, -10, -8,
-7, -7, -8, -10, -12, -11, -10, -11, -10, -11, -16, -18, -21, -26, -30, -33,
-37, -40, -43, -47, -47, -47, -48, -39, -34, -36, -30, -27, -31, -27, -22, -16,
-14, -11, -2, -3, -1, 6, 2, 1, 1, -8, -16, -18, -22, -26, -25, -26, -28, -36,
-38, -40, -52, -49, -48, -55, -45, -36, -26, -5, 16, 28, 40, 51, 50, 51, 51, 50,
48, 46, 46, 46, 47, 51, 50, 50, 46, 38, 30, 19, 8, 0 };

#endif /* BLAHBLAH4B_H_ */
