#ifndef BURROUGHS1_18649_H_
#define BURROUGHS1_18649_H_
 
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
#include "mozzi_pgmspace.h"
 
#define BURROUGHS1_18649_NUM_CELLS 18649
#define BURROUGHS1_18649_SAMPLERATE 16384
 
CONSTTABLE_STORAGE(int8_t) BURROUGHS1_18649_DATA [] = {8, 16, 9, 9, 7,
6, 9, 12, 18, 20, 24, 25, 23, 22, 20, 20, 18, 18, 19, 19, 21, 22, 26, 24, 19,
14, 10, 12, 13, 16, 17, 20, 18, 15, 14, 12, 12, 8, 7, 4, 7, 8, 8, 8, 7, 6, -14,
-32, -40, -28, -21, -23, -27, -25, -19, -28, -40, -48, -38, -32, -34, -36, -25,
-9, -5, -12, -21, -19, -18, -18, -19, -9, 2, 4, -2, -7, -1, 5, 5, -4, -7, -3, 1,
1, -1, 3, 5, 3, -4, -10, -9, -5, -1, -1, -1, 1, 4, 5, 1, -3, -5, -3, -1, 0, 2,
4, 6, 7, 5, 2, -1, -1, 0, 2, 6, 9, 10, 11, 11, 9, 6, 3, 0, -1, -2, 2, 4, 2, -2,
1, 5, 5, 0, -5, -5, -3, 1, 2, 3, 3, 4, 3, 3, 5, 6, 5, 2, 1, 3, 8, 10, 9, 9, 10,
10, 8, 7, 8, 13, 13, 10, 10, 13, 16, 14, 12, 10, 6, 4, 6, 8, 8, 9, 10, 10, 11,
10, 9, 5, 2, 1, 4, 8, 9, 7, 6, 6, 4, -3, -14, -20, -20, -14, -10, -10, -9, -11,
-15, -21, -27, -28, -24, -23, -25, -24, -18, -12, -14, -18, -20, -18, -18, -19,
-14, -8, -2, -2, -4, -5, -4, -4, -6, -8, -6, -2, 2, 4, 4, 5, 2, -2, -4, -3, -4,
-3, -2, 0, 2, 1, -1, -3, -3, -3, -3, -2, -2, 0, 1, 3, 4, 4, 5, 6, 7, 7, 8, 10,
9, 8, 8, 8, 7, 7, 6, 6, 7, 9, 10, 9, 9, 10, 12, 9, 6, 4, 7, 10, 5, 1, 4, 11, 10,
4, -1, 0, 0, -3, -6, -4, -1, -4, -7, -10, -8, -9, -12, -15, -14, -8, -6, -8,
-10, -8, -5, -4, -3, -3, -3, -3, -3, -3, -1, 1, 3, 3, 4, 5, 8, 9, 8, 6, 6, 7,
10, 13, 15, 15, 13, 13, 12, 12, 11, 15, 17, 19, 16, 11, 6, -4, -9, -8, -1, 0,
-2, -5, -8, -10, -19, -26, -24, -18, -17, -20, -21, -17, -14, -19, -24, -22,
-19, -19, -19, -18, -15, -12, -16, -16, -12, -7, -6, -7, -5, -2, 2, 1, 0, 0, -1,
-1, 1, 3, 2, 0, 1, 3, 5, 5, 5, 7, 7, 7, 5, 5, 5, 5, 3, 4, 6, 6, 5, 5, 8, 9, 10,
10, 12, 12, 12, 11, 12, 13, 12, 11, 12, 17, 16, 11, 9, 11, 15, 14, 14, 14, 16,
13, 9, 7, 6, 6, 5, 1, -8, -12, -9, -6, -11, -19, -21, -22, -23, -28, -28, -26,
-23, -23, -27, -25, -21, -21, -24, -26, -22, -18, -17, -17, -14, -8, -8, -8, -7,
-2, 2, 2, 2, 5, 12, 16, 13, 11, 15, 21, 23, 20, 20, 25, 32, 30, 26, 24, 24, 27,
24, 20, 20, 24, 23, 14, 10, 11, 16, 13, 7, -6, -20, -23, -13, -5, -7, -14, -21,
-26, -32, -37, -34, -27, -27, -31, -32, -31, -29, -28, -30, -32, -28, -23, -18,
-12, -6, -4, -4, -3, 1, 5, 7, 8, 11, 14, 17, 19, 20, 19, 20, 22, 25, 29, 29, 30,
31, 35, 35, 33, 32, 33, 35, 33, 29, 26, 25, 20, 15, 7, 3, 0, -5, -12, -21, -22,
-24, -27, -34, -36, -36, -38, -39, -39, -35, -35, -36, -36, -33, -33, -35, -35,
-32, -30, -29, -27, -23, -20, -17, -12, -7, -3, 0, 7, 14, 17, 19, 21, 25, 27,
27, 29, 30, 29, 26, 25, 24, 21, 19, 16, 10, 11, 14, 13, 5, -4, -5, -6, -8, -12,
-9, -5, -9, -17, -23, -22, -18, -17, -18, -14, -10, -11, -11, -7, 0, 3, 3, 4, 9,
14, 14, 15, 17, 20, 22, 24, 27, 30, 34, 37, 41, 44, 48, 53, 57, 58, 56, 53, 50,
51, 44, 35, 32, 33, 27, 8, 0, -2, -10, -39, -53, -35, -25, -34, -48, -46, -51,
-60, -68, -63, -49, -47, -53, -59, -59, -61, -60, -59, -56, -52, -45, -40, -33,
-29, -24, -17, -13, -7, 0, 12, 18, 22, 21, 21, 22, 22, 23, 25, 27, 23, 21, 19,
17, 13, 11, 11, 7, 4, 5, 10, 5, -2, -5, -4, -5, -8, -5, -1, 1, -3, -3, 1, 6, 9,
14, 17, 19, 20, 25, 31, 32, 31, 29, 30, 29, 33, 38, 43, 44, 40, 41, 43, 47, 45,
46, 43, 31, 19, 14, 13, -7, -26, -33, -33, -42, -58, -56, -56, -56, -59, -56,
-53, -56, -49, -48, -50, -52, -44, -38, -48, -59, -57, -39, -29, -35, -37, -28,
-16, -11, -4, 13, 28, 32, 30, 36, 43, 44, 45, 44, 40, 33, 31, 28, 23, 15, 10, 9,
6, 1, -6, -9, -8, -10, -14, -16, -14, -13, -16, -15, -14, -9, -8, -5, 1, 7, 13,
17, 27, 32, 37, 41, 47, 53, 58, 65, 72, 78, 82, 77, 65, 62, 72, 86, 79, 65, 45,
34, 26, 8, -10, -27, -27, -45, -63, -79, -82, -84, -91, -86, -89, -90, -99, -92,
-87, -91, -90, -84, -79, -81, -82, -72, -58, -49, -44, -37, -19, -5, 7, 19, 31,
39, 43, 49, 55, 55, 50, 51, 49, 44, 37, 38, 32, 20, 10, 3, 5, -2, -4, -12, -18,
-24, -29, -25, -28, -28, -29, -23, -22, -20, -15, -8, -1, 2, 10, 17, 24, 29, 34,
43, 48, 54, 61, 64, 70, 73, 82, 86, 87, 79, 70, 61, 49, 45, 31, 12, -16, -27,
-34, -42, -52, -59, -61, -69, -67, -64, -61, -65, -65, -63, -66, -70, -67, -62,
-61, -61, -51, -37, -27, -17, -7, 9, 23, 38, 48, 58, 61, 62, 63, 62, 59, 50, 47,
40, 35, 27, 23, 18, 10, 3, -3, -10, -21, -28, -32, -39, -46, -51, -52, -49, -48,
-42, -35, -25, -16, -8, -4, -1, 10, 25, 36, 37, 41, 45, 49, 50, 58, 75, 85, 88,
86, 90, 86, 79, 67, 54, 47, 27, 1, -36, -49, -57, -64, -74, -85, -90, -95, -85,
-79, -76, -79, -74, -75, -84, -86, -79, -71, -74, -73, -64, -46, -28, -12, 1,
15, 31, 49, 63, 67, 66, 63, 65, 62, 54, 44, 39, 34, 25, 16, 16, 14, 9, -1, -12,
-21, -32, -37, -42, -48, -62, -67, -63, -57, -53, -46, -29, -21, -12, -2, 15,
25, 27, 33, 39, 46, 50, 62, 67, 75, 86, 96, 111, 116, 124, 119, 107, 88, 68, 62,
44, 17, -26, -47, -52, -56, -61, -67, -65, -67, -56, -48, -53, -60, -62, -63,
-73, -83, -76, -70, -68, -67, -58, -36, -14, 13, 23, 34, 45, 61, 67, 56, 47, 39,
39, 30, 21, 13, 9, 4, -2, -6, 2, 4, -4, -20, -37, -46, -57, -57, -67, -74, -79,
-76, -60, -50, -28, -16, -1, 6, 19, 35, 35, 35, 30, 38, 43, 47, 54, 63, 77, 87,
100, 116, 124, 126, 113, 100, 76, 50, 35, 13, -19, -67, -82, -78, -73, -72, -71,
-64, -67, -53, -40, -45, -64, -75, -75, -87, -95, -85, -69, -63, -59, -40, -11,
18, 41, 51, 51, 52, 58, 58, 43, 21, 6, 2, -2, -6, -7, 0, 4, 4, 5, 8, 8, 1, -13,
-35, -54, -60, -59, -62, -65, -55, -36, -15, 10, 33, 48, 54, 61, 65, 62, 57, 51,
45, 38, 38, 45, 58, 76, 94, 107, 117, 125, 126, 115, 92, 57, 23, 4, -20, -58,
-101, -116, -106, -93, -77, -65, -55, -52, -41, -34, -45, -61, -70, -75, -89,
-97, -83, -65, -46, -32, -9, 21, 48, 71, 74, 68, 53, 45, 38, 18, -5, -30, -32,
-30, -28, -21, -10, 3, 2, 2, 0, -6, -17, -36, -56, -78, -82, -71, -60, -54, -45,
-17, 16, 44, 59, 62, 58, 54, 55, 46, 31, 21, 26, 35, 42, 57, 83, 103, 111, 120,
127, 122, 106, 82, 42, -11, -35, -44, -66, -107, -119, -94, -71, -53, -36, -22,
-25, -19, -7, -25, -53, -66, -62, -71, -81, -58, -28, -4, 6, 30, 56, 74, 87, 81,
65, 37, 21, 8, -10, -29, -43, -37, -32, -27, -17, -5, 1, -4, -9, -17, -34, -50,
-66, -80, -89, -83, -61, -41, -25, -11, 11, 40, 60, 67, 59, 48, 39, 31, 25, 18,
22, 33, 42, 56, 75, 102, 112, 115, 118, 116, 107, 81, 45, -7, -41, -50, -65,
-96, -118, -100, -75, -52, -33, -27, -30, -31, -19, -30, -53, -66, -69, -72,
-75, -52, -24, 4, 23, 37, 49, 58, 70, 64, 41, 11, -9, -13, -18, -30, -42, -38,
-26, -18, -8, 1, 2, -6, -11, -23, -43, -53, -53, -57, -65, -55, -30, -6, 12, 29,
44, 53, 61, 61, 50, 33, 24, 23, 23, 19, 23, 34, 50, 67, 88, 106, 109, 109, 110,
104, 85, 59, 26, -21, -53, -63, -71, -93, -106, -87, -64, -42, -28, -26, -38,
-40, -28, -38, -60, -73, -67, -61, -54, -29, -6, 14, 27, 37, 46, 53, 61, 44, 15,
-12, -23, -23, -26, -32, -42, -33, -14, -2, -5, -10, -9, -12, -17, -28, -41,
-52, -49, -38, -32, -26, -7, 17, 29, 35, 40, 47, 47, 43, 34, 19, 13, 17, 26, 25,
32, 51, 62, 65, 71, 87, 92, 91, 95, 90, 75, 50, 22, -17, -45, -48, -58, -85,
-108, -93, -68, -48, -36, -36, -41, -41, -27, -30, -44, -51, -47, -43, -38, -16,
7, 22, 32, 39, 40, 36, 39, 34, 16, -11, -28, -33, -31, -27, -30, -32, -26, -8,
2, -1, -9, -17, -19, -27, -35, -45, -43, -32, -29, -27, -17, 8, 21, 27, 30, 30,
26, 24, 29, 22, 14, 14, 17, 14, 16, 34, 44, 47, 48, 56, 65, 76, 86, 88, 89, 90,
94, 86, 60, 17, -24, -38, -47, -70, -100, -109, -96, -72, -45, -35, -36, -32,
-15, -16, -36, -48, -45, -41, -44, -38, -23, 1, 24, 32, 29, 28, 38, 35, 17, -8,
-30, -42, -43, -38, -44, -46, -37, -22, -12, -5, 3, -1, -11, -20, -21, -26, -32,
-29, -20, -11, -5, 11, 24, 23, 21, 28, 33, 19, 9, 7, 3, -3, 4, 18, 20, 24, 34,
44, 46, 54, 64, 65, 70, 79, 87, 89, 96, 102, 100, 88, 47, -9, -45, -47, -57,
-88, -110, -112, -96, -63, -23, -17, -32, -26, -8, -15, -40, -43, -38, -44, -47,
-29, -5, 14, 38, 47, 37, 25, 29, 30, 4, -32, -52, -50, -48, -52, -52, -41, -26,
-16, -1, 7, 3, -1, 1, -9, -32, -31, -16, -11, -15, 1, 23, 28, 30, 29, 20, 7, 8,
3, -17, -32, -29, -19, -11, 2, 12, 16, 25, 34, 36, 31, 34, 40, 43, 46, 59, 79,
89, 99, 107, 112, 109, 99, 63, -6, -61, -72, -71, -100, -127, -124, -103, -68,
-23, 1, -12, -14, 4, -9, -44, -48, -29, -33, -38, -19, 4, 24, 54, 70, 48, 27,
24, 16, -12, -36, -49, -56, -55, -50, -39, -23, -8, -2, 2, 5, -2, -3, 2, -6,
-23, -20, -7, -8, -1, 18, 30, 27, 26, 22, 3, -13, -22, -36, -51, -49, -37, -26,
-16, -3, 17, 32, 36, 29, 22, 20, 15, 13, 15, 28, 44, 61, 78, 95, 109, 118, 124,
119, 106, 92, 62, -3, -68, -84, -79, -95, -114, -109, -99, -76, -25, 3, -14,
-25, -11, -21, -50, -45, -25, -26, -25, -2, 14, 24, 48, 60, 40, 14, 8, -1, -25,
-46, -54, -55, -54, -41, -21, -5, 3, 12, 17, 8, 4, 11, 16, 2, -7, -5, -2, 1, 9,
12, 4, 6, 11, 3, -14, -24, -32, -43, -48, -50, -53, -41, -18, -4, -3, 6, 18, 21,
23, 27, 22, 11, 16, 26, 26, 25, 45, 68, 75, 76, 89, 101, 97, 96, 104, 99, 79,
62, 29, -40, -89, -84, -79, -110, -128, -106, -89, -70, -30, -5, -15, -10, 13,
-1, -32, -24, 0, -5, -13, 1, 17, 28, 44, 48, 29, 10, 4, -8, -30, -48, -51, -53,
-57, -53, -38, -14, 4, 14, 18, 23, 25, 23, 19, 12, 7, 6, 8, 5, 2, 7, 10, -1,
-16, -22, -30, -39, -40, -39, -42, -40, -32, -30, -26, -11, 0, 2, 5, 12, 13, 19,
27, 27, 22, 24, 27, 29, 34, 39, 38, 37, 47, 58, 62, 63, 76, 91, 93, 84, 82, 81,
70, 53, 14, -55, -106, -103, -97, -121, -128, -108, -96, -72, -20, 4, -9, 3, 21,
-6, -28, -3, 12, -2, 7, 27, 25, 35, 64, 58, 24, 8, -2, -29, -51, -60, -71, -75,
-64, -47, -33, -18, -8, 1, 8, 12, 14, 20, 20, 14, 14, 16, 18, 25, 33, 25, 12, 4,
-3, -15, -27, -41, -52, -55, -56, -59, -46, -20, -1, 5, 5, 3, 11, 30, 34, 22,
17, 19, 16, 11, 9, 9, 14, 22, 19, 13, 22, 34, 36, 37, 48, 56, 61, 67, 70, 70,
78, 93, 97, 81, 63, 38, -16, -79, -105, -106, -117, -126, -115, -105, -89, -37,
10, 9, 6, 30, 24, -11, -12, 7, -1, -5, 14, 18, 15, 42, 61, 35, 8, 2, -20, -59,
-78, -81, -88, -88, -73, -55, -37, -10, 18, 31, 31, 33, 40, 35, 20, 12, 14, 11,
10, 24, 33, 24, 19, 21, 11, -11, -25, -34, -49, -56, -50, -47, -48, -38, -17,
-2, 6, 11, 11, 11, 17, 21, 18, 14, 15, 19, 22, 18, 10, 7, 7, 3, 0, 1, 4, 10, 17,
22, 31, 45, 49, 44, 45, 50, 48, 52, 63, 63, 61, 71, 78, 72, 56, 14, -50, -88,
-89, -96, -117, -120, -108, -86, -44, -4, 6, 14, 36, 33, 1, -11, -2, -3, -5, 5,
6, 7, 28, 42, 24, 1, -10, -29, -55, -68, -76, -84, -76, -56, -41, -26, -1, 22,
29, 27, 26, 28, 29, 23, 13, 11, 20, 30, 32, 26, 22, 21, 17, 5, -12, -25, -31,
-36, -46, -51, -45, -35, -26, -13, -2, 0, 0, 5, 10, 12, 10, 5, 2, 5, 10, 12, 11,
9, 8, 7, 0, -5, -2, -3, -11, -3, 16, 19, 18, 31, 38, 33, 37, 46, 42, 41, 50, 51,
47, 60, 82, 87, 74, 62, 51, 19, -43, -93, -102, -103, -116, -117, -102, -88,
-53, -1, 17, 7, 22, 39, 15, -12, -5, 3, -1, 8, 20, 18, 33, 61, 56, 22, 1, -13,
-44, -73, -83, -91, -92, -72, -50, -44, -26, 14, 38, 33, 28, 30, 26, 19, 16, 14,
15, 22, 31, 36, 38, 37, 31, 17, -6, -27, -42, -52, -61, -62, -54, -42, -26, -11,
3, 18, 25, 19, 13, 10, 1, -10, -7, -3, -7, -3, 11, 16, 17, 23, 23, 11, -2, -12,
-22, -25, -21, -17, -10, 5, 16, 25, 38, 51, 57, 54, 46, 40, 46, 54, 54, 54, 63,
67, 64, 64, 57, 42, 32, -2, -75, -122, -107, -99, -125, -121, -89, -72, -32, 35,
48, 28, 57, 74, 21, -6, 18, 3, -26, 2, 18, -7, 8, 40, 13, -21, -16, -35, -77,
-84, -85, -107, -100, -65, -50, -35, 0, 27, 48, 68, 68, 53, 48, 40, 19, 7, 12,
13, 15, 17, 10, 6, 9, 2, -15, -28, -40, -54, -59, -56, -51, -34, -13, 2, 15, 30,
42, 48, 50, 44, 23, -5, -24, -28, -25, -24, -22, -14, -2, 17, 32, 28, 16, 12, 7,
-5, -8, -4, -5, -1, 15, 23, 21, 29, 39, 39, 33, 28, 26, 25, 20, 13, 18, 31, 39,
40, 40, 39, 39, 46, 48, 31, 10, 7, -9, -64, -103, -90, -78, -92, -82, -59, -57,
-29, 30, 35, 5, 25, 42, 3, -17, 1, -14, -30, 0, 9, -16, 2, 29, -4, -33, -16,
-22, -53, -54, -55, -81, -74, -31, -16, -18, 5, 30, 32, 35, 45, 43, 33, 35, 32,
14, 9, 16, 10, 3, 6, 4, 1, 0, -9, -21, -22, -25, -32, -34, -31, -24, -5, 11, 14,
25, 43, 46, 42, 44, 38, 22, 15, 3, -28, -46, -36, -31, -31, -23, -22, -26, -9,
13, 12, 5, 13, 14, 4, 4, 9, 6, 7, 17, 19, 13, 26, 44, 36, 20, 19, 24, 26, 24,
16, 12, 25, 36, 27, 20, 29, 37, 36, 35, 22, 5, 7, 4, -47, -88, -65, -52, -79,
-77, -54, -62, -38, 22, 19, -20, 11, 44, 0, -15, 22, 3, -38, -9, 7, -25, -5, 37,
4, -34, -10, -7, -38, -42, -43, -65, -64, -38, -32, -32, -7, 18, 22, 30, 43, 42,
42, 45, 34, 17, 18, 26, 17, 4, 5, 10, 14, 16, 6, -5, -9, -13, -17, -19, -21,
-26, -21, -8, -2, 9, 26, 29, 25, 31, 28, 16, 16, 14, 1, -9, -30, -64, -56, -20,
-20, -34, -22, -11, -2, 22, 31, 10, -3, 9, 12, -4, -8, 7, 14, 10, 8, 14, 23, 27,
18, 7, 7, 17, 24, 23, 13, 15, 35, 44, 41, 41, 49, 46, 42, 36, 27, 17, 18, -11,
-70, -84, -63, -72, -94, -79, -74, -74, -30, 10, -15, -24, 20, 27, 0, 10, 24, 0,
-7, 14, 6, -5, 28, 43, 6, -11, 8, -1, -28, -29, -36, -67, -61, -30, -38, -46,
-10, 13, 9, 28, 49, 39, 33, 40, 23, 9, 20, 20, 7, 10, 15, 9, 14, 21, 5, -13, -8,
-9, -25, -29, -27, -35, -33, -22, -14, -5, 13, 24, 21, 25, 37, 36, 25, 21, 12,
0, -3, -16, -54, -61, -28, -20, -32, -25, -19, -11, 20, 32, 6, -4, 12, 12, 1, 4,
1, -3, 14, 20, 5, 15, 38, 28, 11, 20, 29, 23, 22, 23, 14, 22, 45, 51, 39, 45,
57, 49, 43, 40, 25, 12, -4, -57, -86, -67, -62, -89, -86, -67, -66, -41, 6, 1,
-23, 14, 36, -3, -11, 16, -5, -27, -4, -1, -17, 10, 35, 8, -7, 19, 19, -11, -19,
-21, -46, -50, -27, -32, -45, -18, 9, 1, 10, 42, 41, 24, 30, 26, 8, 16, 24, 3,
-7, 8, 12, 6, 10, 10, -3, -12, -10, -16, -29, -33, -32, -35, -34, -22, -7, 3,
11, 16, 18, 21, 30, 31, 18, 7, 5, 3, -3, -20, -47, -43, -21, -15, -16, -16, -16,
0, 24, 26, 13, 4, 4, 2, 3, 2, -5, 3, 15, 9, 2, 20, 29, 20, 18, 21, 24, 32, 41,
34, 33, 42, 52, 55, 46, 40, 33, 29, 27, 26, 13, 6, -29, -74, -66, -46, -69, -89,
-74, -76, -69, -28, 6, -17, -17, 22, 21, -3, 14, 29, -3, -8, 13, 10, 3, 29, 24,
-11, -17, -1, -7, -31, -41, -49, -60, -52, -33, -39, -37, -6, 10, 4, 19, 47, 46,
35, 39, 34, 23, 37, 35, 9, 0, 12, 12, 6, 6, 2, -13, -22, -14, -20, -34, -36,
-32, -37, -31, -11, -2, 2, 12, 17, 20, 28, 28, 20, 10, 7, 3, -9, -23, -37, -40,
-21, -14, -25, -16, 0, 2, 13, 22, 11, 3, 10, 6, -7, -2, 3, -2, 6, 13, 2, 1, 16,
18, 13, 17, 29, 27, 28, 36, 37, 40, 46, 53, 48, 46, 44, 44, 39, 38, 35, 23, -1,
-55, -73, -61, -69, -100, -95, -86, -83, -52, -6, 0, -16, 13, 29, 7, 1, 26, 7,
-18, 4, 21, 9, 22, 48, 25, 1, 7, 10, -16, -36, -42, -58, -72, -56, -42, -54,
-36, -1, 3, 3, 27, 40, 29, 29, 35, 22, 13, 23, 19, 3, 14, 30, 19, 11, 22, 12,
-12, -15, -17, -38, -47, -38, -39, -42, -23, -6, -6, 1, 13, 15, 16, 24, 13, -5,
1, 13, -1, -18, -29, -38, -16, 11, 4, -18, -9, 12, 21, 19, 12, -4, -15, -8, -7,
-12, -10, -3, -1, -1, 9, 18, 24, 22, 20, 23, 36, 45, 47, 39, 28, 46, 62, 58, 56,
61, 52, 46, 53, 48, 30, 22, 10, -60, -104, -78, -65, -103, -107, -80, -78, -54,
8, 19, -24, 0, 39, 8, -22, 11, 15, -21, -7, 29, 15, 13, 57, 49, 2, 1, 14, -17,
-48, -46, -55, -79, -65, -46, -55, -42, 1, 13, 3, 19, 35, 26, 19, 29, 15, 3, 16,
23, 12, 18, 41, 32, 15, 20, 23, -8, -24, -24, -39, -48, -39, -34, -40, -21, 1,
5, 7, 19, 19, 14, 15, 11, 0, -6, 0, -7, -16, -14, -21, -21, 0, 6, -7, -6, 1, 4,
8, 10, 5, -4, -1, 2, 2, 2, 3, 4, 7, 9, 9, 11, 17, 17, 16, 24, 24, 21, 34, 37,
27, 40, 50, 47, 52, 64, 57, 43, 44, 44, 31, 21, -4, -70, -96, -70, -64, -94,
-88, -69, -67, -40, 8, 7, -20, 7, 22, -10, -20, 15, 12, -15, 0, 26, 22, 32, 60,
34, -7, -5, 4, -24, -49, -50, -66, -80, -58, -39, -48, -35, -2, 0, -7, 9, 27,
15, 12, 21, 17, 19, 40, 42, 21, 29, 47, 38, 22, 24, 9, -18, -20, -16, -34, -39,
-22, -22, -28, -16, 1, 3, 5, 8, 2, -1, 7, 8, -1, -1, -2, 1, 4, -6, -23, -10, 14,
11, -4, -4, 3, 8, 17, 9, -5, -9, -4, -8, -9, -7, -6, -3, 4, 4, 0, 16, 24, 13,
15, 28, 23, 23, 35, 29, 25, 45, 57, 46, 51, 61, 41, 32, 52, 48, 17, 9, -18, -81,
-95, -57, -63, -99, -80, -60, -62, -28, 23, 1, -26, 12, 22, -26, -28, 14, -4,
-24, 16, 41, 15, 33, 73, 35, -16, 3, 15, -40, -68, -51, -64, -81, -46, -15, -30,
-23, 8, 4, -14, 7, 25, 2, -6, 16, 20, 17, 42, 54, 35, 34, 48, 38, 14, 11, 3,
-23, -29, -13, -18, -34, -25, -12, -15, -14, 1, 2, -9, -9, -7, -8, -3, 2, -14,
-29, -16, 5, 4, 3, 14, 13, 8, 16, 18, 4, 0, 8, 0, -14, -8, -1, -10, -12, -4,
-12, -17, -8, -5, -11, 1, 20, 20, 19, 28, 31, 26, 38, 45, 41, 43, 50, 53, 57,
66, 61, 53, 46, 37, 25, 16, -24, -90, -104, -75, -72, -96, -78, -55, -56, -37,
9, 5, -25, -9, 0, -35, -46, 1, 12, -7, 17, 58, 46, 33, 56, 45, -3, -19, -7, -39,
-66, -44, -34, -58, -42, -1, -8, -27, -5, 11, -20, -27, -1, -3, -15, 11, 34, 26,
38, 63, 50, 26, 31, 26, 4, 6, 9, -17, -26, 0, 2, -18, -8, 7, -11, -20, -4, -8,
-23, -7, 5, -14, -20, -3, -2, -15, -10, 0, -3, -3, 4, 7, 13, 21, 17, 7, 10, 14,
7, -1, -7, -11, -13, -13, -15, -12, -4, -1, 2, 9, 13, 13, 21, 22, 13, 12, 20,
23, 28, 45, 51, 49, 57, 69, 62, 57, 57, 41, 24, 15, -17, -79, -93, -68, -66,
-89, -75, -58, -65, -50, -12, -16, -42, -22, -4, -32, -42, 4, 22, 6, 24, 63, 55,
35, 47, 42, 2, -14, -10, -36, -54, -27, -10, -33, -34, -5, -9, -35, -30, -18,
-34, -40, -17, -6, -7, 16, 44, 44, 40, 50, 51, 37, 24, 19, 13, 13, 14, 13, 13,
17, 13, 1, -1, -6, -19, -31, -34, -39, -41, -29, -16, -10, -9, -7, -11, -27,
-41, -31, -8, -1, -6, 4, 21, 24, 20, 24, 23, 7, -6, -14, -24, -22, -4, 1, -10,
-3, 15, 14, 9, 19, 28, 17, 8, 13, 21, 24, 28, 43, 54, 56, 54, 64, 70, 65, 61,
56, 44, 39, 44, 5, -68, -88, -54, -53, -88, -77, -53, -65, -62, -24, -24, -45,
-23, -12, -53, -62, -8, 15, 0, 21, 52, 38, 34, 56, 40, 3, 11, 11, -29, -35, -3,
-8, -35, -18, -6, -33, -50, -37, -40, -54, -39, -30, -33, -15, 17, 21, 20, 37,
33, 15, 16, 26, 14, 13, 31, 33, 17, 22, 40, 26, 3, -1, -4, -28, -34, -22, -23,
-32, -24, -14, -27, -35, -25, -15, -22, -20, -11, -8, 3, 20, 23, 18, 27, 30, 17,
8, 10, 9, 9, 19, 17, 2, 6, 21, 15, 7, 18, 21, 10, 8, 15, 13, 10, 8, 8, 20, 36,
43, 44, 51, 54, 51, 56, 57, 45, 37, 28, -28, -76, -60, -38, -62, -65, -31, -44,
-69, -53, -34, -62, -57, -28, -52, -84, -41, 15, 3, 15, 55, 41, 7, 34, 49, 4, 0,
34, 17, -25, -4, 27, 6, -9, -2, -21, -52, -47, -42, -61, -51, -20, -17, -19, 7,
20, 4, 7, 17, 9, 3, 20, 30, 24, 32, 48, 49, 38, 34, 22, 7, 3, 0, -12, -16, -8,
-14, -26, -20, -18, -42, -65, -60, -41, -35, -32, -19, -3, 6, 13, 19, 12, 14,
21, 13, -1, 4, 22, 28, 30, 33, 33, 22, 15, 24, 27, 21, 21, 26, 22, 18, 23, 23,
19, 15, 8, 9, 15, 27, 40, 52, 50, 41, 45, 53, 32, -39, -73, -55, -42, -58, -46,
-24, -37, -41, -25, -31, -67, -57, -33, -61, -89, -48, -1, -6, 9, 45, 30, 5, 22,
26, -10, -7, 22, 10, -7, 23, 43, 14, 7, 15, -18, -51, -32, -26, -54, -42, -7,
-9, -22, -5, 1, -13, -13, -7, -20, -17, 16, 30, 27, 40, 51, 35, 24, 27, 17, 4,
6, 12, 8, 5, 10, 10, 3, -13, -37, -62, -66, -55, -43, -30, -19, -9, 1, 5, 5, 9,
7, -10, -15, -2, 6, 12, 29, 41, 35, 27, 23, 18, 14, 21, 29, 35, 43, 44, 38, 38,
38, 25, 18, 20, 13, 6, 18, 30, 35, 42, 39, 29, 28, 11, -53, -86, -60, -45, -66,
-44, 0, -17, -40, -18, -18, -71, -72, -37, -51, -67, -30, -2, -6, 23, 46, 11,
-14, 5, 4, -22, -3, 24, 9, 0, 25, 30, 1, 3, 8, -24, -49, -30, -19, -28, -4, 18,
3, -12, -1, -3, -18, -15, -3, 0, -3, 6, 19, 27, 36, 35, 23, 14, 14, 6, 6, 13,
12, 12, 22, 21, -2, -23, -34, -39, -48, -37, -13, -8, -13, -2, 6, -4, -4, -7,
-16, -20, -10, -1, 10, 27, 33, 26, 14, 17, 18, 7, 2, 13, 23, 21, 35, 51, 48, 41,
40, 39, 32, 33, 26, 21, 27, 34, 27, 30, 43, 31, 16, 13, -27, -87, -75, -33, -52,
-62, -10, -8, -56, -50, -15, -51, -75, -41, -45, -73, -31, 16, -12, -1, 46, 23,
-22, 4, 18, -23, -17, 27, 16, -12, 19, 33, -7, -14, 9, -13, -48, -30, -16, -31,
-20, 6, -3, -18, -3, -6, -27, -14, 5, -10, -8, 27, 36, 24, 33, 38, 20, 12, 20,
10, 3, 16, 26, 19, 18, 19, 1, -31, -53, -39, -26, -26, -17, 3, 1, -8, 1, 2, -6,
-14, -16, -17, -6, 5, 9, 16, 27, 24, 15, 14, 15, 13, 21, 27, 29, 40, 50, 46, 41,
46, 44, 36, 34, 36, 35, 44, 45, 38, 36, 42, 36, 25, -14, -75, -80, -45, -45,
-65, -26, -12, -54, -65, -30, -49, -91, -61, -43, -72, -52, 9, -2, -15, 30, 28,
-21, -13, 21, -1, -13, 23, 27, 7, 26, 45, 3, -24, -4, -17, -49, -32, -8, -30,
-34, -1, 1, -19, -11, -7, -28, -27, -9, -11, -1, 24, 32, 22, 27, 36, 29, 27, 30,
25, 21, 30, 33, 22, 18, 14, -3, -29, -38, -23, -15, -17, -7, 3, -7, -7, 1, -10,
-18, -16, -20, -21, 0, 13, 7, 5, 10, 10, 4, 4, 9, 15, 20, 21, 28, 40, 41, 37,
40, 33, 24, 34, 44, 39, 44, 60, 54, 41, 39, 46, 41, 30, -19, -72, -64, -36, -47,
-59, -22, -30, -66, -61, -31, -58, -85, -60, -63, -77, -43, -3, -21, -13, 22, 3,
-23, 3, 24, 4, 7, 28, 15, 7, 34, 42, 5, -6, 0, -25, -38, -10, -3, -28, -22, -3,
-16, -23, -11, -21, -39, -28, -14, -16, 8, 32, 25, 16, 23, 24, 21, 28, 31, 29,
27, 29, 33, 31, 19, 7, -3, -31, -50, -25, -3, -13, -12, 5, -12, -30, -17, -12,
-22, -28, -25, -21, -8, 5, 8, 10, 8, 8, 7, 14, 17, 16, 22, 28, 35, 38, 42, 40,
41, 35, 31, 35, 35, 30, 38, 57, 52, 44, 42, 44, 32, 24, -23, -75, -59, -21, -37,
-53, -5, -16, -63, -54, -13, -52, -83, -51, -54, -73, -29, 14, -16, -12, 24, -3,
-33, 3, 21, -5, 4, 33, 11, 3, 36, 37, -5, -9, 3, -26, -31, 0, 1, -28, -17, -2,
-20, -21, -6, -18, -36, -24, -16, -19, 0, 19, 16, 9, 8, 8, 11, 18, 19, 26, 25,
23, 26, 26, 18, 10, 2, -18, -27, -9, 5, -1, -3, -1, -13, -18, -12, -14, -18,
-20, -23, -17, 0, 6, 2, -4, -7, -6, 1, 9, 18, 23, 22, 28, 36, 42, 41, 41, 38,
31, 33, 40, 45, 43, 50, 53, 46, 44, 38, 36, 32, 28, -35, -78, -50, -20, -48,
-51, -7, -44, -83, -57, -23, -66, -71, -42, -63, -71, -13, 17, -22, -5, 28, -5,
-27, 18, 30, 2, 17, 37, 11, 11, 45, 34, -9, -4, -1, -35, -30, 5, -4, -28, -13,
-16, -35, -20, -6, -29, -37, -21, -24, -20, 9, 21, 13, 13, 11, 11, 20, 24, 21,
27, 30, 21, 28, 35, 27, 14, 6, -11, -29, -11, 8, 5, -7, -7, -15, -21, -11, -7,
-12, -22, -23, -19, -12, -1, 7, 4, -5, -2, 3, 0, 6, 16, 23, 23, 30, 37, 36, 37,
39, 37, 33, 36, 39, 35, 47, 52, 48, 45, 46, 38, 31, 25, -42, -79, -46, -18, -52,
-39, -5, -47, -78, -48, -34, -76, -66, -56, -77, -63, -8, -4, -24, 4, 12, -21,
-13, 23, 14, 6, 29, 29, 11, 31, 47, 24, 5, 7, -9, -28, -11, 0, -12, -13, -9,
-27, -33, -17, -25, -39, -33, -29, -29, -10, 7, 3, 9, 16, 7, 10, 25, 26, 23, 32,
31, 29, 36, 34, 21, 17, 12, -12, -19, 3, 13, 0, -6, -5, -14, -16, -7, -12, -22,
-24, -23, -17, -1, 7, 2, -4, -5, -3, 4, 11, 14, 15, 25, 32, 33, 39, 41, 38, 31,
33, 32, 32, 34, 36, 47, 44, 45, 41, 38, 30, 34, 2, -63, -63, -30, -34, -55, -14,
-20, -64, -59, -31, -55, -75, -49, -64, -79, -39, -2, -20, -14, 13, -6, -24, 1,
16, 7, 19, 31, 18, 25, 42, 33, 20, 18, 2, -19, -11, -3, -9, -11, -9, -20, -26,
-16, -20, -33, -33, -34, -38, -20, -3, -5, 0, 12, 6, 4, 18, 20, 21, 33, 35, 25,
34, 42, 29, 20, 24, 12, -12, -14, 3, 8, 0, -3, -3, -7, -9, -8, -9, -12, -19,
-20, -16, -7, 1, 4, -3, -6, 3, 9, 8, 10, 21, 26, 24, 27, 33, 37, 33, 31, 33, 34,
37, 32, 37, 40, 43, 45, 42, 36, 35, 32, -31, -71, -43, -16, -50, -48, -14, -41,
-68, -49, -34, -68, -67, -59, -72, -65, -21, -5, -17, -3, 2, -11, -8, 10, 10,
10, 18, 16, 21, 38, 36, 24, 19, 5, -16, -13, -6, -9, -9, -5, -15, -26, -19, -14,
-24, -36, -36, -34, -28, -13, -2, 3, 6, 4, 2, 9, 13, 17, 21, 23, 24, 34, 38, 31,
29, 21, 10, 3, 1, -2, 3, 3, -6, -7, -1, 1, -5, -8, -14, -18, -21, -15, -7, -5,
-6, -3, 0, -2, 4, 13, 10, 6, 17, 28, 24, 27, 37, 36, 33, 37, 35, 31, 44, 45, 38,
40, 44, 43, 38, 39, 36, 33, -20, -67, -47, -11, -33, -52, -21, -37, -69, -59,
-28, -54, -70, -60, -70, -74, -38, -5, -19, -18, -3, -7, -12, 4, 14, 7, 7, 11,
20, 34, 33, 26, 20, 11, -8, -8, 1, -6, -7, -5, -12, -24, -13, -5, -23, -33, -30,
-29, -30, -10, 0, -6, -1, 7, 6, 5, 17, 18, 12, 15, 21, 29, 32, 31, 25, 18, 10,
3, 5, 4, 5, -1, -8, -10, -5, -2, -5, -4, -10, -16, -21, -14, -5, -5, -9, -7, -1,
-2, 5, 16, 13, 4, 13, 23, 24, 25, 31, 26, 25, 31, 33, 33, 34, 37, 29, 37, 37,
37, 36, 40, 33, 24, 8, -41, -53, -29, -19, -49, -36, -25, -53, -61, -34, -35,
-71, -69, -62, -67, -51, -19, -17, -25, -9, -4, -12, -4, 10, 10, 6, 13, 19, 32,
35, 24, 20, 18, 2, -7, 9, 3, -8, -2, -4, -21, -21, -6, -19, -29, -29, -27, -26,
-15, -3, -2, -1, -5, 1, 9, 13, 10, 12, 14, 14, 24, 34, 32, 27, 24, 14, 7, 13,
11, 4, 6, 3, -7, -12, -3, -1, -4, -15, -22, -15, -14, -15, -11, -8, -17, -12,
-2, -2, 3, 11, 11, 11, 21, 29, 29, 29, 28, 25, 30, 37, 42, 40, 36, 30, 32, 39,
36, 36, 32, 30, 24, 31, -3, -53, -51, -21, -30, -55, -30, -28, -52, -55, -29,
-44, -65, -56, -54, -57, -40, -8, -11, -15, -6, -3, -7, -1, 5, 3, 6, 9, 17, 30,
28, 20, 19, 12, -4, -1, 9, -3, -6, 1, -2, -14, -10, -8, -18, -22, -24, -22, -22,
-16, -7, 1, -2, -6, 1, 4, 0, -1, 9, 10, 8, 20, 32, 27, 22, 25, 15, 4, 6, 9, 3,
2, 7, 5, -3, -6, -3, -5, -15, -21, -17, -17, -17, -12, -6, -12, -14, -5, 1, -2,
1, 9, 9, 13, 24, 30, 28, 31, 34, 36, 37, 38, 38, 37, 33, 35, 47, 46, 38, 34, 31,
29, 33, -2, -52, -47, -12, -25, -50, -30, -26, -51, -55, -34, -48, -60, -54,
-57, -61, -34, -9, -15, -20, -17, -10, -8, -7, -4, 7, 8, 4, 17, 35, 29, 17, 20,
12, -6, -1, 12, 5, -3, 1, 1, -7, -7, -7, -16, -23, -24, -25, -22, -11, -8, -9,
-3, 0, -4, 0, 4, 1, 2, 7, 6, 17, 34, 33, 20, 18, 19, 8, 4, 5, 3, -1, 6, 10, 6,
5, 2, -4, -12, -17, -17, -12, -11, -11, -8, -8, -8, -6, -3, -3, -3, 0, 5, 11,
17, 19, 25, 31, 30, 29, 35, 37, 38, 39, 36, 42, 51, 47, 39, 42, 42, 31, 31, 23,
-21, -46, -22, -6, -34, -38, -25, -36, -54, -45, -41, -61, -67, -64, -63, -55,
-28, -16, -23, -25, -22, -12, -5, -9, -9, 8, 14, 9, 23, 35, 28, 19, 16, 8, 3,
12, 15, 6, -1, 3, 4, 2, -5, -13, -14, -19, -27, -25, -14, -11, -14, -13, -8, 0,
1, -3, -1, 3, 3, 1, 7, 17, 25, 27, 23, 17, 18, 18, 0, -6, 6, 11, 3, 3, 6, 4, 1,
-8, -15, -19, -18, -19, -16, -9, -7, -8, -11, -9, -8, -8, -7, -3, 5, 12, 17, 19,
28, 33, 25, 18, 23, 29, 33, 40, 45, 43, 42, 41, 41, 41, 33, 28, 33, 33, -7, -40,
-24, 3, -20, -49, -31, -25, -39, -46, -36, -50, -60, -56, -54, -57, -46, -21,
-19, -26, -23, -13, -4, -2, -6, -5, 8, 11, 12, 24, 28, 22, 16, 16, 10, 9, 14,
11, 4, 2, 9, 6, 1, -3, -8, -13, -18, -20, -17, -10, -11, -17, -16, -8, -1, 1,
-2, -6, -3, 4, 6, 9, 15, 23, 24, 17, 12, 16, 15, 6, 1, -2, 0, 9, 16, 3, -8, -5,
-5, -14, -19, -13, -15, -19, -17, -12, -10, -3, -2, -9, -12, -7, -1, 2, 9, 16,
19, 21, 22, 23, 31, 32, 23, 25, 40, 43, 32, 34, 44, 47, 39, 31, 32, 36, 32, -7,
-40, -28, 1, -18, -45, -32, -21, -32, -43, -36, -47, -54, -54, -54, -56, -45,
-23, -19, -20, -24, -19, -8, -5, -11, -10, 5, 8, 11, 21, 29, 29, 25, 21, 11, 12,
20, 14, 5, 8, 16, 11, 7, -1, -11, -13, -13, -20, -27, -21, -14, -14, -18, -16,
-8, -9, -15, -16, -8, -2, 0, 6, 14, 21, 22, 21, 20, 19, 19, 9, -4, -1, 10, 12,
7, 6, 4, 1, -4, -10, -10, -13, -20, -22, -15, -12, -9, -2, -2, -5, -9, -7, -4,
-4, 1, 11, 18, 21, 28, 29, 27, 31, 28, 23, 27, 35, 35, 32, 41, 48, 48, 39, 31,
30, 34, 21, -25, -40, -14, 1, -31, -39, -18, -21, -40, -43, -39, -59, -63, -56,
-56, -59, -43, -24, -24, -29, -29, -18, -10, -16, -21, -8, 9, 9, 12, 25, 31, 32,
32, 24, 13, 19, 27, 19, 7, 9, 17, 12, 4, 0, -4, -12, -19, -23, -24, -23, -22,
-19, -15, -13, -10, -13, -13, -9, -5, -5, -1, 9, 16, 20, 22, 23, 24, 22, 17, 14,
12, -1, -8, 3, 15, 10, 0, -1, -1, 0, -7, -16, -20, -17, -15, -18, -16, -8, -2,
-3, -5, -6, -5, -1, -2, 0, 9, 19, 22, 25, 29, 32, 33, 28, 23, 27, 31, 31, 35,
43, 41, 38, 40, 37, 30, 30, 19, -22, -42, -16, 5, -21, -40, -23, -16, -32, -43,
-43, -53, -58, -56, -57, -59, -45, -30, -29, -31, -30, -26, -17, -13, -21, -17,
5, 11, 5, 17, 35, 34, 25, 24, 17, 12, 20, 21, 8, 6, 16, 15, 9, 7, 0, -8, -12,
-20, -28, -21, -15, -19, -18, -8, -7, -13, -13, -10, -9, -6, -2, 1, 8, 16, 20,
22, 22, 19, 18, 17, 12, 8, 7, 1, -6, 1, 12, 9, -5, -6, -3, -7, -15, -16, -14,
-16, -19, -15, -9, -8, -7, -4, -3, -4, -1, 4, 8, 10, 15, 22, 28, 30, 30, 33, 34,
29, 25, 32, 40, 39, 36, 39, 43, 40, 36, 35, 36, 22, -13, -32, -11, 7, -19, -37,
-22, -11, -29, -38, -36, -50, -60, -54, -50, -59, -50, -31, -29, -33, -27, -22,
-21, -18, -20, -20, -7, 4, 3, 7, 21, 24, 16, 13, 14, 15, 14, 11, 6, 8, 17, 16,
8, 5, 4, -1, -8, -14, -16, -10, -7, -10, -13, -8, -7, -10, -9, -10, -13, -11,
-3, 3, 6, 12, 15, 14, 13, 16, 18, 11, 5, 7, 13, 6, -7, -6, 6, 9, 0, -5, -4, -3,
-6, -10, -13, -15, -14, -13, -8, -6, -5, -3, -1, -2, -2, 3, 5, 7, 12, 19, 24,
27, 28, 27, 26, 26, 28, 32, 33, 33, 35, 43, 42, 37, 36, 37, 31, 29, 20, -11,
-28, -7, 11, -13, -31, -20, -12, -29, -39, -39, -49, -56, -53, -53, -60, -47,
-29, -28, -36, -36, -29, -24, -25, -32, -28, -11, 0, 0, 2, 13, 17, 12, 13, 16,
16, 15, 17, 16, 17, 21, 20, 17, 13, 6, 0, 0, 3, -2, -6, -2, -1, -8, -13, -6, -4,
-12, -19, -16, -8, -5, -4, -1, 5, 5, 4, 6, 6, 4, 4, 5, 1, 2, 8, 8, -1, -6, 4,
10, 3, -7, -7, -1, -2, -8, -7, 1, 0, -7, -7, -3, -1, 0, 3, 3, 3, 7, 12, 16, 18,
22, 21, 22, 26, 25, 23, 27, 33, 30, 32, 37, 36, 36, 37, 37, 33, 34, 19, -13,
-24, -1, 16, -8, -26, -18, -8, -18, -32, -37, -44, -52, -57, -55, -52, -46, -38,
-36, -38, -38, -33, -31, -34, -37, -34, -21, -10, -6, -3, 7, 16, 11, 7, 11, 17,
18, 19, 19, 19, 23, 28, 26, 15, 9, 10, 10, 6, 5, 5, 6, 4, -1, -4, -4, -6, -13,
-14, -12, -10, -9, -6, -3, 0, 0, -2, -3, 0, 1, -1, -2, -2, -4, -4, 3, 4, -3, -2,
8, 9, -2, -6, -2, 0, -3, -5, 0, 3, 3, 1, 2, 6, 6, 5, 7, 12, 14, 13, 15, 19, 21,
23, 23, 23, 24, 26, 28, 28, 30, 30, 31, 33, 32, 29, 28, 30, 7, -19, -20, 3, 5,
-17, -22, -12, -10, -28, -36, -37, -41, -49, -54, -53, -46, -37, -36, -43, -43,
-38, -37, -36, -32, -29, -27, -15, -3, -4, -6, 5, 13, 6, 5, 14, 19, 19, 22, 25,
25, 26, 26, 20, 16, 17, 17, 11, 10, 12, 11, 11, 9, 2, -2, 0, -2, -12, -14, -9,
-6, -7, -7, -5, -5, -3, -2, -1, -2, -2, -4, -8, -6, -2, 3, 3, -2, -4, 3, 10, 6,
-1, -2, 2, 3, 4, 5, 5, 2, 0, 1, 5, 8, 8, 5, 5, 9, 14, 17, 15, 11, 14, 17, 16,
19, 23, 26, 22, 25, 30, 31, 31, 30, 31, 29, 29, 11, -15, -19, 5, 16, -10, -26,
-16, -4, -17, -33, -38, -39, -41, -46, -50, -48, -38, -35, -41, -42, -37, -35,
-35, -36, -35, -33, -20, -10, -8, -6, 1, 3, -2, 4, 13, 14, 11, 16, 22, 24, 25,
26, 21, 16, 15, 14, 11, 11, 15, 13, 11, 9, 6, -1, -3, -3, -8, -12, -9, -5, -7,
-7, -4, -3, -6, -8, -8, -7, -2, 4, 2, -1, 1, 3, 0, -1, 5, 6, 0, -1, 8, 13, 8, 0,
0, 4, 5, 0, -4, 0, 4, 2, 3, 7, 6, 3, 1, 3, 6, 10, 13, 13, 12, 14, 17, 21, 24,
21, 18, 24, 32, 32, 30, 31, 33, 31, 27, 8, -13, -11, 10, 11, -12, -21, -8, -3,
-18, -33, -40, -43, -44, -44, -46, -45, -40, -39, -43, -44, -39, -33, -31, -33,
-32, -26, -15, -9, -8, -6, 1, 6, 7, 8, 11, 16, 23, 25, 22, 24, 31, 32, 22, 15,
16, 19, 17, 15, 15, 14, 10, 6, 1, -3, -5, -8, -10, -13, -15, -13, -8, -9, -15,
-15, -8, -6, -10, -12, -8, 0, 2, 0, -1, 4, 7, 0, -5, 4, 12, 6, -5, -2, 9, 12, 5,
2, 4, 1, -1, -2, -2, -3, -3, -2, -4, -3, 0, 4, 3, 2, 6, 8, 8, 9, 11, 12, 15, 21,
26, 27, 26, 28, 31, 29, 28, 29, 30, 32, 33, 22, -2, -6, 10, 19, -1, -19, -14,
-5, -12, -26, -32, -35, -40, -44, -48, -45, -39, -36, -43, -46, -39, -34, -37,
-39, -35, -29, -22, -10, -2, -3, -4, 1, 5, 8, 14, 18, 19, 22, 26, 30, 32, 30,
22, 16, 18, 20, 18, 16, 15, 10, 6, 6, 3, -4, -9, -10, -11, -12, -14, -16, -14,
-13, -13, -13, -9, -8, -11, -12, -8, -2, 1, 3, 4, 7, 8, 8, 8, 6, 2, 1, 7, 12, 7,
-1, 3, 9, 4, -7, -10, -5, -5, -11, -11, -5, -3, -7, -9, -7, -6, -4, -2, -3, -2,
3, 10, 13, 14, 13, 15, 23, 29, 28, 24, 29, 36, 38, 34, 33, 38, 39, 36, 33, 35,
19, -7, -12, 10, 15, -10, -21, -11, -7, -25, -38, -40, -44, -48, -47, -43, -42,
-41, -42, -40, -35, -34, -36, -33, -25, -22, -21, -9, 3, 4, 2, 10, 15, 12, 12,
19, 22, 22, 21, 22, 25, 27, 25, 17, 13, 10, 7, 2, -1, -1, -2, -1, -5, -11, -13,
-12, -16, -22, -22, -20, -16, -12, -9, -9, -6, -1, -2, -6, -5, 1, 8, 10, 12, 13,
15, 17, 16, 15, 16, 19, 16, 11, 5, 4, 7, 5, -3, -9, -5, -4, -10, -20, -21, -13,
-10, -17, -22, -18, -13, -13, -15, -13, -10, -6, -3, 0, 4, 11, 16, 18, 19, 23,
27, 29, 30, 32, 36, 39, 40, 41, 42, 39, 41, 45, 43, 32, 28, 19, -4, -16, -3, 6,
-13, -29, -22, -12, -21, -35, -46, -54, -54, -49, -46, -47, -45, -41, -37, -32,
-30, -32, -29, -21, -17, -17, -8, 5, 9, 9, 12, 19, 18, 15, 17, 19, 18, 18, 19,
21, 19, 14, 9, 6, 5, 2, -3, -5, -6, -10, -12, -11, -13, -17, -20, -17, -14, -17,
-18, -12, -5, -3, -2, -1, 1, 2, 5, 9, 12, 14, 17, 21, 21, 20, 22, 24, 21, 20,
19, 17, 14, 14, 12, 4, -2, -9, -15, -16, -10, -12, -21, -25, -22, -20, -27, -34,
-32, -26, -26, -26, -19, -12, -10, -10, -6, -2, 1, 5, 9, 13, 20, 25, 30, 31, 31,
34, 39, 39, 34, 38, 46, 51, 49, 41, 38, 41, 42, 36, 27, 14, -9, -18, -6, 3, -15,
-31, -24, -18, -32, -48, -50, -53, -57, -56, -52, -49, -43, -39, -40, -40, -31,
-24, -22, -22, -19, -14, -1, 13, 13, 11, 14, 18, 16, 15, 21, 24, 22, 18, 20, 20,
18, 12, 5, -2, -5, -5, -7, -9, -11, -15, -15, -13, -16, -21, -20, -15, -14, -15,
-11, -4, -2, -3, -1, 3, 9, 14, 14, 15, 21, 27, 26, 23, 24, 25, 23, 22, 20, 18,
18, 18, 12, 5, 4, 3, -1, -7, -11, -13, -21, -36, -40, -23, -17, -35, -46, -32,
-21, -30, -39, -32, -19, -15, -18, -15, -6, 1, 0, 3, 9, 13, 19, 27, 30, 32, 37,
44, 47, 43, 39, 41, 44, 42, 41, 45, 48, 41, 34, 37, 39, 31, 21, 20, 11, -17,
-33, -18, -5, -27, -44, -32, -23, -40, -56, -54, -55, -59, -54, -47, -48, -45,
-33, -27, -31, -30, -22, -14, -12, -10, -2, 11, 20, 17, 15, 20, 25, 19, 15, 21,
23, 18, 17, 19, 16, 11, 8, 4, -5, -12, -13, -14, -16, -16, -14, -12, -13, -18,
-20, -19, -18, -18, -13, -4, 0, 3, 8, 10, 9, 12, 13, 10, 12, 21, 25, 24, 23, 23,
20, 16, 15, 13, 8, 5, 8, 6, 1, 0, 0, -8, -17, -18, -17, -18, -24, -38, -42, -25,
-9, -20, -33, -22, -7, -9, -21, -23, -12, 2, 4, 2, 6, 13, 17, 21, 20, 18, 21,
26, 26, 28, 37, 41, 37, 32, 30, 34, 40, 36, 25, 27, 38, 38, 27, 19, 21, 25, 25,
19, 8, -12, -30, -24, -10, -19, -40, -34, -17, -26, -47, -48, -43, -49, -52,
-46, -42, -40, -32, -25, -25, -24, -18, -13, -12, -11, -7, 4, 16, 18, 14, 17,
23, 20, 14, 15, 17, 14, 11, 16, 17, 13, 7, 3, -4, -10, -11, -14, -19, -21, -17,
-14, -12, -13, -17, -19, -13, -9, -12, -12, -4, 4, 6, 7, 11, 14, 14, 16, 18, 18,
19, 22, 23, 21, 19, 20, 19, 15, 9, 6, 6, 6, 1, -4, -5, -8, -10, -13, -19, -21,
-20, -26, -39, -31, -14, -10, -19, -16, -9, -8, -12, -16, -14, -5, 7, 9, 9, 11,
16, 19, 19, 14, 13, 20, 25, 24, 25, 30, 32, 30, 27, 28, 29, 25, 23, 24, 22, 18,
20, 27, 25, 21, 17, 13, 9, 6, -9, -36, -39, -18, -10, -29, -33, -24, -28, -42,
-43, -43, -55, -53, -37, -32, -36, -26, -13, -19, -25, -15, -8, -12, -10, 4, 14,
17, 22, 23, 20, 17, 18, 16, 14, 14, 11, 9, 13, 14, 5, -2, -5, -12, -20, -19,
-16, -18, -21, -18, -15, -14, -14, -16, -16, -13, -9, -7, -4, 3, 9, 12, 15, 18,
16, 17, 23, 21, 17, 23, 31, 26, 18, 20, 22, 15, 8, 5, 2, 1, 0, -2, -8, -13, -16,
-19, -27, -38, -36, -21, -13, -22, -25, -17, -10, -12, -16, -18, -16, -9, 0, 8,
13, 16, 19, 21, 19, 15, 15, 18, 20, 23, 30, 33, 30, 27, 27, 27, 24, 18, 17, 22,
28, 26, 21, 22, 22, 18, 12, 9, 7, 9, 11, -7, -34, -36, -15, -13, -34, -39, -25,
-27, -42, -42, -36, -42, -44, -33, -31, -40, -29, -8, -10, -22, -12, 3, -1, -7,
1, 12, 15, 17, 18, 17, 18, 21, 19, 12, 6, 6, 6, 1, -2, -5, -5, -7, -13, -20,
-20, -17, -21, -25, -22, -16, -16, -15, -14, -15, -13, -7, -4, -2, 5, 12, 15,
17, 20, 20, 20, 22, 23, 23, 22, 21, 21, 20, 18, 15, 10, 5, 1, -4, -8, -9, -12,
-19, -22, -24, -31, -39, -33, -25, -25, -27, -21, -14, -13, -15, -17, -15, -8,
2, 6, 9, 15, 21, 25, 24, 21, 20, 25, 27, 26, 28, 35, 37, 34, 32, 32, 30, 26, 23,
22, 24, 25, 27, 29, 27, 20, 16, 16, 11, 5, 8, 11, -9, -35, -33, -13, -14, -36,
-38, -27, -31, -44, -42, -41, -48, -45, -31, -33, -43, -31, -13, -15, -22, -11,
-2, -7, -7, 7, 13, 9, 13, 19, 15, 12, 20, 20, 7, 3, 8, 7, 1, 2, 2, -5, -10, -13,
-19, -20, -15, -17, -21, -16, -12, -12, -12, -7, -7, -6, -2, 1, 1, 5, 13, 15,
14, 16, 20, 23, 23, 23, 22, 21, 19, 17, 15, 14, 11, 7, 2, -3, -6, -7, -10, -17,
-25, -26, -29, -33, -26, -16, -19, -28, -24, -15, -15, -18, -13, -7, -5, 0, 7,
10, 11, 15, 19, 19, 17, 20, 26, 30, 28, 29, 32, 33, 32, 31, 30, 30, 31, 29, 25,
28, 31, 25, 21, 28, 31, 22, 15, 16, 15, 11, 8, -8, -32, -34, -16, -17, -39, -41,
-26, -28, -44, -45, -41, -51, -53, -39, -38, -47, -35, -11, -11, -23, -14, -2,
-7, -10, 4, 12, 9, 13, 22, 20, 15, 19, 20, 8, 1, 9, 11, 5, 2, 4, -1, -7, -10,
-15, -20, -20, -19, -23, -23, -16, -11, -10, -9, -8, -8, -6, -3, -2, 1, 7, 13,
15, 15, 16, 18, 22, 22, 19, 16, 16, 17, 16, 14, 10, 4, -1, -2, -5, -14, -22,
-22, -22, -24, -24, -22, -23, -26, -23, -19, -19, -21, -18, -13, -8, -4, 0, 3,
6, 10, 12, 12, 13, 17, 23, 25, 27, 30, 31, 30, 31, 32, 30, 30, 31, 32, 31, 32,
32, 30, 28, 27, 26, 22, 24, 26, 26, 23, 21, 10, -13, -31, -30, -22, -29, -37,
-32, -25, -33, -40, -41, -47, -57, -54, -45, -44, -42, -28, -16, -18, -18, -9,
-5, -11, -9, 2, 7, 7, 14, 21, 19, 19, 21, 16, 5, 2, 5, 5, 3, 3, 1, -4, -6, -8,
-14, -21, -21, -20, -21, -21, -14, -8, -7, -9, -8, -6, -4, -2, 1, 7, 13, 16, 16,
18, 22, 22, 18, 16, 16, 16, 15, 14, 15, 14, 10, 3, -4, -9, -13, -18, -23, -31,
-32, -21, -12, -19, -30, -24, -14, -17, -25, -20, -11, -7, -3, 2, 5, 7, 14, 19,
17, 14, 17, 20, 21, 24, 30, 35, 34, 33, 32, 33, 32, 30, 28, 29, 32, 31, 31, 33,
34, 30, 25, 22, 25, 26, 19, 16, 17, 7, -25, -43, -29, -13, -30, -48, -37, -26,
-38, -50, -45, -49, -59, -55, -41, -46, -49, -27, -6, -16, -25, -10, 0, -10,
-11, 6, 14, 10, 14, 21, 19, 19, 25, 19, 1, -3, 7, 8, 0, -1, 2, -1, -7, -10, -17,
-21, -17, -13, -17, -19, -11, -6, -8, -8, -6, -5, -4, 2, 8, 10, 15, 20, 19, 15,
17, 19, 15, 12, 13, 15, 15, 16, 14, 9, 3, 3, -3, -18, -28, -25, -20, -21, -22,
-19, -15, -15, -17, -19, -20, -19, -14, -10, -6, -1, 3, 6, 9, 12, 13, 12, 10,
15, 20, 25, 25, 25, 27, 32, 34, 33, 30, 30, 34, 35, 33, 29, 31, 31, 30, 31, 33,
29, 22, 23, 27, 22, 11, 7, -8, -36, -48, -30, -21, -40, -50, -36, -31, -48, -55,
-50, -55, -62, -50, -40, -47, -41, -16, -6, -19, -18, -2, -1, -9, 1, 16, 14, 13,
25, 29, 21, 21, 26, 16, 3, 5, 13, 7, 1, 3, 3, -3, -8, -12, -20, -23, -19, -18,
-20, -16, -7, -4, -6, -7, -6, -5, -2, 3, 7, 11, 16, 18, 17, 19, 21, 22, 19, 17,
15, 16, 17, 16, 13, 8, 4, -3, -11, -17, -20, -22, -25, -27, -28, -25, -20, -18,
-21, -22, -19, -16, -16, -15, -10, -3, 2, 5, 7, 9, 14, 18, 18, 16, 17, 23, 27,
27, 31, 36, 37, 32, 31, 34, 35, 31, 28, 32, 34, 30, 25, 29, 33, 31, 26, 24, 15,
7, 10, 10, -20, -52, -44, -16, -24, -52, -48, -27, -36, -58, -54, -47, -58, -59,
-38, -37, -49, -31, -2, -10, -29, -13, 8, -3, -14, 7, 24, 18, 16, 25, 21, 15,
23, 24, 5, -4, 10, 14, 2, -3, 2, -2, -10, -13, -17, -23, -19, -15, -21, -23,
-10, 0, -4, -7, -2, -1, -3, -1, 3, 3, 10, 20, 21, 15, 15, 20, 20, 15, 15, 15,
11, 10, 11, 8, 4, -1, -9, -20, -22, -19, -21, -26, -23, -17, -21, -26, -24, -18,
-20, -21, -16, -12, -13, -9, 1, 3, 1, 5, 12, 13, 11, 14, 20, 24, 24, 25, 28, 31,
34, 34, 32, 32, 32, 33, 32, 33, 33, 34, 32, 32, 36, 39, 33, 25, 25, 24, 18, 11,
3, -21, -45, -39, -18, -28, -53, -48, -29, -39, -62, -57, -47, -57, -64, -48,
-45, -51, -35, -9, -13, -25, -10, 6, -6, -14, 9, 24, 17, 15, 28, 31, 24, 27, 25,
10, 4, 15, 14, 1, -1, 8, 2, -10, -11, -10, -17, -20, -15, -16, -18, -10, -2, -6,
-10, -3, 1, -5, -5, 3, 11, 13, 16, 19, 19, 20, 21, 18, 15, 15, 16, 13, 10, 7, 6,
3, -2, -13, -26, -29, -23, -20, -25, -27, -26, -23, -20, -20, -23, -23, -18,
-13, -13, -12, -5, 3, 4, 2, 6, 11, 12, 10, 15, 25, 31, 28, 26, 31, 36, 35, 34,
34, 34, 36, 39, 37, 32, 33, 38, 35, 31, 34, 36, 30, 24, 22, 20, 17, 14, -11,
-49, -54, -25, -20, -52, -61, -37, -32, -56, -60, -49, -57, -69, -55, -45, -53,
-44, -11, -5, -24, -16, 8, 2, -17, -1, 24, 22, 16, 27, 32, 24, 27, 33, 17, -2,
7, 19, 8, -5, 1, 7, -4, -14, -15, -16, -21, -19, -17, -17, -13, -5, -7, -12, -6,
2, 0, -5, 1, 8, 11, 14, 19, 20, 20, 23, 25, 19, 14, 17, 18, 12, 8, 10, 8, 0, -8,
-12, -17, -22, -24, -23, -24, -27, -27, -23, -19, -18, -19, -20, -19, -16, -12,
-6, -3, -2, 0, 5, 12, 14, 12, 13, 17, 20, 22, 25, 29, 31, 34, 36, 36, 35, 36,
36, 33, 30, 34, 37, 33, 30, 36, 38, 29, 22, 23, 19, 12, 13, 4, -34, -57, -33,
-11, -39, -65, -43, -23, -49, -67, -51, -49, -68, -60, -39, -48, -55, -20, 4,
-19, -28, 5, 16, -12, -15, 17, 26, 14, 22, 36, 28, 23, 34, 30, 6, 0, 13, 12, -1,
1, 8, 0, -10, -12, -16, -23, -20, -16, -21, -23, -10, -2, -7, -8, -2, -2, -4, 1,
5, 6, 12, 22, 21, 16, 19, 25, 21, 14, 15, 17, 14, 10, 9, 8, 4, -4, -11, -14,
-15, -20, -28, -35, -34, -28, -21, -21, -25, -24, -19, -16, -18, -20, -14, -5,
-2, -4, -1, 8, 13, 12, 12, 15, 16, 17, 21, 24, 27, 34, 37, 32, 29, 36, 40, 33,
28, 31, 34, 33, 33, 35, 37, 37, 34, 29, 24, 18, 14, 16, 11, -21, -49, -38, -15,
-29, -56, -47, -27, -40, -62, -55, -50, -64, -63, -43, -43, -54, -34, -4, -13,
-28, -8, 11, -5, -15, 8, 21, 13, 15, 30, 27, 18, 28, 30, 9, 0, 14, 14, -2, -2,
11, 6, -10, -14, -13, -18, -20, -17, -19, -22, -14, -3, -5, -8, -4, 2, -1, -2,
2, 7, 12, 19, 23, 20, 21, 26, 24, 15, 16, 21, 19, 12, 12, 9, 3, 1, 0, -9, -18,
-16, -21, -34, -35, -19, -15, -27, -30, -20, -17, -20, -19, -18, -17, -10, -2,
-2, -1, 8, 14, 11, 8, 10, 13, 16, 20, 23, 24, 27, 31, 32, 32, 34, 36, 33, 31,
32, 35, 35, 34, 35, 34, 33, 33, 31, 25, 22, 21, 18, 12, 7, -11, -39, -47, -29,
-26, -50, -55, -36, -34, -55, -58, -50, -60, -67, -51, -43, -53, -41, -10, -5,
-20, -10, 9, 1, -13, 2, 18, 14, 15, 29, 30, 20, 26, 31, 14, -2, 7, 12, -4, -10,
2, 3, -12, -14, -10, -18, -27, -21, -18, -24, -22, -7, -2, -8, -4, 6, 6, 2, 6,
13, 15, 16, 20, 24, 27, 30, 27, 20, 17, 18, 15, 10, 9, 10, 7, 3, 0, -6, -15,
-20, -21, -30, -38, -33, -22, -22, -28, -24, -14, -14, -20, -19, -13, -9, -7,
-3, 2, 8, 13, 15, 14, 14, 17, 20, 21, 20, 25, 33, 35, 30, 30, 35, 38, 36, 31,
29, 29, 33, 34, 31, 29, 31, 30, 27, 26, 26, 22, 15, 12, 8, -4, -26, -39, -36,
-28, -35, -47, -46, -38, -43, -50, -49, -52, -61, -57, -44, -45, -48, -28, -6,
-10, -17, -6, 2, -5, -3, 9, 12, 11, 21, 28, 20, 16, 22, 19, 4, 0, 7, 4, -5, -4,
0, -7, -15, -15, -15, -21, -23, -20, -21, -23, -16, -6, -5, -6, 2, 9, 8, 6, 11,
16, 19, 21, 25, 26, 27, 30, 30, 26, 24, 22, 17, 12, 11, 9, 5, 2, 0, -6, -10,
-12, -22, -35, -29, -17, -26, -47, -40, -16, -10, -23, -24, -14, -10, -9, -8,
-9, -8, 4, 15, 11, 4, 14, 28, 26, 17, 18, 26, 27, 24, 25, 32, 37, 36, 35, 36,
36, 34, 31, 27, 23, 27, 32, 28, 23, 26, 29, 24, 16, 8, 4, 3, -7, -37, -57, -40,
-19, -38, -61, -48, -31, -45, -58, -50, -52, -63, -52, -35, -47, -52, -20, 5,
-10, -20, 1, 12, 0, 1, 19, 19, 13, 23, 31, 20, 17, 28, 23, 1, -1, 12, 5, -12,
-7, 3, -6, -17, -13, -14, -24, -24, -17, -23, -28, -16, -4, -9, -9, 4, 10, 4, 5,
12, 12, 14, 25, 29, 22, 22, 31, 31, 24, 22, 23, 18, 11, 9, 8, 3, -3, -6, -10,
-13, -15, -20, -25, -25, -24, -31, -39, -36, -24, -18, -19, -19, -15, -9, -6,
-5, -6, -3, 3, 9, 11, 12, 19, 28, 31, 24, 20, 22, 26, 24, 23, 27, 32, 33, 31,
33, 35, 34, 29, 25, 24, 24, 25, 24, 25, 26, 25, 21, 23, 19, 8, 2, 4, -13, -46,
-52, -28, -25, -51, -52, -31, -34, -57, -53, -42, -57, -65, -42, -35, -54, -43,
-1, 5, -19, -13, 13, 8, -7, 9, 25, 14, 11, 29, 31, 17, 21, 31, 15, -3, 3, 9, -5,
-14, -5, -3, -14, -18, -15, -23, -29, -23, -21, -28, -24, -9, -5, -10, -3, 9, 7,
3, 11, 17, 13, 14, 24, 27, 23, 27, 33, 29, 20, 19, 18, 11, 3, 1, -2, -6, -8,
-12, -16, -16, -15, -24, -33, -36, -33, -32, -29, -26, -23, -21, -16, -11, -8,
-6, -3, 2, 5, 8, 12, 17, 20, 21, 24, 25, 24, 22, 24, 24, 23, 23, 26, 28, 28, 29,
29, 26, 25, 26, 25, 25, 24, 23, 21, 20, 23, 26, 25, 21, 19, 16, 11, 8, 8, -5,
-33, -47, -33, -22, -38, -51, -37, -30, -46, -54, -44, -47, -58, -48, -36, -47,
-50, -20, 2, -10, -15, 4, 11, -2, 1, 17, 18, 11, 19, 28, 24, 25, 35, 28, 7, 0,
9, 3, -12, -15, -9, -12, -16, -14, -15, -23, -24, -19, -23, -29, -22, -13, -13,
-11, 1, 9, 7, 9, 16, 17, 14, 20, 26, 21, 19, 28, 32, 25, 19, 19, 17, 8, 3, 0,
-5, -10, -11, -12, -16, -19, -23, -27, -29, -26, -29, -33, -29, -19, -14, -15,
-11, -5, 0, 4, 8, 8, 7, 12, 19, 18, 16, 23, 31, 30, 24, 24, 26, 24, 21, 22, 25,
25, 24, 23, 22, 22, 21, 20, 16, 13, 13, 17, 19, 21, 23, 22, 20, 19, 17, 9, 4, 5,
-6, -34, -46, -31, -21, -36, -45, -34, -31, -43, -46, -42, -51, -58, -46, -40,
-51, -45, -16, -4, -13, -10, 6, 6, 0, 7, 16, 13, 12, 21, 26, 24, 28, 34, 25, 10,
6, 8, 2, -9, -12, -11, -12, -13, -12, -15, -19, -19, -17, -19, -22, -16, -9, -9,
-8, 0, 7, 9, 11, 15, 16, 16, 18, 20, 19, 21, 25, 26, 21, 17, 16, 14, 12, 7, 0,
-6, -9, -10, -12, -14, -18, -21, -22, -26, -34, -34, -25, -19, -21, -21, -12,
-2, 1, 3, 5, 5, 7, 11, 12, 12, 17, 22, 24, 24, 25, 26, 24, 23, 22, 20, 18, 19,
21, 20, 19, 20, 21, 18, 16, 15, 13, 10, 11, 15, 19, 22, 24, 24, 19, 16, 14, 12,
9, 3, -18, -40, -37, -19, -24, -45, -44, -28, -31, -46, -45, -40, -49, -53, -43,
-43, -48, -34, -10, -7, -15, -5, 9, 7, 2, 11, 16, 13, 14, 21, 19, 17, 26, 31,
18, 4, 6, 9, -3, -14, -13, -10, -15, -17, -15, -15, -18, -16, -15, -20, -21,
-14, -11, -13, -10, 1, 7, 9, 14, 17, 17, 18, 21, 20, 18, 21, 23, 19, 16, 19, 20,
15, 9, 4, -1, -6, -9, -14, -18, -18, -16, -17, -22, -26, -24, -23, -28, -31,
-26, -17, -12, -9, -5, 2, 8, 13, 13, 11, 12, 16, 17, 14, 17, 24, 26, 23, 22, 23,
23, 22, 21, 19, 19, 20, 21, 20, 21, 22, 20, 18, 16, 15, 15, 17, 18, 18, 23, 29,
27, 22, 20, 19, 16, 10, -7, -30, -38, -28, -26, -40, -44, -35, -32, -41, -41,
-40, -48, -54, -50, -50, -54, -40, -18, -14, -18, -6, 8, 7, 2, 10, 12, 8, 11,
20, 21, 19, 27, 32, 22, 11, 12, 10, -2, -11, -12, -14, -19, -17, -14, -16, -18,
-14, -15, -22, -22, -16, -15, -19, -14, -2, 3, 6, 14, 21, 21, 20, 25, 25, 23,
24, 27, 25, 21, 22, 23, 19, 13, 10, 4, -3, -6, -8, -14, -18, -16, -18, -23, -24,
-20, -23, -31, -33, -29, -28, -26, -19, -13, -9, -2, 7, 11, 11, 10, 11, 12, 12,
11, 11, 13, 17, 18, 18, 17, 17, 17, 16, 14, 13, 14, 14, 16, 17, 17, 15, 16, 18,
19, 19, 19, 19, 19, 24, 30, 31, 27, 26, 23, 20, 18, 10, -13, -33, -29, -19, -29,
-43, -36, -27, -34, -40, -35, -40, -51, -48, -41, -49, -52, -30, -11, -13, -12,
7, 16, 9, 7, 16, 16, 11, 16, 22, 19, 20, 29, 29, 17, 12, 12, 4, -10, -16, -17,
-23, -26, -23, -21, -23, -22, -20, -22, -25, -22, -18, -19, -18, -9, 1, 6, 10,
17, 22, 22, 25, 27, 25, 22, 25, 28, 24, 22, 26, 27, 20, 12, 8, 3, -4, -10, -14,
-17, -18, -17, -18, -21, -23, -20, -21, -29, -35, -34, -26, -21, -18, -15, -7,
2, 10, 11, 10, 11, 13, 13, 9, 9, 14, 14, 11, 10, 14, 15, 13, 13, 10, 7, 8, 13,
12, 10, 11, 16, 19, 17, 15, 16, 20, 23, 22, 22, 27, 34, 35, 31, 31, 31, 26, 22,
20, 5, -22, -30, -19, -20, -38, -42, -30, -32, -43, -41, -37, -48, -54, -45,
-45, -54, -44, -19, -13, -18, -6, 12, 14, 9, 15, 17, 11, 12, 21, 21, 16, 23, 30,
22, 11, 14, 14, 1, -12, -14, -16, -23, -25, -21, -23, -26, -23, -21, -23, -22,
-17, -16, -19, -14, -3, 2, 4, 11, 20, 23, 24, 28, 30, 27, 26, 28, 26, 22, 24,
26, 21, 16, 15, 13, 3, -4, -8, -10, -14, -17, -21, -25, -23, -20, -23, -30, -27,
-24, -28, -28, -21, -15, -14, -7, 0, 2, 3, 9, 13, 10, 8, 9, 13, 12, 10, 9, 11,
12, 10, 10, 10, 9, 9, 10, 10, 11, 13, 17, 18, 19, 20, 21, 20, 21, 23, 24, 26,
28, 33, 34, 33, 34, 34, 30, 22, 18, 9, -12, -28, -27, -23, -35, -44, -39, -35,
-41, -43, -39, -45, -54, -49, -44, -51, -50, -28, -14, -16, -11, 6, 13, 9, 11,
16, 12, 9, 14, 16, 12, 16, 26, 23, 12, 9, 11, 5, -8, -16, -17, -19, -22, -23,
-23, -22, -18, -17, -20, -21, -18, -17, -17, -13, -5, 0, 4, 12, 20, 23, 25, 28,
28, 24, 25, 28, 25, 20, 21, 25, 22, 15, 14, 13, 6, 0, -3, -8, -15, -16, -17,
-20, -23, -22, -22, -25, -24, -23, -25, -29, -25, -17, -13, -14, -10, -2, 1, 1,
5, 7, 5, 4, 8, 11, 7, 6, 10, 13, 11, 10, 13, 14, 12, 12, 14, 16, 15, 16, 20, 23,
22, 22, 24, 26, 26, 25, 26, 29, 31, 30, 30, 31, 31, 31, 28, 23, 16, 7, -8, -21,
-25, -23, -31, -40, -41, -38, -41, -43, -40, -43, -48, -47, -43, -48, -49, -37,
-25, -23, -19, -6, 3, 3, 7, 14, 12, 7, 9, 14, 12, 11, 17, 21, 16, 12, 16, 14, 4,
-5, -7, -9, -16, -19, -18, -18, -19, -16, -14, -15, -14, -10, -7, -9, -10, -5,
1, 5, 7, 12, 17, 22, 25, 26, 26, 26, 25, 22, 20, 19, 18, 16, 15, 13, 9, 6, 3,
-2, -7, -11, -14, -18, -21, -22, -23, -24, -23, -22, -23, -22, -22, -25, -26,
-19, -13, -11, -12, -8, -2, 4, 6, 6, 7, 8, 10, 11, 10, 11, 13, 16, 16, 15, 16,
20, 20, 17, 17, 19, 21, 20, 19, 20, 21, 23, 25, 23, 22, 24, 27, 26, 24, 26, 27,
26, 23, 20, 16, 10, 2, -10, -20, -22, -22, -30, -37, -36, -34, -36, -38, -37,
-39, -45, -45, -44, -47, -47, -38, -29, -26, -20, -10, -2, 0, 3, 6, 6, 6, 8, 10,
9, 10, 15, 18, 17, 16, 17, 15, 10, 4, 0, -4, -7, -9, -10, -10, -9, -8, -8, -7,
-7, -7, -8, -8, -7, -6, -5, -1, 2, 5, 8, 11, 14, 16, 17, 16, 16, 16, 15, 14, 13,
13, 13, 11, 10, 9, 7, 3, 0, -3, -7, -11, -12, -14, -16, -16, -15, -17, -20, -20,
-22, -24, -22, -16, -15, -16, -13, -8, -5, -4, -1, 2, 3, 3, 6, 8, 10, 13, 16,
16, 15, 15, 16, 16, 14, 15, 15, 15, 15, 18, 21, 20, 19, 19, 19, 19, 19, 20, 20,
19, 19, 21, 23, 24, 23, 23, 20, 17, 13, 5, -6, -14, -16, -16, -22, -28, -26,
-24, -27, -30, -29, -31, -36, -39, -40, -41, -43, -38, -30, -27, -25, -18, -10,
-7, -6, -2, 2, 2, 1, 4, 7, 9, 12, 15, 16, 15, 17, 18, 15, 11, 7, 4, 1, -2, -4,
-6, -6, -5, -5, -6, -7, -7, -7, -8, -10, -10, -9, -8, -7, -6, -3, 1, 5, 8, 9,
10, 11, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 10, 7, 5, 3, 0, -3, -6, -8, -11,
-12, -11, -13, -16, -16, -15, -17, -21, -19, -14, -12, -15, -15, -12, -9, -7,
-6, -4, -3, 0, 3, 4, 4, 7, 11, 11, 9, 9, 11, 13, 13, 13, 14, 15, 17, 19, 19, 20,
20, 22, 21, 19, 19, 20, 21, 21, 21, 22, 23, 23, 22, 21, 20, 18, 15, 7, -3, -9,
-10, -10, -17, -23, -23, -22, -24, -26, -27, -30, -32, -33, -36, -41, -42, -37,
-32, -32, -29, -21, -14, -10, -7, -4, -2, 1, 4, 4, 3, 5, 10, 11, 11, 14, 17, 18,
16, 15, 13, 10, 8, 5, 1, -1, -3, -4, -6, -6, -6, -6, -5, -5, -7, -9, -9, -8, -9,
-9, -8, -4, -2, 0, 2, 4, 6, 7, 8, 8, 8, 8, 9, 9, 8, 9, 10, 10, 8, 7, 7, 5, 3, 1,
-1, -3, -4, -6, -7, -9, -10, -11, -13, -17, -17, -14, -12, -13, -14, -12, -11,
-10, -10, -9, -8, -8, -6, -5, -3, 0, 3, 6, 7, 9, 10, 12, 12, 12, 13, 13, 13, 14,
17, 19, 19, 20, 21, 22, 22, 22, 21, 20, 20, 20, 19, 19, 18, 18, 18, 18, 16, 13,
11, 8, 2, -6, -10, -11, -15, -20, -22, -22, -22, -23, -23, -23, -26, -29, -30,
-32, -34, -34, -31, -28, -26, -23, -19, -15, -11, -8, -7, -6, -4, -3, -2, -1, 1,
3, 5, 7, 8, 11, 13, 14, 13, 11, 10, 8, 7, 5, 4, 3, 2, 2, 2, 2, 3, 3, 3, 2, 1, 0,
-1, -2, -2, -2, -1, -1, 0, 2, 3, 4, 5, 5, 5, 5, 4, 4, 3, 3, 3, 2, 2, 2, 2, 2, 2,
1, 0, -1, -2, -3, -3, -5, -6, -6, -5, -7, -9, -8, -7, -11, -12, -9, -6, -8, -9,
-6, -5, -6, -7, -6, -5, -4, -2, -1, 0, 1, 4, 6, 5, 5, 7, 7, 7, 7, 8, 10, 11, 12,
13, 13, 15, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 14, 14, 13, 13, 12,
10, 8, 4, -1, -4, -5, -7, -10, -12, -13, -13, -14, -14, -15, -17, -20, -20, -23,
-26, -27, -25, -25, -26, -26, -23, -21, -19, -17, -16, -14, -12, -11, -10, -9,
-7, -5, -4, -2, 0, 3, 4, 6, 7, 9, 10, 10, 10, 9, 8, 9, 8, 7, 7, 7, 7, 7, 8, 7,
6, 6, 5, 3, 1, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
1, 0, 0, 0, 1, 1, 0, 0, -1, -2, -3, -3, -4, -4, -5, -7, -8, -6, -5, -6, -7, -6,
-5, -5, -5, -5, -5, -4, -4, -3, -3, -2, 0, 0, 1, 1, 2, 4, 5, 5, 6, 6, 6, 7, 7,
7, 7, 8, 8, 8, 8, 8, 9, 10, 10, 10, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15,
14, 14, 15, 13, 9, 7, 6, 4, 1, -2, -3, -4, -7, -8, -9, -11, -13, -15, -18, -20,
-22, -24, -25, -25, -25, -26, -26, -24, -23, -21, -20, -19, -17, -16, -14, -12,
-11, -10, -9, -7, -4, -3, -2, 0, 2, 3, 4, 4, 5, 5, 4, 4, 5, 5, 4, 4, 5, 5, 5, 5,
6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 6, 6, 6, 7, 6, 5, 5, 4, 3, 3, 2, 1, 0, -1, -1, -2,
-3, -4, -4, -5, -5, -6, -5, -5, -5, -5, -5, -5, -4, -3, -4, -4, -3, -2, -2, -3,
-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -1,
0, 0, 1, 2, 2, 3, 5, 6, 6, 7, 9, 9, 10, 11, 12, 12, 14, 15, 15, 15, 15, 16, 16,
15, 16, 16, 15, 14, 13, 14, 12, 9, 6, 4, 2, -1, -3, -4, -6, -8, -10, -11, -12,
-14, -16, -17, -18, -20, -22, -22, -22, -23, -23, -22, -23, -22, -20, -19, -19,
-18, -16, -15, -15, -14, -13, -13, -12, -10, -8, -7, -6, -5, -3, -2, -1, 0, 1,
3, 3, 3, 5, 7, 7, 8, 10, 10, 11, 12, 12, 13, 14, 13, 13, 12, 12, 11, 11, 11, 10,
9, 9, 9, 8, 7, 6, 5, 5, 4, 3, 1, 1, 1, 1, 0, 0, -1, -1, -1, -2, -2, -3, -3, -3,
-4, -4, -5, -5, -5, -6, -7, -7, -6, -6, -7, -8, -8, -8, -8, -8, -8, -8, -8, -8,
-7, -6, -6, -5, -4, -3, -3, -1, 0, 0, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 11,
11, 12, 13, 12, 12, 13, 13, 12, 12, 13, 12, 12, 13, 12, 11, 11, 11, 10, 9, 8, 7,
5, 4, 2, 0, -1, -2, -4, -6, -7, -8, -9, -11, -13, -14, -15, -17, -19, -21, -22,
-23, -23, -24, -24, -24, -24, -24, -24, -24, -23, -23, -21, -20, -19, -18, -16,
-14, -13, -11, -10, -7, -4, -3, 0, 2, 4, 6, 8, 9, 10, 12, 14, 15, 16, 17, 18,
18, 18, 19, 18, 18, 19, 19, 18, 18, 17, 16, 15, 14, 14, 12, 9, 9, 8, 7, 5, 4, 3,
1, 0, -1, -3, -5, -6, -8, -8, -10, -11, -11, -12, -13, -14, -14, -13, -14, -15,
-15, -14, -13, -13, -13, -12, -11, -10, -10, -9, -8, -7, -6, -6, -6, -5, -3, -2,
-2, -1, 0, 1, 2, 4, 5, 6, 7, 8, 8, 9, 10, 12, 13, 14, 14, 14, 16, 18, 18, 19,
19, 20, 20, 20, 20, 21, 21, 21, 21, 20, 19, 18, 17, 15, 12, 9, 7, 5, 3, 0, -3,
-5, -8, -11, -14, -16, -19, -21, -23, -27, -30, -32, -33, -35, -37, -37, -38,
-37, -37, -35, -34, -33, -31, -29, -29, -27, -24, -21, -19, -16, -13, -10, -6,
-3, 0, 3, 7, 10, 12, 14, 17, 19, 21, 22, 23, 24, 25, 26, 27, 28, 28, 27, 27, 26,
26, 24, 23, 22, 20, 18, 15, 14, 12, 10, 8, 6, 3, 1, 0, -2, -4, -6, -8, -9, -10,
-11, -12, -13, -13, -14, -15, -15, -15, -16, -17, -17, -16, -16, -18, -19, -17,
-15, -16, -16, -14, -14, -14, -13, -12, -11, -10, -8, -8, -7, -6, -4, -2, 1, 3,
3, 6, 9, 10, 11, 14, 16, 18, 20, 21, 22, 24, 26, 28, 29, 30, 30, 30, 31, 32, 33,
32, 31, 31, 30, 28, 26, 26, 24, 18, 11, 9, 7, 3, -1, -4, -7, -12, -16, -18, -22,
-26, -30, -33, -38, -43, -44, -44, -46, -48, -48, -49, -49, -46, -44, -43, -41,
-37, -35, -33, -28, -24, -22, -18, -14, -11, -8, -4, 0, 5, 9, 13, 16, 18, 22,
24, 25, 27, 30, 30, 30, 31, 32, 31, 31, 31, 30, 29, 29, 28, 26, 24, 23, 21, 19,
17, 14, 11, 9, 7, 5, 2, 0, -3, -5, -6, -8, -10, -12, -14, -15, -16, -17, -18,
-19, -20, -21, -22, -23, -23, -22, -22, -24, -23, -21, -21, -19, -18, -18, -17,
-16, -15, -14, -12, -10, -9, -8, -6, -5, -2, 1, 3, 5, 7, 10, 13, 16, 19, 21, 23,
25, 26, 28, 30, 32, 34, 35, 35, 35, 36, 37, 38, 38, 37, 36, 36, 34, 31, 27, 23,
17, 14, 11, 5, 0, -3, -6, -11, -15, -18, -23, -27, -31, -36, -42, -45, -47, -48,
-51, -53, -53, -52, -51, -49, -47, -45, -43, -40, -37, -34, -30, -26, -23, -21,
-17, -13, -10, -6, -1, 3, 7, 11, 15, 18, 22, 25, 27, 29, 31, 31, 31, 33, 33, 32,
32, 33, 32, 32, 33, 31, 30, 29, 27, 25, 21, 19, 17, 13, 11, 8, 5, 2, 0, -3, -5,
-8, -10, -11, -14, -16, -17, -18, -20, -21, -21, -23, -24, -24, -26, -26, -24,
-24, -25, -25, -24, -21, -19, -19, -18, -16, -17, -16, -12, -10, -9, -7, -5, -4,
-2, 2, 4, 6, 8, 10, 13, 16, 18, 21, 24, 26, 27, 29, 31, 33, 35, 36, 36, 36, 37,
39, 40, 39, 39, 40, 39, 36, 34, 30, 22, 16, 16, 13, 5, 0, -2, -9, -15, -16, -18,
-25, -30, -33, -39, -44, -46, -47, -50, -53, -53, -55, -56, -52, -49, -47, -45,
-41, -39, -37, -31, -25, -24, -23, -18, -15, -13, -9, -5, -2, 2, 7, 11, 13, 17,
21, 23, 25, 28, 29, 28, 29, 31, 30, 30, 32, 32, 29, 30, 32, 30, 29, 29, 28, 24,
23, 21, 18, 16, 15, 11, 6, 4, 2, -1, -4, -5, -7, -10, -12, -14, -16, -17, -17,
-19, -21, -22, -23, -24, -26, -24, -22, -24, -25, -24, -23, -22, -19, -18, -18,
-16, -15, -16, -13, -10, -10, -8, -5, -5, -3, 1, 3, 4, 8, 10, 11, 14, 17, 20,
23, 25, 27, 28, 30, 32, 35, 36, 35, 37, 39, 38, 40, 40, 39, 39, 40, 37, 34, 31,
23, 16, 16, 14, 6, -1, -3, -9, -15, -16, -18, -24, -30, -34, -38, -43, -45, -46,
-49, -51, -52, -54, -55, -52, -48, -47, -47, -43, -39, -37, -33, -27, -25, -23,
-19, -16, -14, -10, -6, -4, -1, 5, 8, 10, 15, 19, 21, 24, 27, 28, 28, 28, 30,
30, 30, 31, 31, 30, 30, 31, 30, 28, 29, 28, 24, 22, 22, 19, 14, 13, 11, 6, 2, 1,
-2, -5, -6, -7, -11, -13, -13, -15, -17, -18, -18, -20, -22, -23, -22, -23, -23,
-23, -23, -23, -23, -23, -22, -17, -16, -18, -18, -15, -15, -14, -11, -10, -10,
-8, -6, -5, -1, 2, 2, 4, 7, 8, 11, 16, 17, 20, 24, 25, 25, 28, 30, 32, 35, 35,
35, 37, 39, 39, 40, 41, 40, 40, 40, 38, 33, 26, 20, 21, 18, 10, 5, 3, -4, -10,
-10, -12, -18, -24, -29, -35, -38, -39, -41, -45, -47, -48, -50, -51, -49, -48,
-47, -46, -44, -42, -41, -35, -31, -30, -28, -23, -21, -20, -16, -12, -11, -7,
-2, 1, 3, 8, 13, 15, 19, 23, 24, 23, 26, 28, 29, 30, 32, 32, 30, 31, 33, 32, 31,
32, 29, 26, 26, 26, 22, 19, 19, 16, 10, 8, 7, 3, 0, -1, -3, -7, -9, -9, -12,
-14, -12, -14, -17, -18, -18, -20, -21, -21, -22, -21, -21, -23, -23, -20, -19,
-18, -16, -18, -18, -16, -16, -15, -12, -11, -11, -10, -9, -7, -2, -1, -1, 2, 5,
5, 8, 14, 15, 16, 20, 22, 23, 25, 27, 28, 30, 32, 33, 34, 36, 38, 38, 37, 40,
40, 36, 35, 32, 22, 18, 22, 19, 8, 6, 5, -5, -11, -7, -10, -19, -23, -27, -35,
-38, -36, -38, -44, -46, -46, -48, -49, -46, -46, -48, -44, -40, -41, -40, -34,
-30, -30, -27, -22, -21, -21, -16, -13, -12, -6, 0, 0, 3, 9, 12, 14, 19, 23, 22,
23, 26, 26, 26, 28, 31, 30, 29, 30, 31, 29, 30, 31, 29, 26, 25, 23, 21, 19, 18,
15, 11, 9, 6, 2, 0, -1, -1, -5, -7, -9, -11, -12, -11, -13, -15, -15, -17, -20,
-19, -19, -20, -19, -18, -20, -20, -18, -15, -14, -14, -15, -15, -14, -14, -13,
-11, -9, -8, -8, -7, -5, -2, -1, 0, 4, 5, 6, 9, 12, 13, 14, 17, 20, 22, 21, 22,
25, 25, 26, 29, 30, 30, 33, 34, 33, 35, 37, 35, 32, 28, 17, 14, 20, 17, 6, 4, 4,
-5, -10, -6, -8, -16, -22, -27, -34, -36, -33, -36, -42, -45, -44, -45, -47,
-42, -41, -45, -43, -37, -37, -38, -31, -27, -28, -23, -18, -18, -18, -12, -11,
-10, -3, 2, 2, 5, 10, 14, 17, 21, 24, 23, 23, 26, 26, 25, 28, 30, 28, 27, 29,
28, 27, 30, 29, 24, 23, 25, 22, 18, 18, 16, 10, 9, 8, 3, 0, 0, -4, -8, -8, -8,
-11, -12, -13, -15, -16, -16, -16, -19, -21, -19, -20, -22, -21, -19, -20, -17,
-15, -17, -16, -12, -12, -14, -11, -10, -12, -11, -8, -7, -5, -3, -2, -1, -1, 1,
3, 5, 6, 8, 10, 11, 13, 15, 17, 19, 21, 21, 22, 23, 23, 25, 28, 29, 28, 30, 32,
32, 31, 33, 32, 30, 27, 20, 12, 13, 17, 10, 2, 3, 1, -8, -10, -6, -13, -20, -22,
-27, -35, -34, -30, -36, -41, -40, -40, -43, -40, -37, -40, -39, -34, -34, -36,
-32, -27, -25, -22, -17, -17, -18, -13, -9, -8, -5, 1, 3, 3, 6, 12, 14, 16, 20,
21, 20, 22, 26, 25, 25, 28, 28, 25, 26, 29, 25, 25, 27, 24, 20, 21, 22, 18, 15,
15, 12, 8, 6, 5, 1, -2, -2, -5, -8, -8, -8, -11, -13, -13, -15, -16, -16, -17,
-19, -18, -17, -19, -19, -19, -19, -18, -16, -15, -15, -16, -14, -11, -11, -12,
-8, -7, -10, -8, -6, -9, -6, 0, -3, -3, 3, 2, 0, 5, 7, 4, 8, 10, 7, 10, 14, 13,
15, 19, 18, 18, 22, 24, 24, 25, 25, 27, 28, 26, 26, 28, 29, 29, 27, 25, 23, 16,
10, 14, 17, 8, 2, 3, -3, -9, -7, -8, -16, -18, -22, -29, -31, -29, -31, -36,
-37, -38, -39, -38, -36, -35, -37, -35, -31, -30, -31, -28, -24, -23, -20, -15,
-15, -14, -9, -6, -6, -1, 4, 4, 5, 9, 12, 13, 17, 20, 19, 19, 23, 24, 23, 26,
27, 23, 24, 27, 25, 23, 26, 25, 20, 20, 20, 17, 15, 14, 11, 9, 8, 5, 2, 0, -2,
-5, -6, -8, -11, -13, -14, -15, -16, -17, -17, -18, -20, -19, -18, -19, -19,
-19, -19, -19, -17, -17, -17, -15, -14, -13, -11, -10, -9, -7, -7, -7, -5, -4,
-3, 0, -1, -2, -1, 2, 2, 4, 5, 4, 6, 7, 7, 8, 11, 12, 12, 13, 14, 15, 17, 18,
19, 19, 19, 21, 22, 24, 24, 24, 23, 25, 25, 23, 24, 25, 22, 21, 18, 9, 5, 12,
11, 0, -1, 1, -7, -13, -9, -11, -18, -19, -22, -29, -32, -28, -29, -35, -34,
-34, -37, -36, -31, -34, -36, -30, -28, -30, -29, -24, -22, -21, -16, -16, -16,
-11, -7, -8, -5, 2, 4, 3, 6, 10, 11, 14, 19, 19, 18, 20, 22, 21, 23, 27, 27, 24,
25, 26, 24, 24, 26, 23, 18, 19, 18, 15, 13, 13, 9, 6, 6, 3, -2, -3, -4, -8, -9,
-9, -12, -14, -14, -15, -16, -15, -16, -18, -19, -19, -19, -18, -17, -17, -16,
-16, -14, -13, -13, -12, -11, -13, -11, -5, -6, -9, -5, -4, -5, -3, -1, -2, 1,
3, 0, 3, 7, 8, 8, 8, 8, 9, 11, 10, 11, 12, 11, 12, 15, 15, 15, 17, 17, 17, 19,
18, 17, 19, 20, 18, 19, 20, 18, 18, 19, 17, 17, 19, 18, 16, 10, 2, 4, 9, 1, -6,
-4, -6, -13, -11, -10, -18, -18, -18, -25, -31, -30, -29, -32, -32, -34, -36,
-35, -31, -31, -34, -30, -26, -28, -29, -25, -22, -22, -16, -13, -16, -12, -5,
-5, -5, 2, 5, 4, 8, 11, 11, 14, 20, 20, 18, 20, 22, 22, 23, 24, 25, 25, 26, 24,
22, 22, 23, 22, 19, 16, 15, 13, 11, 8, 7, 5, 3, 1, -2, -4, -6, -7, -9, -11, -13,
-14, -14, -15, -16, -16, -15, -16, -17, -16, -16, -16, -16, -16, -15, -15, -14,
-13, -11, -10, -8, -7, -6, -4, -4, -4, -2, 0, -1, -1, 1, 2, 3, 6, 7, 6, 5, 8, 9,
10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 13, 14, 14, 14, 14, 16, 17, 16, 16, 17,
16, 14, 17, 18, 16, 15, 16, 17, 17, 17, 14, 7, 0, -1, 3, -1, -8, -10, -8, -10,
-13, -12, -16, -17, -16, -22, -29, -28, -25, -28, -29, -27, -29, -30, -26, -25,
-28, -26, -22, -22, -21, -20, -20, -18, -13, -10, -13, -10, -4, -3, -5, 0, 5, 3,
6, 9, 8, 9, 15, 18, 18, 20, 21, 20, 22, 24, 25, 24, 23, 21, 20, 21, 20, 20, 17,
13, 12, 11, 9, 5, 5, 5, 1, -1, -6, -8, -8, -9, -13, -15, -12, -15, -17, -16,
-16, -15, -15, -15, -18, -18, -14, -13, -15, -16, -14, -13, -14, -11, -8, -9,
-11, -7, -2, -2, -2, -2, -1, 1, 2, 1, 1, 7, 8, 8, 8, 10, 12, 11, 10, 9, 12, 12,
10, 10, 9, 11, 13, 14, 14, 13, 14, 17, 19, 16, 14, 16, 17, 16, 14, 15, 19, 21,
19, 16, 20, 22, 21, 20, 10, -4, -7, 2, -3, -17, -18, -12, -11, -15, -15, -16,
-17, -13, -18, -31, -34, -27, -28, -33, -29, -28, -29, -25, -22, -24, -24, -18,
-19, -22, -21, -21, -20, -17, -11, -10, -11, -8, -3, 0, 1, 3, 6, 7, 8, 8, 11,
15, 18, 20, 22, 23, 25, 29, 30, 27, 27, 25, 23, 21, 19, 15, 12, 13, 11, 9, 7, 6,
3, 0, -1, -3, -5, -6, -9, -13, -14, -14, -14, -13, -13, -15, -15, -15, -14, -13,
-14, -14, -15, -16, -18, -18, -19, -19, -15, -14, -13, -10, -8, -6, -4, -5, -6,
-2, -1, -3, 3, 7, 7, 10, 12, 12, 14, 16, 11, 11, 13, 11, 12, 16, 16, 15, 18, 18,
17, 19, 16, 17, 22, 23, 20, 16, 17, 19, 21, 18, 18, 24, 23, 21, 19, 17, 17, 20,
16, -3, -15, -16, -10, -14, -27, -27, -16, -14, -21, -20, -19, -23, -22, -26,
-36, -36, -31, -30, -31, -26, -26, -23, -19, -20, -22, -22, -21, -23, -24, -23,
-22, -18, -15, -9, -8, -6, -3, -1, -2, 0, 5, 6, 8, 10, 12, 17, 22, 26, 29, 30,
28, 28, 28, 24, 20, 21, 17, 15, 15, 14, 10, 11, 10, 6, 3, 2, 1, -2, -5, -6, -7,
-8, -8, -7, -7, -6, -7, -10, -10, -9, -13, -14, -11, -14, -15, -14, -16, -23,
-23, -19, -15, -17, -23, -18, -10, -9, -11, -8, -5, -3, 1, 1, 0, 7, 11, 13, 14,
12, 11, 15, 15, 9, 11, 12, 12, 14, 14, 15, 19, 20, 18, 19, 18, 18, 24, 23, 18,
19, 21, 21, 22, 22, 18, 23, 26, 20, 23, 21, 18, 19, 20, 6, -13, -21, -22, -14,
-21, -30, -25, -17, -20, -22, -18, -25, -28, -22, -28, -37, -34, -24, -21, -21,
-17, -16, -13, -15, -21, -25, -27, -22, -23, -26, -26, -20, -14, -11, -6, -8,
-7, -5, -4, -3, 0, 5, 8, 14, 15, 16, 24, 30, 30, 27, 24, 21, 20, 19, 15, 14, 14,
12, 10, 10, 10, 7, 3, 2, 0, -1, -4, -4, -3, -2, -3, -4, -4, -4, -4, -5, -7, -8,
-7, -7, -8, -10, -10, -10, -13, -18, -25, -25, -21, -15, -20, -21, -12, -9, -9,
-10, -8, -11, -5, 2, 0, 1, 8, 15, 17, 15, 12, 13, 14, 7, 6, 10, 8, 10, 12, 14,
13, 17, 18, 16, 16, 14, 19, 22, 21, 22, 25, 25, 24, 25, 20, 18, 22, 23, 25, 22,
19, 23, 26, 21, 12, 6, -19, -33, -23, -15, -25, -33, -20, -16, -17, -20, -18,
-27, -31, -23, -26, -35, -30, -16, -14, -16, -11, -11, -15, -19, -28, -30, -27,
-23, -23, -23, -21, -18, -11, -10, -10, -11, -10, -7, -7, -3, 3, 11, 16, 18, 21,
22, 27, 27, 25, 22, 18, 18, 18, 19, 15, 15, 17, 11, 5, 4, 4, 0, -2, -3, -6, -3,
1, -1, -1, 1, 1, -1, -1, -4, -5, 0, -6, -7, -4, -4, -9, -10, -12, -29, -33, -22,
-13, -19, -25, -17, -13, -13, -12, -10, -14, -11, 0, 1, 1, 7, 13, 13, 13, 11,
12, 13, 7, 2, 5, 8, 11, 16, 15, 15, 17, 17, 13, 10, 14, 17, 19, 14, 16, 22, 26,
25, 22, 21, 19, 22, 18, 18, 20, 24, 21, 20, 25, 26, 24, 11, -6, -32, -36, -27,
-17, -28, -32, -18, -15, -18, -19, -19, -36, -34, -20, -22, -30, -19, -6, -8,
-7, -3, -9, -17, -22, -29, -31, -29, -22, -20, -17, -20, -17, -12, -14, -16,
-16, -10, -10, -6, 3, 10, 10, 13, 24, 22, 16, 20, 25, 25, 22, 24, 22, 22, 23,
20, 15, 4, 2, 4, 5, -1, -3, 4, 2, 0, 0, 0, -4, -1, 4, 1, -1, 3, 3, -1, -2, 0,
-2, -6, -14, -28, -29, -24, -15, -17, -14, -15, -19, -14, -14, -15, -18, -8, -8,
-8, -1, 4, 4, 3, 10, 10, 10, 11, 8, 7, 7, 14, 15, 15, 14, 12, 13, 13, 17, 17,
18, 19, 16, 19, 21, 23, 18, 17, 22, 25, 25, 20, 22, 23, 22, 19, 18, 11, 9, 18,
23, 15, 12, 9, -13, -38, -38, -26, -28, -32, -31, -28, -26, -19, -20, -33, -34,
-24, -18, -26, -26, -17, -11, -11, -16, -17, -19, -23, -29, -31, -29, -25, -15,
-12, -16, -18, -14, -15, -19, -13, -5, 0, 2, 8, 12, 15, 19, 18, 17, 13, 15, 19,
22, 23, 23, 24, 20, 15, 11, 12, 9, 3, 2, 3, 8, 12, 13, 5, 3, 5, 3, 0, 0, -1, -4,
5, 8, 1, -7, -10, -23, -27, -18, -13, -19, -17, -7, -7, -9, -10, -13, -17, -9,
-3, -7, -10, -2, 4, 0, -2, -1, 0, -2, -4, -1, 6, 14, 16, 15, 15, 17, 22, 26, 21,
17, 22, 25, 22, 20, 26, 24, 24, 23, 21, 16, 16, 19, 19, 22, 25, 26, 19, 19, 21,
25, 22, 16, -1, -21, -32, -33, -29, -30, -27, -25, -21, -21, -24, -33, -38, -31,
-25, -21, -24, -16, -12, -13, -15, -17, -18, -24, -25, -28, -28, -21, -14, -11,
-17, -16, -17, -17, -16, -14, -6, -2, 5, 5, 9, 12, 18, 20, 15, 14, 13, 18, 18,
22, 25, 25, 22, 16, 11, 6, 9, 8, 1, -1, 10, 13, 6, 0, 4, 4, 4, 6, -3, -9, -8,
-4, -25, -35, -18, -2, -5, -14, -10, -12, -8, -8, -13, -19, -9, 9, 2, -8, -8, 3,
2, -9, -13, -10, -3, 2, 7, 12, 15, 21, 23, 20, 17, 24, 31, 21, 19, 25, 32, 23,
22, 25, 21, 22, 19, 16, 6, 18, 25, 20, 15, 17, 15, 7, 11, 14, 13, 10, 2, -18,
-31, -27, -18, -22, -21, -20, -18, -21, -24, -27, -34, -29, -24, -22, -28, -26,
-19, -19, -21, -21, -19, -26, -30, -27, -24, -16, -9, -4, -11, -14, -9, -7, -5,
-6, 1, 3, 9, 14, 15, 15, 14, 15, 11, 6, 3, 6, 14, 17, 19, 18, 14, 11, 7, 2, -7,
-4, 3, 3, 0, 5, 8, 0, -2, -1, -4, -7, -6, -13, -30, -28, -16, -12, -15, -8, 0,
-1, -2, -2, -7, -10, -6, -1, -2, -2, 0, 0, 0, 3, 6, 5, 3, 5, 12, 18, 22, 26, 27,
29, 30, 27, 21, 18, 20, 22, 24, 29, 30, 30, 31, 31, 23, 16, 22, 27, 30, 29, 37,
38, 37, 25, -4, -37, -50, -36, -33, -32, -32, -22, -23, -25, -33, -47, -52, -40,
-25, -27, -23, -14, -7, -14, -21, -28, -36, -39, -38, -33, -28, -19, -17, -20,
-23, -24, -22, -22, -20, -16, -5, 7, 13, 17, 17, 20, 18, 15, 11, 13, 18, 23, 31,
34, 34, 28, 25, 17, 12, 12, 14, 13, 14, 16, 13, 10, 8, 6, 1, 0, -2, -9, -18,
-21, -20, -14, -5, -4, -11, -19, -20, -19, -17, -18, -17, -11, -5, -7, -12, -13,
-12, -12, -12, -12, -11, -6, -2, 1, 5, 13, 14, 14, 13, 15, 22, 28, 28, 21, 28,
39, 38, 28, 25, 27, 22, 22, 26, 29, 29, 30, 33, 30, 27, 27, 29, 31, 32, 34, 19,
-15, -43, -41, -27, -30, -31, -25, -21, -25, -26, -34, -46, -38, -24, -25, -34,
-25, -18, -21, -25, -27, -32, -35, -36, -40, -39, -27, -17, -19, -24, -24, -18,
-16, -19, -21, -13, -3, 4, 12, 18, 21, 27, 31, 25, 19, 21, 23, 23, 26, 30, 27,
25, 23, 17, 12, 10, 8, 9, 13, 14, 11, 6, 1, -1, -1, -7, -14, -16, -17, -19, -12,
-3, -7, -15, -17, -20, -24, -18, -15, -17, -12, -4, -7, -13, -13, -14, -15, -7,
-2, -3, 1, 8, 9, 10, 18, 24, 23, 20, 22, 27, 28, 28, 32, 37, 34, 32, 35, 35, 30,
31, 37, 42, 39, 35, 34, 35, 37, 39, 32, -5, -43, -46, -29, -29, -30, -17, -13,
-22, -24, -27, -44, -44, -27, -24, -35, -27, -11, -8, -14, -22, -32, -42, -44,
-45, -43, -37, -28, -27, -29, -27, -20, -21, -31, -33, -26, -14, -2, 11, 14, 15,
22, 23, 15, 14, 23, 25, 25, 30, 34, 35, 33, 27, 17, 11, 9, 6, 8, 11, 13, 16, 14,
7, 3, 4, -2, -10, -11, -16, -22, -15, -2, 1, -4, -6, -14, -22, -22, -18, -18,
-13, -4, -1, -5, -7, -9, -9, -7, -7, -5, 1, 6, 4, 7, 13, 18, 18, 19, 22, 24, 24,
26, 25, 26, 29, 30, 32, 33, 33, 31, 35, 42, 41, 35, 37, 41, 44, 48, 36, -19,
-64, -60, -38, -37, -35, -19, -24, -26, -21, -29, -54, -44, -19, -26, -35, -18,
-2, -5, -8, -17, -37, -42, -35, -41, -49, -39, -26, -29, -27, -18, -16, -24,
-32, -30, -23, -6, 11, 19, 19, 24, 35, 33, 24, 20, 24, 25, 26, 34, 36, 37, 33,
22, 9, 4, 6, 5, 11, 13, 12, 11, 9, 8, 7, 8, -3, -15, -22, -22, -17, -4, 4, -2,
-8, -16, -24, -27, -22, -22, -19, -15, -13, -12, -7, -5, -8, -9, -14, -15, -9,
-1, 1, 8, 17, 18, 18, 19, 19, 19, 24, 22, 19, 28, 38, 37, 30, 33, 36, 34, 39,
42, 45, 38, 38, 45, 50, 56, 51, 21, -43, -71, -52, -35, -42, -31, -11, -20, -25,
-23, -42, -61, -35, -15, -34, -40, -10, 4, -3, -9, -21, -39, -39, -35, -48, -50,
-42, -32, -29, -23, -21, -18, -17, -34, -38, -23, -1, 7, 18, 31, 29, 34, 35, 27,
19, 25, 33, 25, 26, 30, 36, 35, 24, 11, 3, 5, 4, 5, 8, 7, 9, 13, 14, 15, 14, 5,
-16, -31, -30, -18, -3, 0, -3, -6, -8, -16, -26, -25, -21, -15, -10, -11, -13,
-11, -9, -15, -21, -15, -11, -6, -1, 2, 9, 18, 26, 22, 23, 29, 21, 15, 19, 29,
33, 34, 37, 37, 41, 37, 27, 31, 37, 39, 41, 48, 55, 55, 57, 4, -59, -68, -41,
-36, -42, -13, -16, -24, -18, -24, -60, -58, -17, -24, -46, -19, 11, 3, -4, -4,
-26, -44, -34, -43, -60, -50, -27, -26, -33, -24, -18, -21, -35, -43, -35, -14,
5, 20, 30, 33, 38, 34, 20, 10, 20, 29, 25, 26, 28, 30, 28, 26, 12, -3, -8, -15,
-14, -6, 4, 3, 2, 2, 1, 6, 9, 0, -10, -15, -20, -21, -14, -3, 0, 4, 0, -4, -10,
-16, -16, -15, -11, -10, -5, -1, -2, -1, 0, -1, 0, 0, 5, 9, 15, 21, 26, 33, 33,
37, 35, 25, 16, 20, 28, 30, 33, 39, 40, 39, 36, 30, 35, 39, 32, 25, 32, 39, 31,
17, -28, -70, -68, -44, -43, -52, -27, -22, -30, -31, -33, -49, -47, -19, -26,
-41, -20, 9, 7, -5, -7, -18, -34, -34, -43, -50, -42, -25, -20, -26, -20, -19,
-20, -23, -24, -18, -7, 12, 22, 30, 39, 45, 45, 37, 29, 21, 23, 31, 34, 32, 32,
26, 15, 4, -3, -10, -12, -4, -1, 2, 2, 2, 2, 3, 4, -1, -2, -12, -26, -34, -32,
-24, -16, -6, -2, -6, -8, -14, -22, -29, -27, -21, -13, -7, -8, -10, -5, 4, 5,
-1, -3, 8, 12, 16, 23, 29, 28, 29, 40, 37, 27, 23, 30, 31, 31, 38, 46, 53, 49,
44, 43, 43, 32, 29, 37, 34, 27, 26, 3, -53, -71, -47, -41, -55, -39, -22, -35,
-32, -15, -31, -53, -28, -14, -40, -44, -3, 7, -9, -9, -8, -27, -35, -26, -42,
-51, -34, -19, -28, -29, -16, -21, -28, -28, -29, -25, 1, 22, 21, 23, 35, 38,
30, 26, 25, 26, 27, 29, 31, 33, 28, 20, 15, 2, -10, -9, -4, -8, -7, 8, 12, 11,
15, 15, 5, 1, 8, 0, -10, -13, -17, -24, -22, -11, -8, -10, -14, -20, -21, -21,
-22, -21, -12, -7, -9, -4, 3, 2, -2, -1, 0, -1, 6, 16, 18, 15, 17, 27, 30, 27,
21, 23, 26, 25, 30, 41, 43, 36, 38, 43, 40, 39, 46, 37, 22, 24, 33, 29, 19, 3,
-43, -75, -61, -34, -40, -40, -18, -18, -34, -35, -29, -43, -40, -18, -15, -28,
-12, 9, -1, -18, -17, -20, -40, -42, -34, -31, -25, -9, -8, -22, -18, -14, -29,
-41, -25, -6, 2, 17, 34, 35, 37, 42, 36, 23, 21, 23, 18, 25, 36, 37, 32, 26, 13,
-4, -5, -9, -19, -17, 0, 6, 4, 9, 10, 3, -1, -3, -7, -6, -3, -12, -26, -28, -27,
-28, -26, -21, -19, -16, -13, -16, -17, -10, -8, -9, -2, 4, -1, -7, -2, 1, -2,
4, 13, 16, 13, 15, 21, 22, 23, 25, 33, 36, 32, 30, 36, 38, 32, 35, 39, 37, 34,
44, 49, 43, 32, 30, 29, 23, 15, 11, 3, -36, -74, -70, -39, -35, -38, -23, -20,
-44, -51, -38, -40, -42, -22, -16, -35, -28, -2, -3, -21, -18, -14, -29, -31,
-21, -22, -26, -11, -2, -15, -20, -12, -17, -31, -25, -6, 3, 9, 28, 37, 32, 27,
32, 28, 17, 24, 36, 36, 29, 34, 36, 26, 15, 8, 0, -6, -3, 0, 0, 1, 4, 1, -2, -5,
-7, -10, -14, -16, -15, -10, -19, -25, -24, -21, -26, -25, -11, -9, -12, -11,
-6, -10, -12, -6, -4, -5, -2, 2, 1, 1, 4, 5, 4, 6, 10, 11, 15, 18, 21, 20, 24,
33, 36, 32, 26, 32, 35, 38, 41, 45, 45, 41, 46, 50, 47, 34, 27, 24, 15, 5, 5, 6,
-25, -66, -71, -42, -34, -43, -31, -18, -35, -53, -37, -33, -43, -38, -18, -23,
-32, -7, 9, -9, -27, -17, -17, -33, -33, -23, -22, -25, -17, -14, -19, -18, -12,
-16, -20, -12, 0, 10, 15, 22, 24, 29, 30, 25, 22, 25, 29, 26, 26, 26, 27, 27,
19, 10, 5, 9, 6, 1, 3, 5, 0, -4, 0, -5, -15, -15, -9, -9, -10, -6, -11, -23,
-28, -22, -22, -21, -10, 0, -3, -10, -6, -3, -4, -8, -5, 0, 0, 1, 1, 2, -2, -7,
-6, -2, 2, 1, 5, 10, 15, 19, 25, 33, 34, 31, 27, 28, 34, 43, 46, 46, 41, 37, 37,
44, 50, 41, 27, 18, 11, 4, 6, 5, -32, -67, -64, -35, -34, -43, -28, -18, -36,
-56, -45, -37, -37, -34, -21, -19, -13, 1, 5, -9, -21, -16, -19, -25, -29, -20,
-13, -9, -11, -14, -14, -20, -27, -31, -22, -12, -4, 0, 6, 11, 16, 19, 16, 16,
21, 26, 24, 27, 34, 39, 34, 28, 23, 17, 15, 14, 11, 5, 2, 2, 1, -1, -5, -12,
-15, -14, -12, -9, -5, -8, -20, -27, -24, -19, -15, -10, -3, -2, -3, -4, -5, -5,
-2, -2, -4, -1, 6, 6, 1, -2, -2, -5, -5, 0, 1, 3, 8, 15, 15, 18, 26, 27, 23, 22,
26, 27, 33, 41, 43, 41, 39, 39, 38, 43, 43, 39, 30, 25, 21, 22, 15, -28, -71,
-72, -30, -25, -42, -39, -20, -36, -70, -68, -47, -30, -36, -34, -32, -13, 2, 4,
-10, -19, -14, -14, -15, -21, -13, -6, 2, -7, -14, -12, -12, -24, -38, -33, -22,
-9, -3, 2, 4, 7, 8, 3, 4, 14, 27, 28, 29, 37, 46, 47, 42, 36, 29, 25, 22, 19,
18, 19, 16, 9, 5, 3, -3, -15, -23, -23, -20, -18, -21, -27, -34, -37, -36, -30,
-22, -14, -9, -9, -13, -14, -6, 1, 0, -6, -2, 7, 9, 2, -1, -1, -1, -2, -3, -1,
3, 9, 11, 15, 23, 30, 27, 23, 26, 30, 32, 36, 43, 47, 52, 52, 49, 46, 52, 52,
43, 32, 28, 27, 25, 18, -15, -53, -61, -32, -27, -38, -39, -27, -44, -70, -67,
-45, -34, -43, -46, -43, -24, -12, -11, -22, -22, -18, -22, -21, -17, -8, -10,
-5, -5, -5, -7, -11, -22, -31, -20, -9, -3, -6, 0, 4, 4, 2, 0, 4, 10, 19, 19,
24, 34, 43, 42, 38, 37, 32, 27, 24, 27, 25, 23, 21, 16, 11, 5, 2, -5, -10, -13,
-16, -19, -20, -20, -31, -42, -47, -40, -33, -27, -19, -14, -14, -20, -21, -16,
-8, -5, -4, 0, 6, 10, 9, 5, -1, -6, -6, -2, 3, 7, 16, 19, 16, 14, 19, 23, 20,
20, 26, 34, 39, 43, 47, 48, 45, 41, 44, 51, 52, 46, 41, 42, 40, 33, 12, -24,
-52, -43, -21, -22, -32, -27, -27, -56, -75, -63, -44, -48, -58, -56, -43, -25,
-14, -16, -28, -28, -27, -27, -23, -11, 0, 3, 5, 3, 1, -1, -6, -19, -23, -12,
-1, 3, 6, 9, 6, -1, -7, -8, -4, 6, 13, 19, 27, 35, 37, 34, 31, 26, 24, 25, 27,
27, 31, 35, 29, 16, 9, 8, 1, -8, -12, -10, -9, -11, -14, -20, -30, -46, -57,
-55, -43, -31, -22, -16, -16, -18, -21, -20, -17, -14, -7, 0, 7, 9, 9, 7, 6, 2,
-2, -2, 2, 7, 10, 14, 18, 23, 29, 31, 29, 25, 24, 27, 36, 43, 47, 48, 50, 48,
44, 44, 43, 42, 43, 46, 45, 44, 35, -1, -48, -60, -30, -13, -22, -28, -28, -48,
-78, -80, -62, -50, -51, -52, -50, -39, -25, -21, -31, -34, -29, -27, -23, -15,
-5, 1, 7, 7, 0, -6, -4, -6, -13, -13, -4, 6, 10, 9, 3, -3, -7, -8, -5, 6, 16,
18, 21, 27, 31, 29, 27, 25, 24, 27, 30, 29, 29, 33, 32, 23, 12, 9, 4, -3, -8,
-7, -2, -4, -13, -22, -24, -28, -38, -47, -46, -41, -35, -26, -18, -16, -22,
-26, -25, -20, -14, -6, 2, 7, 11, 11, 9, 5, 0, -3, 2, 9, 13, 16, 17, 18, 16, 17,
23, 27, 27, 26, 29, 33, 40, 45, 49, 50, 49, 46, 43, 44, 44, 45, 41, 39, 36, 35,
24, -2, -36, -51, -41, -26, -23, -30, -34, -47, -66, -78, -68, -55, -52, -56,
-55, -42, -28, -22, -29, -35, -35, -29, -23, -14, -5, 2, 5, 5, 1, -2, 1, 1, -4,
-7, 1, 10, 12, 9, 7, 5, 2, -1, -3, 1, 12, 21, 21, 18, 21, 26, 27, 25, 24, 25,
27, 29, 29, 31, 30, 24, 15, 8, 5, 5, 4, 1, -1, -5, -10, -18, -23, -24, -31, -45,
-51, -41, -26, -20, -21, -23, -26, -31, -33, -26, -11, -2, -3, -6, -1, 7, 8, 3,
1, 3, 6, 10, 12, 15, 19, 20, 16, 15, 20, 26, 29, 30, 34, 37, 36, 33, 33, 36, 40,
42, 42, 40, 39, 40, 38, 34, 30, 24, 20, 18, 16, 2, -23, -46, -50, -42, -34, -33,
-35, -43, -58, -70, -71, -62, -55, -51, -47, -41, -36, -31, -29, -29, -28, -28,
-22, -14, -4, 2, 8, 8, 4, 2, 3, 7, 4, 2, 4, 9, 10, 10, 9, 7, 4, 1, 1, 3, 10, 15,
17, 16, 16, 17, 19, 20, 19, 18, 21, 28, 30, 29, 25, 23, 18, 11, 7, 5, 4, 0, -3,
-7, -8, -11, -16, -23, -28, -33, -41, -45, -43, -34, -24, -18, -20, -21, -19,
-17, -17, -15, -9, -4, 0, 1, 4, 6, 8, 8, 8, 10, 13, 18, 20, 20, 19, 24, 26, 28,
31, 31, 29, 32, 39, 39, 37, 33, 33, 34, 38, 43, 43, 41, 36, 34, 30, 33, 37, 36,
25, 12, 4, -11, -31, -45, -42, -37, -33, -34, -39, -50, -61, -67, -70, -64, -56,
-48, -47, -45, -39, -30, -27, -30, -30, -26, -17, -9, -1, 4, 10, 10, 7, 4, 6, 6,
3, 1, 3, 8, 11, 9, 3, -1, -5, -7, -9, -3, 5, 11, 11, 10, 14, 15, 14, 10, 13, 16,
21, 23, 25, 23, 17, 13, 11, 11, 10, 14, 13, 9, 2, -1, -3, -8, -10, -13, -14,
-20, -29, -38, -41, -38, -32, -26, -19, -17, -17, -16, -16, -14, -8, 0, 3, 5, 6,
6, 4, 3, 0, 1, 9, 17, 18, 16, 19, 21, 22, 21, 26, 32, 33, 31, 32, 33, 29, 25,
25, 30, 40, 48, 50, 42, 34, 30, 28, 31, 36, 45, 41, 25, 8, 1, -6, -24, -42, -52,
-48, -42, -35, -40, -45, -54, -65, -77, -80, -67, -53, -43, -42, -38, -36, -30,
-28, -26, -24, -19, -9, 1, 8, 10, 16, 17, 13, 5, 4, 6, 9, 6, 6, 11, 13, 8, 1,
-2, -3, -2, 1, 8, 13, 16, 17, 16, 15, 12, 13, 16, 21, 21, 21, 23, 24, 22, 18,
16, 10, 7, 4, 4, 2, -4, -8, -11, -14, -18, -20, -22, -23, -26, -33, -39, -39,
-29, -21, -17, -16, -16, -14, -18, -18, -16, -4, 3, 4, 3, 5, 9, 7, 4, 0, 6, 9,
14, 15, 17, 20, 21, 23, 23, 25, 30, 36, 37, 33, 30, 33, 36, 36, 35, 40, 46, 46,
40, 33, 30, 30, 36, 36, 34, 25, 17, 2, -8, -13, -17, -31, -54, -58, -50, -37,
-45, -51, -56, -61, -71, -72, -59, -51, -44, -41, -35, -35, -28, -20, -16, -19,
-19, -11, -1, 10, 11, 12, 8, 7, 4, 6, 11, 12, 9, 4, 10, 13, 14, 9, 5, -1, -6,
-4, 3, 12, 16, 16, 11, 8, 7, 13, 17, 18, 15, 12, 13, 13, 16, 16, 12, 5, -2, -5,
-7, -1, 2, -1, -7, -9, -10, -12, -16, -17, -16, -16, -20, -32, -38, -37, -27,
-14, -2, 2, -4, -8, -14, -15, -12, -1, 7, 9, 7, 5, 8, 9, 7, 3, 5, 11, 18, 19,
18, 17, 21, 25, 24, 25, 29, 30, 29, 28, 32, 34, 31, 33, 29, 32, 28, 30, 28, 26,
28, 26, 32, 25, 25, 19, 14, 1, -9, -3, -4, -19, -58, -69, -57, -31, -34, -41,
-37, -41, -57, -79, -66, -52, -36, -37, -32, -25, -19, -10, -16, -17, -20, -10,
-1, 7, 13, 17, 21, 19, 14, 10, 13, 14, 14, 10, 12, 14, 13, 8, 1, 0, -4, -3, -2,
4, 5, 2, 1, 4, 6, 5, 5, 9, 10, 8, 10, 13, 16, 15, 16, 12, 5, -1, -3, -2, -3, -2,
-2, -5, -10, -13, -16, -16, -19, -19, -21, -20, -21, -27, -25, -25, -18, -11,
-2, -3, -14, -16, -17, -14, -10, 0, 9, 12, 10, 7, 9, 13, 12, 8, 5, 6, 10, 14,
18, 20, 23, 20, 16, 16, 19, 21, 25, 28, 29, 26, 24, 28, 29, 32, 29, 28, 26, 20,
18, 16, 28, 36, 37, 27, 12, 11, -1, -5, -11, 0, 3, -14, -41, -66, -61, -48, -32,
-38, -39, -41, -43, -56, -63, -54, -46, -34, -32, -22, -18, -8, -3, -1, -2, -2,
5, 8, 9, 8, 15, 24, 25, 18, 11, 4, -1, -8, -9, -4, 1, 8, 3, -1, -8, -8, -10,
-10, -3, 0, 3, 3, 5, 6, 8, 11, 12, 10, 8, 8, 13, 17, 18, 20, 19, 17, 9, 4, 4, 4,
6, 2, -3, -5, -5, -8, -11, -14, -15, -19, -23, -30, -35, -34, -32, -22, -14, -1,
-4, -6, -12, -14, -9, -7, 4, 7, 13, 11, 11, 11, 13, 13, 16, 17, 14, 13, 14, 18,
14, 15, 15, 19, 17, 13, 14, 17, 20, 18, 19, 17, 14, 9, 13, 21, 30, 29, 26, 21,
17, 16, 18, 30, 33, 32, 24, 21, 21, 16, 13, 7, 9, -2, -33, -67, -71, -46, -31,
-39, -43, -37, -38, -58, -73, -65, -52, -43, -43, -34, -17, -1, 4, -3, -8, -10,
-5, 2, 11, 16, 20, 24, 24, 16, 5, 3, 2, -3, -11, -7, 2, 10, 6, -4, -7, -11, -14,
-22, -20, -11, -2, 4, 1, 5, 10, 15, 11, 4, 5, 12, 18, 18, 19, 22, 24, 17, 7, 0,
0, 1, -2, -1, 0, 0, -6, -10, -13, -18, -23, -25, -20, -15, -14, -16, -17, -21,
-24, -21, -10, -4, -7, -11, -9, -2, 5, 11, 15, 16, 16, 12, 10, 13, 16, 17, 11,
8, 7, 12, 17, 14, 13, 10, 10, 8, 8, 12, 11, 14, 12, 16, 20, 18, 18, 17, 20, 20,
23, 27, 32, 33, 29, 22, 25, 29, 30, 26, 16, 19, 22, 32, 28, 21, 17, 13, 8, -38,
-74, -83, -48, -26, -36, -37, -34, -24, -52, -73, -76, -57, -40, -43, -40, -25,
0, 7, 4, -2, -7, -13, -9, -3, 3, 6, 15, 24, 17, 7, -1, -2, -12, -21, -24, -15,
2, 6, 1, -9, -11, -13, -19, -26, -22, -7, 3, 6, 7, 13, 18, 18, 10, 8, 13, 19,
20, 17, 16, 18, 22, 18, 11, 2, 0, 0, -3, -8, -11, -5, -3, -2, -5, -10, -9, -13,
-16, -20, -15, -8, -12, -14, -14, -1, 4, 1, -2, -7, -1, 0, 2, 4, 10, 21, 20, 16,
6, 3, 5, 5, 6, 0, 4, 10, 11, 8, 0, 1, 1, 5, 4, 3, 6, 13, 17, 17, 15, 20, 21, 14,
9, 10, 23, 28, 32, 27, 25, 28, 31, 28, 23, 21, 24, 18, 11, 14, 16, 27, 22, 27,
18, 21, -7, -58, -72, -64, -22, -29, -25, -33, -22, -31, -64, -73, -71, -43,
-46, -41, -38, -10, 4, 2, -8, -13, -15, -20, -12, -12, 4, 9, 22, 16, 8, 7, 1,
-3, -23, -31, -30, -11, 5, 7, 8, 8, 2, -10, -23, -25, -18, -5, 4, 8, 19, 22, 22,
9, -3, -3, 4, 12, 13, 17, 23, 24, 23, 19, 14, 9, 1, -2, -5, 2, 11, 17, 20, 14,
7, -2, -7, -14, -19, -13, -7, -3, -4, -11, -14, -13, -7, -7, -13, -12, -11, -3,
0, 3, 8, 10, 10, -2, -3, 1, 8, 12, 8, 10, 7, 5, 1, 1, 6, 4, 5, 5, 9, 14, 15, 15,
10, 6, 2, 1, 6, 11, 16, 16, 15, 16, 12, 10, 6, 9, 16, 20, 22, 19, 22, 25, 27,
29, 22, 22, 14, 13, 10, 8, 14, 17, 26, -11, -45, -70, -51, -31, -28, -27, -28,
-11, -28, -43, -63, -52, -39, -39, -42, -35, -14, -7, -3, -11, -16, -22, -16,
-14, -13, -12, -9, -3, -3, -4, -6, 0, -4, -13, -19, -14, -1, 10, 12, 10, 10, 12,
7, -1, -2, 2, 14, 18, 19, 19, 24, 27, 17, 11, 9, 13, 13, 10, 13, 19, 23, 20, 12,
9, 6, 4, 0, -5, -4, -1, 6, 2, -6, -15, -19, -21, -28, -28, -26, -19, -18, -17,
-14, -10, -9, -12, -9, -5, -1, -3, 0, 5, 9, 10, 7, 5, -1, 1, 6, 12, 12, 6, 5, 6,
12, 13, 12, 12, 12, 14, 14, 14, 15, 17, 19, 18, 18, 18, 17, 15, 10, 12, 16, 20,
19, 21, 25, 24, 20, 15, 18, 22, 26, 15, 11, 14, 19, 18, 8, 12, 11, 15, -13, -46,
-60, -47, -21, -30, -32, -34, -16, -23, -47, -63, -59, -39, -40, -43, -37, -18,
-7, -13, -26, -28, -23, -18, -24, -18, -6, 3, 4, -3, 0, 2, 5, -5, -13, -11, -1,
7, 10, 11, 14, 14, 9, 2, -1, 3, 6, 11, 12, 18, 20, 21, 15, 11, 9, 9, 10, 7, 9,
13, 19, 15, 13, 13, 12, 5, -5, -8, -5, 2, 3, -1, -3, -7, -12, -21, -28, -32,
-32, -25, -19, -9, -5, -4, -9, -13, -15, -14, -11, -8, 0, 7, 16, 3, };
 
 #endif /* BURROUGHS1_18649_H_ */
