#include <MozziGuts.h>
#include <Oscil.h>
#include <tables/cos2048_int8.h>
#include <Smooth.h>
#include <AutoMap.h>

Oscil<COS2048_NUM_CELLS, AUDIO_RATE> aCarrier(COS2048_DATA);
Oscil<COS2048_NUM_CELLS, AUDIO_RATE> aModulator(COS2048_DATA);
Oscil<COS2048_NUM_CELLS, CONTROL_RATE> kIntensityMod(COS2048_DATA);
long fm_intensity; // carries control
byte gain_d; // A5 master volume
float mod_speed, smoothness = 0.95f;
Smooth <long> aSmoothIntensity(smoothness);
int loop_counter = 0;
int carrier_freq, i_calibrated, knobValue, FRQ, mod_freq, input_data[6];
AutoMap map_A0_carrierFreq(0,1023,22,440);
AutoMap map_A1_intensity(0,1023,10,770);
AutoMap map_A2_freq(0,1023,1,50);
AutoMap map_A3_freq(0,1023,1,20);
AutoMap map_A4_modSpeed(0,1023,1,10000);
AutoMap map_A5_volume(0,1023,0,255);

void setup(){
  Serial.begin(115200);
  startMozzi();
}

void updateControl(){
  for(int i=0;i<6; i++){ input_data[i] = mozziAnalogRead(i); }
  carrier_freq = map_A0_carrierFreq(input_data[0]);
  i_calibrated = map_A1_intensity(input_data[1]);
  FRQ = map_A2_freq(input_data[2]);
  knobValue = map_A3_freq(input_data[3]);
  mod_speed = (float)map_A4_modSpeed(input_data[4])/1000;
  gain_d = map_A5_volume(input_data[5]);
  kIntensityMod.setFreq(mod_speed);
  mod_freq = carrier_freq * FRQ; 
  aCarrier.setFreq(carrier_freq);
  aModulator.setFreq(mod_freq);
  fm_intensity = ((long)i_calibrated * knobValue * (kIntensityMod.next()+128))>>8;
  if(++loop_counter >9){
    loop_counter = 0;
    for(int i=0;i<5; i++){
      Serial.print("\tA"); Serial.print(i); Serial.print(" = "); Serial.print(input_data[i]);
    }
    Serial.println();
  }
}

int updateAudio(){
  long modulation = aSmoothIntensity.next(fm_intensity) * aModulator.next();
  return MonoOutput::from16Bit(aCarrier.phMod(modulation) * gain_d);
}

void loop(){
  audioHook();
}
