/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import oscP5.OscError;
import oscP5.OscPlug;

public class OscP5 {
    static /* synthetic */ Class class$OscIn;
    private String host = null;
    public boolean isMethod = false;
    private Method method;
    private OscReceiver orObj;
    private OscSender osObj;
    private int oscP5version = 12;
    private OscPlug oscPlug;
    Object parent = null;
    private Class parentClass;
    private int receiveAtPort;
    private int sendToPort;

    public OscP5(Object theParent, String theHost, int theSendToPort, int theReceiveAtPort) {
        this.parent = theParent;
        this.initialize(theHost, theSendToPort, theReceiveAtPort);
    }

    public OscP5(Object theParent, String theHost, int theSendToPort, int theReceiveAtPort, String theMethodName) {
        this.parent = theParent;
        this.parentClass = this.parent.getClass();
        String tMethodName = theMethodName;
        if (tMethodName != null) {
            try {
                Class[] tClass = new Class[]{class$OscIn == null ? (class$OscIn = OscP5.class$("OscIn")) : class$OscIn};
                this.method = this.parentClass.getDeclaredMethod(tMethodName, tClass);
                this.isMethod = true;
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                OscError.methodException(tMethodName);
            }
        }
        this.initialize(theHost, theSendToPort, theReceiveAtPort);
    }

    public void call(OscIn oscIn) {
        try {
            Object[] t = new Object[]{oscIn};
            this.method.invoke(this.parent, t);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    boolean checkNet() {
        return this.orObj.checkNet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    OscIn getMsg(int theInt) {
        return this.orObj.getMsg(theInt);
    }

    int getPort() {
        return this.orObj.getPort();
    }

    String getVersion() {
        String t = "------------------------\n";
        t = t + "OscP5 v." + this.oscP5version + "\n";
        t = t + "by andreas schlegel\n";
        t = t + "andi@sojamo.de\n";
        t = t + "------------------------\n";
        return t;
    }

    private void initialize(String theHost, int theSendToPort, int theReceiveAtPort) {
        this.host = theHost;
        this.sendToPort = theSendToPort;
        this.receiveAtPort = theReceiveAtPort;
        this.oscPlug = new OscPlug();
        if (this.sendToPort > 0 && this.receiveAtPort > 0 && this.parent != null) {
            System.out.println("OscP5 started ...");
            this.orObj = new OscReceiver(this, this.receiveAtPort);
            this.osObj = new OscSender(this, this.host, this.sendToPort);
        } else {
            System.out.println("ERROR > OscP5 failed to initialize.");
        }
    }

    int msgSize() {
        return this.orObj.msgSize();
    }

    OscBundle newBundle() {
        return this.osObj.newBundle();
    }

    OscMessage newMsg(String s) {
        return this.osObj.newMsg(s);
    }

    public void receiverStopped() {
        this.orObj = null;
        this.orObj = new OscReceiver(this, this.receiveAtPort);
        System.out.println("restarting OscReceiver ...");
    }

    public void sendBundle(OscBundle theBundle) {
        this.osObj.sendBundle(theBundle.getTimetag(), theBundle.getMessages());
    }

    public void sendMsg(String s, Object[] o, String addr, int port) {
        this.sendMsg(new OscMessage(s, o), addr, port);
    }

    public void sendMsg(String s, Object[] o) {
        this.sendMsg(new OscMessage(s, o));
    }

    public void sendMsg(MessageOUT msg, String addr, int port) {
        this.osObj.sendMsg(msg, addr, port);
    }

    public void sendMsg(MessageOUT msg) {
        this.osObj.sendMsg(msg);
    }

    void sendMsg(String msgName, ArrayList types, ArrayList args) {
        this.osObj.sendMsg(msgName, types, args);
    }

    void setHost(String theHost) {
        this.host = theHost;
        this.osObj.host = theHost;
    }

    void setSendToPort(int thePort) {
        this.sendToPort = thePort;
        this.osObj.port = thePort;
    }

    int version() {
        return this.oscP5version;
    }
}

