/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import osc.Bytes;
import osc.OscCoreMessage;
import osc.OscCorePacket;

public class OscReceiver
extends Thread {
    private int byteSize = 1024;
    private boolean firstNameFlag = true;
    public MessageINcontainer[] messageINcontainer;
    boolean netFlag = false;
    private OscP5 oscP5 = null;
    private DatagramSocket oscSocket;
    private int port;
    private Thread thrThis = null;

    public OscReceiver(BApplet theParent, int thePort) {
        this(thePort);
    }

    public OscReceiver(int thePort) {
        this.port = thePort;
        this.start();
    }

    public OscReceiver(OscP5 theOscP5, int thePort) {
        this(thePort);
        this.oscP5 = theOscP5;
    }

    boolean checkNet() {
        if (this.netFlag) {
            this.netFlag = false;
            return true;
        }
        return false;
    }

    public ArrayList[] getHeuristicallyTypeGuessedArgs(byte[] block) {
        System.out.println(" getHeuristicallyTypeGuessedArgs() Bad OSC packet: No type tags");
        return new ArrayList[2];
    }

    public MessageINcontainer getMsg(int theInt) {
        return this.messageINcontainer[theInt];
    }

    int getPort() {
        return this.port;
    }

    public ArrayList getStringAndData(byte[] block, int stringLength) {
        ArrayList<Object> arr = new ArrayList<Object>();
        if (stringLength % 4 != 0) {
            System.out.println(" getStringAndData() printNameAndArgs: bad boundary");
            return arr;
        }
        int i = 0;
        while (block[i] != 0) {
            if (i >= stringLength) {
                System.out.println(" getStringAndData() printNameAndArgs: Unreasonably long string");
                return arr;
            }
            ++i;
        }
        arr.add(new String(Bytes.copy(block, 0, i)));
        ++i;
        while (i % 4 != 0) {
            if (i >= stringLength) {
                System.out.println(" getStringAndData() printNameAndArgs: Unreasonably long string");
                return arr;
            }
            if (block[i] != 0) {
                System.out.println(" getStringAndData() printNameAndArgs: Incorrectly padded string.");
                return arr;
            }
            ++i;
        }
        arr.add(new Integer(i));
        arr.add(Bytes.copy(block, i));
        return arr;
    }

    public ArrayList[] getTypeTaggedArgs(byte[] block) {
        ArrayList<Character> typeArr = new ArrayList<Character>();
        ArrayList<Object> argArr = new ArrayList<Object>();
        int p = 0;
        ArrayList typesAndArgs = this.getStringAndData(block, block.length);
        if (typesAndArgs.size() > 1) {
            byte[] args = (byte[])typesAndArgs.get(typesAndArgs.size() - 1);
            int thisType = 1;
            while (block[thisType] != 0) {
                switch (block[thisType]) {
                    case 91: {
                        typeArr.add(new Character('['));
                        break;
                    }
                    case 93: {
                        typeArr.add(new Character(']'));
                        break;
                    }
                    case 98: {
                        typeArr.add(new Character('b'));
                        int tLen = new Integer(Bytes.toInt(Bytes.copy(args, p, 4)));
                        byte[] tByte = Bytes.copy(args, p += 4, tLen);
                        argArr.add(tByte);
                        p += tLen % 4 != 0 ? tLen + (4 - tLen % 4) : tLen;
                        break;
                    }
                    case 109: {
                        typeArr.add(new Character('m'));
                        argArr.add(Bytes.copy(args, p, 4));
                        p += 4;
                        break;
                    }
                    case 99: {
                        typeArr.add(new Character('c'));
                        argArr.add(new Character((char)Bytes.toInt(Bytes.copy(args, p, 4))));
                        p += 4;
                        break;
                    }
                    case 105: 
                    case 114: {
                        typeArr.add(new Character('i'));
                        argArr.add(new Integer(Bytes.toInt(Bytes.copy(args, p, 4))));
                        p += 4;
                        break;
                    }
                    case 102: {
                        typeArr.add(new Character('f'));
                        argArr.add(new Float(Bytes.toFloat(Bytes.copy(args, p, 4))));
                        p += 4;
                        break;
                    }
                    case 104: 
                    case 116: {
                        typeArr.add(new Character('h'));
                        argArr.add(new Long(Bytes.toLong(Bytes.copy(args, p, 8))));
                        p += 8;
                        break;
                    }
                    case 100: {
                        typeArr.add(new Character('d'));
                        argArr.add(new Double(Bytes.toDouble(Bytes.copy(args, p, 8))));
                        p += 8;
                        break;
                    }
                    case 83: 
                    case 115: {
                        typeArr.add(new Character('s'));
                        byte[] remaining = Bytes.copy(args, p);
                        ArrayList arr = this.getStringAndData(remaining, remaining.length);
                        if (arr.size() <= 1) break;
                        argArr.add((String)arr.get(0));
                        p += ((Integer)arr.get(1)).intValue();
                        break;
                    }
                    case 84: {
                        typeArr.add(new Character('T'));
                        argArr.add(new Boolean(true));
                        break;
                    }
                    case 70: {
                        typeArr.add(new Character('F'));
                        argArr.add(new Boolean(false));
                        break;
                    }
                    case 78: {
                        typeArr.add(new Character('N'));
                        argArr.add(null);
                        break;
                    }
                    case 73: {
                        typeArr.add(new Character('I'));
                        break;
                    }
                    default: {
                        System.out.println(" getTypeTaggedArgs() [Unrecognized type tag " + block[thisType] + "]");
                    }
                }
                ++thisType;
            }
        }
        ArrayList[] returnValue = new ArrayList[]{typeArr, argArr};
        return returnValue;
    }

    public ArrayList[] getTypesAndArgs(byte[] block) {
        int n = block.length;
        ArrayList[] arr = new ArrayList[2];
        if (n != 0) {
            arr = block[0] == 44 ? (block[1] != 44 ? this.getTypeTaggedArgs(block) : this.getHeuristicallyTypeGuessedArgs(block)) : this.getHeuristicallyTypeGuessedArgs(block);
        }
        return arr;
    }

    public void killServer() {
        this.oscSocket.close();
        this.thrThis = null;
        System.out.println("ERROR > OscReceiver ... stopped");
        if (this.oscP5 != null) {
            this.oscP5.receiverStopped();
        }
    }

    int msgSize() {
        return this.messageINcontainer.length;
    }

    public boolean parseOscPacket(byte[] datagram, int n, OscCorePacket packet) {
        boolean returnFlag = true;
        if (n % 4 != 0) {
            System.out.println(" parseOscPacket() SynthControl packet size (" + n + ") not a multiple of 4 bytes, dropped it.");
            returnFlag = false;
            return false;
        }
        String dataString = new String(datagram);
        if (n >= 8 && dataString.startsWith("#bundle")) {
            if (n < 16) {
                System.out.println(" parseOscPacket() Bundle message too small (" + n + " bytes) for time tag, dropped it.");
                returnFlag = false;
                return false;
            }
            Long time = new Long(Bytes.toLong(Bytes.copy(datagram, 8, 8)));
            packet.setTime(time);
            int i = 16;
            while (i < n) {
                int size = Bytes.toInt(Bytes.copy(datagram, i, i + 4));
                if (size % 4 != 0) {
                    System.out.println(" parseOscPacket() Bad size count" + size + "in bundle (not a multiple of 4)");
                    returnFlag = false;
                    return false;
                }
                if (size + i + 4 > n) {
                    System.out.println(" parseOscPacket() Bad size count" + size + "in bundle" + "(only" + (n - i - 4) + "bytes left in entire bundle)");
                    returnFlag = false;
                    return false;
                }
                byte[] remaining = Bytes.copy(datagram, i + 4);
                returnFlag = this.parseOscPacket(remaining, size, packet);
                i += 4 + size;
            }
        } else {
            ArrayList nameAndData = this.getStringAndData(datagram, n);
            if (nameAndData.size() > 1) {
                String name = (String)nameAndData.get(0);
                if (this.firstNameFlag) {
                    packet.msgName = name;
                    this.firstNameFlag = false;
                }
                OscCoreMessage message = new OscCoreMessage(name);
                byte[] data = (byte[])nameAndData.get(nameAndData.size() - 1);
                ArrayList[] typesAndArgs = this.getTypesAndArgs(data);
                message.setTypesAndArgs(typesAndArgs[0], typesAndArgs[1]);
                packet.addMessage(message);
            } else {
                returnFlag = false;
            }
        }
        return returnFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (Thread.currentThread() == this.thrThis) {
            Object var9_3;
            try {
                try {
                    this.oscSocket = new DatagramSocket(this.port);
                    System.out.println("osc receiver started on port: " + this.port);
                    block5: while (true) {
                        ArrayList tArr;
                        int tmpSize;
                        byte[] datagram = new byte[this.byteSize];
                        DatagramPacket packet = new DatagramPacket(datagram, datagram.length);
                        this.oscSocket.receive(packet);
                        OscCorePacket oscp = new OscCorePacket();
                        oscp.address = packet.getAddress();
                        oscp.port = packet.getPort();
                        this.firstNameFlag = true;
                        if (!this.parseOscPacket(datagram, packet.getLength(), oscp) || (tmpSize = (tArr = oscp.extractPacket()).size()) <= 0) continue;
                        this.messageINcontainer = new MessageINcontainer[tmpSize];
                        int i = 0;
                        while (true) {
                            if (i >= tmpSize) {
                                continue block5;
                            }
                            ArrayList msgArr = (ArrayList)tArr.get(i);
                            this.messageINcontainer[i] = new MessageINcontainer();
                            this.messageINcontainer[i].addAddrPattern((String)msgArr.get(0));
                            this.messageINcontainer[i].setStructure((ArrayList)msgArr.get(1));
                            this.messageINcontainer[i].setData((ArrayList)msgArr.get(2));
                            this.messageINcontainer[i].setTypetag();
                            this.netFlag = true;
                            if (this.oscP5 != null && this.oscP5.isMethod) {
                                this.oscP5.call(this.messageINcontainer[i]);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    System.out.println("ERROR > OscReceiver ...Stopping OscP5 receiver");
                    var9_3 = null;
                    this.killServer();
                }
            }
            catch (Throwable throwable) {
                var9_3 = null;
                this.killServer();
                throw throwable;
            }
        }
    }

    public void start() {
        if (this.thrThis == null) {
            this.thrThis = new Thread(this);
            this.thrThis.start();
        }
    }
}

