/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import osc.OscCoreMessage;
import osc.OscCorePacket;

public class OscSender {
    public InetAddress addr;
    public String host;
    private OscP5 oscP5;
    public int port;
    private DatagramSocket socket = null;

    public OscSender(String theAddr, int thePort) {
        try {
            this.addr = InetAddress.getByName(theAddr);
        }
        catch (UnknownHostException e) {
            System.out.println("ERROR while initializing host " + e);
        }
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e) {
            System.out.println("ERROR while creating socket " + e);
        }
        this.port = thePort;
        System.out.println("osc sender initialized.");
    }

    public OscSender(BApplet theParent, String theAddr, int thePort) {
        this(theAddr, thePort);
    }

    public OscSender(OscP5 theOscP5, String theAddr, int thePort) {
        this(theAddr, thePort);
        this.oscP5 = theOscP5;
    }

    public OscBundle newBundle() {
        return new OscBundle();
    }

    public OscMessage newMsg(String s) {
        return new OscMessage(s);
    }

    public OscCorePacket preparePacket(String msgName, ArrayList types, ArrayList args, InetAddress addr, int port) {
        OscCorePacket packet = new OscCorePacket(addr, port, 0);
        OscCoreMessage message = new OscCoreMessage(msgName);
        message.setTypesAndArgs(types, args);
        packet.addMessage(message);
        return packet;
    }

    public void sendBundle(long theTimetag, Object[] messages) {
        if (messages.length > 0) {
            OscCorePacket packet = new OscCorePacket(theTimetag, this.addr, this.port, 1);
            int i = 0;
            while (i < messages.length) {
                packet.addMessage((OscCoreMessage)messages[i]);
                ++i;
            }
            this.sendPacket(packet);
        }
    }

    public void sendMsg(MessageOUT msg, String addr, int port) {
        try {
            InetAddress tmpAddr = InetAddress.getByName(addr);
            this.sendPacket(this.preparePacket(msg.getMsgName(), msg.getTypes(), msg.getArgs(), tmpAddr, port));
        }
        catch (UnknownHostException e) {
            System.out.println("ERROR while sending packet " + e);
        }
    }

    public void sendMsg(MessageOUT msg) {
        this.sendPacket(this.preparePacket(msg.getMsgName(), msg.getTypes(), msg.getArgs(), this.addr, this.port));
    }

    public void sendMsg(String msgName, ArrayList types, ArrayList args) {
        this.sendPacket(this.preparePacket(msgName, types, args, this.addr, this.port));
    }

    public void sendPacket(OscCorePacket oscPacket) {
        try {
            byte[] byteArray = oscPacket.getByteArray();
            DatagramPacket packet = new DatagramPacket(byteArray, byteArray.length, oscPacket.getAddress(), oscPacket.getPort());
            this.socket.send(packet);
        }
        catch (SocketException se) {
            System.out.println("ERROR > sendMsg() SocketException");
        }
        catch (IOException ioe) {
            System.out.println("ERROR > sendMsg() io exception");
        }
        catch (NullPointerException npe) {
            System.out.println("ERROR > sendMsg() NullPointerException");
        }
    }

    public void setPort(int thePort) {
        this.port = thePort;
    }
}

