/*
 * Decompiled with CFR 0.152.
 */
package osc;

public class Bytes {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] append(byte[] abyte0, byte[] abyte1, byte[] abyte2) {
        byte[] abyte3 = new byte[abyte0.length + abyte1.length + abyte2.length];
        System.arraycopy(abyte0, 0, abyte3, 0, abyte0.length);
        System.arraycopy(abyte1, 0, abyte3, abyte0.length, abyte1.length);
        System.arraycopy(abyte2, 0, abyte3, abyte0.length + abyte1.length, abyte2.length);
        return abyte3;
    }

    public static byte[] append(byte[] abyte0, byte[] abyte1) {
        byte[] abyte2 = new byte[abyte0.length + abyte1.length];
        System.arraycopy(abyte0, 0, abyte2, 0, abyte0.length);
        System.arraycopy(abyte1, 0, abyte2, abyte0.length, abyte1.length);
        return abyte2;
    }

    public static boolean areEqual(byte[] abyte0, byte[] abyte1) {
        int i = abyte0.length;
        if (i != abyte1.length) {
            return false;
        }
        int j = 0;
        while (j < i) {
            if (abyte0[j] != abyte1[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static byte[] copy(byte[] abyte0, int i, int j) {
        byte[] abyte1 = new byte[j];
        System.arraycopy(abyte0, i, abyte1, 0, j);
        return abyte1;
    }

    public static byte[] copy(byte[] abyte0, int i) {
        return Bytes.copy(abyte0, i, abyte0.length - i);
    }

    public static void merge(byte[] abyte0, byte[] abyte1, int i, int j) {
        System.arraycopy(abyte0, 0, abyte1, i, j);
    }

    public static void merge(byte[] abyte0, byte[] abyte1) {
        System.arraycopy(abyte0, 0, abyte1, 0, abyte0.length);
    }

    public static void merge(byte[] abyte0, byte[] abyte1, int i) {
        System.arraycopy(abyte0, 0, abyte1, i, abyte0.length);
    }

    public static void merge(byte[] abyte0, byte[] abyte1, int i, int j, int k) {
        System.arraycopy(abyte0, i, abyte1, j, k);
    }

    public static byte[] toBytes(long l, byte[] abyte0) {
        abyte0[7] = (byte)l;
        abyte0[6] = (byte)(l >>>= 8);
        abyte0[5] = (byte)(l >>>= 8);
        abyte0[4] = (byte)(l >>>= 8);
        abyte0[3] = (byte)(l >>>= 8);
        abyte0[2] = (byte)(l >>>= 8);
        abyte0[1] = (byte)(l >>>= 8);
        abyte0[0] = (byte)(l >>>= 8);
        return abyte0;
    }

    public static byte[] toBytes(long l) {
        return Bytes.toBytes(l, new byte[8]);
    }

    public static byte[] toBytes(int i, byte[] abyte0) {
        abyte0[3] = (byte)i;
        abyte0[2] = (byte)(i >>>= 8);
        abyte0[1] = (byte)(i >>>= 8);
        abyte0[0] = (byte)(i >>>= 8);
        return abyte0;
    }

    public static byte[] toBytes(int i) {
        return Bytes.toBytes(i, new byte[4]);
    }

    public static double toDouble(byte[] abyte0) {
        long l = Bytes.toLong(abyte0);
        return Double.longBitsToDouble(l);
    }

    public static float toFloat(byte[] abyte0) {
        int i = Bytes.toInt(abyte0);
        return Float.intBitsToFloat(i);
    }

    public static int toInt(byte[] abyte0) {
        return (abyte0[3] & 0xFF) + ((abyte0[2] & 0xFF) << 8) + ((abyte0[1] & 0xFF) << 16) + ((abyte0[0] & 0xFF) << 24);
    }

    public static long toLong(byte[] abyte0) {
        return ((long)abyte0[7] & 0xFFL) + (((long)abyte0[6] & 0xFFL) << 8) + (((long)abyte0[5] & 0xFFL) << 16) + (((long)abyte0[4] & 0xFFL) << 24) + (((long)abyte0[3] & 0xFFL) << 32) + (((long)abyte0[2] & 0xFFL) << 40) + (((long)abyte0[1] & 0xFFL) << 48) + (((long)abyte0[0] & 0xFFL) << 56);
    }

    public static String toString(byte[] abyte0) {
        return Bytes.toString(abyte0, 0, abyte0.length);
    }

    public static String toString(byte[] abyte0, int i, int j) {
        char[] ac = new char[j * 2];
        int k = i;
        int l = 0;
        while (k < i + j) {
            byte byte0 = abyte0[k];
            ac[l++] = hexDigits[byte0 >>> 4 & 0xF];
            ac[l++] = hexDigits[byte0 & 0xF];
            ++k;
        }
        return new String(ac);
    }
}

