/*
 * Decompiled with CFR 0.152.
 */
package osc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class OscCoreMessage {
    private ArrayList arguments;
    private String name;
    private ArrayList types;

    public OscCoreMessage(String s) {
        this.name = s;
        this.types = new ArrayList();
        this.arguments = new ArrayList();
    }

    public void addArg(Character character, Object obj) {
        this.types.add(character);
        this.arguments.add(obj);
    }

    public void addBracket(Character character) {
        this.types.add(character);
    }

    private void alignStream(ByteArrayOutputStream bytearrayoutputstream) throws IOException {
        int i = 4 - bytearrayoutputstream.size() % 4;
        int j = 0;
        while (j < i) {
            bytearrayoutputstream.write(0);
            ++j;
        }
    }

    public String checkString(String s) {
        int i = s.length();
        int j = 0;
        while (j < 4 - i % 4) {
            s = s + "\u0000";
            ++j;
        }
        return s;
    }

    public ArrayList getArgs() {
        return this.arguments;
    }

    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        dataoutputstream.writeBytes(this.name);
        this.alignStream(bytearrayoutputstream);
        dataoutputstream.writeByte(44);
        int i = 0;
        while (i < this.types.size()) {
            char c = ((Character)this.types.get(i)).charValue();
            dataoutputstream.writeByte(c);
            ++i;
        }
        this.alignStream(bytearrayoutputstream);
        Iterator itTypes = ((AbstractList)this.types).iterator();
        Iterator itArgs = ((AbstractList)this.arguments).iterator();
        while (itTypes.hasNext()) {
            char c1 = ((Character)itTypes.next()).charValue();
            switch (c1) {
                case 'i': {
                    dataoutputstream.writeInt((Integer)itArgs.next());
                    break;
                }
                case 'f': {
                    dataoutputstream.writeFloat(((Float)itArgs.next()).floatValue());
                    break;
                }
                case 'h': {
                    dataoutputstream.writeLong((Long)itArgs.next());
                    break;
                }
                case 'd': {
                    dataoutputstream.writeDouble((Double)itArgs.next());
                    break;
                }
                case 's': {
                    dataoutputstream.writeBytes(this.checkString((String)itArgs.next()));
                }
            }
        }
        return bytearrayoutputstream.toByteArray();
    }

    public String getName() {
        if (this.types == null) {
            return "Osc Message getName > ERROR Types not set";
        }
        return this.name;
    }

    public ArrayList getTypes() {
        return this.types;
    }

    public static void printBytes(byte[] abyte0) {
        int i = 0;
        while (i < abyte0.length) {
            System.out.print(abyte0[i] + " (" + (char)abyte0[i] + ")  ");
            if ((i + 1) % 4 == 0) {
                System.out.print("\n");
            }
            ++i;
        }
    }

    public void setTypesAndArgs(ArrayList arrTypes, ArrayList arrArgs) {
        this.types = arrTypes;
        this.arguments = arrArgs;
    }
}

