/*
 * Decompiled with CFR 0.152.
 */
package osc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import osc.OscCoreMessage;

public class OscCorePacket {
    public InetAddress address;
    private ArrayList messages = new ArrayList();
    public String msgName = "/error";
    public int port;
    private long time = 0L;
    private int type;

    public OscCorePacket(long theTime, InetAddress ia, int thePort, int theType) {
        this();
        this.time = theTime;
        this.address = ia;
        this.port = thePort;
        this.type = theType;
    }

    public OscCorePacket(InetAddress ia, int thePort, int theType) {
        this();
        this.address = ia;
        this.port = thePort;
        this.type = theType;
    }

    public OscCorePacket() {
    }

    public void addMessage(OscCoreMessage oscmessage) {
        this.messages.add(oscmessage);
    }

    private void alignStream(ByteArrayOutputStream bytearrayoutputstream) throws IOException {
        int i = 4 - bytearrayoutputstream.size() % 4;
        int j = 0;
        while (j < i) {
            bytearrayoutputstream.write(0);
            ++j;
        }
    }

    public ArrayList extractPacket() {
        ArrayList arr = new ArrayList(this.messages.size());
        boolean flag = true;
        Iterator it = ((AbstractList)this.messages).iterator();
        while (it.hasNext()) {
            OscCoreMessage oscmessage = (OscCoreMessage)it.next();
            ArrayList<Object> tArr = new ArrayList<Object>();
            tArr.add(oscmessage.getName());
            tArr.add(oscmessage.getTypes());
            tArr.add(oscmessage.getArgs());
            arr.add(tArr);
            if (!flag) continue;
            flag = false;
        }
        return arr;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        boolean flag = false;
        if (this.type == 1) {
            bytearrayoutputstream.write("#bundle".getBytes());
            bytearrayoutputstream.write(0);
            boolean flag1 = true;
            dataoutputstream.writeLong(this.time);
        }
        Iterator it = ((AbstractList)this.messages).iterator();
        while (it.hasNext()) {
            OscCoreMessage oscmessage = (OscCoreMessage)it.next();
            byte[] abyte0 = oscmessage.getByteArray();
            if (this.type == 1) {
                dataoutputstream.writeInt(abyte0.length);
            }
            bytearrayoutputstream.write(abyte0);
        }
        return bytearrayoutputstream.toByteArray();
    }

    public int getPort() {
        return this.port;
    }

    public static void printBytes(byte[] abyte0) {
        int i = 0;
        while (i < abyte0.length) {
            System.out.print(abyte0[i] + " (" + (char)abyte0[i] + ")  ");
            if ((i + 1) % 4 == 0) {
                System.out.print("\n");
            }
            ++i;
        }
    }

    public void setAddress(InetAddress inetaddress) {
        this.address = inetaddress;
    }

    public void setPort(int i) {
        this.port = i;
    }

    public void setTime(long l) {
        this.time = l;
    }
}

