
// NOTE: At the bottom of this page is a SuperCollider program that listens to and sends to Processing

// import the oscP5 library. Remember to put the oscP5.jar into the 
// "code" folder in your sketch folder. If the data folder is not there,
// then just create one.
import osc.*;
import oscP5.*;

// oscP5 instance for the osc communication
OscP5 oscP5;
int receiveAtPort;
int sendToPort;
String host;
String oscP5event;
int r = 155;
int g = 100;
int b = 100;

void setup(){
  background(0);
  size(400, 400);   
  initOsc();
}

// initialise all OSC functionality
void initOsc() {
  receiveAtPort = 12000;
  sendToPort = 57120; // supercollider (the language, not the server) listens to port 57120
  host = "127.0.0.1"; // internal IP address - if you want to send to another computer put it's IP here
  oscP5event = "oscEvent"; // the analyser method 
  oscP5 = new OscP5(this, host, sendToPort, receiveAtPort, oscP5event);
}

void oscEvent(OscIn oscIn) {
  println("received a message ... forwarding to analyseMessage(OscIn)");
  analyseMessage(oscIn);
}

void analyseMessage(OscIn oscIn) {  
  if(oscIn.checkAddrPattern("/test")) {
    if(oscIn.checkTypetag("iii")) { // the typetag of the message = integer, integer, integer

       r = oscIn.getInt(0);
       g = oscIn.getInt(1);
       b = oscIn.getInt(2);
       
      // the following would have to be used to get floating point numbers or strings
      //float g = oscIn.getFloat(0);
      //string g = oscIn.getString(0);
      
      println("you have received a message "+
        oscIn.getAddrPattern()+
        "   red = " +r+ "   green= " +g+ "   blue = " + b
        );
    }
  } 
  else {  // your osc message was not "/test"
    println("you have received an osc message "+
      oscIn.getAddrPattern()+"   "+oscIn.getTypetag()
      );
    Object[] o = oscIn.getData();
    for(int i=0;i<o.length;i++) {
      println(i+"  "+o[i]);
    }
  }
}

void draw() {
  fill(r,g,b);
  rect(50, 50, width-100 ,height-100);
}

void mousePressed() {        
  // the arguments of the message are stored in an object array.
  Object[] tObj;
  tObj = new Object[] {
    new Integer(mouseY), new Float(34.55), "yippyy!"  };

  // a message with the address pattern /test and the arguments stored in the object array tObj will be sent out
  oscP5.sendMsg("/test", tObj);
}



/*

 // A SuperCollider program that RECEIVES messages from Processing
 // run this block first
 (
 r = OSCresponder(nil, '/test', { arg time, resp, msg; 
 	[msg].postln;
 }).add;
 )
 // when finishing, remove the OSCresponder
 r.remove;
 
 
 // A SuperCollider program that SENDS messages to Processing
 n = NetAddr("127.0.0.1", 12000);   // ixiOSCp55 listens to 12000
 n.sendMsg("/test", 22.3, 6, 8);    // and it's waiting for a message "/test" and 3 arguments
 *//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
