unsigned char rxFIFO[256], txFIFO[256], adc_old[10];
unsigned char rx_top, rx_end, tx_top, tx_end, status, keyno, dcb;
int midi_message, adc_no;

RawSerial MIDI(PA_2, PA_3);
DigitalOut myled(LED1);
AnalogIn analog_value1(PA_0);
AnalogIn analog_value2(PA_1);
DigitalOut LED_1(PA_4);
DigitalOut LED_2(PB_0);

unsigned char ADC_get(int num){
    unsigned short data = 0;
    switch(num){
        case(0):
            data = analog_value1.read_u16();
            break;
        case(1):
            data = analog_value2.read_u16();
            break;
    }
    return(data>>9);
}
    
int rx_fifo_check(void){
    unsigned char data;
    if(rx_top != rx_end){
        data = rxFIFO[rx_end];
        ++rx_end &= 255;
        if (data > 127){
            status = data;
            dcb = 0;
            return(0);
        }
        else if(status > 0xEF){
            return(0);
        }
        else if( (status > 0xBF) && (status < 0xE0) ){
            midi_message = (status<<16) + (data<<8);
            dcb = 0;
            return(1);
        }
        else if(dcb==0){
            keyno = data;
            dcb++;
            return(0);
        }
        else{
            midi_message = (status<<16) + (keyno<<8) + data;
            dcb = 0;
            return(1);
        }
    }
    return(0);
}

void rx_fifoset(void){
    rxFIFO[rx_top] = MIDI.getc();
    ++rx_top &= 255;
    return;
}

void tx_fifo_check(void){
    if(MIDI.writeable() == 1){
        if(tx_top != tx_end){
            MIDI.putc(txFIFO[tx_end]);
            ++tx_end &= 255;
        }
    }
    return;
}

void tx_fifoset(unsigned char data){
    txFIFO[tx_top] = data;
    ++tx_top &= 255;
    return;
}
