#include "mbed.h"
#include "MIDI_sub4.h"

int counter = 0;

int main(){
    int i, j, k, p;
    unsigned char adc_new;
    i = j = k = p = 0;
    rx_top = rx_end = tx_top = tx_end = adc_no = 0; 
    MIDI.baud(115200);
    MIDI.attach(&rx_fifoset, MIDI.RxIrq);
    for(i=0; i<10; i++) adc_old[i] = 0;
    LED_1 = 0;
    LED_2 = 0;
    while(1){
        p++;
        if(p == 5000){
            LED_1 = 1;
            LED_2 = 0;
        }
        else if(p == 10000){
            adc_no = 0;
            adc_new = ADC_get(adc_no);
            if(adc_old[adc_no] != adc_new){
                adc_old[adc_no] = adc_new;
                tx_fifoset(0xD0);
                tx_fifoset(adc_new);
            }
            adc_no = 1;
            adc_new = ADC_get(adc_no);
            if(adc_old[adc_no] != adc_new){
                adc_old[adc_no] = adc_new;
                tx_fifoset(0xD1);
                tx_fifoset(adc_new);
            }
            LED_1 = 0;
            LED_2 = 0;
        }
        else if(p == 15000){
            LED_1 = 0;
            LED_2 = 1;
        }
        else if(p > 19999){
            p = 0;
            adc_no = 0;
            adc_new = ADC_get(adc_no);
            if(adc_old[adc_no] != adc_new){
                adc_old[adc_no] = adc_new;
                tx_fifoset(0xD2);
                tx_fifoset(adc_new);
            }
            adc_no = 1;
            adc_new = ADC_get(adc_no);
            if(adc_old[adc_no] != adc_new){
                adc_old[adc_no] = adc_new;
                tx_fifoset(0xD3);
                tx_fifoset(adc_new);
            }
            LED_1 = 0;
            LED_2 = 0;
        }
        tx_fifo_check();
        if(rx_fifo_check() == 1){
            switch(midi_message>>20){
                case 0x0B:
                    if(((midi_message>>16) & 0x0F) == 0){
                        k = (midi_message>>8) & 0x7F;
                        if(k < 6){
//                            DAC_out(k, (midi_message & 0x7F)<<1);
                        }
                    }
                    else if(((midi_message>>16) & 0x0F) == 1){
                        k = (midi_message>>8) & 0x7F;
                        if(k < 4){
//                            Trigger_send(k, (midi_message & 0x7F));
                        }
                    }
                    break;
                case 0x0C:
                    tx_fifoset(midi_message>>16);
                    tx_fifoset((midi_message>>8) & 0x7F);
                    break;
            }         
        }
        if(++j > 1000000){
            j = 0;
            myled = !myled;
            counter = ++counter & 0x7F;
            tx_fifoset(0xC0);
            tx_fifoset(counter);
        }
    }
}